/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.airavata.registry.core.experiment.catalog.model.JobPK;
import org.apache.airavata.registry.core.experiment.catalog.model.JobStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="JOB")
@IdClass(value=JobPK.class)
public class Job {
    private static final Logger logger = LoggerFactory.getLogger(Job.class);
    private String jobId;
    private String taskId;
    private String processId;
    private char[] jobDescription;
    private char[] stdOut;
    private char[] stdErr;
    private int exitCode;
    private Timestamp creationTime;
    private String computeResourceConsumed;
    private String jobName;
    private String workingDir;
    private Process process;
    private Collection<JobStatus> jobStatuses;

    @Id
    @Column(name="JOB_ID")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Column(name="PROCESS_ID")
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Id
    @Column(name="TASK_ID")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Lob
    @Column(name="JOB_DESCRIPTION")
    public char[] getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(char[] jobDescription) {
        this.jobDescription = jobDescription;
    }

    @Lob
    @Column(name="STD_OUT")
    public char[] getStdOut() {
        return this.stdOut;
    }

    public void setStdOut(char[] stdOut) {
        this.stdOut = stdOut;
    }

    @Lob
    @Column(name="STD_ERR")
    public char[] getStdErr() {
        return this.stdErr;
    }

    public void setStdErr(char[] stdErr) {
        this.stdErr = stdErr;
    }

    @Column(name="EXIT_CODE")
    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="COMPUTE_RESOURCE_CONSUMED")
    public String getComputeResourceConsumed() {
        return this.computeResourceConsumed;
    }

    public void setComputeResourceConsumed(String computeResourceConsumed) {
        this.computeResourceConsumed = computeResourceConsumed;
    }

    @Column(name="JOB_NAME")
    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="WORKING_DIR")
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @OneToOne
    @JoinColumn(name="PROCESS_ID", referencedColumnName="PROCESS_ID")
    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process processByProcessId) {
        this.process = processByProcessId;
    }

    @OneToMany(mappedBy="job")
    public Collection<JobStatus> getJobStatuses() {
        return this.jobStatuses;
    }

    public void setJobStatuses(Collection<JobStatus> jobStatusesByJobId) {
        this.jobStatuses = jobStatusesByJobId;
    }
}

