/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.GlobusJobSubmission;
import org.apache.airavata.registry.core.app.catalog.model.UnicoreJobSubmission;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicoreJobSubmissionResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UnicoreJobSubmissionResource.class);
    private String jobSubmissionInterfaceId;
    private String securityProtocol;
    private String unicoreEndpointUrl;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreJobSubmission", new Object[0][]);
            generator.setParameter("submissionID", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreJobSubmission", new Object[0][]);
            generator.setParameter("submissionID", identifier);
            Query q = generator.selectQuery(em);
            UnicoreJobSubmission unicoreJobSubmission = (UnicoreJobSubmission)q.getSingleResult();
            UnicoreJobSubmissionResource unicoreSubmissionResource = (UnicoreJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_JOB_SUBMISSION, unicoreJobSubmission);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            UnicoreJobSubmissionResource unicoreJobSubmissionResource = unicoreSubmissionResource;
            return unicoreJobSubmissionResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> unicoreSubmissionResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UnicoreJobSubmission", new Object[0][]);
            if (fieldName.equals("unicoreEndpointUrl")) {
                generator.setParameter("unicoreEndpointUrl", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UnicoreJobSubmission unicoreJobSubmission = (UnicoreJobSubmission)result;
                        UnicoreJobSubmissionResource unicoreJobSubmissionResource = (UnicoreJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_JOB_SUBMISSION, unicoreJobSubmission);
                        unicoreSubmissionResourceList.add(unicoreJobSubmissionResource);
                    }
                }
            } else if (fieldName.equals("securityProtocol")) {
                generator.setParameter("securityProtocol", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UnicoreJobSubmission unicoreJobSubmission = (UnicoreJobSubmission)result;
                        UnicoreJobSubmissionResource unicoreJobSubmissionResource = (UnicoreJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.UNICORE_JOB_SUBMISSION, unicoreJobSubmission);
                        unicoreSubmissionResourceList.add(unicoreJobSubmissionResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Unicore submission resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Unicore Submission resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return unicoreSubmissionResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> globusSubmissionResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GlobusJobSubmission", new Object[0][]);
            if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusJobSubmission globusJobSubmission = (GlobusJobSubmission)result;
                        globusSubmissionResourceIDs.add(globusJobSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("globusEP")) {
                generator.setParameter("globusEP", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusJobSubmission globusJobSubmission = (GlobusJobSubmission)result;
                        globusSubmissionResourceIDs.add(globusJobSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("securityProtocol")) {
                generator.setParameter("securityProtocol", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusJobSubmission globusJobSubmission = (GlobusJobSubmission)result;
                        globusSubmissionResourceIDs.add(globusJobSubmission.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("resourceJobManager")) {
                generator.setParameter("resourceJobManager", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GlobusJobSubmission globusJobSubmission = (GlobusJobSubmission)result;
                        globusSubmissionResourceIDs.add(globusJobSubmission.getSubmissionID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Globus Submission resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Globus Submission resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return globusSubmissionResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UnicoreJobSubmission existingUnicoreSubmission = (UnicoreJobSubmission)em.find(UnicoreJobSubmission.class, (Object)this.jobSubmissionInterfaceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingUnicoreSubmission != null) {
                existingUnicoreSubmission.setSubmissionID(this.jobSubmissionInterfaceId);
                existingUnicoreSubmission.setUnicoreEndpointUrl(this.unicoreEndpointUrl);
                existingUnicoreSubmission.setSecurityProtocol(this.securityProtocol);
                em.merge((Object)existingUnicoreSubmission);
            } else {
                UnicoreJobSubmission unicoreJobSubmission = new UnicoreJobSubmission();
                unicoreJobSubmission.setSubmissionID(this.jobSubmissionInterfaceId);
                unicoreJobSubmission.setUnicoreEndpointUrl(this.unicoreEndpointUrl);
                unicoreJobSubmission.setSecurityProtocol(this.securityProtocol);
                em.persist((Object)unicoreJobSubmission);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UnicoreJobSubmission unicoreJobSubmission = (UnicoreJobSubmission)em.find(UnicoreJobSubmission.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = unicoreJobSubmission != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getjobSubmissionInterfaceId() {
        return this.jobSubmissionInterfaceId;
    }

    public void setjobSubmissionInterfaceId(String jobSubmissionInterfaceId) {
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getUnicoreEndpointUrl() {
        return this.unicoreEndpointUrl;
    }

    public void setUnicoreEndpointUrl(String unicoreEndpointUrl) {
        this.unicoreEndpointUrl = unicoreEndpointUrl;
    }
}

