/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.HostIPAddress;
import org.apache.airavata.registry.core.app.catalog.model.HostIPAddressPK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostIPAddressResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(HostIPAddressResource.class);
    private String resourceID;
    private String ipaddress;
    private ComputeResourceResource computeHostResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("HostIPAddress", new Object[0][]);
            generator.setParameter("resourceID", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("HostIPAddress", new Object[0][]);
            generator.setParameter("resourceID", ids.get("resourceID"));
            generator.setParameter("ipaddress", ids.get("ipaddress"));
            Query q = generator.selectQuery(em);
            HostIPAddress hostIPAddress = (HostIPAddress)q.getSingleResult();
            HostIPAddressResource hostIPAddressResource = (HostIPAddressResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.HOST_IPADDRESS, hostIPAddress);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            HostIPAddressResource hostIPAddressResource2 = hostIPAddressResource;
            return hostIPAddressResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> hostIPAddressResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("HostIPAddress", new Object[0][]);
            if (fieldName.equals("ipaddress")) {
                generator.setParameter("ipaddress", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        HostIPAddress hostIPAddress = (HostIPAddress)result;
                        HostIPAddressResource hostIPAddressResource = (HostIPAddressResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.HOST_IPADDRESS, hostIPAddress);
                        hostIPAddressResources.add(hostIPAddressResource);
                    }
                }
            } else if (fieldName.equals("resourceID")) {
                generator.setParameter("resourceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        HostIPAddress hostIPAddress = (HostIPAddress)result;
                        HostIPAddressResource hostIPAddressResource = (HostIPAddressResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.HOST_IPADDRESS, hostIPAddress);
                        hostIPAddressResources.add(hostIPAddressResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Host IPAddress Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Host IPAddress Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return hostIPAddressResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> hostIPAddressResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("HostIPAddress", new Object[0][]);
            if (fieldName.equals("ipaddress")) {
                generator.setParameter("ipaddress", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        HostIPAddress hostIPAddress = (HostIPAddress)result;
                        hostIPAddressResourceIDs.add(hostIPAddress.getResourceID());
                    }
                }
            } else if (fieldName.equals("resourceID")) {
                generator.setParameter("resourceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        HostIPAddress hostIPAddress = (HostIPAddress)result;
                        hostIPAddressResourceIDs.add(hostIPAddress.getResourceID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Host IP Address resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Host IPAddress Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return hostIPAddressResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            HostIPAddress existingHostIP = (HostIPAddress)em.find(HostIPAddress.class, (Object)new HostIPAddressPK(this.resourceID, this.ipaddress));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.resourceID);
            if (existingHostIP != null) {
                existingHostIP.setIpaddress(this.ipaddress);
                existingHostIP.setResourceID(this.resourceID);
                existingHostIP.setComputeResource(computeResource);
                em.merge((Object)existingHostIP);
            } else {
                HostIPAddress hostIPAddress = new HostIPAddress();
                hostIPAddress.setIpaddress(this.ipaddress);
                hostIPAddress.setResourceID(this.resourceID);
                hostIPAddress.setComputeResource(computeResource);
                em.persist((Object)hostIPAddress);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            HostIPAddress hostIPAddress = (HostIPAddress)em.find(HostIPAddress.class, (Object)new HostIPAddressPK((String)ids.get("resourceID"), (String)ids.get("ipaddress")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = hostIPAddress != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }
}

