/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.logging;

import java.util.Map;
import org.slf4j.MDC;

public class MDCUtil {
    public static Runnable wrapWithMDC(Runnable r) {
        Map mdc = MDC.getCopyOfContextMap();
        return () -> {
            Map oldMdc = MDC.getCopyOfContextMap();
            if (mdc == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)mdc);
            }
            try {
                r.run();
            }
            finally {
                if (oldMdc == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)oldMdc);
                }
            }
        };
    }
}

