/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.helper;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.helper.HelperBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperCreate
extends HelperBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File configuration;
    private String[] replacePairs;
    private boolean noWeb = true;
    private String user = "guest";
    private String password = "guest";
    private String role = "guest";
    private String javaOptions = "";
    private int portOffset = 0;
    private boolean allowAnonymous = true;
    private boolean replicated = false;
    private boolean sharedStore = false;
    private boolean clustered = false;
    private boolean backup = false;
    private String staticCluster;
    private boolean purgePageFolders;
    String dataFolder = "./data";
    private boolean failoverOnShutdown = false;
    private boolean noAutoTune = true;
    private String messageLoadBalancing = "ON_DEMAND";

    public HelperCreate(String homeProperty) {
        super(homeProperty);
    }

    public HelperCreate(File artemisHome) {
        super(artemisHome);
    }

    public String[] getReplacePairs() {
        return this.replacePairs;
    }

    public HelperCreate setReplacePairs(String[] replacePairs) {
        this.replacePairs = replacePairs;
        return this;
    }

    public boolean isNoWeb() {
        return this.noWeb;
    }

    public HelperCreate setNoWeb(boolean noWeb) {
        this.noWeb = noWeb;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public HelperCreate setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public HelperCreate setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public HelperCreate setRole(String role) {
        this.role = role;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public HelperCreate setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public boolean isPurgePageFolders() {
        return this.purgePageFolders;
    }

    public void setPurgePageFolders(boolean purgePageFolders) {
        this.purgePageFolders = purgePageFolders;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public HelperCreate setPortOffset(int portOffset) {
        this.portOffset = portOffset;
        return this;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public HelperCreate setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
        return this;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public HelperCreate setReplicated(boolean replicated) {
        this.replicated = replicated;
        return this;
    }

    public boolean isSharedStore() {
        return this.sharedStore;
    }

    public HelperCreate setSharedStore(boolean sharedStore) {
        this.sharedStore = sharedStore;
        return this;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public HelperCreate setClustered(boolean clustered) {
        this.clustered = clustered;
        return this;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public HelperCreate setBackup(boolean backup) {
        this.backup = backup;
        return this;
    }

    public String getStaticCluster() {
        return this.staticCluster;
    }

    public HelperCreate setStaticCluster(String staticCluster) {
        this.staticCluster = staticCluster;
        return this;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public HelperCreate setDataFolder(String dataFolder) {
        this.dataFolder = new File(dataFolder).getAbsolutePath();
        return this;
    }

    public boolean isFailoverOnShutdown() {
        return this.failoverOnShutdown;
    }

    public HelperCreate setFailoverOnShutdown(boolean failoverOnShutdown) {
        this.failoverOnShutdown = failoverOnShutdown;
        return this;
    }

    public boolean isNoAutoTune() {
        return this.noAutoTune;
    }

    public HelperCreate setNoAutoTune(boolean noAutoTune) {
        this.noAutoTune = noAutoTune;
        return this;
    }

    public String getMessageLoadBalancing() {
        return this.messageLoadBalancing;
    }

    public HelperCreate setMessageLoadBalancing(String messageLoadBalancing) {
        this.messageLoadBalancing = messageLoadBalancing;
        return this;
    }

    @Override
    public HelperCreate setArgs(String ... args) {
        return (HelperCreate)super.setArgs(args);
    }

    @Override
    public HelperCreate setArtemisHome(File artemisHome) {
        return (HelperCreate)super.setArtemisHome(artemisHome);
    }

    @Override
    public HelperCreate setArtemisInstance(File artemisInstance) {
        return (HelperCreate)super.setArtemisInstance(artemisInstance);
    }

    private void add(List<String> list, String ... str) {
        for (String s : str) {
            list.add(s);
        }
    }

    public File getConfiguration() {
        return this.configuration;
    }

    public HelperCreate setConfiguration(File configuration) {
        this.configuration = configuration;
        if (!configuration.exists()) {
            throw new IllegalArgumentException("Base configuration does not exist");
        }
        return this;
    }

    public HelperCreate setConfiguration(String configuration) {
        File configFile = new File(configuration);
        this.setConfiguration(configFile);
        return this;
    }

    public void createServer() throws Exception {
        String[] list;
        ArrayList<String> listCommands = new ArrayList<String>();
        this.add(listCommands, "create", "--silent", "--force", "--user", this.user, "--password", this.password, "--role", this.role, "--port-offset", "" + this.portOffset, "--data", this.dataFolder);
        if (this.allowAnonymous) {
            this.add(listCommands, "--allow-anonymous");
        } else {
            this.add(listCommands, "--require-login");
        }
        if (this.purgePageFolders) {
            this.add(listCommands, "--purge-page-folders");
        }
        if (this.staticCluster != null) {
            this.add(listCommands, "--static-cluster", this.staticCluster);
        }
        if (!this.javaOptions.isEmpty()) {
            this.add(listCommands, "--java-options", this.javaOptions);
        }
        if (this.noWeb) {
            this.add(listCommands, "--no-web");
        }
        if (this.backup) {
            this.add(listCommands, "--backup");
        }
        if (this.replicated) {
            this.add(listCommands, "--replicated");
        }
        if (this.sharedStore) {
            this.add(listCommands, "--shared-store");
        }
        if (this.clustered) {
            this.add(listCommands, "--clustered");
            this.add(listCommands, "--message-load-balancing", this.messageLoadBalancing);
        }
        if (this.failoverOnShutdown) {
            this.add(listCommands, "--failover-on-shutdown");
        }
        if (this.noAutoTune) {
            this.add(listCommands, "--no-autotune");
        }
        this.add(listCommands, "--verbose");
        if ("Linux".equals(System.getProperty("os.name"))) {
            this.add(listCommands, "--aio");
        }
        for (String str : this.args) {
            this.add(listCommands, str);
        }
        this.add(listCommands, this.artemisInstance.getAbsolutePath());
        logger.debug("server created at {} with home = {}", (Object)this.artemisInstance, (Object)this.artemisHome);
        this.artemisInstance.mkdirs();
        Artemis.execute(false, true, false, this.artemisHome, null, null, listCommands.toArray(new String[listCommands.size()]));
        if (this.configuration != null && (list = this.configuration.list()) != null) {
            this.copyConfigurationFiles(list, this.configuration.toPath(), this.artemisInstance.toPath().resolve("etc"));
        }
    }

    private void copyWithReplacements(Path original, Path target) throws IOException {
        String content = Files.readString(original);
        int i = 0;
        while (i + 1 < this.replacePairs.length) {
            content = content.replaceAll(this.replacePairs[i], this.replacePairs[i + 1]);
            i += 2;
        }
        Files.writeString(target, (CharSequence)content, new OpenOption[0]);
    }

    private void copyConfigurationFiles(String[] list, Path sourcePath, Path targetPath) throws IOException {
        boolean hasReplacements = false;
        if (this.replacePairs != null && this.replacePairs.length > 0) {
            hasReplacements = true;
            if (this.replacePairs.length % 2 == 1) {
                throw new IllegalArgumentException("You need to pass an even number of replacement pairs");
            }
        }
        for (String file : list) {
            Path target = targetPath.resolve(file);
            Path originalFile = sourcePath.resolve(file);
            if (hasReplacements) {
                this.copyWithReplacements(originalFile, target);
            } else {
                Files.copy(originalFile, target, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!originalFile.toFile().isDirectory()) continue;
            this.copyConfigurationFiles(originalFile.toFile().list(), originalFile, target);
        }
    }
}

