/* $VER: 13.05.03 */
#include "globalstuff.h"
#include "protos.h"

#include <string.h>

/* Fill the Memo structure and add it to the list */
BOOL create_NewMemo(struct Window *win) {

    struct Memo *memoNode;
    struct Node nd = { NULL, NULL };
    nd.ln_Type = NT_UNKNOWN;
    nd.ln_Pri = 0;
    nd.ln_Name = "Memo";
    
    if ( memoNode = (struct Memo*)AllocVec( sizeof(struct Memo), MEMF_PUBLIC ) ) {

        memoNode->window = win;
        memoNode->node = nd;
        memoNode->textColor = textColor;
        memoNode->memoColor = memoColor;
        memoNode->alarm = alarm;
        memoNode->hours = hours;
        memoNode->minutes = minutes;
        memoNode->origWidth = origWidth;
        memoNode->origHeight = origHeight;
        memoNode->zipped = FALSE;

        memoNode->tColor = tColor;
        memoNode->mColor = mColor;

        strcpy( memoNode->text[0], text[0] );
        strcpy( memoNode->text[1], text[1] );
        strcpy( memoNode->text[2], text[2] );
        strcpy( memoNode->text[3], text[3] );
        strcpy( memoNode->text[4], text[4] );
        strcpy( memoNode->text[5], text[5] );
        strcpy( memoNode->text[6], text[6] );
        strcpy( memoNode->text[7], text[7] );
        strcpy( memoNode->text[8], text[8] );
        strcpy( memoNode->text[9], text[9] );

        AddTail( &memoList, (struct Node *)memoNode);

        DPUTS( "Memo added." );

        //win->Flags = (win->Flags ^ WFLG_WINDOWACTIVE );

        update_memo( memoNode );

        count++;

        return TRUE;

    }

    return FALSE;
}


/* Remove memo */
void delete_memo(struct Memo *memo) {

    ClearMenuStrip( memo->window );
    //printf("Closing window.");
    //CloseWindow( memo->window );
    CloseWindowSafely( memo->window );
    //printf("Removing node.");
    memo->window = NULL;
    Remove( (struct Node *)memo );

    DPUTS( "Memo removed" );

    //printf("Freeing memory.");
    FreeVec( memo );
    //printf("Done.\n");
    count--;

}


/* Open preferences window */
BOOL open_prefsWindow() {

    /* If in editing mode, copy the prevailing values to the gadgets' values */
    if ( editMode ) {

        BYTE i;
        struct Gadget *gad = gadgetList->NextGadget;
        
        while ( gad != NULL ) {
            
            switch ( gad->GadgetID ) {

            case TEXT0:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[0], TAG_DONE );
                break;

            case TEXT1:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[1], TAG_DONE );
                break;

            case TEXT2:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[2], TAG_DONE );
                break;

            case TEXT3:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[3], TAG_DONE );
                break;

            case TEXT4:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[4], TAG_DONE );
                break;

            case TEXT5:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[5], TAG_DONE );
                break;

            case TEXT6:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[6], TAG_DONE );
                break;

            case TEXT7:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[7], TAG_DONE );
                break;

            case TEXT8:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[8], TAG_DONE );
                break;

            case TEXT9:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTST_String, (ULONG)memoToEdit->text[9], TAG_DONE );
                break;

            case MEMOCOLOR:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTPA_Color, (ULONG)memoToEdit->memoColor, TAG_DONE );
                break;

            case TEXTCOLOR:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTPA_Color, (ULONG)memoToEdit->textColor, TAG_DONE );
                break;

            case HOURSLIDER:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTSL_Level, (ULONG)memoToEdit->hours, TAG_DONE );
                break;

            case MINUTESLIDER:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTSL_Level, (ULONG)memoToEdit->minutes, TAG_DONE );
                break;

            case TOGGLEALARM:
                GT_SetGadgetAttrs( gad, prefsWin, NULL, GTCB_Checked, (ULONG)memoToEdit->alarm, TAG_DONE );
                break;

            } /* switch-case */

            gad = gad->NextGadget;
        
        } /* while */


        gad = gadgetList->NextGadget;

        /* Set the Show Content checkbox */
        while ( gad != NULL ) {
            
            switch ( gad->GadgetID ) {
            
            case SHOWCONTENT:
            GT_SetGadgetAttrs( gad, prefsWin, NULL, GTCB_Checked, (ULONG)showContent, TAG_DONE );
                break;

            }

            gad = gad->NextGadget;

        } /* while*/


        /* Make sure that we have all up-to-date properties */
        textColor = memoToEdit->textColor;
        memoColor = memoToEdit->memoColor;
        alarm = memoToEdit->alarm;
        hours = memoToEdit->hours;
        minutes = memoToEdit->minutes;

    } /* if */


    if ( prefsWin = OpenWindowTags( NULL,
        WA_Left,         screen->Width/2 - textWidth/2,
        WA_Top,          screen->Height/2-126,
        WA_Width,        textWidth,
        WA_Height,       384,
        WA_IDCMP,        0/*IDCMP_CLOSEWINDOW | IDCMP_REFRESHWINDOW | IDCMP_ACTIVEWINDOW | IDCMP_VANILLAKEY | IDCMP_GADGETUP | IDCMP_GADGETDOWN | IDCMP_MOUSEMOVE | IDCMP_MENUPICK*/,
        WA_DragBar,      TRUE,
        WA_DepthGadget,  TRUE,
        WA_CloseGadget,  TRUE,
        WA_SimpleRefresh, TRUE,
        WA_Activate,     TRUE,
        WA_ScreenTitle,  (LONG)"Memo Preferences",
        WA_Title,        (LONG)"Set preferences for a new Memo!",
        WA_PubScreen,    (LONG)screen,
        WA_AutoAdjust,   TRUE,
        WA_Gadgets,      (LONG)gadgetList,
        //WA_RMBTrap,      TRUE,
        WA_NewLookMenus, TRUE,
        TAG_DONE ) ) {

            /* Set shared message port */
            prefsWin->UserPort = winPort;

            /* Set 'ID' for a window */
            prefsWin->UserData = (BYTE *) 1;

            ModifyIDCMP( prefsWin, IDCMP_CLOSEWINDOW | IDCMP_REFRESHWINDOW | IDCMP_ACTIVEWINDOW | IDCMP_VANILLAKEY | IDCMP_GADGETUP | IDCMP_GADGETDOWN | IDCMP_MOUSEMOVE | IDCMP_MENUPICK );

            SetMenuStrip( prefsWin, menu );

            GT_RefreshWindow(prefsWin, NULL);
            return TRUE;

    } else {

        return FALSE;

    }
}


/* Get the longest line in pixels */
WORD get_longest( struct RastPort *rp ) {
    
    WORD longest = TextLength( rp, text[0], strlen(text[0]) );
    WORD comparable = 0;
    
    BYTE i;

    for (i = 1; i < 10; i++) {

        if ( (comparable = TextLength( rp, text[i], strlen(text[i]) ) ) > longest )
            longest = comparable;
    
    }

//    printf("Longest line: %d\n", (WORD)longest);
    return ( longest );
}


/* Get the number of lines with text */
BYTE get_lines( struct Memo *memo ) {

    BYTE i, lines = 10;

    for ( i = 9; i >= 0; i-- ) {
        if ( memo == NULL ) {
            if ( strlen(text[i]) == 0 ) {
                lines--;
            } else {
                break;
            }
        } else {
            if ( strlen(memo->text[i]) == 0 ) {
                lines--;
            } else {
                break;
            }
    }   }

//    printf("Lines: %d\n", (WORD)lines);
    return ( lines );
}


/* Open a new Memo */
BOOL open_newMemo( void ) {

    static ULONG callCount = 2;

    WORD memoWidth; // = get_longest() + 16;
    BYTE lines = get_lines( NULL );

    struct Window *window;

    if (window = OpenWindowTags(NULL,
                    WA_Left,         0,
                    WA_Top,          screen->Font->ta_YSize+3,
                    WA_Width,        16,
                    WA_Height,       ( (lines + 1) * screen->Font->ta_YSize + ( lines * screen->Font->ta_YSize)/2 ),
                    WA_IDCMP,        0/*IDCMP_VANILLAKEY | IDCMP_RAWKEY | IDCMP_MOUSEBUTTONS | IDCMP_ACTIVEWINDOW | IDCMP_INACTIVEWINDOW | IDCMP_REFRESHWINDOW | IDCMP_MENUPICK | IDCMP_MOUSEMOVE*/,
                    WA_SmartRefresh, FALSE,
                    WA_Activate,     FALSE,
                    WA_ScreenTitle,  (LONG)"AmiMemos",
                    WA_PubScreen,    (LONG)screen,
                    WA_AutoAdjust,   TRUE,
                    WA_Borderless,   TRUE,
                    WA_Gadgets,      NULL,
                    WA_ReportMouse,  TRUE,
                    //WA_RMBTrap,      TRUE,
                    WA_NewLookMenus, TRUE,
                    TAG_DONE))
    {

        /* Set shared message port */
        window->UserPort = winPort;

        /* Set 'ID' for a window */
        window->UserData = (BYTE *)callCount++;

        ModifyIDCMP( window, IDCMP_VANILLAKEY | IDCMP_RAWKEY | IDCMP_MOUSEBUTTONS | IDCMP_ACTIVEWINDOW | IDCMP_INACTIVEWINDOW | IDCMP_REFRESHWINDOW | IDCMP_MENUPICK | IDCMP_MOUSEMOVE );

        SetMenuStrip( window, menu );

        memoWidth = get_longest( window->RPort ) + 16;
        ChangeWindowBox( window, mx, my, memoWidth, window->Height );

        origWidth = memoWidth;
        origHeight = ( (lines + 1) * screen->Font->ta_YSize + ( lines * screen->Font->ta_YSize)/2 );//window->Height;

        // window->Flags = (window->Flags ^ WFLG_WINDOWACTIVE );

        if ( create_NewMemo( window ) ) {
        // ModifyIDCMP( window, flags | IDCMP_ACTIVEWINDOW );

            window = NULL;
            return TRUE;
        } else
            puts("Something wrong..");

    }

    DPUTS( "Could not create window..." );

    return FALSE;

} /* open_newMemo()*/


/* Refresh the contents of a memo */
void update_memo(struct Memo *memo) {

    WORD yStep = screen->Font->ta_YSize + (screen->Font->ta_YSize)/2;

    struct Window *window = memo->window;
    struct RastPort *rp = window->RPort;

    BYTE i, lines;

    SetRast( rp, memo->memoColor);

    SetAPen( rp, (ULONG)memo->textColor );
    SetBPen( rp, (ULONG)memo->memoColor );

    /* Avoid same back/foreground color! */
    if (memo->memoColor == memo->textColor)
        SetDrMd(rp, COMPLEMENT);

    lines = get_lines( memo );

    for ( i = 0; i < lines ; i++) {

        Move( rp, 8, 1 * yStep+yStep*i );
        Text( rp, memo->text[i], strlen(memo->text[i]) );
    
    }

    /* Draw single border */
    Move(rp, 1, 1);
    Draw(rp, window->Width-2, 1);
    Draw(rp, window->Width-2, window->Height-2);
    Draw(rp, 1, window->Height-2);
    Draw(rp, 1, 2);

    if (doubleBorders) {

        /* Draw double border for active window */
        if (window->Flags && WFLG_WINDOWACTIVE) {
            Move(rp, 0, 0);
            Draw(rp, window->Width-1, 0);
            Draw(rp, window->Width-1, window->Height-1);
            Draw(rp, 0, window->Height-1);
            Draw(rp, 0, 1);
        }
    }

    SetDrMd(rp, 0);

    return;
}


/* Edit memo */
void edit_memo( struct Memo *memoNode ) {

    struct Window *window = memoNode->window;
    WORD memoWidth, memoHeight;
    BYTE lines;
    
    memoNode->textColor = textColor;
    memoNode->memoColor = memoColor;
    memoNode->alarm = alarm;
    memoNode->hours = hours;
    memoNode->minutes = minutes;
    memoNode->origWidth = origWidth;
    memoNode->origHeight = origHeight;
    memoNode->zipped = FALSE;

    strcpy( memoNode->text[0], text[0] );
    strcpy( memoNode->text[1], text[1] );
    strcpy( memoNode->text[2], text[2] );
    strcpy( memoNode->text[3], text[3] );
    strcpy( memoNode->text[4], text[4] );
    strcpy( memoNode->text[5], text[5] );
    strcpy( memoNode->text[6], text[6] );
    strcpy( memoNode->text[7], text[7] );
    strcpy( memoNode->text[8], text[8] );
    strcpy( memoNode->text[9], text[9] );

    lines = get_lines( memoNode );

    memoWidth = get_longest( window->RPort ) + 16;
    memoHeight = ( (lines + 1) * screen->Font->ta_YSize + ( lines * screen->Font->ta_YSize)/2 );

    origWidth = memoWidth;
    origHeight = memoHeight;
    
    ChangeWindowBox( window, window->LeftEdge, window->TopEdge, memoWidth, memoHeight );

    update_memo( memoNode );

}


/**/
void CloseWindowSafely ( struct Window *win )
{
    if (!win)
    {
        return;
    }

    /*
    ** we forbid here to keep out of race conditions with Intuition
    */
    Forbid();

    /*
    ** send back any messages for this window
    ** that have not yet been processed
    */
    StripIntuiMessages(win->UserPort, win);

    /*
    ** clear UserPort so Intuition will not free it
    */
    win->UserPort = NULL;

    /*
    ** tell Intuition to stop sending more messages
    */
    ModifyIDCMP(win, 0UL);

    /*
    ** turn multitasking back on
    */
    Permit();

    /*
    ** and really close the window
    */
    CloseWindow(win);

    DPUTS("Window closed.");

}


/* Takes care of possible unanswered messaged while closing */
void StripIntuiMessages(struct MsgPort *mp, struct Window *win)
{
    struct IntuiMessage *msg;
    struct Node *succ;

    msg = (struct IntuiMessage *) mp->mp_MsgList.lh_Head;

    while ((succ = msg->ExecMessage.mn_Node.ln_Succ))
    {
        if (msg->IDCMPWindow == win)
        {
            /*
            ** Intuition is about to free this message.
            ** Make sure that we have politely sent it back.
            */
            Remove(&msg->ExecMessage.mn_Node);

            ReplyMsg(&msg->ExecMessage);
            //GT_ReplyIMsg(msg);

            DPUTS("Removed and replied @StripIntuiMsgs.");
        }

        msg = (struct IntuiMessage *) succ;
    }
}

