/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import com.icafe4j.util.LinkedList;
import com.icafe4j.util.LinkedListItr;

public class SeparateChainingHashTable<E> {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private LinkedList<E>[] theLists;

    public SeparateChainingHashTable() {
        this(101);
    }

    public SeparateChainingHashTable(int n) {
        this.theLists = new LinkedList[SeparateChainingHashTable.nextPrime(n)];
        for (int i = 0; i < this.theLists.length; ++i) {
            this.theLists[i] = new LinkedList();
        }
    }

    public void put(E e) {
        int n = e.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.theLists.length;
        LinkedList<E> linkedList = this.theLists[n2];
        LinkedListItr<E> linkedListItr = linkedList.find(e);
        if (linkedListItr.isPastEnd()) {
            linkedList.insert(e, linkedList.zeroth());
        }
    }

    public void remove(E e) {
        int n = e.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.theLists.length;
        this.theLists[n2].remove(e);
    }

    public E get(E e) {
        return this.getList(e).retrieve();
    }

    public LinkedListItr<E> getList(E e) {
        int n = e.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.theLists.length;
        return this.theLists[n2].find(e);
    }

    public void makeEmpty() {
        for (int i = 0; i < this.theLists.length; ++i) {
            this.theLists[i].makeEmpty();
        }
    }

    public static int hashString(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = 37 * n2 + string.charAt(i);
        }
        if ((n2 %= n) < 0) {
            n2 += n;
        }
        return n2;
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!SeparateChainingHashTable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        SeparateChainingHashTable<Integer> separateChainingHashTable = new SeparateChainingHashTable<Integer>();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            separateChainingHashTable.put(n);
            n = (n + 37) % 4000;
        }
        for (n = 1; n < 4000; n += 2) {
            separateChainingHashTable.remove(n);
        }
        for (n = 2; n < 4000; n += 2) {
            if (separateChainingHashTable.get(n) == n) continue;
            System.out.println("Find fails " + n);
        }
        for (n = 1; n < 4000; n += 2) {
            if (separateChainingHashTable.get(n) == null) continue;
            System.out.println("OOPS!!! " + n);
        }
    }
}

