/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCache<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4874219673008997966L;
    private Map<K, V> map = null;

    public LRUCache() {
        this(10, false);
    }

    public LRUCache(boolean bl) {
        this(10, bl);
    }

    public LRUCache(final int n, boolean bl) {
        this.map = new LinkedHashMap<K, V>(16, 0.75f, true){
            private static final long serialVersionUID = 3195834455030574184L;

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > n;
            }
        };
        if (bl) {
            this.map = Collections.synchronizedMap(this.map);
        }
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public V remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

