/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowableArray<E> {
    private transient E[] objarray;
    private int increment;
    private int elements;
    private int initsize;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrowableArray.class);

    public GrowableArray(int n, int n2) {
        if (n <= 0) {
            n = 10;
        }
        if (n2 <= 0) {
            n2 = 5;
        }
        this.initsize = n;
        this.objarray = new Object[n];
        this.increment = n2;
        this.elements = 0;
    }

    public int getSize() {
        return this.elements;
    }

    public E[] toArray(E[] objectArray) {
        if (objectArray.length < this.elements) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elements);
        }
        System.arraycopy(this.objarray, 0, objectArray, 0, this.elements);
        if (objectArray.length > this.elements) {
            objectArray[this.elements] = null;
        }
        return objectArray;
    }

    public void shrink() {
        int n = this.objarray.length;
        if (this.elements < n) {
            E[] EArray = this.objarray;
            this.objarray = new Object[this.elements];
            System.arraycopy(EArray, 0, this.objarray, 0, this.elements);
        }
    }

    public void printArray() {
        LOGGER.info("Size is {}.", (Object)String.valueOf(this.elements));
        for (int i = 0; i < this.elements; ++i) {
            LOGGER.info("Position [{}] = {}", (Object)String.valueOf(i), (Object)String.valueOf(this.objarray[i]));
        }
    }

    public E getElement(int n) {
        if (0 <= n && n < this.elements) {
            return this.objarray[n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public boolean setElement(int n, E e) {
        if (0 <= n && n < this.elements) {
            this.objarray[n] = e;
            return true;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public E removeArrayElement(int n) {
        if (this.elements >= 1 && 0 <= n && n < this.elements) {
            E e = this.objarray[n];
            System.arraycopy(this.objarray, n + 1, this.objarray, n, this.elements - n - 1);
            --this.elements;
            this.objarray[this.elements] = null;
            return e;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public E removeArrayElement(E e) {
        int n = -1;
        for (int i = 0; i < this.elements; ++i) {
            if (!e.equals(this.objarray[i])) continue;
            n = i;
            break;
        }
        if (n != -1) {
            return this.removeArrayElement((E)n);
        }
        return null;
    }

    public void addArrayElement(E e) {
        this.checkCapacity(this.elements + 1);
        this.objarray[this.elements++] = e;
    }

    public void insertArrayElement(int n, E e) {
        if (0 <= n && n <= this.elements) {
            this.checkCapacity(this.elements + 1);
            System.arraycopy(this.objarray, n, this.objarray, n + 1, this.elements - n);
            this.objarray[n] = e;
            ++this.elements;
        } else {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    private void checkCapacity(int n) {
        int n2 = this.objarray.length;
        if (n > n2) {
            E[] EArray = this.objarray;
            int n3 = this.increment > 0 ? n2 + this.increment : n2 * 2;
            this.objarray = new Object[n3];
            System.arraycopy(EArray, 0, this.objarray, 0, this.elements);
        }
    }

    public void clear() {
        for (int i = 0; i < this.elements; ++i) {
            this.objarray[i] = null;
        }
        this.objarray = new Object[this.initsize];
        this.elements = 0;
    }
}

