/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import com.icafe4j.util.DoublyLinkedListNode;
import java.lang.reflect.Array;

public class DoublyLinkedList<E> {
    private int count;
    private DoublyLinkedListNode<E> head;
    private DoublyLinkedListNode<E> tail;
    private final DoublyLinkedListNode<E> SENTINEL1 = new DoublyLinkedListNode<Object>(null);
    private final DoublyLinkedListNode<E> SENTINEL2 = new DoublyLinkedListNode<Object>(null);

    public DoublyLinkedList() {
        this.clear();
    }

    public void addToHead(E e) {
        DoublyLinkedListNode<E> doublyLinkedListNode = new DoublyLinkedListNode<E>(e, this.head, this.head.next());
        this.head.setNext(doublyLinkedListNode);
        doublyLinkedListNode.next().setPrev(doublyLinkedListNode);
        ++this.count;
    }

    public void add(E e) {
        this.addToHead(e);
    }

    public E removeFromHead() {
        E e = null;
        if (!this.isEmpty()) {
            DoublyLinkedListNode<E> doublyLinkedListNode = this.head.next();
            this.head.setNext(doublyLinkedListNode.next());
            doublyLinkedListNode.next().setPrev(this.head);
            e = doublyLinkedListNode.getValue();
            --this.count;
        }
        return e;
    }

    public E remove() {
        return this.removeFromHead();
    }

    public void addToTail(E e) {
        DoublyLinkedListNode<E> doublyLinkedListNode = new DoublyLinkedListNode<E>(e, this.tail.prev(), this.tail);
        this.tail.setPrev(doublyLinkedListNode);
        doublyLinkedListNode.prev().setNext(doublyLinkedListNode);
        ++this.count;
    }

    public E removeFromTail() {
        E e = null;
        if (!this.isEmpty()) {
            DoublyLinkedListNode<E> doublyLinkedListNode = this.tail.prev();
            this.tail.setPrev(doublyLinkedListNode.prev());
            doublyLinkedListNode.prev().setNext(this.tail);
            e = doublyLinkedListNode.getValue();
            --this.count;
        }
        return e;
    }

    public E peekHead() {
        return !this.isEmpty() ? (E)this.head.next().getValue() : null;
    }

    public E peekTail() {
        return !this.isEmpty() ? (E)this.tail.prev().getValue() : null;
    }

    public boolean contains(E e) {
        DoublyLinkedListNode<E> doublyLinkedListNode;
        for (doublyLinkedListNode = this.head.next(); doublyLinkedListNode != null && !doublyLinkedListNode.getValue().equals(e); doublyLinkedListNode = doublyLinkedListNode.next()) {
        }
        return doublyLinkedListNode != null;
    }

    public E remove(E e) {
        DoublyLinkedListNode<E> doublyLinkedListNode;
        DoublyLinkedListNode<E> doublyLinkedListNode2 = this.head;
        for (doublyLinkedListNode = this.head.next(); doublyLinkedListNode != null && !doublyLinkedListNode.getValue().equals(e); doublyLinkedListNode = doublyLinkedListNode.next()) {
            doublyLinkedListNode2 = doublyLinkedListNode;
        }
        if (doublyLinkedListNode != null) {
            doublyLinkedListNode2.setNext(doublyLinkedListNode.next());
            if (doublyLinkedListNode.next() != null) {
                doublyLinkedListNode.next().setPrev(doublyLinkedListNode2);
            }
            --this.count;
            return doublyLinkedListNode.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public E[] toArray(E[] objectArray) {
        if (objectArray.length < this.count) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
        }
        int n = 0;
        for (DoublyLinkedListNode<E> doublyLinkedListNode = this.head.next(); doublyLinkedListNode != this.tail; doublyLinkedListNode = doublyLinkedListNode.next()) {
            objectArray[n++] = doublyLinkedListNode.getValue();
        }
        if (objectArray.length > this.count) {
            objectArray[this.count] = null;
        }
        return objectArray;
    }

    public void transferList(DoublyLinkedList<E> doublyLinkedList) {
        doublyLinkedList.head = this.head;
        doublyLinkedList.tail = this.tail;
        doublyLinkedList.count = this.count;
        this.clear();
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.head = this.SENTINEL1;
        this.tail = this.SENTINEL2;
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
        this.count = 0;
    }

    public static void main(String[] stringArray) {
        int n;
        DoublyLinkedList<Integer> doublyLinkedList = new DoublyLinkedList<Integer>();
        System.out.println("Checking... (no more output means success)");
        for (n = 0; n < 4000; ++n) {
            doublyLinkedList.addToTail(new Integer(n));
        }
        for (n = 3999; n > 0; --n) {
            if ((Integer)doublyLinkedList.peekTail() != n) {
                System.out.println("peekHead() error!");
            }
            if ((Integer)doublyLinkedList.removeFromTail() == n) continue;
            System.out.println("removdeFromHead() error!");
        }
        doublyLinkedList.clear();
        for (n = 0; n < 4000; ++n) {
            doublyLinkedList.addToTail(new Integer(n));
        }
        for (n = 0; n < 4000; ++n) {
            if ((Integer)doublyLinkedList.peekHead() != n) {
                System.out.println("peekHead() error!");
            }
            if ((Integer)doublyLinkedList.removeFromHead() == n) continue;
            System.out.println("removdeFromHead() error!");
        }
    }
}

