/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.io;

import com.icafe4j.io.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MemoryCacheRandomAccessInputStream
extends RandomAccessInputStream {
    private static final int BUFFER_SHIFT = 12;
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_MASK = 4095;
    private long pointer = 0L;
    private List<byte[]> cache = new ArrayList<byte[]>(10);
    private int length = 0;
    private boolean foundEOS = false;

    public MemoryCacheRandomAccessInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.cache.clear();
        this.cache = null;
        this.src.close();
        this.src = null;
        this.closed = true;
    }

    @Override
    public void shallowClose() {
        if (this.closed) {
            return;
        }
        this.cache.clear();
        this.cache = null;
        this.src = null;
        this.closed = true;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            byte[] byArray = this.cache.get((int)(this.pointer >> 12));
            return byArray[(int)(this.pointer++ & 0xFFFL)] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] byArray2 = this.cache.get((int)(this.pointer >> 12));
        int n3 = Math.min(n2, 4096 - (int)(this.pointer & 0xFFFL));
        System.arraycopy(byArray2, (int)(this.pointer & 0xFFFL), byArray, n, n3);
        this.pointer += (long)n3;
        return n3;
    }

    private long readUntil(long l) throws IOException {
        int n;
        if (l < (long)this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int n2 = (int)(l >> 12);
        for (int i = n = this.length >> 12; i <= n2; ++i) {
            byte[] byArray = new byte[4096];
            this.cache.add(byArray);
            int n3 = 4096;
            int n4 = 0;
            while (n3 > 0) {
                int n5 = this.src.read(byArray, n4, n3);
                if (n5 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                n4 += n5;
                n3 -= n5;
                this.length += n5;
            }
        }
        return this.length;
    }

    @Override
    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("Negative seek position.");
        }
        this.pointer = l;
    }
}

