/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.UnsupportedCompressionException;
import com.icafe4j.image.compression.ccitt.G31DEncoder;
import com.icafe4j.image.compression.ccitt.G32DEncoder;
import com.icafe4j.image.compression.ccitt.G42DEncoder;
import com.icafe4j.image.compression.deflate.DeflateEncoder;
import com.icafe4j.image.compression.lzw.LZWTreeEncoder;
import com.icafe4j.image.compression.packbits.Packbits;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.JPGOptions;
import com.icafe4j.image.options.TIFFOptions;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.tiff.ASCIIField;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.tiff.UndefinedField;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.image.writer.JPGWriter;
import com.icafe4j.io.ByteOrder;
import com.icafe4j.io.FileCacheRandomAccessOutputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import com.icafe4j.io.WriteStrategyII;
import com.icafe4j.io.WriteStrategyMM;
import com.icafe4j.util.ArrayUtils;
import com.icafe4j.util.CollectionUtils;
import com.icafe4j.util.Updatable;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIFFWriter
extends ImageWriter
implements Updatable<Integer> {
    private static final String pathToCMYKProfile = "/resources/CMYK Profiles/USWebCoatedSWOP.icc";
    private int stripOffset;
    private IFD ifd;
    private TIFFOptions tiffOptions;
    private ICC_ColorSpace cmykColorSpace;
    private List<Integer> stripOffsets = new ArrayList<Integer>();
    private List<Integer> stripByteCounts = new ArrayList<Integer>();
    private RandomAccessOutputStream randomOS;
    private static final Logger LOGGER = LoggerFactory.getLogger(TIFFWriter.class);
    public static final int OFFSET_TO_WRITE_FIRST_IFD_OFFSET = 4;
    public static final int FIRST_WRITE_OFFSET = 8;
    public static final int STREAM_HEAD = 0;

    public TIFFWriter() {
    }

    public TIFFWriter(ImageParam imageParam) {
        super(imageParam);
    }

    private static byte[] applyPredictor(int n, byte[] byArray, int n2, int n3) {
        int n4 = n * n2;
        int n5 = n4 - n;
        int n6 = n;
        for (int i = n3 - 1; i >= 0; --i) {
            for (int j = n5; j >= n6; j -= n) {
                for (int k = 0; k < n; ++k) {
                    int n7 = j + k;
                    byArray[n7] = (byte)(byArray[n7] - byArray[j - n + k]);
                }
            }
            n5 += n4;
            n6 += n4;
        }
        return byArray;
    }

    private static byte[] applyPredictor2(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n3 - 1;
        int n5 = 1;
        for (int i = n2 - 1; i >= 0; --i) {
            for (int j = n4; j >= n5; --j) {
                int n6 = j;
                byArray[n6] = (byte)(byArray[n6] - byArray[j - 1]);
            }
            n4 += n3;
            n5 += n3;
        }
        return byArray;
    }

    private void ccittCompress(byte[] byArray, int n, int n2, ImageEncoder imageEncoder) throws Exception {
        imageEncoder.initialize();
        imageEncoder.encode(byArray, 0, n * n2);
        imageEncoder.finish();
        ShortField shortField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)n2});
        this.ifd.addField(shortField);
    }

    private void compressSample(byte[] byArray, int n, int n2, TiffFieldEnum.Compression compression, int n3) throws Exception {
        Object object;
        int n4 = n2;
        switch (compression) {
            case LZW: {
                object = new LZWTreeEncoder(this.randomOS, 8, n3, this);
                object.initialize();
                object.encode(byArray, 0, byArray.length);
                object.finish();
                break;
            }
            case DEFLATE: 
            case DEFLATE_ADOBE: {
                int n5 = 4;
                if (this.tiffOptions != null) {
                    n5 = this.tiffOptions.getDeflateCompressionLevel();
                }
                DeflateEncoder deflateEncoder = new DeflateEncoder(this.randomOS, n3, n5, this);
                deflateEncoder.initialize();
                deflateEncoder.encode(byArray, 0, byArray.length);
                deflateEncoder.finish();
                break;
            }
            default: {
                compression = TiffFieldEnum.Compression.PACKBITS;
                boolean bl = false;
                int n6 = 0;
                byte[] byArray2 = new byte[n + (n + 127) / 128];
                for (int i = 0; i < n2; ++i) {
                    int n7 = Packbits.packbits(ArrayUtils.subArray(byArray, n6, n), byArray2);
                    n6 += n;
                    this.randomOS.write(byArray2, 0, n7);
                    this.update(n7);
                }
                n4 = 1;
            }
        }
        object = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)n4});
        this.ifd.addField((TiffField<?>)object);
        object = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField((TiffField<?>)object);
    }

    private void deflateCompress(int n, byte[] byArray, int n2, int n3, int n4, byte[] byArray2) throws Exception {
        Object object;
        DeflateEncoder deflateEncoder = new DeflateEncoder(this.randomOS, byArray2.length, n, this);
        deflateEncoder.initialize();
        if (n2 == 8) {
            deflateEncoder.encode(byArray, 0, n3 * (n4 / 2 + 1));
        } else {
            object = ArrayUtils.packByteArray(byArray, n3, 0, n2, n3 * (n4 / 2 + 1));
            deflateEncoder.encode((byte[])object, 0, ((byte[])object).length);
        }
        deflateEncoder.finish();
        deflateEncoder.initialize();
        if (n2 == 8) {
            deflateEncoder.encode(byArray, n3 * (n4 / 2 + 1), byArray.length - n3 * (n4 / 2 + 1));
        } else {
            object = ArrayUtils.packByteArray(byArray, n3, n3 * (n4 / 2 + 1), n2, byArray.length - n3 * (n4 / 2 + 1));
            deflateEncoder.encode((byte[])object, 0, ((byte[])object).length);
        }
        deflateEncoder.finish();
        object = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)(n4 / 2 + 1)});
        this.ifd.addField((TiffField<?>)object);
    }

    public IFD getIFD() {
        return new IFD(this.ifd);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.TIFF;
    }

    private void jpegCompress(int[] nArray, int n, int n2, boolean bl) throws Exception {
        byte[] byArray;
        int n3 = n2 / 2 + 1;
        int n4 = 90;
        boolean bl2 = false;
        TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.YCbCr;
        if (this.tiffOptions != null) {
            n4 = this.tiffOptions.getJPEGQuality();
            if (this.tiffOptions.getPhotoMetric() != TiffFieldEnum.PhotoMetric.UNKNOWN) {
                photoMetric = this.tiffOptions.getPhotoMetric();
            }
            bl2 = this.tiffOptions.writeICCProfile();
        }
        int n5 = 0;
        if (bl) {
            photoMetric = TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO;
            n5 = 1;
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.RGB || photoMetric == TiffFieldEnum.PhotoMetric.YCbCr) {
            n5 = 3;
            this.ifd.addField(new RationalField(TiffTag.REFERENCE_BLACK_WHITE.getValue(), new int[]{0, 255, 128, 255, 128, 255}));
            if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr) {
                this.ifd.addField(new ShortField(TiffTag.YCbCr_SUB_SAMPLING.getValue(), new short[]{1, 1}));
            }
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
            n5 = 4;
        } else {
            throw new UnsupportedOperationException("Unsupported PHOTOMETRIC_INTERPRETATION!");
        }
        short[] sArray = new short[n5];
        Arrays.fill(sArray, (short)8);
        this.ifd.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)photoMetric.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)n5}));
        this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), sArray));
        JPGWriter jPGWriter = new JPGWriter();
        ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
        if (bl) {
            imageParamBuilder.colorType(ImageColorType.GRAY_SCALE);
        }
        JPGOptions jPGOptions = new JPGOptions();
        jPGOptions.setQuality(n4);
        jPGOptions.setColorSpace(photoMetric.getValue());
        jPGOptions.setTiffFlavor(true);
        jPGOptions.setIncludeTables(false);
        imageParamBuilder.imageOptions(jPGOptions);
        jPGWriter.setImageParam(imageParamBuilder.build());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        jPGWriter.writeDefaultJPEGTables(byteArrayOutputStream);
        this.ifd.addField(new UndefinedField(TiffTag.JPEG_TABLES.getValue(), byteArrayOutputStream.toByteArray()));
        long l = this.randomOS.getStreamPointer();
        jPGWriter.write(Arrays.copyOfRange(nArray, 0, n * (n2 / 2 + 1)), n, n2 / 2 + 1, this.randomOS);
        long l2 = this.randomOS.getStreamPointer();
        int n6 = (int)(l2 - l);
        this.update(n6);
        l = l2;
        jPGWriter.write(Arrays.copyOfRange(nArray, n * (n2 / 2 + 1), nArray.length), n, n2 - n2 / 2 - 1, this.randomOS);
        l2 = this.randomOS.getStreamPointer();
        n6 = (int)(l2 - l);
        this.update(n6);
        if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED && bl2 && (byArray = jPGWriter.getCMYK_ICC_Profile()) != null) {
            this.ifd.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), byArray));
        }
        this.ifd.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)TiffFieldEnum.Compression.JPG.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)n3}));
    }

    private void lzwCompress(byte[] byArray, int n, int n2, int n3, int n4) throws Exception {
        Object object;
        LZWTreeEncoder lZWTreeEncoder = new LZWTreeEncoder(this.randomOS, 8, n4, this);
        lZWTreeEncoder.initialize();
        if (n == 8) {
            lZWTreeEncoder.encode(byArray, 0, n2 * (n3 / 2 + 1));
        } else {
            object = ArrayUtils.packByteArray(byArray, n2, 0, n, n2 * (n3 / 2 + 1));
            lZWTreeEncoder.encode((byte[])object, 0, ((byte[])object).length);
        }
        lZWTreeEncoder.finish();
        lZWTreeEncoder.initialize();
        if (n == 8) {
            lZWTreeEncoder.encode(byArray, n2 * (n3 / 2 + 1), byArray.length - n2 * (n3 / 2 + 1));
        } else {
            object = ArrayUtils.packByteArray(byArray, n2, n2 * (n3 / 2 + 1), n, byArray.length - n2 * (n3 / 2 + 1));
            lZWTreeEncoder.encode((byte[])object, 0, ((byte[])object).length);
        }
        lZWTreeEncoder.finish();
        object = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)(n3 / 2 + 1)});
        this.ifd.addField((TiffField<?>)object);
    }

    private void packbitsCompress(byte[] byArray, int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 % 2 == 0 ? n3 / 2 : n3 / 2 + 1;
        byte[] byArray2 = new byte[n2 + (n2 + 127) / 128];
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = ArrayUtils.packByteArray(byArray, n2, n4, n, n2);
            int n7 = Packbits.packbits(byArray3, byArray2);
            n4 += n2;
            this.randomOS.write(byArray2, 0, n7);
            n5 += n7;
            if (i != n6 - 1 && i != n3 - 1) continue;
            this.update(n5);
            n5 = 0;
        }
        ShortField shortField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)n6});
        this.ifd.addField(shortField);
    }

    private void reset(int n) {
        this.stripOffset = n;
        this.stripOffsets.clear();
        this.stripByteCounts.clear();
    }

    @Override
    public void update(Integer n) {
        this.stripByteCounts.add(n);
        this.stripOffsets.add(this.stripOffset);
        this.stripOffset += n.intValue();
    }

    @Override
    protected void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        ImageParam imageParam = this.getImageParam();
        ImageOptions imageOptions = imageParam.getImageOptions();
        if (imageOptions instanceof TIFFOptions) {
            this.tiffOptions = (TIFFOptions)imageOptions;
        }
        this.randomOS = new FileCacheRandomAccessOutputStream(outputStream);
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if (this.tiffOptions != null) {
            byteOrder = this.tiffOptions.getByteOrder();
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            this.randomOS.setWriteStrategy(WriteStrategyMM.getInstance());
            this.randomOS.writeShort(19789);
        } else {
            this.randomOS.setWriteStrategy(WriteStrategyII.getInstance());
            this.randomOS.writeShort(18761);
        }
        this.randomOS.writeShort(42);
        this.ifd = new IFD();
        TiffField tiffField = new LongField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new int[]{0});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_WIDTH.getValue(), new int[]{n});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_LENGTH.getValue(), new int[]{n2});
        this.ifd.addField(tiffField);
        this.reset(8);
        this.randomOS.seek(this.stripOffset);
        this.writePageData(imageParam, nArray, n, n2);
        tiffField = new LongField(TiffTag.STRIP_OFFSETS.getValue(), CollectionUtils.integerListToIntArray(this.stripOffsets));
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.STRIP_BYTE_COUNTS.getValue(), CollectionUtils.integerListToIntArray(this.stripByteCounts));
        this.ifd.addField(tiffField);
        String string = "ICAFE - https://github.com/dragon66/icafe\u0000";
        tiffField = new ASCIIField(TiffTag.SOFTWARE.getValue(), string);
        this.ifd.addField(tiffField);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffField = new ASCIIField(TiffTag.DATETIME.getValue(), simpleDateFormat.format(new Date()) + '\u0000');
        this.ifd.addField(tiffField);
        int n3 = 72;
        int n4 = 72;
        int n5 = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH.getValue();
        if (this.tiffOptions != null) {
            n3 = this.tiffOptions.getXResolution();
            n4 = this.tiffOptions.getYResolution();
            n5 = this.tiffOptions.getResolutionUnit().getValue();
        }
        this.ifd.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{n3, 1}));
        this.ifd.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{n4, 1}));
        this.ifd.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{(short)n5}));
        this.randomOS.seek(4L);
        this.randomOS.writeInt(this.stripOffset);
        this.ifd.write(this.randomOS, this.stripOffset);
        this.randomOS.seek(0L);
        this.randomOS.writeToStream(this.randomOS.getLength());
        this.randomOS.close();
    }

    private void writeBilevel(byte[] byArray, int n, int n2, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> enumSet = TiffFieldEnum.Compression.forBilevel();
        if (!enumSet.contains((Object)compression)) {
            throw new UnsupportedCompressionException("Bilevel Image only supports the following compression types: " + enumSet);
        }
        TiffField tiffField = new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue()});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.FILL_ORDER.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        switch (compression) {
            case CCITTRLE: {
                G31DEncoder g31DEncoder = new G31DEncoder(this.randomOS, n, 1024, this);
                this.ccittCompress(ArrayUtils.packByteArray(byArray, 0, 1, byArray.length), n, n2, g31DEncoder);
                break;
            }
            case CCITTFAX3: {
                G32DEncoder g32DEncoder = new G32DEncoder(this.randomOS, n, 1024, 4, this);
                this.ccittCompress(ArrayUtils.packByteArray(byArray, 0, 1, byArray.length), n, n2, g32DEncoder);
                tiffField = new LongField(TiffTag.T4_OPTIONS.getValue(), new int[]{1});
                this.ifd.addField(tiffField);
                break;
            }
            case CCITTFAX4: {
                G42DEncoder g42DEncoder = new G42DEncoder(this.randomOS, n, 1024, this);
                this.ccittCompress(ArrayUtils.packByteArray(byArray, 0, 1, byArray.length), n, n2, g42DEncoder);
                break;
            }
            case LZW: 
            case DEFLATE: {
                this.compressSample(ArrayUtils.packByteArray(byArray, n, 0, 1, byArray.length), n, n2, compression, 1024);
                break;
            }
            default: {
                compression = TiffFieldEnum.Compression.PACKBITS;
                this.packbitsCompress(byArray, 1, n, n2);
            }
        }
        tiffField = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField(tiffField);
    }

    private void writeGrayScale(byte[] byArray, int n, int n2, TiffFieldEnum.Compression compression, boolean bl) throws Exception {
        boolean bl2;
        EnumSet<TiffFieldEnum.Compression> enumSet = TiffFieldEnum.Compression.forGrayScale();
        if (!enumSet.contains((Object)compression)) {
            throw new UnsupportedCompressionException("GrayScale Image only supports the following compression types: " + enumSet);
        }
        int n3 = 8;
        boolean bl3 = true;
        if (this.tiffOptions != null) {
            bl3 = this.tiffOptions.isApplyPredictor();
        }
        switch (compression) {
            case LZW: 
            case DEFLATE: {
                break;
            }
            default: {
                bl3 = false;
            }
        }
        boolean bl4 = bl2 = !bl;
        if (bl2) {
            n3 = IMGUtils.getBitDepth(byArray, false);
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    n3 = 4;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n3 = 8;
                    break;
                }
            }
        }
        if (n3 != 8) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(byArray[i] << n3 >> 8);
            }
            byArray = ArrayUtils.packByteArray(byArray, n, 0, n3, n * n2);
        }
        ShortField shortField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO.getValue()});
        this.ifd.addField(shortField);
        int n4 = bl2 ? 1 : 2;
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)n4}));
        if (bl2) {
            this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)n3}));
        } else {
            this.ifd.addField(new ShortField(TiffTag.EXTRA_SAMPLES.getValue(), new short[]{2}));
            this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)n3, (short)n3}));
        }
        if (n3 == 8 && bl3) {
            if (bl2) {
                TIFFWriter.applyPredictor2(byArray, n, n2);
            } else {
                int n5 = 2 * n;
                int n6 = n5 - 2;
                int n7 = 2;
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = n6; j >= n7; j -= 2) {
                        int n8 = j;
                        byArray[n8] = (byte)(byArray[n8] - byArray[j - 2]);
                        int n9 = j + 1;
                        byArray[n9] = (byte)(byArray[n9] - byArray[j - 1]);
                    }
                    n6 += n5;
                    n7 += n5;
                }
            }
            shortField = new ShortField(TiffTag.PREDICTOR.getValue(), new short[]{2});
            this.ifd.addField(shortField);
        }
        this.compressSample(byArray, n4 * n, n2, compression, 1024);
    }

    private void writePageData(ImageParam imageParam, int[] nArray, int n, int n2) throws Exception {
        TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.PACKBITS;
        if (this.tiffOptions != null) {
            compression = this.tiffOptions.getTiffCompression();
        }
        if (imageParam.getColorType() == ImageColorType.INDEXED) {
            this.writeIndexed(nArray, n, n2, compression);
        } else if (imageParam.getColorType() == ImageColorType.BILEVEL) {
            if (imageParam.isApplyDither()) {
                byte[] byArray = null;
                byArray = imageParam.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.rgb2bilevelDiffusionDither(nArray, n, n2) : IMGUtils.rgb2bilevelOrderedDither(nArray, n, n2, imageParam.getDitherMatrix());
                this.writeBilevel(byArray, n, n2, compression);
            } else {
                this.writeBilevel(IMGUtils.rgb2bilevel(nArray), n, n2, compression);
            }
        } else if (compression == TiffFieldEnum.Compression.JPG) {
            if (imageParam.hasAlpha()) {
                LOGGER.warn("#Warning: JPEG compression does not support transparency (all transparency information will be lost!)");
            }
            this.jpegCompress(nArray, n, n2, imageParam.getColorType() == ImageColorType.GRAY_SCALE);
        } else if (imageParam.getColorType() == ImageColorType.GRAY_SCALE) {
            if (imageParam.hasAlpha()) {
                this.writeGrayScale(IMGUtils.rgb2grayscaleA(nArray), n, n2, compression, true);
            } else {
                this.writeGrayScale(IMGUtils.rgb2grayscale(nArray), n, n2, compression, false);
            }
        } else {
            this.writeTrueColor(nArray, n, n2, compression);
        }
    }

    private void writeIndexed(int[] nArray, int n, int n2, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> enumSet = TiffFieldEnum.Compression.forIndexed();
        if (!enumSet.contains((Object)compression)) {
            throw new UnsupportedCompressionException("Indexed Image only supports the following compression types: " + enumSet);
        }
        ImageParam imageParam = this.getImageParam();
        byte[] byArray = new byte[n * n2];
        int n3 = 8;
        int[] nArray2 = new int[256];
        int[] nArray3 = IMGUtils.checkColorDepth(nArray, byArray, nArray2);
        if (nArray3[0] > 8) {
            n3 = imageParam.getBitsPerPixel();
            if (n3 <= 0 || n3 > 8) {
                n3 = 8;
            }
            nArray3 = imageParam.isApplyDither() ? (imageParam.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(imageParam.getQuantMethod(), nArray, n, n2, n3, byArray, nArray2) : IMGUtils.reduceColorsOrderedDither(imageParam.getQuantMethod(), nArray, n, n2, n3, byArray, nArray2, imageParam.getDitherMatrix())) : IMGUtils.reduceColors(imageParam.getQuantMethod(), nArray, n3, byArray, nArray2, false);
        }
        n3 = nArray3[0];
        switch (n3) {
            case 3: {
                n3 = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n3 = 8;
                break;
            }
        }
        int n4 = 1 << n3;
        int n5 = n4 << 1;
        short[] sArray = new short[3 * n4];
        for (int i = 0; i < n4; ++i) {
            sArray[i] = (short)((nArray2[i] >> 16 & 0xFF) << 8);
            sArray[n4 + i] = (short)((nArray2[i] >> 8 & 0xFF) << 8);
            sArray[n5 + i] = (short)((nArray2[i] >> 0 & 0xFF) << 8);
        }
        ShortField shortField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.PALETTE_COLOR.getValue()});
        this.ifd.addField(shortField);
        shortField = new ShortField(TiffTag.COLORMAP.getValue(), sArray);
        this.ifd.addField(shortField);
        shortField = new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{1});
        this.ifd.addField(shortField);
        shortField = new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)n3});
        this.ifd.addField(shortField);
        if (compression == TiffFieldEnum.Compression.LZW) {
            this.lzwCompress(byArray, n3, n, n2, 4096);
        } else if (compression == TiffFieldEnum.Compression.DEFLATE_ADOBE || compression == TiffFieldEnum.Compression.DEFLATE) {
            byte[] byArray2 = new byte[4096];
            int n6 = 4;
            if (this.tiffOptions != null) {
                n6 = this.tiffOptions.getDeflateCompressionLevel();
            }
            this.deflateCompress(n6, byArray, n3, n, n2, byArray2);
        } else {
            compression = TiffFieldEnum.Compression.PACKBITS;
            this.packbitsCompress(byArray, n3, n, n2);
        }
        shortField = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField(shortField);
    }

    public int writePage(BufferedImage bufferedImage, int n, int n2, RandomAccessOutputStream randomAccessOutputStream, int n3) throws Exception {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int[] nArray = IMGUtils.getRGB(bufferedImage);
        this.ifd = new IFD();
        TiffField tiffField = new LongField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new int[]{2});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n, (short)n2});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_WIDTH.getValue(), new int[]{n4});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_LENGTH.getValue(), new int[]{n5});
        this.ifd.addField(tiffField);
        this.reset(n3);
        this.randomOS = randomAccessOutputStream;
        this.randomOS.seek(this.stripOffset);
        ImageParam imageParam = this.getImageParam();
        ImageOptions imageOptions = imageParam.getImageOptions();
        if (imageOptions instanceof TIFFOptions) {
            this.tiffOptions = (TIFFOptions)imageOptions;
        }
        this.writePageData(imageParam, nArray, n4, n5);
        tiffField = new LongField(TiffTag.STRIP_OFFSETS.getValue(), CollectionUtils.integerListToIntArray(this.stripOffsets));
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.STRIP_BYTE_COUNTS.getValue(), CollectionUtils.integerListToIntArray(this.stripByteCounts));
        this.ifd.addField(tiffField);
        String string = "ICAFE - https://github.com/dragon66/icafe\u0000";
        tiffField = new ASCIIField(TiffTag.SOFTWARE.getValue(), string);
        this.ifd.addField(tiffField);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffField = new ASCIIField(TiffTag.DATETIME.getValue(), simpleDateFormat.format(new Date()) + '\u0000');
        this.ifd.addField(tiffField);
        int n6 = 72;
        int n7 = 72;
        int n8 = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH.getValue();
        if (this.tiffOptions != null) {
            n6 = this.tiffOptions.getXResolution();
            n7 = this.tiffOptions.getYResolution();
            n8 = this.tiffOptions.getResolutionUnit().getValue();
        }
        this.ifd.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{n6, 1}));
        this.ifd.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{n7, 1}));
        this.ifd.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{(short)n8}));
        return this.ifd.write(this.randomOS, this.stripOffset);
    }

    private void writeTrueColor(int[] nArray, int n, int n2, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> enumSet = TiffFieldEnum.Compression.forTrueColor();
        if (!enumSet.contains((Object)compression)) {
            throw new UnsupportedCompressionException("TrueColor Image only supports the following compression types: " + enumSet);
        }
        boolean bl = true;
        TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.RGB;
        boolean bl2 = false;
        int n3 = 3;
        if (this.tiffOptions != null) {
            bl = this.tiffOptions.isApplyPredictor();
            if (this.tiffOptions.getPhotoMetric() != TiffFieldEnum.PhotoMetric.UNKNOWN) {
                photoMetric = this.tiffOptions.getPhotoMetric();
            }
            if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
                n3 = 4;
                bl2 = this.tiffOptions.writeICCProfile();
            }
        }
        switch (compression) {
            case LZW: 
            case DEFLATE: {
                break;
            }
            default: {
                bl = false;
            }
        }
        boolean bl3 = this.getImageParam().hasAlpha();
        int n4 = bl3 ? n3 + 1 : n3;
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)n4}));
        short[] sArray = new short[n4];
        Arrays.fill(sArray, (short)8);
        this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), sArray));
        if (bl3) {
            this.ifd.addField(new ShortField(TiffTag.EXTRA_SAMPLES.getValue(), new short[]{2}));
        }
        byte[] byArray = new byte[n4 * nArray.length];
        if (photoMetric == TiffFieldEnum.PhotoMetric.RGB) {
            if (!bl3) {
                int n5 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[n5++] = (byte)(nArray[i] >> 16 & 0xFF);
                    byArray[n5++] = (byte)(nArray[i] >> 8 & 0xFF);
                    byArray[n5++] = (byte)(nArray[i] & 0xFF);
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[n6++] = (byte)(nArray[i] >> 16 & 0xFF);
                    byArray[n6++] = (byte)(nArray[i] >> 8 & 0xFF);
                    byArray[n6++] = (byte)(nArray[i] & 0xFF);
                    byArray[n6++] = (byte)(nArray[i] >> 24 & 0xFF);
                }
            }
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
            byte[] byArray2;
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = IMGUtils.getICCColorSpace(pathToCMYKProfile);
            }
            byArray = IMGUtils.RGB2CMYK(this.cmykColorSpace, nArray, n, n2, bl3);
            if (bl2 && (byArray2 = this.cmykColorSpace.getProfile().getData()) != null) {
                this.ifd.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), byArray2));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported TiffPhotoMetric: " + (Object)((Object)photoMetric));
        }
        if (bl) {
            TIFFWriter.applyPredictor(n4, byArray, n, n2);
            this.ifd.addField(new ShortField(TiffTag.PREDICTOR.getValue(), new short[]{2}));
        }
        this.compressSample(byArray, n4 * n, n2, compression, 1024);
        this.ifd.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)photoMetric.getValue()}));
    }
}

