/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.compression.huffman.HuffmanEncoder;
import com.icafe4j.image.jpeg.HTable;
import com.icafe4j.image.jpeg.JPGConsts;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.jpeg.QTable;
import com.icafe4j.image.jpeg.Segment;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.options.JPGOptions;
import com.icafe4j.image.util.DCT;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.IOUtils;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class JPGWriter
extends ImageWriter {
    private int newHeight;
    private int newWidth;
    private ImageParam imageParam;
    private JPGOptions jpegOptions;
    private int numOfComponents = 3;
    private int numOfQTables = 2;
    private int numOfHTables = 2;
    private int[] qTableSelector = new int[]{0, 1, 1, 1};
    private int[][] quant_table = new int[2][];
    private byte[][][] huffman_bits = new byte[2][2][];
    private byte[][][] huffman_values = new byte[2][2][];
    private int quality = 100;
    private boolean includeTables = true;
    private boolean grayScale;
    private int colorSpace = JPGOptions.COLOR_SPACE_YCbCr;
    private static final String pathToCMYKProfile = "/resources/CMYK Profiles/USWebCoatedSWOP.icc";
    private ICC_ColorSpace cmykColorSpace;
    private boolean writeICCProfile;
    private boolean isTiffFlavor;
    private static final String comment = "Created by ICAFE - https://github.com/dragon66/icafe";

    public JPGWriter() {
    }

    public JPGWriter(ImageParam imageParam) {
        super(imageParam);
    }

    private float[][] expandArray(float[][] fArray, int n, int n2) {
        int n3 = n % 8;
        int n4 = n2 % 8;
        this.newWidth = n + (n3 == 0 ? 0 : 8 - n3);
        this.newHeight = n2 + (n4 == 0 ? 0 : 8 - n4);
        if (this.newWidth > n || this.newHeight > n2) {
            int n5;
            float[][] fArray2 = new float[this.newHeight][this.newWidth];
            for (n5 = 0; n5 < n2; ++n5) {
                System.arraycopy(fArray[n5], 0, fArray2[n5], 0, n);
                Arrays.fill(fArray2[n5], n, this.newWidth, fArray[n5][n - 1]);
            }
            for (n5 = n2; n5 < this.newHeight; ++n5) {
                System.arraycopy(fArray2[n2 - 1], 0, fArray2[n5], 0, this.newWidth);
            }
            return fArray2;
        }
        return fArray;
    }

    private float[][] getDCTBlock(float[][] fArray, int n, int n2) {
        float[][] fArray2 = new float[8][8];
        int n3 = n;
        int n4 = 0;
        while (n3 < 8 + n) {
            System.arraycopy(fArray[n3], n2, fArray2[n4], 0, 8);
            ++n3;
            ++n4;
        }
        return fArray2;
    }

    public byte[] getCMYK_ICC_Profile() {
        if (this.cmykColorSpace != null) {
            return this.cmykColorSpace.getProfile().getData();
        }
        return null;
    }

    @Override
    public ImageType getImageType() {
        return ImageType.JPG;
    }

    private void processImageMeta() throws Exception {
        this.imageParam = this.getImageParam();
        this.grayScale = this.imageParam.getColorType() == ImageColorType.GRAY_SCALE;
        ImageOptions imageOptions = this.imageParam.getImageOptions();
        if (imageOptions instanceof JPGOptions) {
            this.jpegOptions = (JPGOptions)imageOptions;
            this.quality = this.jpegOptions.getQuality();
            this.includeTables = this.jpegOptions.includeTables();
            this.colorSpace = this.jpegOptions.getColorSpace();
            this.isTiffFlavor = this.jpegOptions.isTiffFlavor();
            this.writeICCProfile = this.jpegOptions.writeICCProfile();
        }
        if (this.colorSpace == JPGOptions.COLOR_SPACE_CMYK || this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) {
            this.numOfComponents = 4;
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = IMGUtils.getICCColorSpace(pathToCMYKProfile);
            }
        }
        if (this.grayScale) {
            this.numOfComponents = 1;
            this.numOfQTables = 1;
            this.numOfHTables = 1;
        }
        this.setDefaultTables(this.quality);
    }

    private void RGB2RGB(int[] nArray, float[][] fArray, float[][] fArray2, float[][] fArray3, int n, int n2) throws Exception {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[n3] >> 16 & 0xFF;
                int n5 = nArray[n3] >> 8 & 0xFF;
                int n6 = nArray[n3++] & 0xFF;
                fArray[i][j] = (float)n4 - 128.0f;
                fArray2[i][j] = (float)n5 - 128.0f;
                fArray3[i][j] = (float)n6 - 128.0f;
            }
        }
    }

    private void setDefaultTables(int n) {
        this.quant_table[0] = JPGConsts.getDefaultLuminanceMatrix(n);
        this.quant_table[1] = JPGConsts.getDefaultChrominanceMatrix(n);
        this.huffman_bits[0][0] = JPGConsts.getDCLuminanceBits();
        this.huffman_bits[0][1] = JPGConsts.getDCChrominanceBits();
        this.huffman_bits[1][0] = JPGConsts.getACLuminanceBits();
        this.huffman_bits[1][1] = JPGConsts.getACChrominanceBits();
        this.huffman_values[0][0] = JPGConsts.getDCLuminanceValues();
        this.huffman_values[0][1] = JPGConsts.getDCChrominanceValues();
        this.huffman_values[1][0] = JPGConsts.getACLuminanceValues();
        this.huffman_values[1][1] = JPGConsts.getACChrominanceValues();
    }

    @Override
    protected void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        this.processImageMeta();
        this.writeSOI(outputStream);
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            this.writeJFIF(outputStream);
        } else {
            this.writeAdobeApp14(outputStream);
        }
        if ((this.colorSpace == JPGOptions.COLOR_SPACE_CMYK || this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) && this.writeICCProfile) {
            this.writeICCProfile(outputStream);
        }
        this.writeComment(comment, outputStream);
        this.writeComment("Created on " + new SimpleDateFormat("yyyy:MM:dd HH:mm:ss z").format(new Date()), outputStream);
        if (this.includeTables) {
            this.writeDQT(outputStream);
            this.writeDHT(outputStream);
        }
        this.writeSOF0(outputStream, n, n2);
        this.writeSOS(outputStream);
        if (this.grayScale) {
            this.writeGrayScale(IMGUtils.rgb2grayscale(nArray, n, n2), outputStream, n, n2);
        } else {
            this.writeFullColor(nArray, outputStream, n, n2);
        }
        this.writeEOI(outputStream);
    }

    private void writeAdobeApp14(OutputStream outputStream) throws Exception {
        int n = 14;
        byte[] byArray = new byte[n + 2];
        byArray[0] = -1;
        byArray[1] = -18;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = 65;
        byArray[5] = 100;
        byArray[6] = 111;
        byArray[7] = 98;
        byArray[8] = 101;
        byArray[9] = 0;
        byArray[10] = 100;
        byArray[11] = 0;
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            byArray[15] = 1;
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) {
            byArray[15] = 2;
        }
        outputStream.write(byArray);
    }

    private void writeComment(String string, OutputStream outputStream) throws Exception {
        byte[] byArray = string.getBytes();
        int n = byArray.length + 2;
        byte[] byArray2 = new byte[n + 2];
        byArray2[0] = -1;
        byArray2[1] = -2;
        byArray2[2] = (byte)(n >> 8 & 0xFF);
        byArray2[3] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 4, n - 2);
        outputStream.write(byArray2, 0, n + 2);
    }

    private void writeDHT(HTable hTable, OutputStream outputStream) throws Exception {
        int n = hTable.getClazz();
        int n2 = hTable.getID();
        byte[] byArray = hTable.getBits();
        byte[] byArray2 = hTable.getValues();
        int n3 = 0;
        for (byte by : byArray) {
            n3 += by;
        }
        byte[] byArray3 = new byte[1 + byArray.length + n3];
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, n3);
        byArray3[0] = (byte)(n << 4 & 0xF0 | n2 & 0xF);
        new Segment(Marker.DHT, byArray3.length + 2, byArray3).write(outputStream);
    }

    private void writeDHT(OutputStream outputStream) throws Exception {
        for (int i = 0; i < this.numOfHTables; ++i) {
            this.writeDHT(new HTable(0, i, this.huffman_bits[0][i], this.huffman_values[0][i]), outputStream);
            this.writeDHT(new HTable(1, i, this.huffman_bits[1][i], this.huffman_values[1][i]), outputStream);
        }
    }

    private void writeDQT(OutputStream outputStream) throws Exception {
        for (int i = 0; i < this.numOfQTables; ++i) {
            this.writeDQT(new QTable(0, i, this.quant_table[i]), outputStream);
        }
    }

    private void writeDQT(QTable qTable, OutputStream outputStream) throws Exception {
        byte[] byArray;
        int n = qTable.getPrecision();
        int n2 = qTable.getID();
        int[] nArray = qTable.getData();
        int[] nArray2 = JPGConsts.getZigzagMatrix();
        if (n == 0) {
            byArray = new byte[1 + nArray.length];
            for (int i = 1; i < byArray.length; ++i) {
                byArray[i] = (byte)nArray[nArray2[i - 1]];
            }
        } else {
            byArray = new byte[1 + nArray.length * 2];
            for (int i = 1; i < nArray.length; ++i) {
                byArray[i] = (byte)(nArray[nArray2[i - 1]] >> 8);
                byArray[i + 1] = (byte)nArray[nArray2[i - 1]];
            }
        }
        byArray[0] = (byte)(n2 & 0xF | n << 4 & 0xF0);
        new Segment(Marker.DQT, byArray.length + 2, byArray).write(outputStream);
    }

    private void writeEOI(OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[]{-1, -39};
        outputStream.write(byArray);
    }

    private void writeGrayScale(float[][] fArray, OutputStream outputStream, int n, int n2) throws Exception {
        fArray = this.expandArray(fArray, n, n2);
        HuffmanEncoder huffmanEncoder = new HuffmanEncoder(outputStream, 4096);
        huffmanEncoder.initialize();
        for (int i = 0; i < this.newHeight; i += 8) {
            for (int j = 0; j < this.newWidth; j += 8) {
                float[][] fArray2 = this.getDCTBlock(fArray, i, j);
                fArray2 = DCT.forwardDCT(fArray2);
                int[] nArray = new int[64];
                int n3 = 0;
                for (int k = 0; k < 8; ++k) {
                    int n4 = 0;
                    while (n4 < 8) {
                        nArray[n3] = (int)fArray2[k][n4] / this.quant_table[0][n3];
                        ++n4;
                        ++n3;
                    }
                }
                huffmanEncoder.encode(nArray, 0);
            }
        }
        huffmanEncoder.finish();
    }

    private void writeICCProfile(OutputStream outputStream) throws Exception {
        ICC_Profile iCC_Profile = this.cmykColorSpace.getProfile();
        this.writeICCProfile(outputStream, iCC_Profile.getData());
    }

    private void writeICCProfile(OutputStream outputStream, byte[] byArray) throws Exception {
        int n = 65535;
        int n2 = 65519;
        int n3 = byArray.length / n2;
        int n4 = byArray.length % n2;
        int n5 = n3 == 0 ? 1 : (n4 == 0 ? n3 : n3 + 1);
        for (int i = 0; i < n3; ++i) {
            IOUtils.writeShortMM(outputStream, Marker.APP2.getValue());
            IOUtils.writeShortMM(outputStream, n);
            IOUtils.write(outputStream, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(outputStream, n5 | i + 1 << 8);
            IOUtils.write(outputStream, byArray, i * n2, n2);
        }
        if (n4 != 0) {
            IOUtils.writeShortMM(outputStream, Marker.APP2.getValue());
            IOUtils.writeShortMM(outputStream, n4 + 16);
            IOUtils.write(outputStream, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(outputStream, n5 | n5 << 8);
            IOUtils.write(outputStream, byArray, byArray.length - n4, n4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFullColor(int[] nArray, OutputStream outputStream, int n, int n2) throws Exception {
        float[][][] fArray = new float[this.numOfComponents][n2][n];
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            IMGUtils.RGB2YCbCr(nArray, fArray[0], fArray[1], fArray[2], n, n2);
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_RGB) {
            this.RGB2RGB(nArray, fArray[0], fArray[1], fArray[2], n, n2);
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_CMYK) {
            if (!this.isTiffFlavor) {
                IMGUtils.RGB2CMYK_Inverted(this.cmykColorSpace, nArray, fArray[0], fArray[1], fArray[2], fArray[3], n, n2);
            } else {
                IMGUtils.RGB2CMYK(this.cmykColorSpace, nArray, fArray[0], fArray[1], fArray[2], fArray[3], n, n2);
            }
        } else {
            if (this.colorSpace != JPGOptions.COLOR_SPACE_YCCK) throw new IllegalArgumentException("Unsupported color space type: " + this.colorSpace);
            if (this.isTiffFlavor) throw new UnsupportedOperationException("YCCK JPEG is not supported in TIFF!");
            IMGUtils.RGB2YCCK_Inverted(this.cmykColorSpace, nArray, fArray[0], fArray[1], fArray[2], fArray[3], n, n2);
        }
        for (int i = 0; i < this.numOfComponents; ++i) {
            fArray[i] = this.expandArray(fArray[i], n, n2);
        }
        HuffmanEncoder huffmanEncoder = new HuffmanEncoder(outputStream, 4096);
        huffmanEncoder.initialize();
        for (int i = 0; i < this.newHeight; i += 8) {
            for (int j = 0; j < this.newWidth; j += 8) {
                for (int k = 0; k < this.numOfComponents; ++k) {
                    int[] nArray2 = this.quant_table[this.qTableSelector[k]];
                    float[][] fArray2 = this.getDCTBlock(fArray[k], i, j);
                    fArray2 = DCT.forwardDCT(fArray2);
                    int[] nArray3 = new int[64];
                    int n3 = 0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        int n4 = 0;
                        while (n4 < 8) {
                            nArray3[n3] = (int)fArray2[i2][n4] / nArray2[n3];
                            ++n4;
                            ++n3;
                        }
                    }
                    huffmanEncoder.encode(nArray3, k);
                }
            }
        }
        huffmanEncoder.finish();
    }

    private void writeJFIF(OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        outputStream.write(byArray);
    }

    public void writeDefaultJPEGTables(OutputStream outputStream) throws Exception {
        if (this.imageParam == null) {
            this.processImageMeta();
        }
        this.writeSOI(outputStream);
        this.writeDQT(outputStream);
        this.writeDHT(outputStream);
        this.writeEOI(outputStream);
    }

    private void writeSOF0(OutputStream outputStream, int n, int n2) throws Exception {
        int n3 = 8 + 3 * this.numOfComponents;
        byte[] byArray = new byte[n3 + 2];
        byArray[0] = -1;
        byArray[1] = -64;
        byArray[2] = (byte)(n3 >> 8);
        byArray[3] = (byte)n3;
        byArray[4] = 8;
        byArray[5] = (byte)(n2 >> 8 & 0xFF);
        byArray[6] = (byte)(n2 & 0xFF);
        byArray[7] = (byte)(n >> 8 & 0xFF);
        byArray[8] = (byte)(n & 0xFF);
        byArray[9] = (byte)this.numOfComponents;
        int n4 = 10;
        for (int i = 0; i < this.numOfComponents; ++i) {
            byArray[n4++] = (byte)(i + 1);
            byArray[n4++] = 17;
            byArray[n4++] = (byte)this.qTableSelector[i];
        }
        outputStream.write(byArray);
    }

    private void writeSOI(OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[]{-1, -40};
        outputStream.write(byArray);
    }

    private void writeSOS(OutputStream outputStream) throws Exception {
        int n = 6 + 2 * this.numOfComponents;
        byte[] byArray = new byte[n + 2];
        byArray[0] = -1;
        byArray[1] = -38;
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
        byArray[4] = (byte)this.numOfComponents;
        int n2 = 5;
        for (int i = 0; i < this.numOfComponents; ++i) {
            byArray[n2++] = (byte)(i + 1);
            byArray[n2++] = (byte)((this.qTableSelector[i] << 4) + this.qTableSelector[i]);
        }
        byArray[n2++] = 0;
        byArray[n2++] = 63;
        byArray[n2++] = 0;
        outputStream.write(byArray);
    }
}

