/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.util.IMGUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.OutputStream;

public abstract class ImageWriter {
    private ImageParam imageParam = ImageParam.DEFAULT_IMAGE_PARAM;

    protected ImageWriter() {
    }

    protected ImageWriter(ImageParam imageParam) {
        this.imageParam = imageParam;
    }

    private int[] getPixels(Image image, int n, int n2) throws Exception {
        int[] nArray = null;
        if (image instanceof BufferedImage) {
            nArray = IMGUtils.getRGB((BufferedImage)image);
        } else {
            nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
            }
        }
        if (this.imageParam.isTransparent()) {
            int n3 = this.imageParam.getTransparentColor() & 0xFFFFFF;
            for (int i = nArray.length - 1; i > 0; --i) {
                int n4 = nArray[i] & 0xFFFFFF;
                if (n4 != n3) continue;
                nArray[i] = n4;
            }
        }
        return nArray;
    }

    public ImageParam getImageParam() {
        return this.imageParam;
    }

    public abstract ImageType getImageType();

    public void setImageParam(ImageParam imageParam) {
        this.imageParam = imageParam;
    }

    public void write(Image image, OutputStream outputStream) throws Exception {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        this.write(this.getPixels(image, n, n2), n, n2, outputStream);
    }

    protected abstract void write(int[] var1, int var2, int var3, OutputStream var4) throws Exception;
}

