/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.writer;

import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.gif.GIFFrame;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.image.writer.ImageWriter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class GIFWriter
extends ImageWriter {
    private int codeLen;
    private int codeIndex;
    private int clearCode;
    private int endOfImage;
    private int bufIndex;
    private int empty_bits = 8;
    private int bitsPerPixel = 8;
    private byte[] bytes_buf = new byte[256];
    private int[] colorPalette;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int[] child = new int[4097];
    int[] siblings = new int[4097];
    int[] suffix = new int[4097];
    private int logicalScreenWidth;
    private int logicalScreenHeight;
    private boolean animated;
    private int loopCount;
    private boolean firstFrame = true;

    private static Dimension getLogicalScreenSize(BufferedImage[] bufferedImageArray) {
        int n = 0;
        int n2 = 0;
        for (BufferedImage bufferedImage : bufferedImageArray) {
            if (bufferedImage.getWidth() > n) {
                n = bufferedImage.getWidth();
            }
            if (bufferedImage.getHeight() <= n2) continue;
            n2 = bufferedImage.getHeight();
        }
        return new Dimension(n, n2);
    }

    private static Dimension getLogicalScreenSize(GIFFrame[] gIFFrameArray) {
        int n = 0;
        int n2 = 0;
        for (GIFFrame gIFFrame : gIFFrameArray) {
            int n3 = gIFFrame.getFrameWidth() + gIFFrame.getLeftPosition();
            int n4 = gIFFrame.getFrameHeight() + gIFFrame.getTopPosition();
            if (n3 > n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    public GIFWriter() {
    }

    public GIFWriter(ImageParam imageParam) {
        super(imageParam);
    }

    private void encode(byte[] byArray, OutputStream outputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = byArray.length;
        this.bitsPerPixel = this.bitsPerPixel == 1 ? 2 : this.bitsPerPixel;
        outputStream.write(this.bitsPerPixel);
        this.init_encoder(this.bitsPerPixel);
        this.send_code_to_buffer(this.clearCode, outputStream);
        n = byArray[n5++] & 0xFF;
        block0: while (n5 < n6) {
            n4 = byArray[n5++] & 0xFF;
            n2 = this.child[n];
            if (n2 > 0) {
                if (this.suffix[n2] == n4) {
                    n = n2;
                    continue;
                }
                n3 = n2;
                while (this.siblings[n3] > 0) {
                    if (this.suffix[n3 = this.siblings[n3]] != n4) continue;
                    n = n3;
                    continue block0;
                }
                this.siblings[n3] = this.codeIndex;
                this.suffix[this.codeIndex] = n4;
                this.send_code_to_buffer(n, outputStream);
                n = n4;
                ++this.codeIndex;
                if (this.codeIndex <= 1 << this.codeLen) continue;
                if (this.codeLen == 12) {
                    this.send_code_to_buffer(this.clearCode, outputStream);
                    this.init_encoder(this.bitsPerPixel);
                    continue;
                }
                ++this.codeLen;
                continue;
            }
            this.child[n] = this.codeIndex;
            this.suffix[this.codeIndex] = n4;
            this.send_code_to_buffer(n, outputStream);
            n = n4;
            ++this.codeIndex;
            if (this.codeIndex <= 1 << this.codeLen) continue;
            if (this.codeLen == 12) {
                this.send_code_to_buffer(this.clearCode, outputStream);
                this.init_encoder(this.bitsPerPixel);
                continue;
            }
            ++this.codeLen;
        }
        this.send_code_to_buffer(n, outputStream);
        this.send_code_to_buffer(this.endOfImage, outputStream);
        this.flush_buf(outputStream, this.bufIndex + 1);
    }

    public void finishWrite(OutputStream outputStream) throws Exception {
        outputStream.write(59);
        outputStream.close();
    }

    private void flush_buf(OutputStream outputStream, int n) throws Exception {
        outputStream.write(n);
        outputStream.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, 255, (byte)0);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.GIF;
    }

    private void init_encoder(int n) {
        this.clearCode = 1 << n;
        this.endOfImage = this.clearCode + 1;
        this.codeLen = n + 1;
        this.codeIndex = this.endOfImage + 1;
        Arrays.fill(this.child, 0);
        Arrays.fill(this.siblings, 0);
        Arrays.fill(this.suffix, 0);
    }

    public void prepareForWrite(OutputStream outputStream, int n, int n2) throws Exception {
        this.writeHeader(outputStream, true);
        this.logicalScreenWidth = n;
        this.logicalScreenHeight = n2;
        this.animated = true;
    }

    private void send_code_to_buffer(int n, OutputStream outputStream) throws Exception {
        int n2 = this.codeLen;
        int n3 = this.bufIndex;
        this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | (n & MASK[this.empty_bits]) << 8 - this.empty_bits);
        n >>= this.empty_bits;
        n2 -= this.empty_bits;
        while (n2 > 0) {
            if (++this.bufIndex >= 255) {
                this.flush_buf(outputStream, 255);
            }
            int n4 = this.bufIndex;
            this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | n & 0xFF);
            n >>= 8;
            n2 -= 8;
        }
        this.empty_bits = -n2;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    @Override
    protected void write(int[] nArray, int n, int n2, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        this.logicalScreenWidth = n;
        this.logicalScreenHeight = n2;
        this.firstFrame = true;
        this.animated = false;
        this.writeFrame(nArray, n, n2, 0, 0, 0, outputStream);
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(BufferedImage[] bufferedImageArray, int[] nArray, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        Dimension dimension = GIFWriter.getLogicalScreenSize(bufferedImageArray);
        this.logicalScreenWidth = dimension.width;
        this.logicalScreenHeight = dimension.height;
        this.animated = true;
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            int n = bufferedImageArray[i].getWidth();
            int n2 = bufferedImageArray[i].getHeight();
            int[] nArray2 = IMGUtils.getRGB(bufferedImageArray[i]);
            this.writeFrame(nArray2, n, n2, 0, 0, nArray[i], outputStream);
        }
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(GIFFrame[] gIFFrameArray, OutputStream outputStream) throws Exception {
        this.writeHeader(outputStream, true);
        Dimension dimension = GIFWriter.getLogicalScreenSize(gIFFrameArray);
        this.logicalScreenWidth = dimension.width;
        this.logicalScreenHeight = dimension.height;
        this.animated = true;
        for (int i = 0; i < gIFFrameArray.length; ++i) {
            int n = gIFFrameArray[i].getFrameWidth();
            int n2 = gIFFrameArray[i].getFrameHeight();
            int[] nArray = IMGUtils.getRGB(gIFFrameArray[i].getFrame());
            if (gIFFrameArray[i].getTransparencyFlag() == 1 && gIFFrameArray[i].getTransparentColor() != -1) {
                int n3 = gIFFrameArray[i].getTransparentColor() & 0xFFFFFF;
                for (int j = nArray.length - 1; j > 0; --j) {
                    int n4 = nArray[j] & 0xFFFFFF;
                    if (n4 != n3) continue;
                    nArray[j] = n4;
                }
            }
            this.writeFrame(nArray, n, n2, gIFFrameArray[i].getLeftPosition(), gIFFrameArray[i].getTopPosition(), gIFFrameArray[i].getDelay(), gIFFrameArray[i].getDisposalMethod(), gIFFrameArray[i].getUserInputFlag(), outputStream);
        }
        outputStream.write(59);
        outputStream.close();
    }

    public void writeAnimatedGIF(List<GIFFrame> list, OutputStream outputStream) throws Exception {
        this.writeAnimatedGIF(list.toArray(new GIFFrame[0]), outputStream);
    }

    public void writeComment(OutputStream outputStream, String string) throws Exception {
        outputStream.write(33);
        outputStream.write(-2);
        byte[] byArray = string.getBytes();
        int n = byArray.length / 255;
        int n2 = byArray.length % 255;
        int n3 = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                outputStream.write(255);
                outputStream.write(byArray, n3, 255);
                n3 += 255;
            }
        }
        if (n2 > 0) {
            outputStream.write(n2);
            outputStream.write(byArray, n3, n2);
        }
        outputStream.write(0);
    }

    public void writeFrame(OutputStream outputStream, GIFFrame gIFFrame) throws Exception {
        BufferedImage bufferedImage = gIFFrame.getFrame();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = gIFFrame.getLeftPosition();
        int n4 = gIFFrame.getTopPosition();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = n;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = n2;
            }
        }
        if (n3 >= this.logicalScreenWidth || n4 >= this.logicalScreenHeight) {
            return;
        }
        if (n3 + n > this.logicalScreenWidth) {
            n = this.logicalScreenWidth - n3;
        }
        if (n4 + n2 > this.logicalScreenHeight) {
            n2 = this.logicalScreenHeight - n4;
        }
        int[] nArray = IMGUtils.getRGB(bufferedImage.getSubimage(0, 0, n, n2));
        if (gIFFrame.getTransparencyFlag() == 1 && gIFFrame.getTransparentColor() != -1) {
            int n5 = gIFFrame.getTransparentColor() & 0xFFFFFF;
            for (int i = nArray.length - 1; i > 0; --i) {
                int n6 = nArray[i] & 0xFFFFFF;
                if (n6 != n5) continue;
                nArray[i] = n6;
            }
        }
        this.writeFrame(nArray, n, n2, gIFFrame.getLeftPosition(), gIFFrame.getTopPosition(), gIFFrame.getDelay(), gIFFrame.getDisposalMethod(), gIFFrame.getUserInputFlag(), outputStream);
    }

    public void writeFrame(OutputStream outputStream, BufferedImage bufferedImage) throws Exception {
        this.writeFrame(outputStream, bufferedImage, 100);
    }

    public void writeFrame(OutputStream outputStream, BufferedImage bufferedImage, int n) throws Exception {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = n2;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = n3;
            }
        }
        if (n <= 0) {
            n = 100;
        }
        if (n2 > this.logicalScreenWidth) {
            n2 = this.logicalScreenWidth;
        }
        if (n3 > this.logicalScreenHeight) {
            n3 = this.logicalScreenHeight;
        }
        int[] nArray = IMGUtils.getRGB(bufferedImage.getSubimage(0, 0, n2, n3));
        this.writeFrame(nArray, n2, n3, 0, 0, n, outputStream);
    }

    private void writeFrame(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, OutputStream outputStream) throws Exception {
        ImageParam imageParam = this.getImageParam();
        this.empty_bits = 8;
        int n8 = -1;
        byte[] byArray = new byte[n * n2];
        this.colorPalette = new int[256];
        int[] nArray2 = IMGUtils.checkColorDepth(nArray, byArray, this.colorPalette);
        if (nArray2[0] > 8) {
            this.bitsPerPixel = imageParam.getBitsPerPixel();
            if (this.bitsPerPixel <= 0 || this.bitsPerPixel > 8) {
                this.bitsPerPixel = 8;
            }
            nArray2 = imageParam.isApplyDither() ? (imageParam.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(imageParam.getQuantMethod(), nArray, n, n2, this.bitsPerPixel, byArray, this.colorPalette) : IMGUtils.reduceColorsOrderedDither(imageParam.getQuantMethod(), nArray, n, n2, this.bitsPerPixel, byArray, this.colorPalette, imageParam.getDitherMatrix())) : IMGUtils.reduceColors(imageParam.getQuantMethod(), nArray, this.bitsPerPixel, byArray, this.colorPalette, false);
        }
        this.bitsPerPixel = nArray2[0];
        n8 = nArray2[1];
        int n9 = 1 << this.bitsPerPixel;
        if (this.firstFrame) {
            int n10 = -120;
            byte by = 0;
            byte by2 = 0;
            int n11 = 7;
            n10 = (byte)(n10 | (n11 << 4 | this.bitsPerPixel - 1));
            if (n8 >= 0) {
                by = (byte)n8;
            }
            this.writeLSD(outputStream, (short)this.logicalScreenWidth, (short)this.logicalScreenHeight, (short)n10, by, by2);
            this.writePalette(outputStream, n9);
            this.writeComment(outputStream, "Created by ICAFE - https://github.com/dragon66/icafe");
            if (this.animated) {
                this.writeNetscapeApplicationBlock(outputStream, this.loopCount);
            }
        }
        this.writeGraphicControlBlock(outputStream, n5, n8, n6, n7);
        if (this.firstFrame) {
            this.writeImageDescriptor(outputStream, n, n2, n3, n4, -1);
            this.firstFrame = false;
        } else {
            this.writeImageDescriptor(outputStream, n, n2, n3, n4, this.bitsPerPixel - 1);
            this.writePalette(outputStream, n9);
        }
        this.encode(byArray, outputStream);
        outputStream.write(0);
    }

    private void writeFrame(int[] nArray, int n, int n2, int n3, int n4, int n5, OutputStream outputStream) throws Exception {
        this.writeFrame(nArray, n, n2, n3, n4, n5, 2, 0, outputStream);
    }

    private void writeGraphicControlBlock(OutputStream outputStream, int n, int n2, int n3, int n4) throws Exception {
        byte[] byArray;
        n = Math.round((float)n / 10.0f);
        byArray = new byte[]{33, -7, 4, (byte)(byArray[3] | ((n3 & 7) << 2 | (n4 & 1) << 1)), (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)n2, 0};
        if (n2 >= 0) {
            byArray[3] = (byte)(byArray[3] | 1);
        }
        outputStream.write(byArray, 0, 8);
    }

    private void writeHeader(OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            outputStream.write("GIF89a".getBytes());
        } else {
            outputStream.write("GIF87a".getBytes());
        }
    }

    private void writeImageDescriptor(OutputStream outputStream, int n, int n2, int n3, int n4, int n5) throws Exception {
        byte[] byArray = new byte[]{44, (byte)(n3 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n4 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), 32};
        if (n5 >= 0) {
            byArray[9] = (byte)(byArray[9] | (0x80 | n5));
        }
        outputStream.write(byArray, 0, 10);
    }

    private void writeLSD(OutputStream outputStream, short s, short s2, short s3, byte by, byte by2) throws IOException {
        byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF), (byte)(s2 & 0xFF), (byte)(s2 >> 8 & 0xFF), (byte)(s3 & 0xFF), by, by2};
        outputStream.write(byArray);
    }

    private void writeNetscapeApplicationBlock(OutputStream outputStream, int n) throws Exception {
        byte[] byArray = new byte[]{33, -1, 11, 78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48, 3, 1, (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), 0};
        outputStream.write(byArray);
    }

    private void writePalette(OutputStream outputStream, int n) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            byArray[n2++] = (byte)(this.colorPalette[i] >> 16 & 0xFF);
            byArray[n2++] = (byte)(this.colorPalette[i] >> 8 & 0xFF);
            byArray[n2++] = (byte)(this.colorPalette[i] & 0xFF);
        }
        outputStream.write(byArray, 0, n * 3);
    }
}

