/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.tiff;

import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TIFFImage
implements Iterable<IFD>,
Closeable {
    private int numOfPages;
    private int workingPage;
    private List<IFD> ifds = new ArrayList<IFD>();
    private RandomAccessInputStream rin;

    public TIFFImage(RandomAccessInputStream randomAccessInputStream) throws IOException {
        this.rin = randomAccessInputStream;
        TIFFTweaker.readIFDs(this.ifds, randomAccessInputStream);
        this.numOfPages = this.ifds.size();
        this.workingPage = 0;
    }

    public void addField(TiffField<?> tiffField) {
        this.ifds.get(this.workingPage).addField(tiffField);
    }

    public TiffField<?> getField(Tag tag) {
        return this.ifds.get(this.workingPage).getField(tag);
    }

    public List<IFD> getIFDs() {
        return Collections.unmodifiableList(this.ifds);
    }

    public RandomAccessInputStream getInputStream() {
        return this.rin;
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public TiffField<?> removeField(Tag tag) {
        return this.ifds.get(this.workingPage).removeField(tag);
    }

    public IFD removePage(int n) {
        IFD iFD = this.ifds.remove(n);
        --this.numOfPages;
        return iFD;
    }

    public void setWorkingPage(int n) {
        if (n < 0 || n >= this.numOfPages) {
            throw new IllegalArgumentException("Invalid page number: " + n);
        }
        this.workingPage = n;
    }

    public void write(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        if (this.numOfPages > 1) {
            for (int i = 0; i < this.ifds.size(); ++i) {
                this.ifds.get(i).removeField(TiffTag.PAGE_NUMBER);
                this.ifds.get(i).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(this.numOfPages - 1)}));
            }
        }
        TIFFTweaker.write(this, randomAccessOutputStream);
    }

    @Override
    public Iterator<IFD> iterator() {
        return this.ifds.iterator();
    }

    @Override
    public void close() throws IOException {
        this.rin.close();
    }
}

