/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.compression.lzw.LZWTreeDecoder;
import com.icafe4j.image.gif.GIFFrame;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.io.IOUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GIFReader
extends ImageReader {
    private GifHeader gifHeader;
    protected int logicalScreenWidth;
    protected int logicalScreenHeight;
    private Color backgroundColor = new Color(255, 255, 255);
    private int[] globalColorPalette;
    protected int disposalMethod = 0;
    protected int userInputFlag = 0;
    protected int transparencyFlag = 0;
    protected int transparent_color = -1;
    protected int delay;
    protected int colorsUsed;
    protected int image_x;
    protected int image_y;
    private List<GIFFrame> gifFrames;
    private List<BufferedImage> frames;
    private BufferedImage baseImage;
    private static final Logger LOGGER = LoggerFactory.getLogger(GIFReader.class);

    private byte[] decodeLZW(InputStream inputStream) throws Exception {
        int n = this.width * this.height;
        byte[] byArray = new byte[n];
        int n2 = inputStream.read();
        LZWTreeDecoder lZWTreeDecoder = new LZWTreeDecoder(inputStream, n2);
        lZWTreeDecoder.decode(byArray, 0, n);
        return byArray;
    }

    private byte[] decodeLZWInterLaced(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 8, 4, 8, 2, 4, 1, 2};
        int[] nArray2 = new int[]{0, this.width * nArray[2], this.width * nArray[4], this.width * nArray[6]};
        int[] nArray3 = new int[]{this.width * nArray[1], this.width * nArray[3], this.width * nArray[5], this.width * nArray[7]};
        int[] nArray4 = new int[]{(this.height - 1 >> 3) + 1, this.height + 3 >> 3, this.height + 1 >> 2, this.height >> 1};
        int n3 = inputStream.read();
        int n4 = this.width * this.height;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        LZWTreeDecoder lZWTreeDecoder = new LZWTreeDecoder(inputStream, n3);
        lZWTreeDecoder.decode(byArray, 0, n4);
        for (int i = 1; i < 5; ++i) {
            n = nArray2[i - 1];
            int n5 = nArray3[i - 1] - this.width;
            int n6 = 0;
            while (n6 < nArray4[i - 1]) {
                int n7 = 0;
                while (n7 < this.width) {
                    byArray2[n] = byArray[n2];
                    ++n7;
                    ++n;
                    ++n2;
                }
                ++n6;
                n += n5;
            }
        }
        return byArray2;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected BufferedImage getFrameAsBufferedImage(InputStream inputStream) throws Exception {
        byte[] byArray = this.readFrame(inputStream);
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[]{0};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, this.width, 1, nArray, null);
        IndexColorModel indexColorModel = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, this.transparent_color, 0);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    protected BufferedImage getFrameAsBufferedImageEx(InputStream inputStream) throws Exception {
        int n;
        BufferedImage bufferedImage = this.getFrameAsBufferedImage(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        int n2 = this.width < this.logicalScreenWidth ? this.width : this.logicalScreenWidth;
        int n3 = n = this.height < this.logicalScreenHeight ? this.height : this.logicalScreenHeight;
        if (this.baseImage == null) {
            this.baseImage = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
        }
        Rectangle rectangle = new Rectangle(this.image_x, this.image_y, n2, n);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 2);
        bufferedImage2.setData(this.baseImage.getData(rectangle));
        Graphics2D graphics2D = this.baseImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, this.image_x, this.image_y, null);
        BufferedImage bufferedImage3 = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
        bufferedImage3.setData(this.baseImage.getData());
        if (this.disposalMethod != 1 && this.disposalMethod != 0) {
            if (this.disposalMethod == 2) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(this.image_x, this.image_y, this.width, this.height);
                graphics2D.setComposite(composite);
            } else if (this.disposalMethod == 3) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage((Image)bufferedImage2, this.image_x, this.image_y, null);
                graphics2D.setComposite(composite);
            } else {
                this.baseImage = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
                graphics2D = this.baseImage.createGraphics();
            }
        }
        return bufferedImage3;
    }

    @Override
    public int getFrameCount() {
        if (this.frames != null) {
            return this.frames.size();
        }
        return super.getFrameCount();
    }

    @Override
    public BufferedImage getFrame(int n) {
        if (this.frames == null) {
            return null;
        }
        if (n >= 0 && n < this.frames.size()) {
            return this.frames.get(n);
        }
        throw new IllegalArgumentException("Frame index " + n + " out of bounds");
    }

    @Override
    public List<BufferedImage> getFrames() {
        if (this.frames != null) {
            return Collections.unmodifiableList(this.frames);
        }
        return Collections.emptyList();
    }

    public GIFFrame getGIFFrame(int n) {
        if (this.gifFrames == null) {
            return null;
        }
        if (n < 0 || n >= this.gifFrames.size()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return this.gifFrames.get(n);
    }

    public List<GIFFrame> getGIFFrames() {
        if (this.gifFrames != null) {
            return Collections.unmodifiableList(this.gifFrames);
        }
        return Collections.emptyList();
    }

    public int getLogicalScreenHeight() {
        return this.logicalScreenHeight;
    }

    public int getLogicalScreenWidth() {
        return this.logicalScreenWidth;
    }

    public int getTransparentColor() {
        if (this.transparent_color >= 0) {
            return this.rgbColorPalette[this.transparent_color] & 0xFFFFFF;
        }
        return -1;
    }

    public boolean isTransparent() {
        return this.transparencyFlag == 1;
    }

    private byte[] readFrame(InputStream inputStream) throws Exception {
        int n;
        int n2;
        if (this.gifHeader == null && !this.readGlobalScopeData(inputStream)) {
            return null;
        }
        this.resetFrameParameters();
        int n3 = 0;
        do {
            if ((n3 = inputStream.read()) == -1 || n3 == 59) {
                LOGGER.info("End of stream!");
                return null;
            }
            if (n3 != 33) continue;
            n2 = inputStream.read();
            n = inputStream.read();
            if (n2 == 249) {
                int n4 = inputStream.read();
                this.disposalMethod = (n4 & 0x1C) >> 2;
                LOGGER.info("Disposal method: {}", (Object)(this.disposalMethod == 0 ? "UNSPECIFIED" : (this.disposalMethod == 1 ? "LEAVE_AS_IS" : (this.disposalMethod == 2 ? "RESTORE_TO_BACKGROUND" : (this.disposalMethod == 3 ? "RESTORE_TO_PREVIOUS" : "TO_BE_DEFINED")))));
                this.userInputFlag = (n4 & 2) >> 1;
                LOGGER.info("User input flag: {}", (Object)(this.userInputFlag == 0 ? "INPUT_NONE" : "INPUT_SET"));
                this.delay = IOUtils.readUnsignedShort(inputStream);
                LOGGER.info("Delay: {} miliseconds", (Object)(this.delay * 10));
                int n5 = inputStream.read();
                if ((n4 & 1) == 1) {
                    this.transparencyFlag = 1;
                    LOGGER.info("transparent gif...");
                    this.transparent_color = n5;
                }
                n = inputStream.read();
            }
            while (n != 0) {
                IOUtils.skipFully(inputStream, n);
                n = inputStream.read();
            }
        } while (n3 != 44);
        n2 = this.readImageDescriptor(inputStream);
        n = 0;
        if ((n2 & 0x80) == 128) {
            n = 1;
            LOGGER.info("local color map is present");
            this.bitsPerPixel = (n2 & 7) + 1;
            this.colorsUsed = 1 << this.bitsPerPixel;
            LOGGER.info("{} color image", (Object)this.colorsUsed);
            this.readLocalPalette(inputStream, this.colorsUsed);
        }
        if (n == 0) {
            this.rgbColorPalette = this.globalColorPalette;
        }
        if (this.transparencyFlag == 1 && this.transparent_color < this.colorsUsed) {
            int n6 = this.transparent_color;
            this.rgbColorPalette[n6] = this.rgbColorPalette[n6] & 0xFFFFFF;
        }
        if ((n2 & 0x40) == 64) {
            LOGGER.info("Interlaced gif image!");
            return this.decodeLZWInterLaced(inputStream);
        }
        return this.decodeLZW(inputStream);
    }

    private void readGlobalPalette(InputStream inputStream, int n) throws Exception {
        int n2 = 0;
        int n3 = n * 3;
        byte[] byArray = new byte[n3];
        IOUtils.readFully(inputStream, byArray, 0, n3);
        this.globalColorPalette = new int[n];
        for (int i = 0; i < n; ++i) {
            this.globalColorPalette[i] = 0xFF000000 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
    }

    private boolean readGlobalScopeData(InputStream inputStream) throws Exception {
        this.gifHeader = new GifHeader();
        this.gifHeader.readHeader(inputStream);
        this.logicalScreenWidth = this.gifHeader.screen_width;
        this.logicalScreenHeight = this.gifHeader.screen_height;
        String string = new String(this.gifHeader.signature) + new String(this.gifHeader.version);
        LOGGER.info(string);
        if (!string.equalsIgnoreCase("GIF87a") && !string.equalsIgnoreCase("GIF89a")) {
            LOGGER.warn("Only GIF87a and GIF89a is supported by this decoder!");
            return false;
        }
        byte by = this.gifHeader.flags;
        if ((by & 0x80) == 128) {
            LOGGER.info("a global color map is present!");
            this.bitsPerPixel = (by & 7) + 1;
            this.colorsUsed = 1 << this.bitsPerPixel;
            LOGGER.info("{} color image", (Object)this.colorsUsed);
            int n = ((by & 0x70) >> 4) + 1;
            this.readGlobalPalette(inputStream, this.colorsUsed);
            int n2 = this.gifHeader.bgcolor & 0xFF;
            if (n2 < this.colorsUsed) {
                this.backgroundColor = new Color(this.globalColorPalette[n2]);
            }
        }
        return true;
    }

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        this.frames = new ArrayList<BufferedImage>();
        this.gifFrames = new ArrayList<GIFFrame>();
        BufferedImage bufferedImage = null;
        while ((bufferedImage = this.getFrameAsBufferedImageEx(inputStream)) != null) {
            this.gifFrames.add(new GIFFrame(bufferedImage, this.image_x, this.image_y, this.delay, this.disposalMethod, this.userInputFlag, this.transparencyFlag, this.transparent_color));
            this.frames.add(bufferedImage);
        }
        return this.frames.get(0);
    }

    private byte readImageDescriptor(InputStream inputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[9];
        IOUtils.readFully(inputStream, byArray, 0, 9);
        this.image_x = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        this.image_y = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        this.width = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        this.height = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        return byArray[n++];
    }

    private void readLocalPalette(InputStream inputStream, int n) throws Exception {
        int n2 = 0;
        int n3 = n * 3;
        byte[] byArray = new byte[n3];
        IOUtils.readFully(inputStream, byArray, 0, n3);
        this.rgbColorPalette = new int[n];
        for (int i = 0; i < n; ++i) {
            this.rgbColorPalette[i] = 0xFF000000 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
    }

    private void resetFrameParameters() {
        this.disposalMethod = 0;
        this.userInputFlag = 0;
        this.transparencyFlag = 0;
        this.transparent_color = -1;
        this.delay = 0;
        this.image_x = 0;
        this.image_y = 0;
        this.width = 0;
        this.height = 0;
    }

    private static class GifHeader {
        private byte[] signature = new byte[3];
        private byte[] version = new byte[3];
        private int screen_width;
        private int screen_height;
        private byte flags;
        private byte bgcolor;
        private byte aspectRatio;

        private GifHeader() {
        }

        void readHeader(InputStream inputStream) throws Exception {
            int n;
            int n2 = 0;
            byte[] byArray = new byte[13];
            IOUtils.readFully(inputStream, byArray, 0, 13);
            for (n = 0; n < 3; ++n) {
                this.signature[n] = byArray[n2++];
            }
            for (n = 0; n < 3; ++n) {
                this.version[n] = byArray[n2++];
            }
            this.screen_width = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
            this.screen_height = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
            this.flags = byArray[n2++];
            this.bgcolor = byArray[n2++];
            this.aspectRatio = byArray[n2++];
        }
    }
}

