/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.quant;

public class WuQuant {
    private static final int MAXCOLOR = 256;
    private static final int RED = 2;
    private static final int GREEN = 1;
    private static final int BLUE = 0;
    private static int QUANT_SIZE = 33;
    private int size;
    private int lut_size;
    private int[] qadd;
    private int[] pixels;
    private int transparent_color = -1;
    private float[][][] m2 = new float[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] wt = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mr = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mg = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mb = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];

    public WuQuant(int[] nArray, int n) {
        this.pixels = nArray;
        this.size = nArray.length;
        this.lut_size = n;
    }

    public int quantize(byte[] byArray, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        Box[] boxArray = new Box[256];
        int[] nArray3 = new int[QUANT_SIZE * QUANT_SIZE * QUANT_SIZE];
        float[] fArray = new float[256];
        this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        for (n2 = 0; n2 < 256; ++n2) {
            boxArray[n2] = new Box();
        }
        boxArray[0].b0 = 0;
        boxArray[0].g0 = 0;
        boxArray[0].r0 = 0;
        boxArray[0].g1 = boxArray[0].b1 = QUANT_SIZE - 1;
        boxArray[0].r1 = boxArray[0].b1;
        int n3 = 0;
        if (this.transparent_color >= 0) {
            --this.lut_size;
        }
        for (n2 = 1; n2 < this.lut_size; ++n2) {
            if (this.Cut(boxArray[n3], boxArray[n2])) {
                fArray[n3] = boxArray[n3].vol > 1 ? this.Var(boxArray[n3]) : 0.0f;
                fArray[n2] = boxArray[n2].vol > 1 ? this.Var(boxArray[n2]) : 0.0f;
            } else {
                fArray[n3] = 0.0f;
                --n2;
            }
            n3 = 0;
            float f = fArray[0];
            for (n = 1; n <= n2; ++n) {
                if (!(fArray[n] > f)) continue;
                f = fArray[n];
                n3 = n;
            }
            if (!(f <= 0.0f)) continue;
            n = n2 + 1;
            break;
        }
        for (n = 0; n < this.lut_size; ++n) {
            this.Mark(boxArray[n], n, nArray3);
            long l = this.Vol(boxArray[n], this.wt);
            if (l > 0L) {
                int n4 = (int)(this.Vol(boxArray[n], this.mr) / l);
                int n5 = (int)(this.Vol(boxArray[n], this.mg) / l);
                int n6 = (int)(this.Vol(boxArray[n], this.mb) / l);
                nArray[n] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                continue;
            }
            nArray[n] = 0;
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            byArray[n2] = this.pixels[n2] >>> 24 < 128 ? (byte)this.lut_size : (byte)nArray3[this.qadd[n2]];
        }
        int n7 = 0;
        while (1 << n7 < this.lut_size) {
            ++n7;
        }
        nArray2[0] = n7;
        nArray2[1] = -1;
        if (this.transparent_color >= 0) {
            nArray[this.lut_size] = this.transparent_color;
            nArray2[1] = this.lut_size;
        }
        return this.lut_size;
    }

    public int quantize(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        Box[] boxArray = new Box[256];
        float[] fArray = new float[256];
        this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        for (n2 = 0; n2 < 256; ++n2) {
            boxArray[n2] = new Box();
        }
        boxArray[0].b0 = 0;
        boxArray[0].g0 = 0;
        boxArray[0].r0 = 0;
        boxArray[0].g1 = boxArray[0].b1 = QUANT_SIZE - 1;
        boxArray[0].r1 = boxArray[0].b1;
        int n3 = 0;
        if (this.transparent_color >= 0) {
            --this.lut_size;
        }
        for (n2 = 1; n2 < this.lut_size; ++n2) {
            if (this.Cut(boxArray[n3], boxArray[n2])) {
                fArray[n3] = boxArray[n3].vol > 1 ? this.Var(boxArray[n3]) : 0.0f;
                fArray[n2] = boxArray[n2].vol > 1 ? this.Var(boxArray[n2]) : 0.0f;
            } else {
                fArray[n3] = 0.0f;
                --n2;
            }
            n3 = 0;
            float f = fArray[0];
            for (n = 1; n <= n2; ++n) {
                if (!(fArray[n] > f)) continue;
                f = fArray[n];
                n3 = n;
            }
            if (!(f <= 0.0f)) continue;
            n = n2 + 1;
            break;
        }
        for (n = 0; n < this.lut_size; ++n) {
            long l = this.Vol(boxArray[n], this.wt);
            if (l > 0L) {
                int n4 = (int)(this.Vol(boxArray[n], this.mr) / l);
                int n5 = (int)(this.Vol(boxArray[n], this.mg) / l);
                int n6 = (int)(this.Vol(boxArray[n], this.mb) / l);
                nArray[n] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                continue;
            }
            nArray[n] = 0;
        }
        int n7 = 0;
        while (1 << n7 < this.lut_size) {
            ++n7;
        }
        nArray2[0] = n7;
        nArray2[1] = -1;
        if (this.transparent_color >= 0) {
            nArray[this.lut_size] = this.transparent_color;
            nArray2[1] = this.lut_size;
        }
        return this.lut_size;
    }

    private void Hist3d(long[][][] lArray, long[][][] lArray2, long[][][] lArray3, long[][][] lArray4, float[][][] fArray) {
        int n;
        int[] nArray = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray[n] = n * n;
        }
        this.qadd = new int[this.size];
        for (n = 0; n < this.size; ++n) {
            int n2 = this.pixels[n];
            if (n2 >>> 24 < 128 && this.transparent_color < 0) {
                this.transparent_color = n2;
            }
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = (n3 >> 3) + 1;
            int n7 = (n4 >> 3) + 1;
            int n8 = (n5 >> 3) + 1;
            this.qadd[n] = (n6 << 10) + (n6 << 6) + n6 + (n7 << 5) + n7 + n8;
            long[] lArray5 = lArray[n6][n7];
            int n9 = n8;
            lArray5[n9] = lArray5[n9] + 1L;
            long[] lArray6 = lArray2[n6][n7];
            int n10 = n8;
            lArray6[n10] = lArray6[n10] + (long)n3;
            long[] lArray7 = lArray3[n6][n7];
            int n11 = n8;
            lArray7[n11] = lArray7[n11] + (long)n4;
            long[] lArray8 = lArray4[n6][n7];
            int n12 = n8;
            lArray8[n12] = lArray8[n12] + (long)n5;
            float[] fArray2 = fArray[n6][n7];
            int n13 = n8;
            fArray2[n13] = fArray2[n13] + (float)(nArray[n3] + nArray[n4] + nArray[n5]);
        }
    }

    private void M3d(long[][][] lArray, long[][][] lArray2, long[][][] lArray3, long[][][] lArray4, float[][][] fArray) {
        int[] nArray = new int[QUANT_SIZE];
        int[] nArray2 = new int[QUANT_SIZE];
        int[] nArray3 = new int[QUANT_SIZE];
        int[] nArray4 = new int[QUANT_SIZE];
        float[] fArray2 = new float[QUANT_SIZE];
        for (int i = 1; i < QUANT_SIZE; ++i) {
            for (int j = 0; j < QUANT_SIZE; ++j) {
                nArray4[j] = 0;
                nArray3[j] = 0;
                nArray2[j] = 0;
                nArray[j] = 0;
                fArray2[j] = 0;
            }
            for (int j = 1; j < QUANT_SIZE; ++j) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                float f = 0;
                for (int k = 1; k < QUANT_SIZE; ++k) {
                    n4 = (int)((long)n4 + lArray[i][j][k]);
                    n3 = (int)((long)n3 + lArray2[i][j][k]);
                    n2 = (int)((long)n2 + lArray3[i][j][k]);
                    n = (int)((long)n + lArray4[i][j][k]);
                    f += fArray[i][j][k];
                    int n5 = k;
                    nArray[n5] = nArray[n5] + n4;
                    int n6 = k;
                    nArray2[n6] = nArray2[n6] + n3;
                    int n7 = k;
                    nArray3[n7] = nArray3[n7] + n2;
                    int n8 = k;
                    nArray4[n8] = nArray4[n8] + n;
                    int n9 = k;
                    fArray2[n9] = fArray2[n9] + f;
                    lArray[i][j][k] = lArray[i - 1][j][k] + (long)nArray[k];
                    lArray2[i][j][k] = lArray2[i - 1][j][k] + (long)nArray2[k];
                    lArray3[i][j][k] = lArray3[i - 1][j][k] + (long)nArray3[k];
                    lArray4[i][j][k] = lArray4[i - 1][j][k] + (long)nArray4[k];
                    fArray[i][j][k] = fArray[i - 1][j][k] + fArray2[k];
                }
            }
        }
    }

    private long Vol(Box box, long[][][] lArray) {
        return lArray[box.r1][box.g1][box.b1] - lArray[box.r1][box.g1][box.b0] - lArray[box.r1][box.g0][box.b1] + lArray[box.r1][box.g0][box.b0] - lArray[box.r0][box.g1][box.b1] + lArray[box.r0][box.g1][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
    }

    private long Bottom(Box box, int n, long[][][] lArray) {
        switch (n) {
            case 2: {
                return -lArray[box.r0][box.g1][box.b1] + lArray[box.r0][box.g1][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
            }
            case 1: {
                return -lArray[box.r1][box.g0][box.b1] + lArray[box.r1][box.g0][box.b0] + lArray[box.r0][box.g0][box.b1] - lArray[box.r0][box.g0][box.b0];
            }
            case 0: {
                return -lArray[box.r1][box.g1][box.b0] + lArray[box.r1][box.g0][box.b0] + lArray[box.r0][box.g1][box.b0] - lArray[box.r0][box.g0][box.b0];
            }
        }
        return 0L;
    }

    private long Top(Box box, int n, int n2, long[][][] lArray) {
        switch (n) {
            case 2: {
                return lArray[n2][box.g1][box.b1] - lArray[n2][box.g1][box.b0] - lArray[n2][box.g0][box.b1] + lArray[n2][box.g0][box.b0];
            }
            case 1: {
                return lArray[box.r1][n2][box.b1] - lArray[box.r1][n2][box.b0] - lArray[box.r0][n2][box.b1] + lArray[box.r0][n2][box.b0];
            }
            case 0: {
                return lArray[box.r1][box.g1][n2] - lArray[box.r1][box.g0][n2] - lArray[box.r0][box.g1][n2] + lArray[box.r0][box.g0][n2];
            }
        }
        return 0L;
    }

    private float Var(Box box) {
        float f = this.Vol(box, this.mr);
        float f2 = this.Vol(box, this.mg);
        float f3 = this.Vol(box, this.mb);
        float f4 = this.m2[box.r1][box.g1][box.b1] - this.m2[box.r1][box.g1][box.b0] - this.m2[box.r1][box.g0][box.b1] + this.m2[box.r1][box.g0][box.b0] - this.m2[box.r0][box.g1][box.b1] + this.m2[box.r0][box.g1][box.b0] + this.m2[box.r0][box.g0][box.b1] - this.m2[box.r0][box.g0][box.b0];
        return f4 - (f * f + f2 * f2 + f3 * f3) / (float)this.Vol(box, this.wt);
    }

    private float Maximize(Box box, int n, int n2, int n3, int[] nArray, long l, long l2, long l3, long l4) {
        long l5 = this.Bottom(box, n, this.mr);
        long l6 = this.Bottom(box, n, this.mg);
        long l7 = this.Bottom(box, n, this.mb);
        long l8 = this.Bottom(box, n, this.wt);
        float f = 0.0f;
        nArray[0] = -1;
        for (int i = n2; i < n3; ++i) {
            long l9 = l5 + this.Top(box, n, i, this.mr);
            long l10 = l6 + this.Top(box, n, i, this.mg);
            long l11 = l7 + this.Top(box, n, i, this.mb);
            long l12 = l8 + this.Top(box, n, i, this.wt);
            if (l12 == 0L) continue;
            float f2 = (float)(l9 * l9 + l10 * l10 + l11 * l11) / (float)l12;
            l9 = l - l9;
            l10 = l2 - l10;
            l11 = l3 - l11;
            if ((l12 = l4 - l12) == 0L || !((f2 += (float)(l9 * l9 + l10 * l10 + l11 * l11) / (float)l12) > f)) continue;
            f = f2;
            nArray[0] = i;
        }
        return f;
    }

    private boolean Cut(Box box, Box box2) {
        int n;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        long l = this.Vol(box, this.mr);
        long l2 = this.Vol(box, this.mg);
        long l3 = this.Vol(box, this.mb);
        long l4 = this.Vol(box, this.wt);
        float f = this.Maximize(box, 2, box.r0 + 1, box.r1, nArray, l, l2, l3, l4);
        float f2 = this.Maximize(box, 1, box.g0 + 1, box.g1, nArray2, l, l2, l3, l4);
        float f3 = this.Maximize(box, 0, box.b0 + 1, box.b1, nArray3, l, l2, l3, l4);
        if (f >= f2 && f >= f3) {
            n = 2;
            if (nArray[0] < 0) {
                return false;
            }
        } else {
            n = f2 >= f && f2 >= f3 ? 1 : 0;
        }
        box2.r1 = box.r1;
        box2.g1 = box.g1;
        box2.b1 = box.b1;
        switch (n) {
            case 2: {
                box2.r0 = box.r1 = nArray[0];
                box2.g0 = box.g0;
                box2.b0 = box.b0;
                break;
            }
            case 1: {
                box2.g0 = box.g1 = nArray2[0];
                box2.r0 = box.r0;
                box2.b0 = box.b0;
                break;
            }
            case 0: {
                box2.b0 = box.b1 = nArray3[0];
                box2.r0 = box.r0;
                box2.g0 = box.g0;
            }
        }
        box.vol = (box.r1 - box.r0) * (box.g1 - box.g0) * (box.b1 - box.b0);
        box2.vol = (box2.r1 - box2.r0) * (box2.g1 - box2.g0) * (box2.b1 - box2.b0);
        return true;
    }

    private void Mark(Box box, int n, int[] nArray) {
        for (int i = box.r0 + 1; i <= box.r1; ++i) {
            for (int j = box.g0 + 1; j <= box.g1; ++j) {
                for (int k = box.b0 + 1; k <= box.b1; ++k) {
                    nArray[(i << 10) + (i << 6) + i + (j << 5) + j + k] = n;
                }
            }
        }
    }

    private static final class Box {
        int r0;
        int r1;
        int g0;
        int g1;
        int b0;
        int b1;
        int vol;

        private Box() {
        }
    }
}

