/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Reader;
import java.io.IOException;

public class SRGBReader
implements Reader {
    private Chunk chunk;
    private byte renderingIntent;

    public SRGBReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.SRGB) {
            throw new IllegalArgumentException("Not a valid sRGB chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("SRGBReader: error reading chunk");
        }
    }

    public byte getRenderingIntent() {
        return this.renderingIntent;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.chunk.getData();
        this.renderingIntent = byArray.length > 0 ? byArray[0] : (byte)-1;
    }
}

