/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.icc.ICCProfile;
import com.icafe4j.image.meta.png.PngXMP;
import com.icafe4j.image.meta.png.TIMEChunk;
import com.icafe4j.image.meta.png.TextualChunks;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.ICCPBuilder;
import com.icafe4j.image.png.TextBuilder;
import com.icafe4j.image.png.TextReader;
import com.icafe4j.image.png.UnknownChunk;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import com.icafe4j.string.XMLUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ICC_Profile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PNGTweaker {
    private static final long SIGNATURE = -8552249625308161526L;
    private static Set<ChunkType> REMOVABLE = EnumSet.range(ChunkType.TEXT, ChunkType.TIME);
    private static final Logger LOGGER = LoggerFactory.getLogger(PNGTweaker.class);

    public static void dumpTextChunks(Chunk[] chunkArray) throws IOException {
        TextReader textReader = new TextReader();
        for (Chunk chunk : chunkArray) {
            if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ITXT && chunk.getChunkType() != ChunkType.ZTXT) continue;
            textReader.setInput(chunk);
            LOGGER.info("{}: {}", (Object)textReader.getKeyword(), (Object)textReader.getText());
        }
    }

    public static void dumpTextChunks(InputStream inputStream) throws IOException {
        LOGGER.info("\n{}", (Object)PNGTweaker.readTextChunks(inputStream));
    }

    public static void insertChunk(Chunk chunk, InputStream inputStream, OutputStream outputStream) throws IOException {
        PNGTweaker.insertChunks(inputStream, outputStream, chunk);
    }

    public static void insertChunks(InputStream inputStream, OutputStream outputStream, Chunk ... chunkArray) throws IOException {
        List<Chunk> list = PNGTweaker.readChunks(inputStream);
        Collections.addAll(list, chunkArray);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGTweaker.serializeChunks(list, outputStream);
    }

    public static void insertChunks(List<Chunk> list, InputStream inputStream, OutputStream outputStream) throws IOException {
        List<Chunk> list2 = PNGTweaker.readChunks(inputStream);
        list2.addAll(list);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGTweaker.serializeChunks(list2, outputStream);
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        TextBuilder textBuilder = new TextBuilder(ChunkType.TEXT);
        int n = list.size();
        Chunk[] chunkArray = new Chunk[n];
        for (int i = 0; i < n; ++i) {
            chunkArray[i] = textBuilder.keyword("Comment").text(list.get(i)).build();
        }
        PNGTweaker.insertChunks(inputStream, outputStream, chunkArray);
    }

    public static void insertICCProfile(String string, byte[] byArray, InputStream inputStream, OutputStream outputStream) throws IOException {
        ICCPBuilder iCCPBuilder = new ICCPBuilder();
        iCCPBuilder.name(string);
        iCCPBuilder.data(byArray);
        PNGTweaker.insertChunk(iCCPBuilder.build(), inputStream, outputStream);
    }

    public static void insertICCProfile(String string, ICC_Profile iCC_Profile, InputStream inputStream, OutputStream outputStream) throws IOException {
        PNGTweaker.insertICCProfile(string, iCC_Profile.getData(), inputStream, outputStream);
    }

    public static void insertTextChunk(ChunkType chunkType, String string, String string2, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (chunkType == null || string == null || string2 == null) {
            throw new IllegalArgumentException("Argument(s) are null");
        }
        PNGTweaker.insertChunk(new TextBuilder(chunkType).keyword(string).text(string2).build(), inputStream, outputStream);
    }

    public static void insertTextChunks(TextualChunks textualChunks, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (textualChunks == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        PNGTweaker.insertChunks(textualChunks.getChunks(), inputStream, outputStream);
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        PNGTweaker.insert(inputStream, outputStream, XMLUtils.serializeToString(xMP.getMergedDocument()));
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Document document = XMLUtils.createXML(string);
        XMLUtils.insertLeadingPI(document, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(document, "xpacket", "end='r'");
        String string2 = XMLUtils.serializeToString(document);
        PNGTweaker.insert(inputStream, outputStream, string2);
    }

    private static void insert(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Chunk chunk;
        List<Chunk> list = PNGTweaker.readChunks(inputStream);
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            chunk = listIterator.next();
            if (chunk.getChunkType() != ChunkType.ITXT) continue;
            TextReader textReader = new TextReader(chunk);
            if (textReader.getKeyword().equals("XML:com.adobe.xmp")) {
                // empty if block
            }
            listIterator.remove();
        }
        chunk = new TextBuilder(ChunkType.ITXT).keyword("XML:com.adobe.xmp").text(string).build();
        list.add(chunk);
        IOUtils.writeLongMM(outputStream, -8552249625308161526L);
        PNGTweaker.serializeChunks(list, outputStream);
    }

    public static List<Chunk> mergeIDATChunks(List<Chunk> list) {
        ListIterator<Chunk> listIterator = list.listIterator();
        byte[] byArray = new byte[]{};
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (chunk.getChunkType() != ChunkType.IDAT) continue;
            byArray = ArrayUtils.concat(byArray, new byte[][]{chunk.getData()});
            listIterator.remove();
        }
        list.add(new Chunk(ChunkType.IDAT, byArray.length, byArray, Chunk.calculateCRC(ChunkType.IDAT.getValue(), byArray)));
        return list;
    }

    public static byte[] readICCProfileChunk(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        byArray = new byte[17];
        IOUtils.readFully(inputStream, byArray, 0, 17);
        while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(n2);
            switch (chunkType) {
                case ICCP: {
                    byArray = new byte[n];
                    IOUtils.readFully(inputStream, byArray);
                    IOUtils.skipFully(inputStream, 4);
                    return PNGTweaker.readICCProfile(byArray);
                }
            }
            byArray = new byte[n + 4];
            IOUtils.readFully(inputStream, byArray, 0, n + 4);
        }
        IOUtils.readIntMM(inputStream);
        return null;
    }

    public static String readTextChunks(File file) throws IOException {
        return PNGTweaker.readTextChunks(new FileInputStream(file));
    }

    public static String readTextChunks(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            throw new RuntimeException("ReadTextChunks: Invalid PNG signature");
        }
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("ReadTextChunks: Invalid PNG header");
        }
        byArray = new byte[17];
        IOUtils.readFully(inputStream, byArray, 0, 17);
        block5: while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(n2);
            switch (chunkType) {
                case ZTXT: {
                    stringBuilder.append("zTXt chunk:\n");
                    stringBuilder.append("**********************\n");
                    byArray = new byte[n];
                    IOUtils.readFully(inputStream, byArray);
                    int n3 = 0;
                    while (byArray[n3] != 0) {
                        ++n3;
                    }
                    stringBuilder.append(new String(byArray, 0, n3, "UTF-8"));
                    stringBuilder.append(": ");
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n3 + 2, n - n3 - 2));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inflaterInputStream, "UTF-8");
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("**********************\n");
                    bufferedReader.close();
                    IOUtils.skipFully(inputStream, 4);
                    continue block5;
                }
                case TEXT: {
                    stringBuilder.append("tEXt chunk:\n");
                    stringBuilder.append("**********************\n");
                    byArray = new byte[n];
                    IOUtils.readFully(inputStream, byArray);
                    int n3 = 0;
                    while (byArray[n3] != 0) {
                        ++n3;
                    }
                    stringBuilder.append(new String(byArray, 0, n3, "UTF-8"));
                    stringBuilder.append(": ");
                    stringBuilder.append(new String(byArray, n3 + 1, n - n3 - 1, "UTF-8"));
                    stringBuilder.append("\n**********************\n");
                    IOUtils.skipFully(inputStream, 4);
                    continue block5;
                }
                case ITXT: {
                    String string;
                    BufferedReader bufferedReader;
                    InputStreamReader inputStreamReader;
                    InflaterInputStream inflaterInputStream;
                    stringBuilder.append("iTXt chunk:\n");
                    stringBuilder.append("**********************\n");
                    byArray = new byte[n];
                    IOUtils.readFully(inputStream, byArray);
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    boolean bl = false;
                    while (byArray[n3] != 0) {
                        ++n3;
                    }
                    stringBuilder.append(new String(byArray, 0, n3, "UTF-8"));
                    if (byArray[++n3] == 1) {
                        bl = true;
                    }
                    ++n3;
                    while (byArray[++n3] != 0) {
                        ++n5;
                    }
                    stringBuilder.append("(");
                    if (n5 > 0) {
                        stringBuilder.append(new String(byArray, n3 - n5, n5, "UTF-8"));
                    }
                    while (byArray[++n3] != 0) {
                        ++n4;
                    }
                    if (n4 > 0) {
                        stringBuilder.append(" ");
                        stringBuilder.append(new String(byArray, n3 - n4, n4, "UTF-8"));
                    }
                    stringBuilder.append("): ");
                    if (bl) {
                        inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n3 + 1, n - n3 - 1));
                        inputStreamReader = new InputStreamReader((InputStream)inflaterInputStream, "UTF-8");
                        bufferedReader = new BufferedReader(inputStreamReader);
                        string = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string);
                            stringBuilder.append("\n");
                        }
                        bufferedReader.close();
                    } else {
                        stringBuilder.append(new String(byArray, n3 + 1, n - n3 - 1, "UTF-8"));
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("**********************\n");
                    IOUtils.skipFully(inputStream, 4);
                    continue block5;
                }
            }
            byArray = new byte[n + 4];
            IOUtils.readFully(inputStream, byArray, 0, n + 4);
        }
        IOUtils.readIntMM(inputStream);
        return stringBuilder.toString();
    }

    public static String readTextChunks(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = PNGTweaker.readTextChunks(fileInputStream);
        fileInputStream.close();
        return string2;
    }

    public static List<Chunk> readChunks(InputStream inputStream) throws IOException {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        byArray = new byte[13];
        IOUtils.readFully(inputStream, byArray, 0, 13);
        arrayList.add(new Chunk(ChunkType.IHDR, 13L, byArray, IOUtils.readUnsignedIntMM(inputStream)));
        while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(n2);
            byArray = new byte[n];
            IOUtils.readFully(inputStream, byArray, 0, n);
            if (chunkType == ChunkType.UNKNOWN) {
                arrayList.add(new UnknownChunk(n, n2, byArray, IOUtils.readUnsignedIntMM(inputStream)));
                continue;
            }
            arrayList.add(new Chunk(chunkType, n, byArray, IOUtils.readUnsignedIntMM(inputStream)));
        }
        arrayList.add(new Chunk(ChunkType.IEND, n, new byte[0], IOUtils.readUnsignedIntMM(inputStream)));
        return arrayList;
    }

    private static byte[] readICCProfile(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Input array is null");
        }
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n, "UTF-8");
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n + 2, byArray.length - n - 2));
        LOGGER.info("ICCProfile name: {}", (Object)string);
        byte[] byArray2 = IOUtils.readFully((InputStream)inflaterInputStream, 4096);
        LOGGER.info("ICCProfile length: {}", (Object)byArray2.length);
        return byArray2;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        Object object;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        List<Chunk> list = PNGTweaker.readChunks(inputStream);
        Iterator<Chunk> iterator = list.iterator();
        TextualChunks textualChunks = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            ChunkType chunkType = ((Chunk)object).getChunkType();
            long l = ((Chunk)object).getLength();
            if (chunkType == ChunkType.ICCP) {
                hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile(PNGTweaker.readICCProfile(((Chunk)object).getData())));
            } else if (chunkType == ChunkType.TEXT || chunkType == ChunkType.ITXT || chunkType == ChunkType.ZTXT) {
                if (textualChunks == null) {
                    textualChunks = new TextualChunks();
                }
                textualChunks.addChunk((Chunk)object);
            } else if (chunkType == ChunkType.TIME) {
                hashMap.put(MetadataType.PNG_TIME, new TIMEChunk((Chunk)object));
            }
            LOGGER.info("{} ({}) | {} bytes | 0x{} (CRC)", new Object[]{chunkType.getName(), chunkType.getAttribute(), l, Long.toHexString(((Chunk)object).getCRC())});
        }
        if (textualChunks != null) {
            hashMap.put(MetadataType.PNG_TEXTUAL, textualChunks);
            object = textualChunks.getKeyValMap();
            for (Map.Entry entry : object.entrySet()) {
                if (!((String)entry.getKey()).equals("XML:com.adobe.xmp")) continue;
                hashMap.put(MetadataType.XMP, new PngXMP((String)entry.getValue()));
            }
        }
        inputStream.close();
        return hashMap;
    }

    public static void removeAncillaryChunks(InputStream inputStream, Set<ChunkType> set) throws IOException {
        File file = new File(".");
        if (set != null) {
            REMOVABLE = EnumSet.noneOf(ChunkType.class);
            for (ChunkType chunkType : set) {
                if (chunkType.getAttribute() != ChunkType.Attribute.ANCILLARY) continue;
                REMOVABLE.add(chunkType);
            }
        }
        String string = "slim.png";
        PNGTweaker.removeChunks(inputStream, file, string);
        LOGGER.info(">>{}", (Object)string);
        LOGGER.info("************************");
    }

    public static List<Chunk> removeAncillaryChunks(List<Chunk> list) throws Exception {
        return PNGTweaker.removeChunks(list, REMOVABLE);
    }

    public static void removeAncillaryChunks(String string, Set<ChunkType> set) throws IOException {
        File file = new File(".");
        File[] fileArray = null;
        if (!StringUtils.isNullOrEmpty(string) && (fileArray = new File[]{new File(string)})[0].isDirectory()) {
            file = fileArray[0];
            fileArray = null;
        }
        if (fileArray == null) {
            fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith("png");
                }
            });
        }
        if (set != null) {
            REMOVABLE = EnumSet.noneOf(ChunkType.class);
            for (ChunkType chunkType : set) {
                if (chunkType.getAttribute() != ChunkType.Attribute.ANCILLARY) continue;
                REMOVABLE.add(chunkType);
            }
        }
        Object object = null;
        for (int i = fileArray.length - 1; i >= 0; --i) {
            String string2 = fileArray[i].getName();
            string2 = string2.substring(0, string2.lastIndexOf(46)) + "_slim.png";
            LOGGER.info("<<{}", (Object)fileArray[i].getName());
            object = new FileInputStream(fileArray[i]);
            PNGTweaker.removeChunks((InputStream)object, file, string2);
            LOGGER.info(">>{}", (Object)string2);
            LOGGER.info("************************");
            ((FileInputStream)object).close();
        }
    }

    private static void removeChunks(InputStream inputStream, File file, String string) throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string));
        IOUtils.writeLongMM(fileOutputStream, -8552249625308161526L);
        IOUtils.writeIntMM(fileOutputStream, 13);
        IOUtils.writeIntMM(fileOutputStream, ChunkType.IHDR.getValue());
        byArray = new byte[17];
        IOUtils.readFully(inputStream, byArray, 0, 17);
        IOUtils.write((OutputStream)fileOutputStream, byArray);
        while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            if (REMOVABLE.contains((Object)ChunkType.fromInt(n2))) {
                LOGGER.info("{} Chunk removed!", (Object)ChunkType.fromInt(n2));
                IOUtils.skipFully(inputStream, n + 4);
                continue;
            }
            byArray = new byte[n + 4];
            IOUtils.readFully(inputStream, byArray, 0, n + 4);
            IOUtils.writeIntMM(fileOutputStream, n);
            IOUtils.writeIntMM(fileOutputStream, n2);
            IOUtils.write((OutputStream)fileOutputStream, byArray);
        }
        IOUtils.writeIntMM(fileOutputStream, n);
        IOUtils.writeIntMM(fileOutputStream, ChunkType.IEND.getValue());
        int n3 = IOUtils.readIntMM(inputStream);
        IOUtils.writeIntMM(fileOutputStream, n3);
        fileOutputStream.close();
    }

    public static List<Chunk> removeChunks(List<Chunk> list, ChunkType chunkType) {
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (chunk.getChunkType() != chunkType) continue;
            listIterator.remove();
        }
        return list;
    }

    public static List<Chunk> removeChunks(List<Chunk> list, Set<ChunkType> set) {
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (!set.contains((Object)chunk.getChunkType())) continue;
            listIterator.remove();
        }
        return list;
    }

    public static List<Chunk> removeTextChunks(List<Chunk> list) {
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = (Chunk)listIterator.next();
            if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ZTXT && chunk.getChunkType() != ChunkType.ITXT) continue;
            listIterator.remove();
        }
        return list;
    }

    public static void serializeChunks(List<Chunk> list, OutputStream outputStream) throws IOException {
        Collections.sort(list);
        for (Chunk chunk : list) {
            chunk.write(outputStream);
        }
    }

    public static void showICCProfile(InputStream inputStream) throws IOException {
        byte[] byArray = PNGTweaker.readICCProfileChunk(inputStream);
        if (byArray != null) {
            ICCProfile.showProfile(byArray);
        }
    }

    public static List<Chunk> splitIDATChunk(Chunk chunk, int n) {
        if (chunk.getChunkType() != ChunkType.IDAT) {
            throw new IllegalArgumentException("Not a valid IDAT chunk.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid IDAT chunk size: " + n);
        }
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        byte[] byArray = chunk.getData();
        int n2 = byArray.length;
        int n3 = n2 % n;
        int n4 = n2 / n;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n3];
        for (int i = 0; i < n4; ++i) {
            byArray2 = ArrayUtils.subArray(byArray, i * n, n);
            arrayList.add(new Chunk(ChunkType.IDAT, n, byArray2, Chunk.calculateCRC(ChunkType.IDAT.getValue(), byArray2)));
        }
        if (n3 != 0) {
            byArray3 = ArrayUtils.subArray(byArray, n2 - n3, n3);
            arrayList.add(new Chunk(ChunkType.IDAT, n3, byArray3, Chunk.calculateCRC(ChunkType.IDAT.getValue(), byArray3)));
        }
        return arrayList;
    }

    public static List<Chunk> splitIDATChunks(List<Chunk> list, int n) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        ListIterator<Chunk> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Chunk chunk = listIterator.next();
            if (chunk.getChunkType() != ChunkType.IDAT) continue;
            arrayList.addAll(PNGTweaker.splitIDATChunk(chunk, n));
            listIterator.remove();
        }
        list.addAll(arrayList);
        return list;
    }

    private PNGTweaker() {
    }
}

