/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Reader;
import java.io.IOException;

public class PLTEReader
implements Reader {
    private byte[] redMap;
    private byte[] greenMap;
    private byte[] blueMap;
    private Chunk chunk;

    public PLTEReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.PLTE) {
            throw new IllegalArgumentException("Not a valid PLTE chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("PLTEReader: error reading chunk");
        }
    }

    public byte[] getRedMap() {
        return this.redMap;
    }

    public byte[] getGreenMap() {
        return this.greenMap;
    }

    public byte[] getBlueMap() {
        return this.blueMap;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.chunk.getData();
        int n = byArray.length;
        if (n % 3 != 0) {
            throw new IllegalArgumentException("Invalid colorMap length: " + n);
        }
        this.redMap = new byte[n / 3];
        this.greenMap = new byte[n / 3];
        this.blueMap = new byte[n / 3];
        int n2 = n - 1;
        for (int i = this.redMap.length - 1; i >= 0; --i) {
            this.blueMap[i] = byArray[n2--];
            this.greenMap[i] = byArray[n2--];
            this.redMap[i] = byArray[n2--];
        }
    }
}

