/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkBuilder;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Builder;

public class PLTEBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private byte[] redMap;
    private byte[] greenMap;
    private byte[] blueMap;

    public PLTEBuilder() {
        super(ChunkType.PLTE);
    }

    public PLTEBuilder redMap(byte[] byArray) {
        this.redMap = byArray;
        return this;
    }

    public PLTEBuilder greenMap(byte[] byArray) {
        this.greenMap = byArray;
        return this;
    }

    public PLTEBuilder blueMap(byte[] byArray) {
        this.blueMap = byArray;
        return this;
    }

    @Override
    protected byte[] buildData() {
        int n = this.redMap.length;
        byte[] byArray = new byte[3 * n];
        int n2 = byArray.length - 1;
        for (int i = n - 1; i >= 0; --i) {
            byArray[n2--] = this.blueMap[i];
            byArray[n2--] = this.greenMap[i];
            byArray[n2--] = this.redMap[i];
        }
        return byArray;
    }
}

