/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.iptc.IPTCRecord;
import com.icafe4j.image.meta.iptc.IPTCTag;
import com.icafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCPostObjectDataTag implements IPTCTag
{
    CONFIRMED_OBJECT_SIZE(10, "ConfirmedObjectSize"),
    UNKNOWN(999, "Unknown IPTCPostObjectDataTag");

    private static final Map<Integer, IPTCPostObjectDataTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCPostObjectDataTag(int n2, String string2) {
        this.tag = n2;
        this.name = string2;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8").trim();
            if (string.length() > 0) {
                return string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(byArray, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRecordNumber() {
        return IPTCRecord.POST_OBJECTDATA.getRecordNumber();
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCPostObjectDataTag fromTag(int n) {
        IPTCPostObjectDataTag iPTCPostObjectDataTag = recordMap.get(n);
        if (iPTCPostObjectDataTag == null) {
            return UNKNOWN;
        }
        return iPTCPostObjectDataTag;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCPostObjectDataTag>();
        for (IPTCPostObjectDataTag iPTCPostObjectDataTag : IPTCPostObjectDataTag.values()) {
            recordMap.put(iPTCPostObjectDataTag.getTag(), iPTCPostObjectDataTag);
        }
    }
}

