/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.iptc.IPTCDataSet;
import com.icafe4j.image.meta.iptc.IPTCTag;
import com.icafe4j.image.meta.iptc.IPTCTagComparator;
import com.icafe4j.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPTC
extends Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPTC.class);
    private Map<IPTCTag, List<IPTCDataSet>> datasetMap;

    public static void showIPTC(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            IPTC iPTC = new IPTC(byArray);
            try {
                iPTC.read();
                for (MetadataEntry metadataEntry : iPTC) {
                    LOGGER.info(metadataEntry.getKey() + ": " + metadataEntry.getValue());
                    if (!metadataEntry.isMetadataEntryGroup()) continue;
                    String string = "    ";
                    Collection<MetadataEntry> collection = metadataEntry.getMetadataEntries();
                    for (MetadataEntry metadataEntry2 : collection) {
                        LOGGER.info(string + metadataEntry2.getKey() + ": " + metadataEntry2.getValue());
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showIPTC(InputStream inputStream) {
        try {
            IPTC.showIPTC(IOUtils.inputStreamToByteArray(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IPTC() {
        super(MetadataType.IPTC);
        this.datasetMap = new TreeMap<IPTCTag, List<IPTCDataSet>>(new IPTCTagComparator());
        this.isDataRead = true;
    }

    public IPTC(byte[] byArray) {
        super(MetadataType.IPTC, byArray);
        this.ensureDataRead();
    }

    public void addDataSet(IPTCDataSet iPTCDataSet) {
        if (this.datasetMap != null) {
            IPTCTag iPTCTag = iPTCDataSet.getTagEnum();
            if (this.datasetMap.get(iPTCTag) == null) {
                ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
                arrayList.add(iPTCDataSet);
                this.datasetMap.put(iPTCTag, arrayList);
            } else if (iPTCDataSet.allowMultiple()) {
                this.datasetMap.get(iPTCTag).add(iPTCDataSet);
            }
        } else {
            throw new IllegalStateException("DataSet Map is empty");
        }
    }

    public void addDataSets(Collection<? extends IPTCDataSet> collection) {
        if (this.datasetMap != null) {
            for (IPTCDataSet iPTCDataSet : collection) {
                IPTCTag iPTCTag = iPTCDataSet.getTagEnum();
                if (this.datasetMap.get(iPTCTag) == null) {
                    ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
                    arrayList.add(iPTCDataSet);
                    this.datasetMap.put(iPTCTag, arrayList);
                    continue;
                }
                if (!iPTCDataSet.allowMultiple()) continue;
                this.datasetMap.get(iPTCTag).add(iPTCDataSet);
            }
        } else {
            throw new IllegalStateException("DataSet Map is empty");
        }
    }

    public String getAsString(IPTCTag iPTCTag) {
        List<IPTCDataSet> list = this.getDataSet(iPTCTag);
        String string = "";
        if (list != null) {
            if (list.size() == 1) {
                string = list.get(0).getDataAsString();
            } else {
                for (int i = 0; i < list.size() - 1; ++i) {
                    string = string + list.get(i).getDataAsString() + ";";
                }
                string = string + list.get(list.size() - 1).getDataAsString();
            }
        }
        return string;
    }

    public List<IPTCDataSet> getDataSet(IPTCTag iPTCTag) {
        return this.getDataSets().get(iPTCTag);
    }

    public Map<IPTCTag, List<IPTCDataSet>> getDataSets() {
        this.ensureDataRead();
        return this.datasetMap;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        if (this.datasetMap != null) {
            Set<Map.Entry<IPTCTag, List<IPTCDataSet>>> set = this.datasetMap.entrySet();
            final Iterator<Map.Entry<IPTCTag, List<IPTCDataSet>>> iterator = set.iterator();
            return new Iterator<MetadataEntry>(){

                @Override
                public MetadataEntry next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string = ((IPTCTag)entry.getKey()).getName();
                    String string2 = "";
                    for (IPTCDataSet iPTCDataSet : (List)entry.getValue()) {
                        string2 = string2 + ";" + iPTCDataSet.getDataAsString();
                    }
                    return new MetadataEntry(string, string2.replaceFirst(";", ""));
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Removing MetadataEntry is not supported by this Iterator");
                }
            };
        }
        return Collections.emptyIterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            byte by = this.data[n];
            this.datasetMap = new TreeMap<IPTCTag, List<IPTCDataSet>>(new IPTCTagComparator());
            while (by == 28) {
                int n2 = ++n;
                int n3 = this.data[n2] & 0xFF;
                int n4 = ++n;
                int n5 = this.data[n4] & 0xFF;
                int n6 = IOUtils.readUnsignedShortMM(this.data, ++n);
                n += 2;
                if (n6 > 0) {
                    IPTCDataSet iPTCDataSet = new IPTCDataSet(n3, n5, n6, this.data, n);
                    IPTCTag iPTCTag = iPTCDataSet.getTagEnum();
                    if (this.datasetMap.get(iPTCTag) == null) {
                        ArrayList<IPTCDataSet> arrayList = new ArrayList<IPTCDataSet>();
                        arrayList.add(iPTCDataSet);
                        this.datasetMap.put(iPTCTag, arrayList);
                    } else {
                        this.datasetMap.get(iPTCTag).add(iPTCDataSet);
                    }
                }
                if ((n += n6) >= this.data.length) break;
                by = this.data[n];
            }
            for (Map.Entry<IPTCTag, List<IPTCDataSet>> entry : this.datasetMap.entrySet()) {
                entry.setValue(new ArrayList(new LinkedHashSet(entry.getValue())));
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        for (List<IPTCDataSet> list : this.getDataSets().values()) {
            for (IPTCDataSet iPTCDataSet : list) {
                iPTCDataSet.write(outputStream);
            }
        }
    }
}

