/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.image;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.Thumbnail;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ImageMetadata
extends Metadata {
    private Map<String, Thumbnail> thumbnails;
    private Collection<MetadataEntry> entries = new ArrayList<MetadataEntry>();

    public ImageMetadata() {
        super(MetadataType.IMAGE);
    }

    public ImageMetadata(Map<String, Thumbnail> map) {
        super(MetadataType.IMAGE);
        this.thumbnails = map;
    }

    public void addMetadataEntry(MetadataEntry metadataEntry) {
        this.entries.add(metadataEntry);
    }

    public void addMetadataEntries(Collection<MetadataEntry> collection) {
        collection.addAll(collection);
    }

    public boolean containsThumbnail() {
        return this.thumbnails != null && this.thumbnails.size() > 0;
    }

    public Map<String, Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            this.isDataRead = true;
        }
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        if (this.containsThumbnail()) {
            Iterator<Map.Entry<String, Thumbnail>> iterator = this.thumbnails.entrySet().iterator();
            this.entries.add(new MetadataEntry("Total number of thumbnails", "" + this.thumbnails.size()));
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, Thumbnail> entry = iterator.next();
                MetadataEntry metadataEntry = new MetadataEntry("Thumbnail " + n, entry.getKey(), true);
                Thumbnail thumbnail = entry.getValue();
                metadataEntry.addEntry(new MetadataEntry("Thumbnail width", thumbnail.getWidth() < 0 ? " Unavailable" : "" + thumbnail.getWidth()));
                metadataEntry.addEntry(new MetadataEntry("Thumbnail height", thumbnail.getHeight() < 0 ? " Unavailable" : "" + thumbnail.getHeight()));
                metadataEntry.addEntry(new MetadataEntry("Thumbnail data type", thumbnail.getDataTypeAsString()));
                this.entries.add(metadataEntry);
                ++n;
            }
        }
        return Collections.unmodifiableCollection(this.entries).iterator();
    }
}

