/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.icc;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProfileTag {
    A2B0(TagType.PUBLIC, 1093812784, "AToB0Tag"),
    A2B1(TagType.PUBLIC, 1093812785, "AToB1Tag"),
    A2B2(TagType.PUBLIC, 1093812786, "AToB2Tag"),
    bXYZ(TagType.PUBLIC, 1649957210, "blueMatrixColumnTag"),
    bTRC(TagType.PUBLIC, 1649693251, "blueTRCTag"),
    B2A0(TagType.PUBLIC, 1110589744, "BToA0Tag"),
    B2A1(TagType.PUBLIC, 1110589745, "BToA1Tag"),
    B2A2(TagType.PUBLIC, 1110589746, "BToA2Tag"),
    B2D0(TagType.PUBLIC, 1110590512, "BToD0Tag"),
    B2D1(TagType.PUBLIC, 1110590513, "BToD1Tag"),
    B2D2(TagType.PUBLIC, 0x42324432, "BToD2Tag"),
    B2D3(TagType.PUBLIC, 0x42324433, "BToD3Tag"),
    BKPT(TagType.PUBLIC, 1651208308, "mediaBlackPointTag"),
    calt(TagType.PUBLIC, 1667329140, "calibrationDateTimeTag"),
    chad(TagType.PUBLIC, 1667785060, "chromaticAdaptationTag"),
    chrm(TagType.PUBLIC, 1667789421, "chromaticityTag"),
    clro(TagType.PUBLIC, 1668051567, "colorantOrderTag"),
    clrt(TagType.PUBLIC, 1668051572, "colorantTableTag"),
    clot(TagType.PUBLIC, 1668050804, "colorantTableOutTag"),
    ciis(TagType.PUBLIC, 1667852659, "colorimetricIntentImageStateTag"),
    cprt(TagType.PUBLIC, 1668313716, "copyrightTag"),
    desc(TagType.PUBLIC, 1684370275, "profileDescriptionTag"),
    desm(TagType.PRIVATE, 1685283693, "appleMultilanguageDescriptionTag"),
    dmnd(TagType.PUBLIC, 1684893284, "deviceMfgDescTag"),
    dmdd(TagType.PUBLIC, 0x646D6464, "deviceModelDescTag"),
    D2B0(TagType.PUBLIC, 1144144432, "DToB0Tag"),
    D2B1(TagType.PUBLIC, 1144144433, "DToB1Tag"),
    D2B2(TagType.PUBLIC, 0x44324232, "DToB2Tag"),
    D2B3(TagType.PUBLIC, 0x44324233, "DToB3Tag"),
    gamt(TagType.PUBLIC, 1734438260, "gamutTag"),
    gTRC(TagType.PUBLIC, 1733579331, "greenTRCTag"),
    gXYZ(TagType.PUBLIC, 1733843290, "greenMatrixColumnTag"),
    kTRC(TagType.PUBLIC, 1800688195, "grayTRCTag"),
    lumi(TagType.PUBLIC, 1819635049, "luminanceTag"),
    meas(TagType.PUBLIC, 1835360627, "measurementTag"),
    mmod(TagType.PRIVATE, 1835888484, "MakeAndModel"),
    ncl2(TagType.PUBLIC, 1852009522, "namedColor2Tag"),
    pre0(TagType.PUBLIC, 1886545200, "preview0Tag"),
    pre1(TagType.PUBLIC, 1886545201, "preview1Tag"),
    pre2(TagType.PUBLIC, 1886545202, "preview2Tag"),
    pseq(TagType.PUBLIC, 1886610801, "profileSequenceDescTag"),
    psid(TagType.PUBLIC, 1886611812, "profileSequenceIdentifierTag"),
    resp(TagType.PUBLIC, 1919251312, "outputResponseTag"),
    rigo(TagType.PUBLIC, 1919510320, "perceptualRenderingIntentGamutTag"),
    rig2(TagType.PUBLIC, 1919510322, "saturationRenderingIntentGamutTag"),
    rXYZ(TagType.PUBLIC, 1918392666, "redMatrixColumnTag"),
    rTRC(TagType.PUBLIC, 1918128707, "redTRCTag"),
    targ(TagType.PUBLIC, 1952543335, "charTargetTag"),
    tech(TagType.PUBLIC, 1952801640, "technologyTag"),
    vcgt(TagType.PRIVATE, 1986226036, "VideoCardGammaType"),
    vued(TagType.PUBLIC, 1987405156, "viewingCondDescTag"),
    view(TagType.PUBLIC, 1986618743, "viewingConditionsTag"),
    wtpt(TagType.PUBLIC, 0x77747074, "mediaWhitePointTag"),
    UNKNOWN(TagType.UNKNOWN, -1, "UnknownTag");

    private static final Logger LOGGER;
    private static final Map<Integer, ProfileTag> typeMap;
    private final TagType tagType;
    private final String description;
    private final int value;

    public TagType getTagType() {
        return this.tagType;
    }

    private ProfileTag(TagType tagType, int n2, String string2) {
        this.description = string2;
        this.value = n2;
        this.tagType = tagType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name() + " (" + this.description + ")";
    }

    public static ProfileTag fromInt(int n) {
        ProfileTag profileTag = typeMap.get(n);
        if (profileTag == null) {
            LOGGER.warn("tag value 0x{} unknown", (Object)Integer.toHexString(n));
            return UNKNOWN;
        }
        return profileTag;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ProfileTag.class);
        typeMap = new HashMap<Integer, ProfileTag>();
        for (ProfileTag profileTag : ProfileTag.values()) {
            typeMap.put(profileTag.getValue(), profileTag);
        }
    }

    public static enum TagType {
        PUBLIC,
        PRIVATE,
        UNKNOWN;

    }
}

