/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.string.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public enum GPSTag implements Tag
{
    GPS_VERSION_ID("GPS Version ID", 0),
    GPS_LATITUDE_REF("GPS Latitude Ref", 1),
    GPS_LATITUDE("GPS Latitude", 2){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSLatitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_LONGITUDE_REF("GPS Longitude Ref", 3),
    GPS_LONGITUDE("GPS Longitude", 4){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSLongitude data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_ALTITUDE_REF("GPS Altitude Ref", 5),
    GPS_ALTITUDE("GPS Altitude", 6){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSAltitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_TIME_STAMP("GPS Time Stamp", 7){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSTimeStamp data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + ":" + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + ":" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]);
        }
    }
    ,
    GPS_SATELLITES("GPS Satellites", 8),
    GPS_STATUS("GPS Status", 9),
    GPS_MEASURE_MODE("GPS Measure Mode", 10),
    GPS_DOP("GPS DOP/Processing Software", 11),
    GPS_SPEED_REF("GPS Speed Ref", 12),
    GPSSpeed("GPS Speed", 13),
    GPS_TRACK_REF("GPS Track Ref", 14),
    GPS_TRACK("GPS Track", 15),
    GPS_IMG_DIRECTION_REF("GPS Img Direction Ref", 16),
    GPS_IMG_DIRECTION("GPS Img Direction", 17){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSImgDirection data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + '\u00b0';
        }
    }
    ,
    GPS_MAP_DATUM("GPS Map Datum", 18),
    GPS_DEST_LATITUDE_REF("GPS Dest Latitude Ref", 19),
    GPS_DEST_LATITUDE("GPS Dest Latitude", 20){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSDestLatitute data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_DEST_LONGITUDE_REF("GPS Dest Longitude Ref", 21),
    GPS_DEST_LONGITUDE("GPS Dest Longitude", 22){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 6) {
                throw new IllegalArgumentException("Wrong number of GPSDestLongitude data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray[0], nArray[1]) + '\u00b0' + StringUtils.rationalToString(decimalFormat, true, nArray[2], nArray[3]) + "'" + StringUtils.rationalToString(decimalFormat, true, nArray[4], nArray[5]) + "\"";
        }
    }
    ,
    GPS_DEST_BEARING_REF("GPS Dest Bearing Ref", 23),
    GPS_DEST_BEARING("GPS Dest Bearing", 24){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSDestBearing data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_DEST_DISTANCE_REF("GPS Dest Distance Ref", 25),
    GPS_DEST_DISTANCE("GPS Dest Distance", 26){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of GPSDestDistance data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "m";
        }
    }
    ,
    GPS_PROCESSING_METHOD("GPS Processing Method", 27),
    GPS_AREA_INFORMATION("GPS Area Information", 28),
    GPS_DATE_STAMP("GPS Date Stamp", 29),
    GPS_DIFFERENTIAL("GPS Differential", 30),
    GPS_HPOSITIONING_ERROR("GPS H Positioning Error", 31),
    UNKNOWN("Unknown", -1);

    private static final Map<Short, GPSTag> tagMap;
    private final String name;
    private final short value;

    private GPSTag(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short s) {
        GPSTag gPSTag = tagMap.get(s);
        if (gPSTag == null) {
            return TiffTag.UNKNOWN;
        }
        return gPSTag;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, GPSTag>();
        for (GPSTag gPSTag : GPSTag.values()) {
            tagMap.put(gPSTag.getValue(), gPSTag);
        }
    }
}

