/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.meta.Thumbnail;
import com.icafe4j.image.options.JPGOptions;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.MemoryCacheRandomAccessOutputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExifThumbnail
extends Thumbnail {
    private IFD thumbnailIFD = new IFD();

    public ExifThumbnail() {
    }

    public ExifThumbnail(BufferedImage bufferedImage) {
        super(bufferedImage);
    }

    public ExifThumbnail(ExifThumbnail exifThumbnail) {
        this.dataType = exifThumbnail.dataType;
        this.height = exifThumbnail.height;
        this.width = exifThumbnail.width;
        this.thumbnail = exifThumbnail.thumbnail;
        this.compressedThumbnail = exifThumbnail.compressedThumbnail;
        this.thumbnailIFD = exifThumbnail.thumbnailIFD;
    }

    public ExifThumbnail(int n, int n2, int n3, byte[] byArray) {
        super(n, n2, n3, byArray);
    }

    public ExifThumbnail(int n, int n2, int n3, byte[] byArray, IFD iFD) {
        super(n, n2, n3, byArray);
        this.thumbnailIFD = iFD;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        RandomAccessOutputStream randomAccessOutputStream = null;
        randomAccessOutputStream = outputStream instanceof RandomAccessOutputStream ? (RandomAccessOutputStream)outputStream : new MemoryCacheRandomAccessOutputStream(outputStream);
        int n = (int)randomAccessOutputStream.getStreamPointer();
        if (this.getDataType() == 1) {
            byte[] byArray = this.getCompressedImage();
            if (byArray == null) {
                throw new IllegalArgumentException("Expected compressed thumbnail data does not exist!");
            }
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{byArray.length}));
            n = this.thumbnailIFD.write(randomAccessOutputStream, n);
            randomAccessOutputStream.seek(n);
            randomAccessOutputStream.write(this.getCompressedImage());
            randomAccessOutputStream.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT).getDataOffset());
            randomAccessOutputStream.writeInt(n);
        } else if (this.getDataType() == 2) {
            TiffField<?> tiffField;
            ArrayList<IFD> arrayList = new ArrayList<IFD>();
            FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(new ByteArrayInputStream(this.getCompressedImage()));
            TIFFTweaker.readIFDs(arrayList, fileCacheRandomAccessInputStream);
            TiffField<?> tiffField2 = ((IFD)arrayList.get(0)).getField(TiffTag.STRIP_OFFSETS);
            if (tiffField2 == null) {
                tiffField2 = ((IFD)arrayList.get(0)).getField(TiffTag.TILE_OFFSETS);
            }
            if ((tiffField = ((IFD)arrayList.get(0)).getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                tiffField = ((IFD)arrayList.get(0)).getField(TiffTag.TILE_BYTE_COUNTS);
            }
            n = ((IFD)arrayList.get(0)).write(randomAccessOutputStream, n);
            int[] nArray = new int[]{};
            if (tiffField2 != null) {
                nArray = tiffField2.getDataAsLong();
                int[] nArray2 = tiffField.getDataAsLong();
                for (int i = 0; i < nArray.length; ++i) {
                    ((RandomAccessInputStream)fileCacheRandomAccessInputStream).seek(nArray[i]);
                    byte[] byArray = new byte[nArray2[i]];
                    fileCacheRandomAccessInputStream.readFully(byArray);
                    randomAccessOutputStream.seek(n);
                    randomAccessOutputStream.write(byArray);
                    nArray[i] = n;
                    n += nArray2[i];
                }
            }
            ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
            randomAccessOutputStream.seek(tiffField2.getDataOffset());
            for (int n2 : nArray) {
                randomAccessOutputStream.writeInt(n2);
            }
        } else {
            BufferedImage bufferedImage = this.getRawImage();
            if (bufferedImage == null) {
                throw new IllegalArgumentException("Expected raw data thumbnail does not exist!");
            }
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            this.thumbnailIFD.addField(new ShortField(TiffTag.IMAGE_WIDTH.getValue(), new short[]{(short)n3}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.IMAGE_LENGTH.getValue(), new short[]{(short)n4}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{0}));
            this.thumbnailIFD.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{n3, 1}));
            this.thumbnailIFD.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{n4, 1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.YCbCr.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{3}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{8, 8, 8}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.YCbCr_SUB_SAMPLING.getValue(), new short[]{1, 1}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)TiffFieldEnum.Compression.OLD_JPG.getValue()}));
            this.thumbnailIFD.addField(new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)n4}));
            randomAccessOutputStream.seek(this.thumbnailIFD.write(randomAccessOutputStream, n));
            ImageWriter imageWriter = ImageIO.getWriter(ImageType.JPG);
            ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
            JPGOptions jPGOptions = new JPGOptions();
            jPGOptions.setQuality(this.writeQuality);
            imageParamBuilder.imageOptions(jPGOptions);
            imageWriter.setImageParam(imageParamBuilder.build());
            long l = randomAccessOutputStream.getStreamPointer();
            try {
                imageWriter.write(bufferedImage, randomAccessOutputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l2 = randomAccessOutputStream.getStreamPointer();
            int n5 = (int)(l2 - l);
            randomAccessOutputStream.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT).getDataOffset());
            randomAccessOutputStream.writeInt((int)l);
            randomAccessOutputStream.seek(this.thumbnailIFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH).getDataOffset());
            randomAccessOutputStream.writeInt(n5);
        }
        if (!(outputStream instanceof RandomAccessOutputStream)) {
            randomAccessOutputStream.shallowClose();
        }
    }
}

