/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public enum ExifTag implements Tag
{
    EXPOSURE_TIME("Exposure Time", -32102),
    FNUMBER("FNumber", -32099){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF FNumber data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.#");
            return "F" + StringUtils.rationalToString(decimalFormat, true, nArray);
        }
    }
    ,
    EXPOSURE_PROGRAM("Exposure Program", -30686),
    SPECTRAL_SENSITIVITY("Spectral Sensitivity", -30684),
    ISO_SPEED_RATINGS("ISO Speed Ratings", -30681),
    OECF("OECF", -30680),
    EXIF_VERSION("Exif Version", -28672){

        @Override
        public String getFieldAsString(Object object) {
            return new String((byte[])object).trim();
        }
    }
    ,
    DATE_TIME_ORIGINAL("DateTime Original", -28669),
    DATE_TIME_DIGITIZED("DateTime Digitized", -28668),
    COMPONENT_CONFIGURATION("Component Configuration", -28415),
    COMPRESSED_BITS_PER_PIXEL("Compressed Bits PerPixel", -28414),
    SHUTTER_SPEED_VALUE("Shutter Speed Value", -28159){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF ShutterSpeedValue data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, false, nArray);
        }
    }
    ,
    APERTURE_VALUE("Aperture Value", -28158),
    BRIGHTNESS_VALUE("Bright Value", -28157),
    EXPOSURE_BIAS_VALUE("Exposure Bias Value", -28156),
    MAX_APERTURE_VALUE("Max Aperture Value", -28155),
    SUBJECT_DISTANCE("Subject Distance", -28154),
    METERING_MODE("Metering Mode", -28153),
    LIGHT_SOURCE("Light Source", -28152),
    FLASH("Flash", -28151),
    FOCAL_LENGTH("Focal Length", -28150){

        @Override
        public String getFieldAsString(Object object) {
            int[] nArray = (int[])object;
            if (nArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of EXIF FocalLength data number: " + nArray.length);
            }
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.##");
            return StringUtils.rationalToString(decimalFormat, true, nArray) + "mm";
        }
    }
    ,
    SUBJECT_AREA("Subject Area", -28140),
    MAKER_NODE("Maker Note", -28036),
    USER_COMMENT("User Comment", -28026),
    SUB_SEC_TIME("Sub Sec Time", -28016),
    SUB_SEC_TIME_ORIGINAL("Sub Sec Time Original", -28015),
    SUB_SEC_TIME_DIGITIZED("Sub Sec Time Digitized", -28014),
    WINDOWS_XP_TITLE("WindowsXP Title", -25445){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_COMMENT("WindowsXP Comment", -25444){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_AUTHOR("WindowsXP Author", -25443){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_KEYWORDS("WindowsXP Keywords", -25442){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    WINDOWS_XP_SUBJECT("WindowsXP Subject", -25441){

        @Override
        public String getFieldAsString(Object object) {
            byte[] byArray = (byte[])object;
            String string = "";
            try {
                string = new String(byArray, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }

        @Override
        public boolean isCritical() {
            return false;
        }
    }
    ,
    FLASH_PIX_VERSION("Flash Pix Version", -24576){

        @Override
        public String getFieldAsString(Object object) {
            return new String((byte[])object).trim();
        }
    }
    ,
    COLOR_SPACE("Color Space", -24575){

        @Override
        public String getFieldAsString(Object object) {
            int n = ((int[])object)[0];
            String string = "Warning: unknown color space value: " + n;
            switch (n) {
                case 1: {
                    string = "sRGB";
                    break;
                }
                case 65535: {
                    string = "Uncalibrated";
                }
            }
            return string;
        }
    }
    ,
    EXIF_IMAGE_WIDTH("Exif Image Width", -24574),
    EXIF_IMAGE_HEIGHT("Exif Image Height", -24573),
    RELATED_SOUND_FILE("Related Sound File", -24572),
    EXIF_INTEROPERABILITY_OFFSET("Exif Interoperability Offset", -24571){

        @Override
        public FieldType getFieldType() {
            return FieldType.LONG;
        }
    }
    ,
    FLASH_ENERGY("Flash Energy", -24053),
    SPATIAL_FREQUENCY_RESPONSE("Spatial Frequency Response", -24052),
    FOCAL_PLANE_X_RESOLUTION("Focal Plane XResolution", -24050),
    FOCAL_PLANE_Y_RESOLUTION("Focal Plane YResolution", -24049),
    FOCAL_PLANE_RESOLUTION_UNIT("Focal Plane Resolution Unit", -24048),
    SUBJECT_LOCATION("Subject Location", -24044),
    EXPOSURE_INDEX("Exposure Index", -24043),
    SENSING_METHOD("Sensing Method", -24041),
    FILE_SOURCE("File Source", -23808),
    SCENE_TYPE("Scene Type", -23807),
    CFA_PATTERN("CFA Pattern", -23806),
    CUSTOM_RENDERED("Custom Rendered", -23551),
    EXPOSURE_MODE("Exposure Mode", -23550),
    WHITE_BALENCE("While Balence", -23549),
    DIGITAL_ZOOM_RATIO("Digital Zoom Ratio", -23548),
    FOCAL_LENGTH_IN_35MM_FORMAT("Focal Length In 35mm Format", -23547),
    SCENE_CAPTURE_TYPE("Scene Capture Type", -23546),
    GAIN_CONTROL("Gain Control", -23545),
    CONTRAST("Contrast", -23544),
    SATURATION("Saturation", -23543),
    SHARPNESS("Sharpness", -23542),
    DEVICE_SETTING_DESCRIPTION("Device Setting Description", -23541),
    SUBJECT_DISTANCE_RANGE("Subject Distance Range", -23540),
    IMAGE_UNIQUE_ID("Image Unique ID", -23520),
    OWNER_NAME("Owner Name", -23504),
    BODY_SERIAL_NUMBER("Body Serial Number", -23503),
    LENS_SPECIFICATION("Lens Specification", -23502),
    LENS_Make("Lens Make", -23501),
    LENS_MODEL("Lens Model", -23500),
    LENS_SERIAL_NUMBER("Lens Serial Number", -23499),
    EXPAND_SOFTWARE("Expand Software", -20544),
    EXPAND_LENS("Expand Lens", -20543),
    EXPAND_FILM("Expand Film", -20542),
    EXPAND_FILTER_LENS("Expand Filter Lens", -20541),
    EXPAND_SCANNER("Expand Scanner", -20540),
    EXPAND_FLASH_LAMP("Expand Flash Lamp", -20539),
    PADDING("Padding", -5604),
    UNKNOWN("Unknown", -1);

    private static final Map<Short, ExifTag> tagMap;
    private final String name;
    private final short value;

    private ExifTag(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short s) {
        ExifTag exifTag = tagMap.get(s);
        if (exifTag == null) {
            return TiffTag.UNKNOWN;
        }
        return exifTag;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, ExifTag>();
        for (ExifTag exifTag : ExifTag.values()) {
            tagMap.put(exifTag.getValue(), exifTag);
        }
    }
}

