/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _8BIM {
    private short id;
    private String name;
    protected int size;
    protected byte[] data;
    private static final Logger LOGGER = LoggerFactory.getLogger(_8BIM.class);

    public _8BIM(short s, String string, byte[] byArray) {
        this(s, string, byArray == null ? 0 : byArray.length, byArray);
    }

    public _8BIM(short s, String string, int n, byte[] byArray) {
        this.id = s;
        this.name = string;
        this.size = n;
        this.data = byArray;
    }

    public _8BIM(ImageResourceID imageResourceID, String string, byte[] byArray) {
        this(imageResourceID.getValue(), string, byArray);
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    protected MetadataEntry getMetadataEntry() {
        ImageResourceID imageResourceID = ImageResourceID.fromShort(this.id);
        if (this.id >= ImageResourceID.PATH_INFO0.getValue() && this.id <= ImageResourceID.PATH_INFO998.getValue()) {
            return new MetadataEntry("PATH_INFO [" + StringUtils.shortToHexStringMM(this.id) + "]", imageResourceID.getDescription());
        }
        if (this.id >= ImageResourceID.PLUGIN_RESOURCE0.getValue() && this.id <= ImageResourceID.PLUGIN_RESOURCE999.getValue()) {
            return new MetadataEntry("PLUGIN_RESOURCE [" + StringUtils.shortToHexStringMM(this.id) + "]", imageResourceID.getDescription());
        }
        if (imageResourceID == ImageResourceID.UNKNOWN) {
            return new MetadataEntry("UNKNOWN [" + StringUtils.shortToHexStringMM(this.id) + "]", imageResourceID.getDescription());
        }
        return new MetadataEntry("" + (Object)((Object)imageResourceID), imageResourceID.getDescription());
    }

    public String getName() {
        return this.name;
    }

    public short getID() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public void print() {
        ImageResourceID imageResourceID = ImageResourceID.fromShort(this.id);
        if (this.id >= ImageResourceID.PATH_INFO0.getValue() && this.id <= ImageResourceID.PATH_INFO998.getValue()) {
            LOGGER.info("PATH_INFO [Value: {}] - Path Information (saved paths).", (Object)StringUtils.shortToHexStringMM(this.id));
        } else if (this.id >= ImageResourceID.PLUGIN_RESOURCE0.getValue() && this.id <= ImageResourceID.PLUGIN_RESOURCE999.getValue()) {
            LOGGER.info("PLUGIN_RESOURCE [Value: {}] - Plug-In resource.", (Object)StringUtils.shortToHexStringMM(this.id));
        } else if (imageResourceID == ImageResourceID.UNKNOWN) {
            LOGGER.info("{} [Value: {}]", (Object)imageResourceID, (Object)StringUtils.shortToHexStringMM(this.id));
        } else {
            LOGGER.info("{}", (Object)imageResourceID);
        }
        LOGGER.info("Type: 8BIM");
        LOGGER.info("Name: {}", (Object)this.name);
        LOGGER.info("Size: {}", (Object)this.size);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write("8BIM".getBytes());
        IOUtils.writeShortMM(outputStream, this.id);
        byte[] byArray = this.name.trim().getBytes();
        outputStream.write(byArray.length);
        outputStream.write(byArray);
        if (byArray.length % 2 == 0) {
            outputStream.write(0);
        }
        IOUtils.writeIntMM(outputStream, this.size);
        outputStream.write(this.data);
        if (this.data.length % 2 != 0) {
            outputStream.write(0);
        }
    }
}

