/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import java.util.HashMap;
import java.util.Map;

public enum DataBlockType {
    Layr("Layer Data", 1281456498),
    LMsk("User Mask Same as Global layer mask info table", 1280144235),
    Patt("Pattern", 1348564084),
    FMsk("Filter Mask", 1179480939),
    Anno("Annotations", 1097756271),
    UNKNOWN("Unknown Data Block", -1);

    private static final Map<Integer, DataBlockType> typeMap;
    private final String description;
    private final int value;

    private DataBlockType(String string2, int n2) {
        this.description = string2;
        this.value = n2;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static DataBlockType fromInt(int n) {
        DataBlockType dataBlockType = typeMap.get(n);
        if (dataBlockType == null) {
            return UNKNOWN;
        }
        return dataBlockType;
    }

    static {
        typeMap = new HashMap<Integer, DataBlockType>();
        for (DataBlockType dataBlockType : DataBlockType.values()) {
            typeMap.put(dataBlockType.getValue(), dataBlockType);
        }
    }
}

