/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public abstract class Thumbnail {
    public static final int DATA_TYPE_KRawRGB = 0;
    public static final int DATA_TYPE_KJpegRGB = 1;
    public static final int DATA_TYPE_TIFF = 2;
    protected BufferedImage thumbnail;
    protected byte[] compressedThumbnail;
    protected int writeQuality = 100;
    protected int width;
    protected int height;
    protected int dataType = 0;

    public Thumbnail() {
    }

    public Thumbnail(BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
    }

    public Thumbnail(int n, int n2, int n3, byte[] byArray) {
        this.setImage(n, n2, n3, byArray);
    }

    public boolean containsImage() {
        return this.thumbnail != null || this.compressedThumbnail != null;
    }

    public BufferedImage getAsBufferedImage() {
        if (this.dataType == 1 || this.dataType == 2) {
            try {
                return ImageIO.read(new ByteArrayInputStream(this.getCompressedImage()));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error decoding compressed thumbnail data to BufferedImage");
            }
        }
        if (this.dataType == 0) {
            return this.getRawImage();
        }
        return null;
    }

    public byte[] getCompressedImage() {
        return this.compressedThumbnail;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getDataTypeAsString() {
        switch (this.dataType) {
            case 0: {
                return "DATA_TYPE_KRawRGB";
            }
            case 1: {
                return "DATA_TYPE_KJpegRGB";
            }
            case 2: {
                return "DATA_TYPE_TIFF";
            }
        }
        return "DATA_TYPE_Unknown";
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getRawImage() {
        return this.thumbnail;
    }

    public int getWidth() {
        return this.width;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.thumbnail = bufferedImage;
        this.dataType = 0;
    }

    public void setImage(int n, int n2, int n3, byte[] byArray) {
        this.width = n;
        this.height = n2;
        if (n3 == 1 || n3 == 2) {
            this.compressedThumbnail = byArray;
            this.dataType = n3;
        }
    }

    public void setWriteQuality(int n) {
        this.writeQuality = n;
    }

    public abstract void write(OutputStream var1) throws IOException;
}

