/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.jpeg;

import com.icafe4j.image.jpeg.HTable;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.jpeg.Segment;
import com.icafe4j.util.Reader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHTReader
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DHTReader.class);
    private Segment segment;
    private List<HTable> dcTables = new ArrayList<HTable>(3);
    private List<HTable> acTables = new ArrayList<HTable>(3);

    public DHTReader(Segment segment) throws IOException {
        if (segment.getMarker() != Marker.DHT) {
            throw new IllegalArgumentException("Not a valid DHT segment!");
        }
        this.segment = segment;
        this.read();
    }

    public List<HTable> getDCTables() {
        return this.dcTables;
    }

    public List<HTable> getACTables() {
        return this.acTables;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.segment.getData();
        int n = this.segment.getLength();
        n -= 2;
        int n2 = 0;
        while (n > 0) {
            int n3;
            byte by = byArray[n2++];
            int n4 = by >> 4 & 1;
            int n5 = by & 0xF;
            byte[] byArray2 = new byte[16];
            int n6 = 0;
            for (n3 = 0; n3 < 16; ++n3) {
                byArray2[n3] = byArray[n2 + n3];
                n6 += byArray2[n3] & 0xFF;
            }
            if (n6 > 256) {
                LOGGER.error("invalid huffman code count!");
                return;
            }
            n2 += 16;
            byte[] byArray3 = new byte[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                byArray3[n3] = byArray[n2 + n3];
            }
            n2 += n6;
            n -= 17 + n6;
            HTable hTable = new HTable(n4, n5, byArray2, byArray3);
            if (n4 == 0) {
                this.dcTables.add(hTable);
                continue;
            }
            if (n4 == 1) {
                this.acTables.add(hTable);
                continue;
            }
            LOGGER.error("Invalid component class value: " + n4);
            return;
        }
    }
}

