/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.lzw;

import com.icafe4j.image.compression.ImageDecoder;
import com.icafe4j.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class LZWTreeDecoder
implements ImageDecoder {
    private int bits_remain = 0;
    private int bytes_available = 0;
    private int temp_byte = 0;
    private int bufIndex = 0;
    private byte[] bytes_buf = new byte[256];
    private int oldcode = 0;
    private int code = 0;
    private int[] prefix = new int[4097];
    private int[] suffix = new int[4097];
    private int min_code_size;
    private int clearCode;
    private int endOfImage;
    private int codeLen;
    private int codeIndex;
    private int limit;
    private int first_code_index;
    private int first_char;
    private InputStream is;
    private boolean isTIFF;
    private boolean isCodeBigEndian;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095};
    private int leftOver = 0;
    private int[] buf = new int[4097];
    private static final int MAX_CODE = 4096;

    public LZWTreeDecoder(InputStream inputStream, int n) {
        if (n < 2 || n > 12) {
            throw new IllegalArgumentException("invalid min_code_size: " + n);
        }
        this.is = inputStream;
        this.min_code_size = n;
        this.clearCode = 1 << n;
        this.endOfImage = this.clearCode + 1;
        this.first_code_index = this.endOfImage + 1;
        this.isCodeBigEndian = true;
        this.clearStringTable();
    }

    public LZWTreeDecoder(int n, boolean bl) {
        this(null, n);
        this.isTIFF = bl;
    }

    private void clearStringTable() {
        this.codeLen = this.min_code_size + 1;
        this.limit = (1 << this.codeLen) - 1;
        this.codeIndex = this.endOfImage;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int decode(byte[] var1_1, int var2_2, int var3_3) throws Exception {
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        if (this.leftOver > 0) {
            var7_7 = this.leftOver - 1;
            while (var7_7 >= 0) {
                if (var2_2 >= var1_1.length || var4_4 >= var3_3) {
                    return var4_4;
                }
                var1_1[var2_2++] = (byte)this.buf[var7_7];
                ++var4_4;
                --var7_7;
                --this.leftOver;
            }
        }
        block1: while (true) {
            var6_6 = 0;
            var5_5 = this.code = this.readLZWCode();
            if (this.code == this.clearCode) {
                this.clearStringTable();
                continue;
            }
            if (this.code == this.endOfImage) break;
            if (this.code >= this.codeIndex) {
                var5_5 = this.oldcode;
                this.buf[var6_6++] = this.first_char;
            }
            while (var5_5 >= this.first_code_index) {
                this.buf[var6_6++] = this.suffix[var5_5];
                var5_5 = this.prefix[var5_5];
            }
            this.buf[var6_6++] = var5_5;
            this.suffix[this.codeIndex] = this.first_char = var5_5;
            this.prefix[this.codeIndex] = this.oldcode;
            if (this.codeIndex < 4096) {
                ++this.codeIndex;
            }
            this.oldcode = this.code;
            if (this.codeIndex > (this.isTIFF != false && this.isCodeBigEndian != false ? this.limit - 1 : this.limit) && this.codeLen < 12) {
                ++this.codeLen;
                this.limit = (1 << this.codeLen) - 1;
            }
            this.leftOver = var6_6;
            var7_7 = var6_6 - 1;
            while (true) {
                if (var7_7 >= 0) ** break;
                continue block1;
                if (var2_2 >= var1_1.length || var4_4 >= var3_3) break block1;
                var1_1[var2_2++] = (byte)this.buf[var7_7];
                --var7_7;
                --this.leftOver;
                ++var4_4;
            }
            break;
        }
        return var4_4;
    }

    private int readLZWCode() throws Exception {
        int n = 0;
        n = !this.isTIFF || !this.isCodeBigEndian ? this.temp_byte >> 8 - this.bits_remain : this.temp_byte & MASK[this.bits_remain];
        while (this.codeLen > this.bits_remain) {
            if (!this.isTIFF) {
                if (this.bytes_available == 0) {
                    this.bytes_available = this.is.read();
                    if (this.bytes_available > 0) {
                        IOUtils.readFully(this.is, this.bytes_buf, 0, this.bytes_available);
                        this.bufIndex = 0;
                    } else {
                        if (this.bytes_available == 0) {
                            return this.endOfImage;
                        }
                        return this.endOfImage;
                    }
                }
                this.temp_byte = this.bytes_buf[this.bufIndex++] & 0xFF;
                --this.bytes_available;
                n |= this.temp_byte << this.bits_remain;
            } else {
                this.temp_byte = this.is.read();
                if (this.temp_byte == -1) {
                    return this.endOfImage;
                }
                n = this.isCodeBigEndian ? n << 8 | this.temp_byte : (n |= this.temp_byte << this.bits_remain);
            }
            this.bits_remain += 8;
        }
        if (this.isTIFF && this.isCodeBigEndian) {
            n >>= this.bits_remain - this.codeLen;
        }
        this.bits_remain -= this.codeLen;
        return n & MASK[this.codeLen];
    }

    @Override
    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    @Override
    public void setInput(byte[] byArray, int n, int n2) {
        this.isCodeBigEndian = byArray[n] != 0 || byArray[n + 1] != 1;
        this.is = new ByteArrayInputStream(byArray, n, n2);
        this.bits_remain = 0;
        this.leftOver = 0;
        this.clearStringTable();
    }
}

