/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.ccitt;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.ccitt.G31DEncoder;
import com.icafe4j.image.compression.ccitt.T42DCode;
import com.icafe4j.image.compression.ccitt.T4WhiteCode;
import com.icafe4j.util.Updatable;
import java.io.OutputStream;

public class G32DEncoder
extends G31DEncoder
implements ImageEncoder {
    private int k;
    private int a0 = -1;
    private int a1;
    private int a2;
    private int b1;
    private int b2;

    public G32DEncoder(OutputStream outputStream, int n, int n2, int n3, Updatable<Integer> updatable) {
        super(outputStream, n, n2, updatable);
        if (n3 < 2) {
            throw new IllegalArgumentException("Invalid k value: " + n3);
        }
        this.k = n3;
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        int n4 = n2 / this.scanLineWidth;
        int n5 = n4 / this.k;
        int n6 = n4 % this.k;
        for (n3 = 0; n3 < n5; ++n3) {
            n = this.encodeKLines(byArray, n);
        }
        if (n6 > 0) {
            this.send_code_to_buffer(24, 13);
            n = this.encode1DLine(byArray, n);
            for (n3 = 0; n3 < n6 - 1; ++n3) {
                this.send_code_to_buffer(16, 13);
                n = this.encode2DLine(byArray, n);
            }
        }
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.send_code_to_buffer(24, 13);
        this.setExtraFlush(true);
    }

    private int encodeKLines(byte[] byArray, int n) throws Exception {
        this.send_code_to_buffer(24, 13);
        n = this.encode1DLine(byArray, n);
        for (int i = 0; i < this.k - 1; ++i) {
            this.send_code_to_buffer(16, 13);
            n = this.encode2DLine(byArray, n);
        }
        return n;
    }

    protected int encode2DLine(byte[] byArray, int n) throws Exception {
        boolean bl = false;
        int n2 = 0;
        int n3 = this.currPos;
        int n4 = n3 + this.scanLineWidth % 8;
        if (n4 > 7) {
            n4 -= 8;
        }
        int n5 = ((n + 1 << 3) - n3 - this.scanLineWidth + 7 >> 3) - 1;
        int n6 = 7;
        this.a0 = -1;
        while (!bl) {
            int n7 = this.a0 + 1;
            int n8 = n + (n7 - n3 + 7) / 8;
            if (n7 >= this.scanLineWidth) {
                this.a1 = this.scanLineWidth;
            } else {
                n6 = n3 - n7 % 8;
                if (n6 < 0) {
                    n6 += 8;
                }
                n2 = this.a0 == -1 ? 0 : (n6 == 7 ? byArray[n8 - 1] & 1 : byArray[n8] >>> n6 + 1 & 1);
                this.a1 = this.findChangingElement(byArray, n8, n2, n6, n7, true);
                if (this.a1 == -1) {
                    this.a1 = this.scanLineWidth;
                }
            }
            n7 = this.a0 + 1;
            n8 = n5 + (n7 - n4 + 7) / 8;
            if (n8 < 0) {
                this.b1 = this.scanLineWidth;
            } else if (n7 >= this.scanLineWidth) {
                this.b1 = this.scanLineWidth;
            } else {
                n6 = n4 - n7 % 8;
                if (n6 < 0) {
                    n6 += 8;
                }
                this.b1 = this.findChangingElement(byArray, n8, n2, n6, n7, false);
                if (this.b1 == -1) {
                    this.b1 = this.scanLineWidth;
                }
            }
            n2 ^= 1;
            n7 = this.b1 + 1;
            n8 = n5 + (n7 - n4 + 7) / 8;
            if (n7 >= this.scanLineWidth) {
                this.b2 = this.scanLineWidth;
            } else {
                n6 = n4 - n7 % 8;
                if (n6 < 0) {
                    n6 += 8;
                }
                this.b2 = this.findChangingElement(byArray, n8, n2, n6, n7, true);
                if (this.b2 == -1) {
                    this.b2 = this.scanLineWidth;
                }
            }
            if (this.b2 < this.a1) {
                this.send_code_to_buffer(T42DCode.P.getCode(), T42DCode.P.getCodeLen());
                this.a0 = this.b2;
            } else {
                int n9 = this.a1 - this.b1;
                if (Math.abs(n9) <= 3) {
                    if (n9 == 0) {
                        this.send_code_to_buffer(T42DCode.V0.getCode(), T42DCode.V0.getCodeLen());
                    } else if (n9 == 1) {
                        this.send_code_to_buffer(T42DCode.VR1.getCode(), T42DCode.VR1.getCodeLen());
                    } else if (n9 == 2) {
                        this.send_code_to_buffer(T42DCode.VR2.getCode(), T42DCode.VR2.getCodeLen());
                    } else if (n9 == 3) {
                        this.send_code_to_buffer(T42DCode.VR3.getCode(), T42DCode.VR3.getCodeLen());
                    } else if (n9 == -1) {
                        this.send_code_to_buffer(T42DCode.VL1.getCode(), T42DCode.VL1.getCodeLen());
                    } else if (n9 == -2) {
                        this.send_code_to_buffer(T42DCode.VL2.getCode(), T42DCode.VL2.getCodeLen());
                    } else if (n9 == -3) {
                        this.send_code_to_buffer(T42DCode.VL3.getCode(), T42DCode.VL3.getCodeLen());
                    }
                    this.a0 = this.a1;
                } else {
                    this.send_code_to_buffer(T42DCode.H.getCode(), T42DCode.H.getCodeLen());
                    int n10 = this.a1 - this.a0;
                    if (this.a0 == -1) {
                        --n10;
                    }
                    if (n10 == 0) {
                        T4WhiteCode t4WhiteCode = T4WhiteCode.CODE0;
                        short s = t4WhiteCode.getCode();
                        int n11 = t4WhiteCode.getCodeLen();
                        this.send_code_to_buffer(s, n11);
                    } else {
                        this.outputRunLengthCode(n10, n2 ^ 1);
                    }
                    n7 = this.a1 + 1;
                    n8 = n + (n7 - n3 + 7) / 8;
                    if (n7 >= this.scanLineWidth) {
                        this.a2 = this.scanLineWidth;
                    } else {
                        n6 = n3 - n7 % 8;
                        if (n6 < 0) {
                            n6 += 8;
                        }
                        this.a2 = this.findChangingElement(byArray, n8, n2, n6, n7, true);
                        if (this.a2 == -1) {
                            this.a2 = this.scanLineWidth;
                        }
                    }
                    n10 = this.a2 - this.a1;
                    this.outputRunLengthCode(n10, n2);
                    this.a0 = this.a2;
                }
            }
            if (this.a0 < this.scanLineWidth) continue;
            bl = true;
        }
        this.currPos = n3 - this.scanLineWidth % 8;
        if (this.currPos < 0) {
            this.currPos += 8;
        }
        return n + (this.scanLineWidth - n3 + 7) / 8;
    }

    private int findChangingElement(byte[] byArray, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        if (bl) {
            return this.find(byArray, n, n2, n3, n4, true);
        }
        int n6 = this.a0 == -1 ? 0 : (n5 = n3 == 7 ? byArray[n - 1] & 1 : byArray[n] >>> n3 + 1 & 1);
        if (n2 == n5) {
            return this.find(byArray, n, n2, n3, n4, true);
        }
        return this.find(byArray, n, n5, n3, n4, false);
    }

    private int find(byte[] byArray, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = -1;
        while (n3 >= 0) {
            if ((byArray[n] >>> n3 & 1) == n2) {
                ++n4;
                --n3;
            } else {
                --n3;
                if (bl) {
                    n5 = n4++;
                    break;
                }
                ++n4;
                n2 ^= 1;
                bl = true;
            }
            if (n4 >= this.scanLineWidth) break;
            if (n3 >= 0) continue;
            n3 = 7;
            ++n;
        }
        return n5;
    }
}

