/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.bmp;

import java.util.HashMap;
import java.util.Map;

public enum BmpCompression {
    BI_RGB("No Compression", 0),
    BI_RLE8("8 bit RLE Compression (8 bit only)", 1),
    BI_RLE4("4 bit RLE Compression (4 bit only)", 2),
    BI_BITFIELDS("No compression (16 & 32 bit only)", 3),
    UNKNOWN("Unknown", 9999);

    private static final Map<Integer, BmpCompression> typeMap;
    private String description;
    private int value;

    private BmpCompression(String string2, int n2) {
        this.description = string2;
        this.value = n2;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.description;
    }

    public static BmpCompression fromInt(int n) {
        BmpCompression bmpCompression = typeMap.get(n);
        if (bmpCompression == null) {
            return UNKNOWN;
        }
        return bmpCompression;
    }

    static {
        typeMap = new HashMap<Integer, BmpCompression>();
        for (BmpCompression bmpCompression : BmpCompression.values()) {
            typeMap.put(bmpCompression.getValue(), bmpCompression);
        }
    }
}

