/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.transform.InterpolationMethod;
import com.github.ajalt.colormath.transform.InterpolationMethodKt;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/colormath/transform/MonotonicSplineInterpolator;", "Lcom/github/ajalt/colormath/transform/InterpolationMethod$ComponentInterpolator;", "points", "", "Lcom/github/ajalt/colormath/transform/InterpolationMethod$Point;", "parabolicEndpoints", "", "<init>", "(Ljava/util/List;Z)V", "n", "", "x", "", "i", "y", "h", "", "s", "p", "yp", "interpolate", "t", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolationMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpolationMethod.kt\ncom/github/ajalt/colormath/transform/MonotonicSplineInterpolator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n388#2,7:165\n*S KotlinDebug\n*F\n+ 1 InterpolationMethod.kt\ncom/github/ajalt/colormath/transform/MonotonicSplineInterpolator\n*L\n137#1:165,7\n*E\n"})
final class MonotonicSplineInterpolator
implements InterpolationMethod.ComponentInterpolator {
    @NotNull
    private final List<InterpolationMethod.Point> points;
    private final int n;
    @NotNull
    private final float[] h;
    @NotNull
    private final float[] s;
    @NotNull
    private final float[] p;
    @NotNull
    private final float[] yp;

    public MonotonicSplineInterpolator(@NotNull List<InterpolationMethod.Point> points, boolean parabolicEndpoints) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.points = points;
        this.n = CollectionsKt.getLastIndex(this.points);
        int n3 = 0;
        int n4 = this.n;
        float[] fArray = new float[n4];
        MonotonicSplineInterpolator monotonicSplineInterpolator = this;
        while (n3 < n4) {
            n2 = n3++;
            fArray[n2] = this.x(n2 + 1) - this.x(n2);
        }
        monotonicSplineInterpolator.h = fArray;
        n3 = 0;
        n4 = this.n;
        fArray = new float[n4];
        monotonicSplineInterpolator = this;
        while (n3 < n4) {
            n2 = n3++;
            fArray[n2] = (this.y(n2 + 1) - this.y(n2)) / this.h[n2];
        }
        monotonicSplineInterpolator.s = fArray;
        n4 = this.points.size();
        fArray = new float[n4];
        monotonicSplineInterpolator = this;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3;
            n = n2;
            fArray[n2] = n == 0 ? this.s[0] * (1.0f + this.h[0] / (this.h[0] + this.h[1])) - this.s[1] * (this.h[0] / (this.h[0] + this.h[1])) : (n == this.n ? this.s[this.n - 1] * (1.0f + this.h[this.n - 1] / (this.h[this.n - 1] + this.h[this.n - 2])) - this.s[this.n - 2] * (this.h[this.n - 1] / (this.h[this.n - 1] + this.h[this.n - 2])) : (this.s[n2 - 1] * this.h[n2] + this.s[n2] * this.h[n2 - 1]) / (this.h[n2 - 1] + this.h[n2]));
        }
        monotonicSplineInterpolator.p = fArray;
        n4 = this.points.size();
        fArray = new float[n4];
        monotonicSplineInterpolator = this;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3;
            n = n2;
            fArray[n2] = n == 0 ? (parabolicEndpoints ? (this.p[0] * this.s[0] <= 0.0f ? 0.0f : (Math.abs(this.p[0]) > (float)2 * Math.abs(this.s[0]) ? (float)2 * this.s[0] : this.p[0])) : this.s[0]) : (n == this.n ? (parabolicEndpoints ? (this.p[this.n] * this.s[this.n - 1] <= 0.0f ? 0.0f : (Math.abs(this.p[this.n]) > (float)2 * Math.abs(this.s[this.n - 1]) ? (float)2 * this.s[this.n - 1] : this.p[this.n])) : this.s[this.n - 1]) : (Math.signum(this.s[n2 - 1]) + Math.signum(this.s[n2])) * Math.min(Math.abs(this.s[n2 - 1]), Math.min(Math.abs(this.s[n2]), Math.abs(this.p[n2]) / (float)2)));
        }
        monotonicSplineInterpolator.yp = fArray;
    }

    private final float x(int i) {
        return this.points.get(i).getX();
    }

    private final float y(int i) {
        return this.points.get(i).getY();
    }

    @Override
    public float interpolate(float t) {
        int n;
        block3: {
            List<InterpolationMethod.Point> $this$indexOfLast$iv = this.points;
            boolean $i$f$indexOfLast = false;
            ListIterator<InterpolationMethod.Point> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                InterpolationMethod.Point it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getX() <= t)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        int i = RangesKt.coerceIn((int)n, (int)0, (int)(this.n - 1));
        InterpolationMethod.Point point = this.points.get(i);
        float xi = point.component1();
        float yi = point.component2();
        float xDiff = t - xi;
        if (xDiff == 0.0f) {
            return yi;
        }
        float ai = (this.yp[i] + this.yp[i + 1] - (float)2 * this.s[i]) / (float)Math.pow(this.h[i], 2);
        float bi = ((float)3 * this.s[i] - (float)2 * this.yp[i] - this.yp[i + 1]) / this.h[i];
        float f = ai * (float)Math.pow(xDiff, 3) + bi * (float)Math.pow(xDiff, 2) + this.yp[i] * xDiff + yi;
        if (Float.isNaN(f)) {
            return t <= this.x(0) ? this.y(0) : (t >= this.x(this.n) ? this.y(this.n) : InterpolationMethodKt.access$lerp(yi, this.y(i + 1), xDiff / (this.x(i + 1) - xi)));
        }
        return f;
    }
}

