/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGBColorSpace;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/ajalt/colormath/model/BT2020TransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "<init>", "()V", "a", "", "b", "eotfCutoff", "eotf", "", "x", "oetf", "colormath"})
final class BT2020TransferFunctions
implements RGBColorSpace.TransferFunctions {
    @NotNull
    public static final BT2020TransferFunctions INSTANCE = new BT2020TransferFunctions();
    private static final double a = 1.0993;
    private static final double b = 0.0181;
    private static final double eotfCutoff = 1.0993 * Math.pow(0.0181, 0.45) - 0.09929999999999994;

    private BT2020TransferFunctions() {
    }

    @Override
    public float eotf(float x) {
        return ((Number)((double)x < eotfCutoff ? (Number)Float.valueOf(x / 4.5f) : (Number)InternalMathKt.spow(((double)x + 0.09929999999999994) / 1.0993, 2.2222222222222223))).floatValue();
    }

    @Override
    public float oetf(float x) {
        return (float)((double)x < 0.0181 ? 4.5 * (double)x : 1.0993 * InternalMathKt.spow(x, 0.45) - 0.09929999999999994);
    }
}

