MODULE m2scan;
(*
 * 15.8.92/bp
 * Sucht alle zugehrigen Dateien
 *)
(*$ LargeVars:=FALSE RangeChk:=FALSE OverflowChk:=FALSE StackChk:=FALSE
    StackParms:=FALSE
 *)

FROM SYSTEM IMPORT ADR,ADDRESS,CAST,LONGSET,SETREG;
FROM Arts	IMPORT  programName;
FROM M2File	IMPORT	FileType, GetFileName, ReadPathTable, pathFileName;
FROM Terminal	IMPORT	WriteString, WriteLn, FormatS, Format,
			waitCloseGadget;
FROM ArgHandler	IMPORT	interActive, verbose, InitHandler, FetchName,
			fName,fNameLen,SetReply;
FROM ReplyVals	IMPORT	rcIllOpt,rcWarn,rcActionErr,rcMainNotFound;
FROM DateConversions IMPORT DateInfo,DateToStr,FromDos;
IMPORT DosD, DosL;

CONST
  in="in> ";
  title1="m2scan";
  title2="Amiga Modula-2 Modul-Scanner";
  ver="4.4";
  date=COMPILEDATE;
  version=", "+ver+"d, "+date+"\n";
  verDollar="$VER: m2scan "+ver+" "+date;
  usage="Aufruf: %s {+-d ? ModulName}\n\n";
  exit=" --- ende\n\n";


TYPE
  Str4 = ARRAY[0..3] OF CHAR;
  FTArr = ARRAY FileType OF Str4;

CONST
  FTs = FTArr
  {"def", "mod", "sym", "obj", "ob1", "ob2", "ob3", "ob4", "ob8", "ref", "bin"};


VAR
  (*$ LongAlign:=FALSE *)
  dejaVue,
  showDates: BOOLEAN;
  FullName: ARRAY[0..255] OF CHAR;
  DateString: ARRAY [0..79] OF CHAR;
  (*$ LongAlign:=TRUE *)
  fib: DosD.FileInfoBlock;


PROCEDURE ConvertDate;
VAR
  di:DateInfo;
BEGIN
  FromDos(fib.date,di);
  DateToStr(di,"    (%d.%m.%y %H:%M:%S)","",DateString);
END ConvertDate;

(* Den brauche ich auch, um das Datum zu holen!! *)
PROCEDURE FileExists():BOOLEAN;
VAR
  l: DosD.FileLockPtr;
  res:BOOLEAN;
BEGIN
  res:=FALSE;
  l:=DosL.Lock(ADR(FullName),DosD.sharedLock);
  IF l <> NIL THEN
    IF DosL.Examine(l,ADR(fib)) THEN
      IF fib.dirEntryType < 0 THEN (* file *)
        res:=TRUE;
      END;
    END;
    DosL.UnLock(l);
  END;
  RETURN res;
END FileExists;



PROCEDURE ShowFiles;
VAR
  ft:FileType;
BEGIN
  FOR ft:=MIN(FileType) TO MAX(FileType) DO
    GetFileName(FullName,ft,fName,FALSE);
    FormatS("    %s: ",FTs[ft]);
    IF FileExists() THEN
      WriteString(FullName);
      IF showDates THEN
        ConvertDate;
        WriteString(DateString);
      END;
    ELSE
      WriteString("----------------");
    END;
    WriteLn;
  END;
  WriteLn;
END ShowFiles;

(*$ CopyDyn:=FALSE *)
PROCEDURE Options(s:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
VAR set,ok:BOOLEAN; i,val:INTEGER;
BEGIN
  IF s[0]='?' THEN
    ok:=FALSE;
  ELSE
    ok:=TRUE;
    i:=0;
    LOOP
      CASE CAP(s[i]) OF (* zunchst kommt ja sicher '+' oder '-'! *)
      | '+': set:=TRUE;
      | '-': set:=FALSE;
      | 'Q': verbose:=set;
      | 'D': showDates:=set;
      | ELSE
	  ok:=FALSE;
	  EXIT
      END; (* case *)
      INC(i);
      IF i>=len THEN EXIT END;
    END; (* loop *)
    IF interActive THEN verbose:=TRUE END;
  END;
  IF ~ok THEN
    WriteString(title1); WriteString(version);
    Format(usage,ADR(programName));
    SetReply(rcIllOpt);
  END;
  RETURN ok;
END Options;

BEGIN
  SETREG(11,ADR(verDollar));
  showDates:=TRUE;

  InitHandler(Options,ADR(in),ADR('ENV:m2scan'),ADR("m2scan.opt"));
  WriteString(title2); WriteString(version);

  IF ~FetchName() THEN RETURN END; (* bei Aufruffehler gleich raus *)
  IF fNameLen=0 THEN interActive:=TRUE END;
  ReadPathTable(pathFileName);
  (* Nun erstes Arg holen! *)
  LOOP
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT
      UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;
    IF interActive THEN verbose:=TRUE END;
    ShowFiles;
  END; (* loop *)
  IF interActive&verbose THEN
    WriteString(exit);
  END;
  waitCloseGadget:=verbose & ~interActive;
END m2scan.
