MODULE m2decsym;
(*$ LargeVars:=FALSE StackChk:=FALSE StackParms:=FALSE Volatile:=FALSE *)
(* 25.8.90/bp angepat neues Ref-Format ExtVars etc. *)
(* 30.12.90/bp SHORTSET fehlte, SHORTINT u. SHORTCARD gro geschrieben *)
(*	angepat fr neue Idents und VarModes *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,BYTE,CAST,WORD,LONGSET,SETREG;
FROM Arts	IMPORT	Assert,BreakPoint,Requester,Terminate;
FROM Assembler	IMPORT	d0;
FROM DecBase	IMPORT	ModKeys,Do,Error,Get,OutC,OutChar,OutCard,
			OutCondLn,OutHex,OutInt,OutKey,OutLn,OutLR,OutS;
FROM ExecL	IMPORT	CopyMem;
FROM Heap	IMPORT	AllocMem,Deallocate,Largest;
FROM M2File	IMPORT	FileType;
FROM ReplyVals	IMPORT	rcActionErr;

CONST
 ver="4.4";
 date=COMPILEDATE;
 verDollar="$VER: m2decsym "+ver+" "+date;
 titleString = "m2decsym "+ver+"d, "+date+"\n";

 usage = "Aufruf:\n m2decsym {? SymbolFile}\n";
 refFileWrong = "Fehler in Symboldatei\n";
 notRefFile = "Symboldatei hat falschen Typ\n";
 header=
    "Amiga Modula-2 Symbolfiledecoder";
 body=
(*  "Insufficient Memory"; *)
    "Nicht gengend Speicher";
 abort=
(*  " Abort "; *)
    " abbrechen ";
 retry=
(*  " Retry "; *)
    " weiter ";

VAR
 indent:INTEGER;

PROCEDURE Indent; BEGIN INC(indent); END Indent;

PROCEDURE UnIndent; BEGIN IF indent>0 THEN DEC(indent); END; END UnIndent;

PROCEDURE OutEOL;
VAR
 i:INTEGER;
BEGIN
 OutLn;
 FOR i:=1 TO indent DO OutC(" "); END;
END OutEOL;

PROCEDURE OutCondEOL;
VAR
 i:INTEGER;
BEGIN
 IF OutCondLn(60) THEN FOR i:=1 TO indent DO OutC(" "); END; END;
END OutCondEOL;

CONST
 pc=16;
 minSInt=-128; maxSInt=127;
 minSCard=0; maxSCard=255;
 minInt=MIN(INTEGER); maxInt=MAX(INTEGER);
 minCard=MIN(CARDINAL); maxCard=MAX(CARDINAL);
 minLInt=MIN(LONGINT); maxLInt=MAX(LONGINT);
 minLCard=MIN(LONGCARD); maxLCard=MAX(LONGCARD);
 minReal=MIN(REAL); maxReal=MAX(REAL);
 nil=0;
 pointerTypSize=4;
 procTypSize=4;
 dynArrDesSize=8; (* Descriptor size for dynamic array param. *)
 byte=0; word=1; long=2;
 (* Instruction size for simple types *)

TYPE
 WidType=[byte..long];
 RegType=(Dreg,Areg);
 Register=[d0..pc];
 RegisterSet=SET OF Register;
 ObjPtr=POINTER TO Object;
 StrPtr=POINTER TO Structure;
 ParPtr=POINTER TO Parameter;
 KeyPtr=POINTER TO Key;
 Ident=POINTER TO
 RECORD
     len:INTEGER;
     buf: ARRAY [0..20000] OF CHAR
 END;
 ObjClass=(Header,Const,Typ,Var,Field,Proc,Code,Module);
 (* Note: for scalar types: form<=UInt *)
 (* for subrange types: RBaseTyp^.form<Range *)
 (* for structured types: form>Opaque *)
 StrForm=(
  Undef,Bool,Char,UInt,Enum,Range,FFP,Real,LReal,UReal,BPointer,Pointer,Set,
  ProcTyp,Opaque,String,Array,Record
 );
 Standard=(
  Abs,Adr,Cap,Cast,Chr,Dec,Excl,Float,Halt,High,Inc,Incl,Inline,Loadregs,
  Max,Min,Odd,Ord,Reg,Saveregs,Setreg,Shift,Size,Tsize,Trunc,Val,NonStand
 );
 ConstValue=RECORD
  CASE :StrForm OF
  | Undef..UInt: sign,I:LONGINT; (* always corrctly sign extended ! *)
  | FFP..UReal: R:LONGREAL; (* FFP values are always stored as longreal *)
  | Set: d:LONGINT; S:LONGSET;
  | String: Str:Ident;
  END;
  prev:ObjPtr;
 END;
 VarModes=(norm,absvar,regvar,farvar,extvar,smallextvar);
 ModModes=(none,hasimp,library,noimp);
 Object=RECORD
  name:Ident; (* index to name buffer *)
  typ:StrPtr;
  next,last:ObjPtr;
  CASE class:ObjClass OF
  | Header:
  | Const: conmod:INTEGER; conval:ConstValue;
  | Typ: tmod:INTEGER;
  | Var:
   varpar:BOOLEAN; vmode:VarModes; vmod,vlev:INTEGER; vadr:LONGINT;
  | Field:
     (*
      * The fields pd - cd and firstParam - firstArg have to be at the
      * same place, because Code Procedures are treated differently
      * only after the parameters have been read.
      *)
  | Proc: pnr:INTEGER; firstParam:ParPtr; extName: Ident;
  | Code: cnr:INTEGER; firstArg:ParPtr; std:Standard; cnum:INTEGER;
  | Module:
   key:KeyPtr; firstObj:ObjPtr; (*mmod:INTEGER;*) mode:ModModes;
  END;
 END;
 Structure=RECORD
  strobj:ObjPtr; (* object (type) naming structure *)
  ref:INTEGER;
  CASE form:StrForm OF
  | Undef..UInt,FFP..UReal,Opaque..String: (* no field *)
  | Enum: ConstLink,LastConst:ObjPtr; NofConst:LONGINT;
  | Range: RBaseTyp:StrPtr; min,max:LONGINT; sign:BOOLEAN; (*BndAdr:INTEGER;*)
  | BPointer,Pointer: PBaseTyp:StrPtr; BaseId: Ident; (* forward refs *)
  | Set: SBaseTyp:StrPtr;
  | Array: ElemTyp,IndexTyp:StrPtr; dyn:BOOLEAN;
  | Record: firstFld:ObjPtr;
  | ProcTyp: firstPar:ParPtr; resTyp:StrPtr;
  END;
 END;
 Parameter=RECORD
  name:Ident;
  varpar:BOOLEAN;
  parMode:INTEGER; (* 0=stack, 1..16=Register 0..15 *)
  typ:StrPtr;
  next:ParPtr;
 END;
 Key=RECORD
  CASE :INTEGER OF
  |0: modKeys:ModKeys;
  |1: id: Ident; ver: INTEGER
  END
 END;

VAR
 notyp,unknowntyp,undftyp,booltyp,chartyp,uinttyp,
 ffptyp,realtyp,lrealtyp,urealtyp,ssettyp,bsettyp,lsettyp,proctyp,stringtyp,
 bytetyp,wordtyp,addrtyp,bptrtyp:StrPtr;
 numtyp:ARRAY [byte..long],[FALSE..TRUE] OF StrPtr;


CONST
 maxChunk=8000;
 saveMem=20000;


TYPE
 StorageNodePtr=POINTER TO StorageNode;
 StorageNode=RECORD
  next: StorageNodePtr;
  size,
  free: INTEGER;
  data: LONGINT;
 END;

VAR
 heap: StorageNodePtr;

(*$ RangeChk:=FALSE OverflowChk:=FALSE *)

PROCEDURE AllocateMemory(VAR a: ADDRESS; min,max: LONGINT): INTEGER;
VAR
 size: LONGINT;
BEGIN
 REPEAT
  LOOP
  (*
   * Only if we can leave at least 20K continuos memory we will
   * allocate the memory. Otherwise we will tell the user, that
   * we can't allocate the memory and offer a possibility to retry.
   *)
   size:=Largest(FALSE)-saveMem;
   IF size>=min THEN
    EXIT
   ELSIF ~Requester(ADR(header),ADR(body),ADR(retry),ADR(abort)) THEN
    Terminate;
   END
  END;
  IF size>max THEN
   size:=max
  END;
  AllocMem(a,size,FALSE)
 UNTIL a#NIL;
 RETURN size;
END AllocateMemory;

PROCEDURE Allocate(VAR list: StorageNodePtr; VAR a: ADDRESS; n: INTEGER);
VAR
 temp: StorageNodePtr;
 blockSize: INTEGER;
 maxSize: INTEGER;
 (* 30.12.90/bp Korrigiert fr beliebig groe Bereiche! *)
BEGIN
 a:=NIL;
 IF ODD(n) THEN INC(n) END;
 IF (list=NIL) OR (list^.free<n) THEN
  IF n<=maxChunk THEN
   maxSize:=maxChunk
  ELSE
   maxSize:=n;
  END;
  blockSize:=n+SIZE(StorageNode);
  INC(maxSize,SIZE(StorageNode));
  blockSize:=AllocateMemory(temp,blockSize,maxSize);
  WITH temp^ DO
   next:=list;
   data:=CAST(LONGINT,temp)+SIZE(StorageNode);
   free:=blockSize-SIZE(StorageNode);
   size:=free;
  END;
  list:=temp;
 END;
 WITH list^ DO
  DEC(free,n);
  a:=CAST(ADDRESS,data+free);
 END;
END Allocate;

PROCEDURE ALLOCATE(VAR a: ADDRESS; n: INTEGER);
BEGIN
 Allocate(heap, a, n)
END ALLOCATE;

PROCEDURE Reset(VAR c: StorageNodePtr; adr: LONGINT);
VAR
 temp:StorageNodePtr;
BEGIN
 WHILE (c#NIL) & ( (adr < c^.data+c^.free) OR (c^.data+c^.size <= adr) ) DO
  temp:=c;
  c:=c^.next;
  Deallocate(temp);
 END;
 IF c#NIL THEN
  c^.free:=adr-c^.data; (* Hier killt der Compiler d2 !! *)
 END;
END Reset;

PROCEDURE ResetHeap(adr:ADDRESS);
BEGIN
 Reset(heap, CAST(LONGINT,adr));
END ResetHeap;

(*$ POP OverflowChk POP RangeChk *)

(*
VAR
 topScope,Scope:ObjPtr; (*header of scope located by Find*)
*)
PROCEDURE NewObj(id{6}: Ident; cl{7}:ObjClass):ObjPtr;
VAR
 ob1:ObjPtr;
BEGIN
 ALLOCATE(ob1,SIZE(Object));
 WITH ob1^ DO
  next:=NIL;
  name:=id; typ:=undftyp; class:=cl;
  CASE cl OF
  | Header,Const,Typ,Field:
  | Var: vmode:=norm
  | Proc: firstParam:=NIL; pnr:=0;
  | Code: firstArg:=NIL; cnr:=0;
  | Module: firstObj:=NIL; key:=NIL; typ:=notyp
  END
 END;
 RETURN ob1;
END NewObj;

(*$ CopyDyn:=FALSE *)
PROCEDURE Enter(name: ARRAY OF CHAR): Ident;
VAR
 l: INTEGER;
 id: Ident;
BEGIN
 l:=HIGH(name)+1; (* ohne 0C *)
 ALLOCATE(id,l+3); (* +0C+len *)
 CopyMem(ADR(name),ADR(id^.buf),l+1); (* mit 0C *)
 id^.len:=l;
 RETURN id;
END Enter;

PROCEDURE NewStr(frm:StrForm):StrPtr;
VAR
 str:StrPtr;
BEGIN
 ALLOCATE(str,SIZE(Structure));
 WITH str^ DO
  strobj:=NIL; ref:=0; form:=frm;
  CASE frm OF
  | Undef..Enum,FFP..UReal,Opaque..String:
  | Range: RBaseTyp:=undftyp; min:=0; max:=0; sign:=FALSE;
  | BPointer,Pointer: PBaseTyp:=undftyp
  | Set: SBaseTyp:=undftyp
  | ProcTyp: firstPar:=NIL; resTyp:=NIL
  | Array: ElemTyp:=undftyp; IndexTyp:=undftyp
  | Record: firstFld:=NIL
  END
 END;
 RETURN str
END NewStr;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterTyp(VAR str:StrPtr; name:ARRAY OF CHAR; frm:StrForm);
VAR
 obj:ObjPtr;
BEGIN
 obj:=NewObj(Enter(name),Typ); str:=NewStr(frm);
 obj^.typ:=str; str^.strobj:=obj;
END EnterTyp;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterNumTyp(VAR str:StrPtr; name:ARRAY OF CHAR;
                      sgn:BOOLEAN; lo,hi:LONGINT);
VAR
 obj:ObjPtr;
BEGIN
 EnterTyp(str,name,Range);
 WITH str^ DO
  RBaseTyp:=uinttyp;
  sign:=sgn; min:=lo; max:=hi;
 END;
END EnterNumTyp;

VAR
 SBtyp,BBtyp,LBtyp:StrPtr;


CONST
 reffile=10;
 CTL=0; anchor=0; ModTag=1; ProcTag=2; RefTag=3; linkage=4;
 STR=1; enum=0; range=1; pointer=2; set=3; procTyp=4; funcTyp=5;
 array=6; dynarr=7; record=10; opaque=11; bpointer=12;
 CMP=2; parref=0; par=1; field=2;
 OBJ=3; varref=0; var=1; const=2; string=3; type=4; proc=5; func=6;
 module=7; svc=10; svcfunc=11;
 maxM=64; minS=32 (*first non-standard structure*); maxS=1024;

(*$ StackChk:=FALSE OverflowChk:=FALSE RangeChk:=FALSE *)
PROCEDURE InB(VAR b:BYTE);
BEGIN
 IF Get(b) THEN END;
END InB;

PROCEDURE InW(VAR w:WORD);
BEGIN
 IF Get(w) THEN END;
END InW;

PROCEDURE InL(VAR l:LONGINT);
BEGIN
 IF Get(l) THEN END;
END InL;

PROCEDURE InNumber(VAR x:ARRAY OF BYTE);
VAR
 c,i,k,l:SHORTINT;
 ch:CHAR;
 fill:BOOLEAN;  (* HACK: assumes TRUE=-1 ! *)
BEGIN
 InB(ch); c:=SHORTCARD(ch) MOD 64;
 l:=HIGH(x);
 fill:=c>31;
 IF fill THEN DEC(c,64); END;
 CASE CAST(SHORTCARD,ch) DIV 64 OF
 | 0: x[l]:=c; DEC(l,1);
 | 1: x[l-1]:=c; InB(x[l]); DEC(l,2);
 | 2: x[l-2]:=c; InB(x[l-1]); InB(x[l]); DEC(l,3);
 | 3:
   k:=l-c+1;
   FOR i:=k TO l DO InB(x[i]); END;
   l:=k-1; (* = DEC(l,c); *)
   fill:=CAST(SHORTINT,x[k])<0;
 END;
 FOR i:=0 TO l DO x[i]:=CAST(SHORTINT,fill); END;
END InNumber;

PROCEDURE InBool(VAR b:BOOLEAN);
VAR
 temp:SHORTINT;
BEGIN
 InNumber(temp); b:=BOOLEAN(temp);
END InBool;

PROCEDURE InId():Ident;
VAR
 L:INTEGER;
 ch:INTEGER; (* 30.1.90/bp Es knnen nun LANGE Strings kommen! *)
 id:Ident;
 id0:POINTER TO CHAR;
BEGIN
 id:=NIL;
 InNumber(ch);
 L:=ch-1;
 IF L>0 THEN
  ALLOCATE(id,L+3); id0:=ADR(id^.buf); id^.len:=L;
  WHILE L>0 DO InB(id0^); INC(id0);  DEC(L); END;
  id0^:=0C;
 END;
 RETURN id
END InId;

CONST (* 30.12.90/bp SHORTSET auch! *)
 systemStruct=LONGSET{9,12,13,14,18,19,22,23};

VAR
 addSystem:BOOLEAN;

PROCEDURE SysTest(s:INTEGER);
BEGIN
 IF (s<minS) & (s IN systemStruct) THEN addSystem:=TRUE; END;
END SysTest;

(*$ POP RangeChk POP OverflowChk POP StackChk *)

VAR
 currMod,currStr:INTEGER;
 modules:ARRAY [0..maxM+1] OF ObjPtr;
 structures:ARRAY [0..maxS] OF StrPtr;

PROCEDURE OutString(name:Ident);
VAR i:INTEGER;
BEGIN
 IF name#NIL THEN
   FOR i:=0 TO name^.len-1 DO
    OutC(name^.buf[i]);
   END;
 END;
END OutString;

PROCEDURE OutStr(str:StrPtr); FORWARD;

PROCEDURE OutVal(obj:ObjPtr);
VAR
 comma:BOOLEAN;
 i:LONGINT;
 o:ObjPtr;
BEGIN
 WITH obj^.conval DO
  CASE obj^.typ^.form OF
  | Undef,UInt,Range,BPointer,Pointer,ProcTyp,Opaque: OutInt(I);
  | Bool:
   IF I=0 THEN OutS("FALSE"); ELSE OutS("TRUE"); END;
  | Char: OutChar(CHAR(I));
  | Enum:
   o:=obj^.typ^.ConstLink;
   (* 1.1.91/bp Neue Enums *)
   WHILE (o#NIL)&(o^.conval.I#I) DO o:=o^.conval.prev END;
   IF o=NIL THEN OutInt(I); ELSE
    IF o^.conmod#0 THEN OutString(modules[o^.conmod]^.name); OutC("."); END;
    OutString(o^.name);
   END;
  | FFP..UReal: OutLR(R);
  | Set:
   WITH obj^.typ^ DO
    IF strobj^.tmod#0 THEN OutString(modules[strobj^.tmod]^.name); OutC("."); END;
    OutString(strobj^.name); OutC("{");
    IF SBaseTyp^.form=Enum THEN
    (* 1.1.91/bp Sets weiterhin nur fr ORD(first)=0 zugelassen, also ok *)
     o:=SBaseTyp^.ConstLink; i:=0; comma:=FALSE;
     WHILE (i<=31) & (o#NIL) DO
      IF i IN S THEN
       IF comma THEN OutC(","); OutCondEOL; END;
       IF o^.conmod#0 THEN OutString(modules[o^.conmod]^.name); OutC("."); END;
       OutString(o^.name); comma:=TRUE;
      END;
      o:=o^.conval.prev; INC(i);
     END;
    ELSE
     i:=0; comma:=FALSE;
     FOR i:=0 TO 31 DO
      IF i IN S THEN
       IF comma THEN OutC(","); END;
       OutInt(i); comma:=TRUE;
      END;
     END;
    END;
   END;
   OutC("}");
  | String: OutC('"'); OutString(Str); OutC('"');
  END;
 END;
END OutVal;

PROCEDURE OutPar(par:ParPtr; n:INTEGER; withName:BOOLEAN);
BEGIN
 WITH par^ DO
  IF varpar THEN OutS("VAR "); END;
  IF withName THEN
   IF name#NIL THEN OutString(name); ELSE OutS("par"); OutInt(n); END;
   IF parMode>0 THEN OutC("{"); OutInt(parMode-1); OutC("}"); END;
   OutC(":");
  END;
  OutStr(typ);
  IF (~withName) & (parMode>0) THEN OutC("{"); OutInt(parMode-1); OutC("}"); END;
 END;
END OutPar;

VAR
 lastObjClass:ObjClass;

PROCEDURE OutObj(obj:ObjPtr);
VAR
 i:INTEGER;
 par:ParPtr;
BEGIN
 WITH obj^ DO
  CASE class OF
  | Proc,Code:
   lastObjClass:=Header;
   UnIndent; OutEOL;
   OutS("PROCEDURE"); Indent; OutEOL;
   OutString(name);
   par:=firstParam;
   IF par#NIL THEN
    OutS("("); i:=0; Indent; OutEOL;
    WHILE par#NIL DO
     OutPar(par,i,TRUE); INC(i);
     par:=par^.next;
     IF par#NIL THEN OutS(";"); OutEOL; END;
    END; UnIndent; OutEOL;
    OutS(")");
   ELSIF typ#notyp THEN
    OutS("()");
   END;
   IF (typ#notyp) THEN OutC(":"); OutStr(typ) END;
   IF class=Code THEN
     OutS("; CODE "); OutInt(cnum);
   (* 05.09.92/bp externe Procs! *)
   ELSIF extName#NIL THEN
     OutS('; CODE "'); OutString(extName); OutC('"');
   END;
   OutC(";"); OutEOL;
  | Const:
   (*IF typ^.form#Enum THEN 1.1.91/bp endlich korrekt! *)
    IF lastObjClass#Const THEN
     lastObjClass:=Const;
     UnIndent; OutEOL;
     OutS("CONST"); Indent; OutEOL;
    END;
    OutString(name); OutS("="); OutVal(obj); OutC(";"); OutEOL;
   (*END;*)
  | Typ:
   IF lastObjClass#Typ THEN
    lastObjClass:=Typ;
    UnIndent; OutEOL;
    OutS("TYPE"); Indent; OutEOL;
   END;
   OutString(name); OutS("="); OutStr(typ); OutC(";"); OutEOL;
  | Var:
   IF lastObjClass#Var THEN
    lastObjClass:=Var;
    UnIndent; OutEOL;
    OutS("VAR"); Indent; OutEOL;
   END;
   OutString(name);
   IF vmode=absvar THEN
     OutS("[0"); OutHex(vadr); OutS("H]");
   ELSIF (vmode>=extvar)&(vmode<=smallextvar) THEN
     OutS("[ "); IF vmode=smallextvar THEN OutS("< ") END;
     OutS('"');
     OutString(CAST(Ident,vadr));
     OutS('"]');
   END;
   OutS(":"); OutStr(typ); OutC(";"); OutEOL;
  | Field:
   OutString(name); OutS(":"); OutStr(typ); OutC(";");
  END;
 END
END OutObj;

PROCEDURE OutStr(str:StrPtr);
VAR
 o:Object;
 obj:ObjPtr;
 par:ParPtr;

 PROCEDURE OutFlds(fld:ObjPtr);
 BEGIN
  WHILE
   fld#NIL DO OutObj(fld); fld:=fld^.next;
   IF fld#NIL THEN OutEOL; END;
  END;
 END OutFlds;

VAR
 i:INTEGER;
BEGIN
 WITH str^ DO
  IF (ref#0) & (strobj#NIL) & (strobj^.name#NIL) THEN
   IF strobj^.tmod#0 THEN OutString(modules[strobj^.tmod]^.name); OutC("."); END;
   OutString(strobj^.name); RETURN;
  END;
  CASE form OF
  | Enum:
   OutC("(");
   obj:=ConstLink; Indent; OutEOL;
   (* 1.1.91/bp Neue Enum-Typen! *)
   i:=0;
   WHILE obj#NIL DO
    OutString(obj^.name);
    IF (i=0)&(obj^.conval.I#0) THEN
      OutS(":="); OutInt(obj^.conval.I);
    END;
    INC(i);
    obj:=obj^.conval.prev;
    IF obj#NIL THEN OutC(","); OutCondEOL; END;
   END;
   UnIndent; OutEOL;
   OutC(")");
  | Range:
   WITH o DO
    typ:=str^.RBaseTyp;
    class:=Const;
   END;
   obj:=ADR(o);
   OutC("[");
   o.conval.I:=min; OutVal(obj);
   OutS("..");
   o.conval.I:=max; OutVal(obj);
   OutC("]");
  | BPointer,Pointer:
   IF form=BPointer THEN OutC("B"); END;
   OutS("POINTER TO ");
   IF (PBaseTyp^.strobj#NIL) & (PBaseTyp^.strobj^.name#NIL) THEN
    OutString(PBaseTyp^.strobj^.name);
   ELSE
    OutStr(PBaseTyp);
   END;
  | Set:
   OutS("SET OF ");
   OutStr(SBaseTyp)
  | ProcTyp:
   OutS("PROCEDURE");
   par:=firstPar;
   IF par#NIL THEN
    OutS("("); i:=0; Indent; OutEOL;
    WHILE par#NIL DO
     OutPar(par,i,FALSE); INC(i);
     par:=par^.next;
     IF par#NIL THEN OutS("; "); OutCondEOL; END;
    END;
    UnIndent; OutEOL;
    OutS(")");
   ELSIF resTyp#notyp THEN
    OutS("()");
   END;
   IF (resTyp#notyp) THEN OutC(":"); OutStr(resTyp) END;
  | Array:
   OutS("ARRAY");
   IF ~dyn THEN OutC(" "); OutStr(IndexTyp); END;
   OutS(" OF "); Indent; OutEOL; OutStr(ElemTyp); UnIndent;
  | Record:
   OutS("RECORD"); Indent; OutEOL;
    OutFlds(firstFld);
   UnIndent; OutEOL; OutS("END");
  | Opaque:
  END;
  ref:=99;  (* als besucht markiert *)
 END
END OutStr;

PROCEDURE OutUnit;
VAR
 i:INTEGER;
 obj:ObjPtr;
BEGIN
 WITH modules[0]^ DO
  IF mode=noimp THEN
   OutS("(*$ Implementation:=FALSE *)"); OutEOL;
  END;
  OutS("DEFINITION MODULE "); OutString(name);
  IF mode=library THEN
   OutS('{"'); OutString(key^.id); OutS('",');
   OutInt(key^.ver); OutC("}");
  END;
  OutC(";"); OutEOL;
  IF mode#library THEN
   OutS("(* "); OutKey(key^.modKeys); OutS(" *)"); OutEOL;
  END;
 END;
 OutEOL;
 IF addSystem THEN OutS("IMPORT SYSTEM;"); OutEOL; OutEOL; END;
 FOR i:=1 TO currMod-1 DO
  WITH modules[i]^ DO
   OutS("IMPORT "); OutString(name); OutC(";"); OutEOL;
  END;
 END;
 OutEOL;
 obj:=modules[0]^.next;
 WHILE obj#NIL DO OutObj(obj); obj:=obj^.next; END;
 UnIndent; OutEOL;
 OutS("END "); OutString(modules[0]^.name); OutC("."); OutEOL;
END OutUnit;

PROCEDURE InRef;
VAR
 addObj:BOOLEAN;
 blk,ch:CHAR;
 block:CARDINAL;
 cleanup:ADDRESS;
 dummy,fileType:LONGINT;
 dummyB:BOOLEAN;
 err:BOOLEAN;
 i,len,m,p,s:INTEGER;
 newobj,obj:ObjPtr;
 newpar,par:ParPtr;
 newstr:StrPtr;
 tempParamList,lastTempPar:ParPtr;
 tempFieldList:ObjPtr;
 enumFlag:BOOLEAN;
BEGIN
  InL(fileType);
  IF (fileType#reffile) THEN (* Dies kann bleiben, da sym immer=reffile*)
    Error(notRefFile,rcActionErr);
    RETURN;
  END;
  addSystem:=FALSE;
  enumFlag:=FALSE;
  indent:=0;
  lastObjClass:=Header;
  ALLOCATE(cleanup,0);
  currMod:=0; currStr:=minS; err:=FALSE;
  ALLOCATE(tempFieldList,SIZE(Object)); ALLOCATE(tempParamList,SIZE(Parameter));
  WITH tempFieldList^ DO
   class:=Header; next:=NIL; last:=tempFieldList;
  END;
  tempParamList^.next:=NIL; lastTempPar:=tempParamList;
  LOOP
   InB(blk); block:=CARDINAL(blk);
   CASE block DIV 16 OF
   | OBJ:
    addObj:=TRUE;
    DEC(block,16*OBJ);
    IF block>svcfunc THEN err:=TRUE; EXIT END;
    ALLOCATE(newobj,SIZE(Object)); m:=0;
    WITH newobj^ DO
     next:=NIL;
     CASE block OF
     | var:
      class:=Var; InNumber(s); typ:=structures[s]; SysTest(s);
      varpar:=FALSE;
      InNumber(vlev); InNumber(vadr); InNumber(vmode);
      IF (vmode>=extvar)&(vmode<=smallextvar) THEN
        vadr:=CAST(LONGINT,InId())
      END;
     | const:
      class:=Const; InNumber(s); typ:=structures[s]; SysTest(s);
      InNumber(conmod); InNumber(conval.R); conval.prev:=NIL;
      addObj:=conmod=0;
     | string:
      class:=Const; InNumber(s); typ:=structures[s]; SysTest(s);
      conval.Str:=InId();
     | type:
      class:=Typ; InNumber(s); typ:=structures[s]; SysTest(s);
      InNumber(tmod);
      addObj:=tmod=0;
      IF ~addObj THEN typ^.ref:=s; END;
      enumFlag:=FALSE;
     | proc,func:
      class:=Proc;
      IF block=func THEN InNumber(s); typ:=structures[s]; SysTest(s);
      ELSE typ:=notyp
      END;
      InNumber(pnr); InNumber(dummy(*pd^.lev*));
      IF dummy<0 THEN
        extName:=InId();
      ELSE
        InNumber(dummy(*pd^.adr*));
      END;
      InNumber(dummy(*pd^.size*));
      InNumber(dummy(*pd^.regs*));
         (*
          * Add chain of just read parameters to this procedure and clear
          * the list.
          *)
      firstParam:=tempParamList^.next;
      tempParamList^.next:=NIL; lastTempPar:=tempParamList;
     | svc,svcfunc:
      class:=Code;
      IF block=svcfunc THEN InNumber(s); typ:=structures[s]; SysTest(s);
      ELSE typ:=notyp
      END;
      InNumber(cnum); std:=NonStand;
      cnr:=0;
         (*
          * Add chain of just read parameters to this procedure and clear
          * the list.
          *)
      firstArg:=tempParamList^.next;
      tempParamList^.next:=NIL; lastTempPar:=tempParamList;
     END;
     name:=InId(); InBool(dummyB); (*exported*)
     (* 1.1.91/bp Hier ist ein Fehler!! Jede CONST vom Typ Enum wird als
        Enum-Typ abgelegt! Das tut der Compiler leider auch!!!
        TYPE x=(a,b,c);
        CONST z=b;
        ==> TYPE x=(a,b,c,z); !!!!!!!!!!!!!!!!!!!!!!!
        Ich fhre ein globales Flag ein. Es kommt ja immer in der
        Reihenfolge Enum, Const, ..., Type
        Enum setzt das Flag, Type lscht es
      *)
     IF enumFlag & (class=Const) & (typ^.form=Enum) THEN
      IF typ^.LastConst=NIL THEN typ^.ConstLink:=newobj;
      ELSE typ^.LastConst^.conval.prev:=newobj;
      END;
      typ^.LastConst:=newobj;
      addObj:=FALSE;
     END;
     IF addObj THEN
      modules[0]^.last^.next:=newobj;
      modules[0]^.last:=newobj;
     END;
     IF (class=Typ) & (typ^.strobj=NIL) THEN typ^.strobj:=newobj END;
    END;
   | CMP:
    DEC(block,16*CMP);
    IF block>field THEN err:=TRUE; EXIT END;
    IF block=field THEN
       (*
        * The field is inserted into the temporary field list, so that it can
        * be added to the record structure which follows all the fields
        * which belongs to it.
        *)
     ALLOCATE(newobj,SIZE(Object));
     WITH newobj^ DO
      class:=Field; next:=NIL;
      InNumber(s); typ:=structures[s]; SysTest(s);
      InNumber(dummy(*offset*)); name:=InId();
     END;
     tempFieldList^.last^.next:=newobj; tempFieldList^.last:=newobj
    ELSE (* par or parref *)
       (*
        * The parameter is inserted into the temporary field list, so that it
        * can be added to the procedure object or structure which follows all
        * the parameters which belongs to it.
        *)
     ALLOCATE(newpar,SIZE(Parameter));
     WITH newpar^ DO
      next:=NIL; InNumber(s); typ:=structures[s]; SysTest(s);
      varpar:=block=parref; InNumber(parMode);
      name:=InId();
      lastTempPar^.next:=newpar; lastTempPar:=newpar;
     END
    END
   | STR:
    DEC(block,16*STR);
    IF block>bpointer THEN err:=TRUE; EXIT END;
    ALLOCATE(newstr,SIZE(Structure));
    WITH newstr^ DO
     strobj:=NIL; InNumber(dummy(*size*)); ref:=0;
     CASE block OF
     | enum: form:=Enum; InNumber(NofConst); ConstLink:=NIL; LastConst:=NIL;
	enumFlag:=TRUE;
     | range:
      form:=Range; InNumber(s); RBaseTyp:=structures[s]; SysTest(s);
      InNumber(min); InNumber(max); InBool(sign); (*BndAdr:=0;*)
     | bpointer,pointer:
      IF block=bpointer THEN form:=BPointer; ELSE form:=Pointer; END;
      PBaseTyp:=NIL; BaseId:=NIL
     | set: form:=Set; InNumber(s); SBaseTyp:=structures[s]; SysTest(s);
     | procTyp,funcTyp:
      form:=ProcTyp;
      IF block=funcTyp THEN
       InNumber(s); resTyp:=structures[s]; SysTest(s);
      ELSE
       resTyp:=notyp
      END;
         (*
          * Add chain of just read parameters to this procedure and clear
          * the list.
          *)
      firstPar:=tempParamList^.next;
      tempParamList^.next:=NIL; lastTempPar:=tempParamList
     | array:
      form:=Array; InNumber(s);
      ElemTyp:=structures[s]; dyn:=FALSE; SysTest(s);
      InNumber(s); IndexTyp:=structures[s]; SysTest(s);
     | dynarr:
      form:=Array; InNumber(s); SysTest(s);
      ElemTyp:=structures[s]; dyn:=TRUE;
      IndexTyp:=NIL
     | record:
      form:=Record;
         (*
          * Add chain of just read fields to this record and clear
          * the list.
          *)
      firstFld:=tempFieldList^.next;
      tempFieldList^.next:=NIL; tempFieldList^.last:=tempFieldList;
     | opaque: form:=Opaque;
     END;
    END;
    IF currStr>maxS THEN err:=TRUE; EXIT END;
    structures[currStr]:=newstr;
    INC(currStr);
   | CTL:
    DEC(block,16*CTL);
    IF block=linkage THEN
     InNumber(s); InNumber(p); SysTest(s); SysTest(p);
     IF structures[p]^.PBaseTyp=NIL THEN
      structures[p]^.PBaseTyp:=structures[s];
     END
    ELSIF block=ModTag THEN (* main module *)
     InNumber(m); (* dummy ? *)
    ELSIF block=anchor THEN
     ALLOCATE(newobj,SIZE(Object));
     WITH newobj^ DO
      class:=Module; typ:=NIL; next:=NIL; last:=newobj;
      ALLOCATE(key,SIZE(Key));
      FOR i:=0 TO 2 DO InW(key^.modKeys[i]); END;
      firstObj:=NIL;
      name:=InId();
      InNumber(mode);
      IF mode=library THEN key^.id:=InId(); END;
     END;
     IF currMod>maxM THEN EXIT END;
     modules[currMod]:=newobj;
     INC(currMod);
    ELSIF block=RefTag THEN
     InNumber(dummy(*adr*)); InNumber(dummy(*pno*)); EXIT
    ELSE
     err:=TRUE; EXIT
    END
   ELSE (*line block*)
    err:=TRUE; EXIT;
   END
  END; (* LOOP *)
  IF err THEN
    Error(refFileWrong,rcActionErr);
  ELSE
    OutUnit;
  END;
  ResetHeap(cleanup);
END InRef;

VAR
 i:INTEGER;
BEGIN
 SETREG(11,ADR(verDollar));
(* BEGIN M2DM/M2TM *)
 heap:=NIL;
 undftyp:=NewStr(Undef);
 notyp:=NewStr(Undef);
 uinttyp:=NewStr(UInt);
 urealtyp:=NewStr(UReal);
 stringtyp:=NewStr(String);
 BBtyp:=NewStr(Range); (*Bitset Basetyp*)
 LBtyp:=NewStr(Range); (*LBitset Basetyp*)
 SBtyp:=NewStr(Range); (*Shortset basetype *)
 EnterNumTyp(numtyp[byte,FALSE],"SHORTCARD",FALSE,minSCard,maxSCard);
 EnterNumTyp(numtyp[byte,TRUE], "SHORTINT",TRUE, minSInt, maxSInt);
 EnterNumTyp(numtyp[word,FALSE],"CARDINAL",FALSE,minCard, maxCard);
 EnterNumTyp(numtyp[word,TRUE], "INTEGER", TRUE, minInt,  maxInt);
 EnterNumTyp(numtyp[long,FALSE],"LONGCARD",FALSE,minLCard,CAST(LONGINT,maxLCard));
 EnterNumTyp(numtyp[long,TRUE], "LONGINT", TRUE, minLInt, maxLInt);
 EnterTyp(unknowntyp,"<unknown>",Undef);
 EnterTyp(booltyp, "BOOLEAN", Bool);
 EnterTyp(chartyp, "CHAR",    Char);
 EnterTyp(realtyp, "REAL",    Real);
 EnterTyp(proctyp, "PROC",    ProcTyp);
 EnterTyp(lrealtyp,"LONGREAL",LReal);
 EnterNumTyp(SBtyp,  "ShortsetBase", FALSE,0,     7);
 EnterNumTyp(BBtyp,  "BitsetBase", FALSE,0,       15);
 EnterNumTyp(LBtyp,  "LongsetBAse",FALSE,0,       31);
 EnterNumTyp(addrtyp,"SYSTEM.ADDRESS", TRUE, minLInt, maxLInt);
 EnterNumTyp(bptrtyp,"SYSTEM.BPTR",    TRUE, minLInt, maxLInt);
 EnterTyp(ssettyp, "SYSTEM.SHORTSET",Set); ssettyp^.SBaseTyp:=SBtyp;
 EnterTyp(bsettyp, "SYSTEM.BITSET",  Set); bsettyp^.SBaseTyp:=BBtyp;
 EnterTyp(lsettyp, "SYSTEM.LONGSET", Set); lsettyp^.SBaseTyp:=LBtyp;
 EnterTyp(bytetyp, "SYSTEM.BYTE",    Undef);
 EnterTyp(wordtyp, "SYSTEM.WORD",    Undef);
 EnterTyp(ffptyp,  "SYSTEM.FFP",     FFP);
(*
END DM;
*)
 undftyp^.ref:=1; booltyp^.ref:=2; chartyp^.ref:=3; numtyp[word,TRUE]^.ref:=4;
 numtyp[word,FALSE]^.ref:=5; numtyp[long,TRUE]^.ref:=6; realtyp^.ref:=7;
 lrealtyp^.ref:=8; bsettyp^.ref:=9; proctyp^.ref:=10; stringtyp^.ref:=11;
 addrtyp^.ref:=12; bytetyp^.ref:=13; wordtyp^.ref:=14;
 numtyp[long,FALSE]^.ref:=15; uinttyp^.ref:=16; urealtyp^.ref:=17;
 ffptyp^.ref:=18; lsettyp^.ref:=19; numtyp[byte,FALSE]^.ref:=20;
 numtyp[byte,TRUE]^.ref:=21; bptrtyp^.ref:=22; ssettyp^.ref:=23;
 FOR i:=0 TO maxS DO structures[i]:=unknowntyp; END;
 structures[1]:=undftyp; structures[2]:=booltyp; structures[3]:=chartyp;
 structures[4]:=numtyp[word,TRUE]; structures[5]:=numtyp[word,FALSE];
 structures[6]:=numtyp[long,TRUE]; structures[7]:=realtyp; structures[8]:=lrealtyp;
 structures[9]:=bsettyp; structures[10]:=proctyp; structures[11]:=stringtyp;
 structures[12]:=addrtyp; structures[13]:=bytetyp; structures[14]:=wordtyp;
 structures[15]:=numtyp[long,FALSE]; structures[16]:=uinttyp; structures[17]:=urealtyp;
 structures[18]:=ffptyp; structures[19]:=lsettyp; structures[20]:=numtyp[byte,FALSE];
 structures[21]:=numtyp[byte,TRUE]; structures[22]:=bptrtyp;
 structures[23]:=ssettyp;
 Do(InRef,titleString,usage,symFile,ADR("decsym> "),ADR("ENV:m2decsym"),ADR("m2decsym.opt"));
END m2decsym.
