MODULE errPack;
(* 2.0 / 22.4.87 / ms *)
(* 3.1 / 21.9.87/cn *)
(*$ LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE *)
FROM SYSTEM IMPORT
 ADR;
FROM Arguments IMPORT
 GetArg, NumArgs;
FROM Arts IMPORT
 Assert;
FROM FileSystem IMPORT
 File, Response,
 Close, Lookup, ReadChar, WriteChar;
FROM Terminal IMPORT
 WriteLn, WriteString;

CONST
 nul = 0C;
 lf = 12C;
 maxErrorMsg = 256;
 version = "errPack, [4.4], 2000-10-21\n";
 usage = "Usage: errPack [fromfile][tofile]\n";
 noop = ": cannot open\n";

TYPE
 ErrorMsg = ARRAY [0..maxErrorMsg-1] OF CHAR;
 Error = RECORD
  no: INTEGER;
  len: INTEGER;
  msg: ErrorMsg
 END;

VAR
 ch: CHAR; (* current input character *)
 in, out: File;
 err: Error;

PROCEDURE OutWord(VAR f:File; i:INTEGER);
VAR
 p:POINTER TO CHAR;
BEGIN
 p:=ADR(i);
 WriteChar(f,p^); INC(p); WriteChar(f,p^);
END OutWord;

PROCEDURE OutLong(VAR f:File; l:LONGINT);
VAR
 p:POINTER TO INTEGER;
BEGIN
 p:=ADR(l);
 OutWord(f,p^); INC(p,2); OutWord(f,p^);
END OutLong;

PROCEDURE ReadErrNo(VAR f: File; VAR no: INTEGER);
VAR
 number: BOOLEAN;
BEGIN
 no:=0;
 REPEAT
  ReadChar(f, ch);
  number:=("0"<=ch) & (ch<="9")
 UNTIL number OR (ch#' ') OR f.eof;
 IF number THEN
  REPEAT
   no:=10*no;
   no:=no+ORD(ch)-ORD("0");
   ReadChar(f, ch);
   number:=("0"<=ch) & (ch<="9")
  UNTIL ~number
 ELSE
  WHILE (ch#lf) & ~f.eof DO
   ReadChar(f, ch)
  END
 END
END ReadErrNo;

PROCEDURE ReadErrMsg(VAR f: File; VAR err: ErrorMsg; VAR len: INTEGER);
BEGIN
 len:=0;
 ReadChar(f, ch); (* skip blank after colon *)
 REPEAT
  ReadChar(f, ch);
  IF ch=lf THEN
   err[len]:=nul
  ELSE
   err[len]:=ch
  END;
  INC(len);
 UNTIL f.eof OR (ch=lf) OR (len=maxErrorMsg);
 IF len=maxErrorMsg THEN
  REPEAT
   ReadChar(f, ch);
  UNTIL f.eof OR (ch#lf)
 END
END ReadErrMsg;

PROCEDURE ReadError(VAR f: File; VAR err: Error): BOOLEAN;
BEGIN
 WITH err DO
  REPEAT
   ReadErrNo(f, no)
  UNTIL (no#0) OR f.eof;
  IF f.eof THEN
   RETURN FALSE
  ELSE
   ReadErrMsg(f, msg, len)
  END
 END;
 RETURN TRUE
END ReadError;

VAR
 pos: LONGINT;

PROCEDURE WriteError(VAR f: File; err: Error): BOOLEAN;
VAR
 i:INTEGER;
BEGIN
 WITH err DO
  IF ODD(len) THEN
   INC(len); msg[len]:=nul
  END;
  pos:=pos+LONGINT(len+6);
  OutLong(f, pos);
  OutWord(f, no);
  FOR i:=0 TO len-1 DO
   WriteChar(f, msg[i]);
  END;
  RETURN TRUE
 END
END WriteError;

VAR
 name: ARRAY [0..31] OF CHAR;
 len: INTEGER;
BEGIN
 GetArg(1, name, len);
 IF (len=0) OR (name[0]="?") OR (NumArgs()#2) THEN
  WriteString(version);
  WriteString(usage);
 ELSE
  Lookup(in, name, 4096, FALSE);
  IF in.res=done THEN
   GetArg(2, name, len);
   Lookup(out, name, 4096, TRUE);
   IF out.res=done THEN
    pos:=0;
    WHILE ReadError(in, err) & WriteError(out, err) DO END;
    OutLong(out, 0); OutLong(out, 0);
    Close(out)
   ELSE
    WriteString(name); WriteString(noop);
   END;
   Close(in)
  ELSE
   WriteString(name); WriteString(noop);
  END
 END
END errPack.
