IMPLEMENTATION MODULE WbClone;

(*$ LargeVars	:=FALSE
    StackParms	:=FALSE
    Volatile	:=FALSE
    NilChk	:=FALSE
 *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,CAST,LONGSET,TAG;
FROM GraphicsL	IMPORT	GetVPModeID;
FROM UtilityD	IMPORT	tagEnd;
FROM ExecL	IMPORT	Forbid,Permit,GetMsg,ReplyMsg;
IMPORT	R,
	A:Arts,
	GD:GraphicsD,
	ID:IntuitionD,
	IL:IntuitionL;

(* ============== aus WbClone.def: ==================
VAR	bdScreen: ScreenPtr;
	bdWindow: WindowPtr;
	bdRp    : RastPortPtr;
======================================================*)



PROCEDURE CloseWbClone;
VAR
  im{R.A3}:ID.IntuiMessagePtr;
BEGIN
  IF bdWindow<>NIL THEN
    IL.ClearMenuStrip(bdWindow);
    WITH bdWindow^ DO
      IF userPort#NIL THEN
        Forbid; (* KEINE neuen Messages, bitte! *)
        LOOP
          im:=GetMsg(userPort);
          IF im=NIL THEN EXIT END;
          ReplyMsg(im);
        END;
        IL.ModifyIDCMP(bdWindow,ID.IDCMPFlagSet{});
        Permit;
      END;
    END;
    IL.CloseWindow(bdWindow);
    bdWindow:=NIL;
  END;
  IF bdScreen<>NIL THEN
    IL.CloseScreen(bdScreen);
    bdScreen:=NIL;
  END;
  bdRp:=NIL;
END CloseWbClone;


PROCEDURE OpenWbClone(
	scrDepth:Depth;		(* Tiefe des Screens *)
	scrTitle:ADDRESS	(* oder NIL *)
	);
TYPE
  LC=LONGCARD;
  LS=LONGSET;
VAR
  s{R.A3}:ID.ScreenPtr;
  wbKey{R.D7}:LONGCARD;
  (* immer nur 1 zur Zeit bentigt, also Stackbedarf minimieren! *)
  mixRec:RECORD
    CASE : INTEGER OF
    | 0: nw:ID.NewWindow;
    | 1: ns:ID.NewScreen;
    | 2: tagBuffer:ARRAY [1..9] OF LONGINT;
    END;
  END;
  min1:CARDINAL;
BEGIN

  CloseWbClone;

  IF IL.intuitionVersion>=36 THEN (* Kick 2.0 *)

    (* key des Default Pub Screen holen *)
    s:=IL.LockPubScreen(NIL);
    IF s#NIL THEN
      wbKey:=GetVPModeID(ADR(s^.viewPort));
      IL.UnlockPubScreen(NIL,s);
    ELSE (* Workbench-Screen nicht geffnet *)
      wbKey:=GD.hiresKey (* wenigstens etwas! *)
    END;

    (* scrDepth anpassen: *)
    IF CAST(LC,CAST(LS,wbKey)*CAST(LS,GD.monitorIDmask))
       >=GD.vgaMonitorID THEN
      IF scrDepth>2 THEN
        scrDepth:=2
      END;
    END;

    (* Trick17 fr 3D-Look: *)
    min1:=0FFFFH; (* Kennung: Ende der Colorliste *)

    (* Screen ffnen: *)
    bdScreen:=IL.OpenScreenTagList(NIL,TAG(mixRec.tagBuffer,
	ID.saDepth,	scrDepth,
	ID.saDisplayID,	wbKey,
	ID.saPens,	ADR(min1), (* ergibt "new look"!!! *)
	ID.saTitle,	scrTitle,
	tagEnd));
  ELSE (* Popel-Rechner! V33,V34 *)

    wbKey:=IL.LockIBase(0);
    s:=IL.intuitionBase^.firstScreen;
    (* suche Workbench: (OpenWorkbench hat zu viele Nebeneffekte!) *)
    WHILE (s#NIL)
          &(s^.flags*ID.customScreen#ID.ScreenFlagSet{ID.wbenchScreen}) DO
      s:=s^.nextScreen;
    END;
    IF s#NIL THEN (* gefunden *)
      mixRec.ns.width:=s^.width;
      mixRec.ns.height:=s^.height;
    ELSE (* 640*normale hhe, kein Interlace *)
      mixRec.ns.width:=640;
      mixRec.ns.height:=ID.stdScreenHeight;
    END;
    IL.UnlockIBase(wbKey);

    WITH mixRec.ns DO
      leftEdge:=0;
      topEdge:=0;
      depth:=scrDepth;
      detailPen:=0;
      blockPen:=1;
      viewModes:=GD.ViewModeSet{GD.hires};
      IF height>300 THEN
        INCL(viewModes,GD.lace)
      END;
      type:=ID.customScreen;
      font:=NIL;
      defaultTitle:=scrTitle;
      gadgets:=NIL;
      customBitMap:=NIL;
    END;
    bdScreen:=IL.OpenScreen(mixRec.ns);
  END;

  IF bdScreen=NIL THEN
    A.Error(A.programName,ADR("Kann Screen nicht ffnen"));
  END;


  (* Window ffnen: *)
  WITH mixRec.nw DO
    leftEdge:=0;
    IF scrTitle=NIL THEN
      topEdge:=0;
      IL.ShowTitle(bdScreen,FALSE);
    ELSE
      topEdge:=bdScreen^.barHeight+bdScreen^.barVBorder;
    END;
    height:=bdScreen^.height-topEdge;
    width:=bdScreen^.width;
    detailPen:=0;
    blockPen:=1;
    idcmpFlags:=ID.IDCMPFlagSet{}; (* erstmal nix *)
    flags:=ID.WindowFlagSet{ID.backDrop, ID.borderless, ID.activate};
    (* =smartRefresh.
     * Geht nur ohne userPort, weil sizing nicht mglich!
     *)
    title:=NIL;
    type:=ID.customScreen;
    firstGadget:=NIL;
    checkMark:=NIL;
    screen:=bdScreen;
    bitMap:=NIL;
    (* das kann entfallen! sizing nicht mglich:
     * minWidth:=width;
     * minHeight:=height;
     * maxWidth:=width;
     * maxHeight:=height;
     *)
  END; (*WITH*)
  bdWindow:=IL.OpenWindow(mixRec.nw);
  IF bdWindow=NIL THEN
    A.Error(A.programName,ADR("Kann Fenster nicht ffnen"));
  END;

  (* RastPort setzen: *)
  bdRp:=bdWindow^.rPort;

END OpenWbClone;

BEGIN (* module *)
  (*
  bdScreen:=NIL;
  bdWindow:=NIL;
  bdRp:=NIL;
  *)
CLOSE
  CloseWbClone;
END WbClone.mod
