IMPLEMENTATION MODULE String;
(*$ LargeVars:=FALSE StackChk:=FALSE Volatile:=FALSE *)

FROM SYSTEM IMPORT ASSEMBLE;

(*
; register declarations for 2 string arg procedures

; destHigh	EQUR	D1
; destAdr	EQUR	A1
; srcHigh	EQUR	D0
; srcAdr	EQUR	A0
; index		EQUR	D2
; min		EQUR	D1
; returnAddress	EQUR	A2
; returnVal	EQUR	D0
*)

(*$ EntryExitCode:=FALSE *)
PROCEDURE Length(str: ARRAY OF CHAR): INTEGER;
BEGIN
  ASSEMBLE(
	MOVE.L	(A7)+,A0
	MOVE.L	(A7)+,A1
	MOVE.L	(A7)+,D0 (* A0=ret A1=Str D0=HIGH=len-1 *)
	MOVE.L  D0,D1
    Lp:	TST.B   (A1)+
	DBEQ    D1,Lp
	SUB.W	D1,D0	(* Oberes Wort sicher 0, wenn HIGH <65536 ! *)
	JMP     (A0)
	END);
END Length;

(*$ EntryExitCode:=FALSE *)
PROCEDURE LLength(str: ARRAY OF CHAR):LONGINT;
BEGIN
  ASSEMBLE(
	MOVE.L	(A7)+,A0
	MOVE.L	(A7)+,A1
	MOVE.L	(A7)+,D0 (* A0=ret A1=Str D0=HIGH=len-1 *)
	MOVE.L  D0,D1
   lp:	TST.B   (A1)+
	BEQ.S	rdy
	SUBQ.L	#1,D1
	BGE.S	lp
   rdy:	SUB.L	D1,D0
	JMP     (A0)
	END);
END LLength;

(*$ CopyDyn:=FALSE *)
PROCEDURE CanCopy(VAR dest: ARRAY OF CHAR; src:ARRAY OF CHAR):BOOLEAN;
BEGIN
  RETURN Length(src)<=HIGH(dest);
END CanCopy;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Copy(VAR dest: ARRAY OF CHAR; src: ARRAY OF CHAR);
BEGIN ASSEMBLE(
		MOVE.L	(A7),-(A7)	(* ; move return address down *)
		CLR.L	4(A7)		(* ; clear index to 0 *)
		BRA	CopyPos
		END);
END Copy;

(*$ CopyDyn:=FALSE *)
PROCEDURE CanCopyPos(VAR dest:ARRAY OF CHAR; src:ARRAY OF CHAR;
		  destPos:LONGCARD):BOOLEAN;
BEGIN
  RETURN Length(src)+INTEGER(destPos) <= HIGH(dest)
END CanCopyPos;

(*$ EntryExitCode:=FALSE *)
PROCEDURE CopyPos(VAR dest: ARRAY OF CHAR;
		  src: ARRAY OF CHAR; destPos: LONGCARD);
BEGIN ASSEMBLE(
	MOVEM.L	D2/A2,-(A7)
	LEA	4+8(A7),A2
	MOVE.L	(A2)+,D2	(* D2=destPos *)
	MOVE.L	(A2)+,A0	(* A0=ADR(src) *)
	MOVE.L	(A2)+,D0	(* D0=HIGH(src) *)
	MOVE.L	(A2)+,A1	(* A1=ADR(dest *)
	MOVE.L	(A2)+,D1	(* D1=HIGH(dest) *)
	SUBQ.L	#1,D1	(* Anpassen fr letzten frei! *)
	ADDA.L	D2,A1		(* A1=StartPos dest *)
	SUB.L	D2,D1		(* D1=HIGH(dest)-destPos *)
	BMI.S	CopyEnd		(* geht nicht! *)
(* ADR(dest) und HIGH(dest) nun angepat, destPos unwichtig,
 * normales Copy
 *)
	CMP.L	D1,D0		(* D0:=MIN( HIGH(dest), HIGH(src) ) *)
	BLE.S	ok
	MOVE.L	D1,D0
    ok:
    lp:	MOVE.B	(A0)+,(A1)+
    	DBEQ	D0,lp
	CLR.B	(A1)		(* und noch 0C ans Ende! *)
CopyEnd:
	MOVEM.L	(A7)+,D2/A2
(*$ IF m68010 *)
	RTD	#20
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	LEA	20(A7),A7
	JMP	(A0)
(*$ ENDIF *)
	END);
END CopyPos;

(*$ CopyDyn:=FALSE *)
PROCEDURE CanConcat(VAR dest: ARRAY OF CHAR; src:ARRAY OF CHAR):BOOLEAN;
BEGIN
  RETURN Length(src)+Length(dest) <= HIGH(dest)
END CanConcat;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Concat(VAR dest: ARRAY OF CHAR; src: ARRAY OF CHAR);
BEGIN ASSEMBLE(
		MOVE.L	16(A7),-(A7)	(* ; push dest string descriptor *)
		MOVE.L	16(A7),-(A7)
		BSR	Length
		MOVE.L	(A7),-(A7)	(* ; "pop" & "push" return address *)
		MOVE.L	D0,4(A7)	(* ; "push" Length(dest) *)
		BRA	CopyPos
		END);
END Concat;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Compare(s1,s2: ARRAY OF CHAR): LONGINT;
(*
; h1		EQUR	D1
; s1		EQUR	A1
; h2		EQUR	D2
; s2		EQUR	A0
; retAddress	EQUR	A2
; i		EQUR	D0
; ch		EQUR	D3
*)
BEGIN ASSEMBLE(
		MOVEM.L	D2/D3/A2,-(A7)
		LEA	4+12(A7),A2
		MOVE.L	(A2)+,A0
		MOVE.L	(A2)+,D2
		MOVE.L	(A2)+,A1
		MOVE.L	(A2)+,D1

		MOVEQ	#0,D0
CompareLoop:
		CMP.L	D1,D0
		BLE.S	NotEndOfS1
		CMP.L	D2,D0
		BLE.S	NotEndOfS2
ret0:		MOVEQ	#0,D0
		BRA.S	raus
NotEndOfS2:	TST.B	0(A0,D0.L)
		BEQ.S	ret0
retMinI:	ADDQ.L	#1,D0
		NEG.L	D0
		BRA.S	raus
NotEndOfS1:	CMP.L	D2,D0
		BLE.S	NotEndOfAny
		TST.B	0(A1,D0.L)
		BEQ.S	ret0
retI:		ADDQ.L	#1,D0
		BRA.S	raus
NotEndOfAny:	MOVE.B	0(A1,D0.L),D3
		CMP.B	0(A0,D0.L),D3
		BLT.S	retMinI
		BGT.S	retI
                TST.B	D3
                BEQ.S	ret0
		ADDQ.L	#1,D0
		BRA.S	CompareLoop
raus:		MOVEM.L	(A7)+,D2/D3/A2
(*$ IF m68010 *)
		RTD	#16
(*$ ELSE *)
		MOVE.L	(A7)+,A0
		LEA	16(A7),A7
		JMP	(A0)
(*$ ENDIF *)
		END);
END Compare;

(*$ EntryExitCode:=FALSE *)
PROCEDURE FirstPos(st: ARRAY OF CHAR; from{2}: LONGCARD; ch{3}: CHAR): LONGINT;
BEGIN ASSEMBLE(
		MOVE.L	(A7)+,A0	(* Ret-Adr *)
		MOVE.L	(A7)+,A1	(* String Address *)
		MOVE.L	(A7)+,D1	(* String High *)
		CMP.L	D1,D2		(* Assert ( from <= HIGH ) *)
		BGT.S	FirstPos2
		MOVE.L	A1,D0
		ADD.L	D2,A1		(* Adjust s1 to s1[from] *)
		SUB.L	D2,D1		(* Adjust length *)
FirstPos0:	TST.B	(A1)		(* End of string *)
		BEQ.S	FirstPos2
		CMP.B	(A1)+,D3	(* Check for ch ? *)
		DBEQ	D1,FirstPos0	(* UNTIL high or equal *)
		BEQ.S	FirstPos1
FirstPos2:	MOVEQ	#-1,D0
		BRA.S	raus
FirstPos1:	SUB.L	D0,A1
		SUBQ.L	#1,A1
		MOVE.L	A1,D0
raus:		JMP	(A0)
		END);
END FirstPos;

(*$ EntryExitCode:=FALSE *)
PROCEDURE LastPos(st: ARRAY OF CHAR; to{2}: LONGCARD; ch{3}: CHAR): LONGINT;
BEGIN ASSEMBLE(
		MOVE.L	(A7)+,A0	(* retAdr *)
		MOVE.L	(A7)+,A1	(* String Address *)
		MOVE.L	(A7)+,D1	(* String High *)
		MOVE.L	D4,-(A7)
		MOVE.L	A1,D4
		MOVEQ	#-1,D0
		CMP.L	D1,D2		(* Assert ( to <= HIGH ) *)
		BGT.S	LastPos0
		MOVE.L	D2,D1		(* HIGH:=to *)
LastPos0:	TST.B	(A1)		(* End of string *)
		BEQ.S	LastPos3
		CMP.B	(A1)+,D3	(* Check for ch ? *)
		BNE.S	LastPos2
		MOVE.L	A1,D0
		SUB.L	D4,D0
		SUBQ.L	#1,D0		(* jeweils hchsten merken *)
LastPos2:	DBRA	D1,LastPos0	(* UNTIL high or equal *)
LastPos3:	MOVE.L	(A7)+,D4
		JMP	(A0)
		END);
END LastPos;


(*$ EntryExitCode:=FALSE *)
PROCEDURE CapString(VAR st: ARRAY OF CHAR);
BEGIN ASSEMBLE(
	MOVE.L	(A7)+,A1
	MOVE.L	(A7)+,A0
	MOVE.L	(A7)+,D1
CapStringLoop:
	CMPI.B	#'a',(A0)
	BLT.S	CapStringNext
	CMPI.B	#'z',(A0)
	BGT.S	CapStringNext
	SUBI.B	#{'a'-'A'},(A0)
CapStringNext:
	TST.B	(A0)+
	DBEQ	D1,CapStringLoop
	JMP	(A1)
  END);
END CapString;

(*$ EntryExitCode:=FALSE *)
PROCEDURE ANSICap(ch{0}:CHAR):CHAR;
BEGIN
  ASSEMBLE(
	CMPI.B	#'a',D0
	BCS.S	CapOk
	CMPI.B	#'z',D0
	BLS.S	CapLetter
	CMPI.B	#$E0,D0		(* nun Umlaute etc. C0..DE, E0..FE *)
	BCS.S	CapOk
	CMPI.B	#$FE,D0
	BHI.S	CapOk
CapLetter:
	ANDI.B	#$0DF,D0	(* Grobuchstabe *)
CapOk:
	RTS
  END);
END ANSICap;

(*$ EntryExitCode:=FALSE *)
PROCEDURE ANSICapString(VAR str: ARRAY OF CHAR);
BEGIN ASSEMBLE(
	MOVE.L	(A7)+,A1
	MOVE.L	(A7)+,A0
	MOVE.L	(A7)+,D1
CapStringLoop:
	MOVE.B	(A0),D0
	BSR.S	ANSICap
	MOVE.B	D0,(A0)+
	DBEQ	D1,CapStringLoop
	JMP	(A1)
  END);
END ANSICapString;


(*$ EntryExitCode:=FALSE *)
PROCEDURE CapD1;
BEGIN (* interne Proc, D1:=CAP(D1) *)
  ASSEMBLE(
	CMPI.B	#'a',D1
	BCS.S	CapOk
	CMPI.B	#'z',D1
	BHI.S	CapOk
	ANDI.B	#$DF,D1
  CapOk:
  	RTS
  END);
END CapD1;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Occurs(VAR str: ARRAY OF CHAR; from: INTEGER;
                 token: ARRAY OF CHAR; caseSens:BOOLEAN): INTEGER;
CONST SRegs=9;
      Off=SRegs*4-4;
BEGIN
  ASSEMBLE(
	MOVEM.L	D2-D7/A2/A3/A6,-(A7)
	MOVE.L	str+4+Off(A7),D3	(* HIGH(str) *)
	MOVE.L	str+Off(A7),A3	(* str *)
	MOVE.L	token+Off(A7),A6	(* token *)
	MOVE.B	caseSens+Off(A7),D7	(* caseSens 0=FALSE *)
	MOVE.W	from+Off(A7),D6	(* from *)
	EXT.L	D6

(* if token[0]=0C then return from end *)
	MOVE.L	D6,D0
	TST.B	(A6)
	BEQ	OccursOk

	MOVE.L  token+4+Off(A7),D4
	CMPI.L	#$00007FFE,D4
	BLS.S	OccLenOk
	TRAP	#14
OccLenOk:
	MOVE.L	D4,D0
	MOVE.L  A6,A0
OccLen1:
	TST.B	(A0)+
	DBEQ	D0,OccLen1
	SUB.W	D0,D4		(* length(token) *)

(* if (from>HIGHstr) OR ((len-1)>HIGHstr) OR (from<0) then return last end *)
	CMP.L	D3,D6
	BGT.S   OccursLast
	MOVE.L	D4,D1
	SUBQ.L  #1,D1 (* len-1 *)
	CMP.L   D3,D1
	BGT.S   OccursLast
	TST.W   D6
	BLT.S	OccursLast

(* for pos:=0 to from do if str[pos]=0C then return last end end *)
	MOVE.W	D6,D2 (* = Anzahl-1 *)
OccursLp1:
	TST.B	(A3)+
	DBEQ	D2,OccursLp1
	BEQ.S	OccursLast
	SUBQ.L	#1,A3	(* wieder auf pos stellen *)

(* if caseSens then ch:=token[0] else ch:=cap(token[0]) end *)
	MOVE.B	(A6)+,D1 (* token[0] *)
	TST.B	D7
	BNE.S	OccursCase1
	BSR.S	CapD1
OccursCase1:
	MOVE.B	D1,D5	(* ch:=.. *)

(* for pos:=from to highstr-len+1 do *)
	SUB.L	D4,D3	(* highstr-len ; pos==from==D6 *)
	ADDQ.L	#1,D3	(* +1 = endfor *)
OccursFor:
	CMP.L   D3,D6
	BGT.S   OccursLast
(* if str[pos]=0c then return last end *)
	TST.B	(A3)
	BEQ.S	OccursLast	(* D0 ist -1 *)
(*   if str[pos]=ch then *)
(*    if casesens then *)
	TST.B	D7
	BEQ.S	OccursCase2
	CMP.B	(A3)+,D5
	BRA.S	OccursNo2
OccursCase2:
	MOVE.B	(A3)+,D1
	BSR	CapD1
	CMP.B	D5,D1
OccursNo2:
	BNE.S   OccursNext
	MOVEQ	#1,D0	(* occ:=1 *)
	MOVE.L	A6,A2	(* alte strpos und tokenpos behalten *)
	MOVE.L	A3,A1
(* loop *)
L000027:
(* if occ>=len then return pos end *)
	CMP.W   D4,D0
	BLT.S   L000028
	MOVE.L  D6,D0
	BRA.S   OccursOk	(* return pos *)
(* if str[pos+occ]#token[occ] then exit end *)
L000028:
	TST.B	D7
	BEQ.S	OccursCase3
	CMPM.B	(A2)+,(A1)+
	BRA.S	OccursNo3
OccursCase3:
	MOVE.B	(A2)+,D1
	BSR	CapD1
	MOVE.B	D1,D2
	MOVE.B	(A1)+,D1
	BSR	CapD1
	CMP.B	D2,D1
OccursNo3:
	BNE.S	OccursNext
	ADDQ.L  #1,D0
	BRA.S   L000027

OccursNext:
	ADDQ.L  #1,D6
	BVC.S   OccursFor

OccursLast:
	MOVEQ   #-1,D0

OccursOk:
	MOVEM.L	(A7)+,D2-D7/A2/A3/A6
	(*$ IF m68010 *)
	RTD	#20
	(*$ ELSE *)
	MOVEA.L (A7)+,A0
	LEA     20(A7),A7
	JMP     (A0)
	(*$ ENDIF *)
  END);
END Occurs;

(*$ CopyDyn:=FALSE  *)
PROCEDURE CanInsert(VAR str: ARRAY OF CHAR;
		 at:INTEGER; token:ARRAY OF CHAR):BOOLEAN;
VAR newlen:INTEGER;
BEGIN
  newlen:=Length(str);
  IF at<0 THEN at:=newlen END;
  IF at>newlen THEN newlen:=at END;
  RETURN Length(token)+newlen<=HIGH(str);
END CanInsert;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Insert(VAR str: ARRAY OF CHAR; at: INTEGER;
                 token: ARRAY OF CHAR);
CONST SRegs=7;
      Off=SRegs*4-4;
VAR
  strPtr{8+2}:LONGINT;
  strHigh{2}:LONGINT;
  strLen{6}:INTEGER;
  at7{7}:LONGINT;
  tokenPtr{8+3}:LONGINT;
  tokenLen{5}:INTEGER;
  lastpos{4}:INTEGER;

BEGIN
  ASSEMBLE(
(* 0.: at<0 then return *)
(* 1.: evtl bis at mit spaces auffllen *)
(* 1.5.: tokenlen bestimmen *)
(* 2.: evtl hinter at platz schaffen *)
(* 3.: token einfgen *)
(* 4.: letztes auf 0c setzen *)
	MOVEM.L	D2/D4-D7/A2/A3,-(A7)
	MOVE.L	str+Off(A7),strPtr
	MOVE.L	strPtr,A0
        MOVE.L	str+4+Off(A7),strHigh

	MOVE.W  strHigh,D1
	MOVE.W	strHigh,strLen
InsLen1:
	TST.B   (A0)+
	DBEQ    D1,InsLen1
	SUB.W	D1,strLen
(* A0 jetzt hinter 0 oder hinter ende str *)
	SUBQ.L	#1,A0

	MOVE.W	at+Off(A7),at7	(* at *)
(* if at=last then at:=strlength *)
	CMPI.W	#-1,at7
	BNE.S	Ins2
	MOVE.W	strLen,at7		(* at:=strlength, sicher >= 0 *)
        BRA.S	Ins3
(* elsif at<first then return *)
Ins2:	BLT	InsertOk	(* at<-1: return *)
(* elsif at>strlength then *)
	CMP.W	strLen,at7
	BLE.S	Ins3
(*  if at>highstr then at:=highstr+1 end *)
	CMP.W	strHigh,at7
	BLE.S	Ins2a
	MOVE.W	strHigh,at7
	ADDQ.W	#1,at7
Ins2a:
(*  for i:=strlength to at-1 do str[i]:=' ' end; *)
	MOVE.W	at7,D1
	SUB.W	strLen,D1
	BRA.S	Ins2c
Ins2b:	MOVE.B	#' ',(A0)+
Ins2c:	DBRA	D1,Ins2b
(*  if at<=highstr then str[at]:=0c end *)
	CMP.W	strHigh,at7
	BGT.S	Ins2d
	CLR.B	(A0)
Ins2d:
(* strlen:=at *)
	MOVE.W	at7,strLen
(* end elsifs *)
Ins3:
(* A0 steht nun auf 0c bzw. HIGH(str) *)
(* D5:=tokenlen *)
	MOVE.L	token+Off(A7),tokenPtr
	MOVE.L	tokenPtr,A1
	MOVE.L	token+4+Off(A7),tokenLen
	MOVE.W  tokenLen,D1
InsLen2:
	TST.B   (A1)+
	DBEQ    D1,InsLen2
	SUB.W	D1,tokenLen
(* A3 jetzt hinter 0 oder hinter ende str *)
(* if tokenlen>0 then (bis ende) *)
	BLE.S	InsertOk
(* lastpos:=strlen+tokenlen-1 *)
	MOVE.W	strLen,lastpos
	SUBQ.W	#1,lastpos
	ADD.W	tokenLen,lastpos
	TRAPV		(* na ja, wenigstens etwas Sicherheit *)
(* if lastpos>highstr then lp:=highstr end *)
	CMP.W	strHigh,lastpos
	BLE.S	Ins4
	MOVE.W	strHigh,lastpos
Ins4:
(* if at<strlen then macheplatz *)
	CMP.W	strLen,at7
	BGE.S	Ins5
	MOVE.L	strPtr,A0
	ADDA.W	lastpos,A0 (* + lastpos *)
	ADDQ.L	#1,A0 (* wg. MOVE -(),-() *)
	MOVE.L	A0,A1
	SUBA.W	tokenLen,A1 (* +lastpos-tokenlen *)
	MOVE.W	lastpos,D0
	SUB.W	at7,D0
	SUB.W	tokenLen,D0 (* D0:=lastpos-(at+tokenlen)  = Anz Verschieb-1 *)
Ins4a:	MOVE.B	-(A1),-(A0)
	DBRA	D0,Ins4a
Ins5:
(* if tokenlen>(maxstrlen-at) then tokenlen:=maxstrlen-at *)
	MOVE.W	strHigh,D0
	SUB.W	at7,D0
	ADDQ.W	#1,D0
	CMP.W	D0,tokenLen
	BLE.S	Ins5a
	MOVE.W	D0,tokenLen
(* (els)if lastpos<highstr then str[lastpos+1]:=0c end *)
Ins5a:
	CMP.W	strHigh,lastpos
	BGE.S	Ins6
	CLR.B	1(strPtr,lastpos.W)
Ins6:
(* for i:=0 to tokenlen-1 do str[i+at]:=token[i] end *)
	ADDA.W	at7,strPtr
	SUBQ.W	#1,tokenLen	(* tokenlen-1 *)
	BMI.S	InsertOk	(* 9.6.91/bp sonst Crash bei VOLLEM str! *)
Ins6a:	MOVE.B	(tokenPtr)+,(strPtr)+
	DBRA	tokenLen,Ins6a
InsertOk:
(* str[HIGH(str)]:=0C 30.10.90/bp *)
	MOVEA.L	str+Off(A7),A0
	ADDA.L	strHigh,A0 (* HIGH str *)
	CLR.B	(A0)

	MOVEM.L	(A7)+,D2/D4-D7/A2/A3
	(*$ IF m68010 *)
	RTD	#18
	(*$ ELSE *)
	MOVEA.L (A7)+,A0
	LEA     18(A7),A7
	JMP     (A0)
	(*$ ENDIF *)
  END);
END Insert;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Delete(VAR str: ARRAY OF CHAR; start, length: INTEGER);
CONST SRegs=5;
      Off=4*SRegs-4;
BEGIN
  ASSEMBLE(
(* length: 4(A7)D7   start: 6(A7)D6    ADRstr: 8(A7)A3   HIGHstr: 12(A7) *)
	MOVEM.L	D5-D7/A2/A3,-(A7)
	MOVE.W	length+Off(A7),D7
	MOVE.W	start+Off(A7),D6
	TST.W   D7
	BLE.S   DelOk
	TST.W   D6
	BLT.S	DelOk
(* gehe auf start, length ist >0 *)
	MOVE.L	str+Off(A7),A3
	MOVE.L	str+4+Off(A7),D5
	SUB.W	D6,D5		(* max. restlnge-1 *)
	BLT.S	DelOk		(* start mu <= HIGH(str) sein! *)
DelLp1:	TST.B	(A3)+
	DBEQ	D6,DelLp1
	BEQ.S	DelOk		(* str zu kurz *)
	CLR.B	-(A3)		(* 0 dranhngen (oder zwischen) *)
	CMP.W	D7,D5
	BLE.S	DelOk		(* nichts mehr zu verschieben, fertig *)
(* rest verschieben *)
	MOVE.L	A3,A2
	ADDA.W	D7,A2	(* +length *)
DelLp2:	MOVE.B	(A2)+,(A3)+
	DBEQ	D5,DelLp2
DelOk:
	MOVEM.L	(A7)+,D5-D7/A2/A3
	(*$ IF m68010 *)
	RTD	#12
	(*$ ELSE *)
	MOVEA.L (A7)+,A0
	LEA     12(A7),A7
	JMP     (A0)
	(*$ ENDIF *)
  END);
END Delete;


(*$ CopyDyn:=FALSE  *)
PROCEDURE CanCopyPart(VAR dest:ARRAY OF CHAR; src:ARRAY OF CHAR;
		start,length:INTEGER):BOOLEAN;
BEGIN
  IF length<0 THEN length:=0 END;
  start:=Length(src);
  IF start>length THEN start:=length END;
  (* start ist nun MIN(length,Length(src)) *)
  RETURN start<=HIGH(dest);
END CanCopyPart;

(*$ EntryExitCode:=FALSE *)
PROCEDURE CopyPart(VAR str: ARRAY OF CHAR; src: ARRAY OF CHAR;
               start, length: INTEGER);
CONST SRegs=5;
      Off=SRegs*4-4;
BEGIN
  ASSEMBLE(
(* length: 4(A7)D0   start: 6(A7)D1  ADRsource: 8(A7)A3  HIGHsource: 12(A7)D3 *)
(* ADRstr: 16(A7)A2  HIGHstr: 20(A7)D2 *)
	MOVEM.L	D2/D3/D5/A2/A3,-(A7)
	MOVE.L	str+Off(A7),A2
	MOVE.L	str+4+Off(A7),D2
(*	CLR.B	(A2)		(* erstmal str lschen *) NEIN!!! *)
	MOVE.L	src+4+Off(A7),D3(* highsource *)
	MOVE.W	start+Off(A7),D1(* start *)
	BMI.S	CopyEmpty	(* start<0 *)
	EXT.L	D1
	CMP.L	D3,D1
	BGT.S	CopyEmpty	(* start>highsource *)
	MOVE.W	length+Off(A7),D0
	BLE.S	CopyEmpty	(* length<=0 *)
(* gehe auf start source *)
	MOVE.L	src+Off(A7),A3
	MOVE.W	D1,D5
CopyLp1:
	TST.B	(A3)+
	DBEQ	D5,CopyLp1
	BEQ.S	CopyEmpty	(* start>length(source) *)
	SUBQ.L	#1,A3		(* A3 auf start *)
(* minimum (highstr,highsource-start,length-1) ermitteln *)
	SUBQ.W	#1,D0		(* dec(length) *)
	SUB.W	D1,D3
	CMP.W	D3,D0
	BLE.S	Copy2
	MOVE.W	D3,D0
Copy2:	CMP.W	D2,D0
	BLT.S	Copy3
	MOVE.W	D2,D0
	SUBQ.W #1,D0 (* max. HIGH-1+1 Zeichen kopieren! *)
	BMI.S	CopyEmpty
(* jetzt kopieren *)
Copy3:	MOVE.B	(A3)+,(A2)+
	DBEQ	D0,Copy3
(* evtl letzten auf 0C *)
	BEQ.S	CopyOk
CopyEmpty:
	CLR.B	(A2)
CopyOk:
	MOVEM.L	(A7)+,D2/D3/D5/A2/A3
	(*$ IF m68010 *)
	RTD	#20
	(*$ ELSE *)
	MOVEA.L (A7)+,A0
	LEA     20(A7),A7
	JMP     (A0)
	(*$ ENDIF *)
  END);
END CopyPart;

(*$ EntryExitCode:=FALSE *)
PROCEDURE ComparePart(VAR str: ARRAY OF CHAR; start, length: INTEGER;
                  token : ARRAY OF CHAR; caseSens: BOOLEAN): INTEGER;
CONST SRegs=8;
      Off=4*SRegs-4;
BEGIN
  ASSEMBLE(
(* caseSens: 4(A7)D7.h   ADRtoken: 6(A7)A3   HIGHtoken: 10(A7)D4
   length:14(A7)D6
   start: 16(A7)D7  ADRstr: 18(A7)A2   HIGHstr: 22(A7)D2
   a D5 in token   b D7.W in str   c D3 endeb  ch1:D1 ch2:D2 *)

	MOVEM.L	D2-D7/A2/A3,-(A7)
	CLR.L	D0
	MOVE.L	caseSens+Off(A7),D7	(* casesens in vorzeichen D7.L !! *)
	MOVE.W	start+Off(A7),D7
	BMI	CompOk		(* start<0 *)
	MOVE.W	length+Off(A7),D6
	BMI	CompOk
	CLR.L	D5
	MOVE.W	D7,D3
	ADD.W	D6,D3		(* c:=start+length *)
	TRAPV
(* length(str) *)
	MOVE.L	str+Off(A7),A2
	MOVE.L	A2,A1
	MOVE.L	str+4+Off(A7),D2
	CMPI.L	#$00007FFF,D2
	BLS.S	CompNTRAP
	TRAP	#14
CompNTRAP:
	MOVE.W	D2,D1
CompLp1:
	TST.B	(A1)+
	DBEQ	D1,CompLp1
	SUB.W	D1,D2		(* D2=length(str) *)
	CMP.W	D3,D2
	BGE.S	Comp2
	MOVE.W	D2,D3
Comp2:
(* str auf start stellen *)
	ADDA.W	D7,A2

	MOVE.L	token+Off(A7),A3
	MOVE.L	token+4+Off(A7),D4	(* high(token) *)
	CMPI.L	#$00007FFF,D4
	BLS.S	CompLoop
	TRAP	#14
CompLoop:
(* if b>=c then *)
	CMP.W	D3,D7
	BLT.S	CompElse
(* if a>high(token) or token[a]=0c or a>=length then return 0 *)
	CMP.W	D4,D5
	BGT.S	CompOk
	TST.B	(A3)
	BEQ.S	CompOk
	CMP.W	D6,D5	(* NEW V1.1!!! *)
	BGE.S	CompOk  (* NEW V1.1!!! *)
	BRA.S	CompRetA1	(* return a+1 *)
CompElse:
	CMP.W	D4,D5		(* if a>hightoken *)
	BGT.S	CompRetMA1	(* ret -(a+1) *)
CompEnd:
(* ch2:=token[a] *)
	TST.L	D7		(* casesens positiv=false, also CAP *)
	BPL.S	CompNoCase
	MOVE.B	(A3)+,D2
	MOVE.B	(A2)+,D1
	BRA.S	CompCaseEnd
CompNoCase:
	MOVE.B	(A3)+,D1
	BSR	CapD1
	MOVE.B	D1,D2
	MOVE.B	(A2)+,D1
	BSR	CapD1
CompCaseEnd:
(* if ch>ch2 then *)
	CMP.B	D2,D1
	BHI.S	CompRetMA1	(* return -(a+1)  (a,b werden erst spter geINCt) *)
(* elsif ch1<ch2 then *)
	BCS.S	CompRetA1	(* return -(a+1) *)
(* elsif ch1=0c then *)
	TST.B	D1
	BEQ.S	CompOk		(* return 0 *)
	ADDQ.W	#1,D5	(* inc(a) *)
	ADDQ.W	#1,D7	(* inc(b) *)
	BRA.S	CompLoop

CompRetMA1:
	ADDQ.W	#1,D5
	TRAPV
	NEG.W	D5
	BRA.S	CompRet

CompRetA1:
	ADDQ.W	#1,D5
	TRAPV
CompRet:
	EXT.L	D5
	MOVE.L	D5,D0
CompOk:
	MOVEM.L	(A7)+,D2-D7/A2/A3
	(*$ IF m68010 *)
	RTD	#22
	(*$ ELSE *)
	MOVEA.L (A7)+,A0
	LEA     22(A7),A7
	JMP     (A0)
	(*$ ENDIF *)
  END);
END ComparePart;

PROCEDURE CanConcatChar(VAR str:ARRAY OF CHAR; ch:CHAR):BOOLEAN;
BEGIN
  RETURN Length(str)<HIGH(str);
END CanConcatChar;

(*$ EntryExitCode:=FALSE *)
PROCEDURE ConcatChar(VAR str:ARRAY OF CHAR; ch:CHAR);
BEGIN
  ASSEMBLE(
	MOVE.L	(A7)+,A1 (* retadr *)
	MOVE.B	(A7)+,D1 (* ch *)
	MOVE.L	(A7)+,A0
	MOVE.L	(A7)+,D0
  lp:	TST.B	(A0)+
	DBEQ	D0,lp
	TST.W	D0 (* -1: String voll, 0: letzer=0C *)
	BLE.S	raus
	CLR.B	(A0)
	MOVE.B	D1,-(A0)
  raus:
	JMP	(A1)
  END);
END ConcatChar;

PROCEDURE DeleteChar(VAR str:ARRAY OF CHAR; pos:INTEGER);
BEGIN
  Delete(str,pos,1); (* todo! *)
END DeleteChar;

(* len, ch, ch, ... nach ch, ch, .., 0C *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE BStrToStr(VAR str:ARRAY OF CHAR);
BEGIN
  ASSEMBLE(
	MOVE.L	str-4(A7),A0
	MOVE.L	A0,A1
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0 (* len BString, mind. 0 *)
  lp:	MOVE.B	(A0)+,(A1)+ (* um 1 zurck kopieren *)
	DBRA	D0,lp
	CLR.B	-(A1)	(* letzten auf 0C *)
(*$ IF m68010 *)
	RTD	#8
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	ADDQ.L	#8,A7
	JMP	(A0)
(*$ ENDIF *)
  END);
END BStrToStr;

(*$ EntryExitCode:=FALSE *)
PROCEDURE StrToBStr(VAR str:ARRAY OF CHAR);
BEGIN
  ASSEMBLE(
	MOVE.L	str-4(A7),A0
	MOVE.L	str+4-4(A7),D0
	MOVE.L	D0,D1
  lp:	TST.B	(A0)+
	DBEQ	D0,lp
	SUB.W	D0,D1 (* D1=length *)
	MOVE.W	D1,D0 (* len merken *)
	LEA	-1(A0),A1
  lp2:	MOVE.B	-(A1),-(A0)
	DBRA	D1,lp2 (* kopiert 1 zuviel, macht nichts! *)
	MOVE.B	D0,(A0) (* Lnge am Anfang eintragen *)
(*$ IF m68010 *)
	RTD	#8
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	ADDQ.L	#8,A7
	JMP	(A0)
(*$ ENDIF *)
  END);
END StrToBStr;


(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(RTS END) (* open nix *)
CLOSE
  ASSEMBLE(RTS END) (* close nix *)
END String.
