IMPLEMENTATION MODULE Profiler;
(* new ver 26.9.90/bp *)
(* modified 8.12.90/cn *)
(*
 * back to the roots 26.1.91/bp
 *)

(*$ LargeVars:=TRUE *) (* verhindert aber reentrancy! *)
(*$ StackParms:=FALSE *) (* always! *)
(*$ Volatile:=FALSE NilChk:=FALSE EntryClear:=FALSE *)

(*$ RangeChk:=FALSE OverflowChk:=FALSE *)

(*
 * !!!!!!! Keine der Prozeduren darf Register verndern !!!!!!!
 * !!!!!!! Auch nicht D0,D1,A0,A1,FP0,FP1 !!!!!!!!
 * Bei JMP(A0) geht es voll in die Hose, deshalb alle ohne
 * EntryExit und in Assembler!!!!
 * Im Inneren sind es normale Prozeduren!!!
 * RETURN-Anweisungen in $E - Prozeduren gehen HINTER das Proc-Ende!!!
 * 1.396825 microsecs pro tick
 * write: erst low, dann high
 *)

(*$
  DEFINE Show:=FALSE
  DEFINE Test:=FALSE
  DEFINE English:=FALSE
  DEFINE CompGens:=TRUE
*)

FROM SYSTEM	IMPORT	ADDRESS,ADR,ASSEMBLE,BYTE,CAST,SETREG;
FROM Hardware	IMPORT	ciab,CiaIcrFlags,CiaIcrFlagSet,CiaCraFlags;
FROM Resources	IMPORT	ciabName,CiaResourcePtr,AddICRVector,RemICRVector,
			AbleICR,SetICR;
FROM ExecD	IMPORT	NodeType, Interrupt, InterruptPtr;
FROM ExecL	IMPORT	OpenResource;
FROM RealConversions IMPORT RealToStr;
FROM SeqIO      IMPORT	SeqKey,CloseSeq,OpenSeqIn,SeqInB,SeqInCount,
			OpenSeqOut,SeqOutCount;
FROM String	IMPORT	Compare,Concat,Length,Copy;
IMPORT ExecD,ExecL,GraphicsD,GraphicsL,Heap,DosD,DosL,
	ASCII,Arts,R,IconL,WorkbenchD;
(*$ IF Show *)
FROM Terminal	IMPORT	WriteString,WriteInt,Format,FormatNr,FormatS;
(*$ ENDIF *)


(* ========================================================== *)
MODULE PIcon;
IMPORT ADR,IconL,WorkbenchD;
EXPORT MakeIcon;

(*$ CopyDyn:=FALSE *)
PROCEDURE MakeIcon(name,icon: ARRAY OF CHAR);
VAR
 do: WorkbenchD.DiskObjectPtr;
BEGIN
  do:=IconL.GetDiskObject(ADR(icon));
  IF do#NIL THEN
    IF IconL.PutDiskObject(ADR(name),do) THEN END;
    IconL.FreeDiskObject(do)
  END
END MakeIcon;
END PIcon;
(* ========================================================== *)

(* ========================================================== *)
MODULE M2File;
IMPORT Arts,ASCII,Heap,DosD,DosL,Concat,Copy,Length,
	ADDRESS,BYTE,ADR,SETREG,ASSEMBLE;
EXPORT ReadPathTable,ForgetPathTable,GetFileName,CloseM2File,pathFileName;

CONST
  maxPathLen=128;
  maxFileName=maxPathLen;
(*$ IF English *)
  memOverFlow="Not enough memory";
  pathOverFlow="Path Entry Too Long";
(*$ ELSE *)
  memOverFlow="Zuwenig Speicher";
  pathOverFlow="Pfadname zu lang";
(*$ ENDIF *)
  Empty="";
  pathFileName="path";
  systemPath="M2:Path";

TYPE
  FileType=(txtFile,symFile,objFile,refFile,binFile);

  Path=ARRAY [0..maxPathLen-1] OF CHAR;
  PathPtr = POINTER TO Path;
  PathEntryPtr=POINTER TO PathEntry;
  PathEntry=RECORD
    next: PathEntryPtr;
    pLock: DosD.FileLockPtr; (* path Lock *)
    oLock: DosD.FileLockPtr; (* altes currDir oder NIL *)
    dLock: ARRAY [MIN(FileType)..MAX(FileType)] OF DosD.FileLockPtr;
    (* a lock for each subdir *)
    path: Path;
  END;
  ShString=ARRAY [0..5] OF CHAR;
  ShStringPtr=POINTER TO ShString;

VAR
  dir: ARRAY [MIN(FileType)..MAX(FileType)] OF ShStringPtr;
  ext:ShStringPtr;
(*$ LongAlign:=TRUE *)
(* sollten schon auf Langworte kommen, sind ja alle Lang! *)
  userPath,
  defaultPath: PathEntryPtr;
  originalDirectory, newDir: DosD.FileLockPtr;
  me:DosD.ProcessPtr;

PROCEDURE Exists(fname: ADDRESS): BOOLEAN;
VAR
  lock: DosD.FileLockPtr;
BEGIN
  lock:=DosL.Lock(fname,DosD.sharedLock);
  IF lock#NIL THEN
    DosL.UnLock(lock);
    RETURN TRUE
  ELSE
    RETURN FALSE
  END
END Exists;

PROCEDURE InitPathLocks(path: PathEntryPtr);
VAR
  t: FileType;
  dl: DosD.FileLockPtr;
BEGIN
  WITH path^ DO
    IF pLock=NIL THEN
      pLock:=DosL.Lock(ADR(path),DosD.sharedLock);
      IF pLock#NIL THEN
        dl:=DosL.CurrentDir(pLock);
        FOR t:=MIN(FileType) TO MAX(FileType) DO
          dLock[t]:=DosL.Lock(dir[t],DosD.sharedLock);
        END;
        dl:=DosL.CurrentDir(dl);
      END
    END
  END
END InitPathLocks;

(*$ CopyDyn:=FALSE *)
PROCEDURE GetFileName(VAR name: ARRAY OF CHAR; module: ARRAY OF CHAR);
VAR
  curPath: PathEntryPtr;
  lock: DosD.FileLockPtr;
  sdir: BOOLEAN;
  fname: ARRAY [0..maxFileName] OF CHAR;
BEGIN
  curPath:=userPath;
  lock:=DosL.Lock(dir[refFile],DosD.sharedLock);
  IF lock#NIL THEN
    DosL.UnLock(lock);
    Copy(fname,dir[refFile]^);
  ELSE
    fname:=Empty;
  END;
  Concat(fname,module);
  Concat(fname,ext^);
  IF Exists(ADR(fname)) THEN
  ELSE
    Copy(fname,module);
    Concat(fname,ext^);
    LOOP
      IF curPath=NIL THEN EXIT END;
      InitPathLocks(curPath);
      WITH curPath^ DO
        IF pLock#NIL THEN
          sdir:=dLock[refFile] # NIL;
          IF sdir THEN
            lock:=DosL.CurrentDir(dLock[refFile]);
          ELSE
            lock:=DosL.CurrentDir(pLock)
          END;
          IF Exists(ADR(fname)) THEN
            Copy(fname,path);
            IF sdir THEN
              Concat(fname,dir[refFile]^)
            END;
            Concat(fname,module);
            Concat(fname,ext^);
            lock:=DosL.CurrentDir(lock);
            EXIT
          END;
          lock:=DosL.CurrentDir(lock);
        END
      END;
      curPath:=curPath^.next;
    END
  END;
  Copy(name,fname);
END GetFileName;

PROCEDURE ForgetPathTable;
VAR
  path: PathEntryPtr;
  t: FileType;
BEGIN
  WHILE (userPath#NIL) & (userPath#defaultPath) DO
    path:=userPath;
    userPath:=userPath^.next;
    WITH path^ DO
      IF pLock#NIL THEN DosL.UnLock(pLock) END;
      FOR t:=MIN(FileType) TO MAX(FileType) DO
        IF dLock[t]#NIL THEN DosL.UnLock(dLock[t]) END;
      END
    END;
    Heap.Deallocate(path);
  END;
  userPath:=defaultPath;
  (* Wieder in StartDir gehen! *)
  IF newDir#NIL THEN
    IF newDir = me^.currentDir THEN (* alles klar, kein Schwein da gewesen! *)
      SETREG(0,DosL.CurrentDir(originalDirectory));
    END; (* Sonst um Gottes willen nicht!/bp *)
    DosL.UnLock(newDir); newDir:=NIL;
  END;
END ForgetPathTable;

(* falls wir aus einer SubDir gestartet wurden, wechseln wir ins ParentDir *)
PROCEDURE SetProjectDir;
 VAR
   dirInfo: DosD.FileInfoBlockPtr;
   ft: FileType;
   eq: BOOLEAN;
   i:INTEGER;
 BEGIN
   ASSEMBLE(
	MOVE.L	Arts.thisTask(A4),A0
	MOVE.L	DosD.Process.currentDir(A0),originalDirectory
   END);

   Heap.Allocate(dirInfo,SIZE(dirInfo^));
   Arts.Assert(dirInfo#NIL,ADR(memOverFlow));
   eq:=FALSE;
   IF DosL.Examine(originalDirectory,dirInfo) THEN
     ft:=MIN(FileType);
     REPEAT
       eq:=TRUE;
       FOR i:=0 TO 2 DO
         eq:=eq & (CAP(dir[ft]^[i])=CAP(dirInfo^.fileName[i]));
       END;
       (*$ RangeChk:=FALSE *)
       INC(ft);
       (*$ POP RangeChk *)
     UNTIL eq OR (ft>MAX(FileType));
   END;
   IF eq THEN
     newDir:=DosL.ParentDir(originalDirectory); (* neues Lock, merken! *)
     SETREG(0,DosL.CurrentDir(newDir));
   ELSE
     originalDirectory:=NIL;
     newDir:=NIL;
   END;
   Heap.Deallocate(dirInfo);
END SetProjectDir;

PROCEDURE ReadPathTable(name: ARRAY OF CHAR);
VAR
  ch: CHAR;
  eof: BOOLEAN;
  f: DosD.FileHandlePtr;
  i: INTEGER;
  entry: Path;
  lastEntry: PathEntryPtr;

  PROCEDURE AddEntry;
  TYPE CharPtr = POINTER TO CHAR;
  VAR
    path: PathEntryPtr;
    cp1,cp2:CharPtr;
  BEGIN
    Heap.Allocate(path,SIZE(PathEntry)-SIZE(Path)+i+1);
    Arts.Assert(path#NIL,ADR(memOverFlow));
    cp1:=ADR(path^.path); cp2:=ADR(entry);
    WHILE cp2^#ASCII.nul DO
      cp1^:=cp2^;
      INC(cp1); INC(cp2);
    END;
    cp1^:=ASCII.nul;
    (* Copy(path^.path,entry); Copy kopiert den GANZEN String!! Nicht mehr!/bp *)
    path^.next:=NIL;
    lastEntry^.next:=path;
    lastEntry:=path
  END AddEntry;

(*$ CopyDyn:=FALSE *)
BEGIN
  ForgetPathTable; (* alten lschen und in alte Dir wechseln, UnLocken *)
  SetProjectDir; (* ins Project heruntergehen, falls in SubDir *)
  lastEntry:=ADR(userPath);
  f:=DosL.Open(ADR(name),DosD.oldFile);
  IF f#NIL THEN
    eof:=DosL.Read(f,ADR(ch),1)#1; i:=0;
    WHILE ~eof DO
      IF (ch=ASCII.lf) & (i#0) THEN
        ch:=entry[i-1];
        IF (ch#":") & (ch#"/") THEN
          entry[i]:="/"; INC(i)
        END;
        entry[i]:=ASCII.nul;
        AddEntry;
        i:=0
      ELSIF i<maxPathLen THEN
        entry[i]:=ch; INC(i)
      END;
      eof:=DosL.Read(f,ADR(ch),1)#1
    END;
    DosL.Close(f)
  END;
  lastEntry^.next:=defaultPath;
END ReadPathTable;

PROCEDURE CloseM2File;
BEGIN
  ForgetPathTable;
  defaultPath:=NIL;
  ForgetPathTable;
END CloseM2File;

BEGIN (* M2File *)
  me:=Arts.thisTask;
  dir[symFile]:=ADR("sym/");dir[refFile]:=ADR("ref/");dir[objFile]:=ADR("obj/");
  dir[txtFile]:=ADR("txt/");dir[binFile]:=ADR("bin/");

  ext:=ADR(".ref");

 (* IMMER mit 0 initialisiert!
  * userPath:=NIL; defaultPath:=NIL; newDir:=NIL; originalDirectory:=NIL;
  *)
  ReadPathTable(systemPath);
  defaultPath:=userPath;
  ForgetPathTable; (* auf jeden fall wieder in StartDir gehen!! *)
END M2File;
(* ============================================================== *)


CONST
  msgNil = 'Profiler: prof=NIL!';
  msgMax = 'Profiler: id>max!';
  maxProf=800; (* dummy, aber wichtig fr Alloc-SIZE *)
  maxName=16; (*for procedure names*)
  ordStart=SHORTCARD(craStart);

TYPE
  (* reicht fr 100 Minuten! *)
  TimeRec= RECORD
	     CASE: INTEGER OF
	     | 0: val:LONGCARD;
	     | 1: high: CARDINAL;
	 	  low: CARDINAL
	     | 2: highhib: SHORTCARD;
		  highlob: SHORTCARD;
		  lowhib: SHORTCARD;
		  lowlob: SHORTCARD;
	     END;
	   END;

  Id=ARRAY [0..maxName-1] OF CHAR;

(*
  Proc enthlt Informationen fr jede Prozedur:
  - ownStartTime:	Startzeit des letzten Abschnitts ohne Prozeduraufrufe.
  - totalStartTime:	Startzeit dieser Prozedur.
  - called:	Anzahl Aufrufe dieser Prozedur.
  - calls:	Anzahl Aufrufe, die diese Prozedur gettigt hat.
  - ownTime:	Die akkumulierte Zeit die in dieser Prozedur selbst
  		verbraucht wurde.
  - totalTime:	Die akkumulierte Zeit dieser Prozedur inklusive aller
  		Aufrufe von fremden Prozeduren.
*)
  CTime=RECORD
    CASE: INTEGER OF
    | 0: lc:LONGCARD;
    | 1: re:REAL;
    END;
  END;
  Proc=RECORD
    ownStartTime:LONGCARD;
    totalStartTime:LONGCARD;
    called:LONGINT;
    calls:LONGINT;
    ownTime:CTime;
    totalTime:CTime;
    name:Id;
  END;
  ProfData=POINTER TO Prof;

  List = RECORD
    head,tail,tailPred: ProfData;
  END;

  ProcArr = ARRAY[0..maxProf-1] OF Proc;

(*
  Prof enthlt Profilerdaten fr jedes Modul:
  - name:	Name des Moduls.
  - max:	gesamte Zahl der Prozeduren.
  - procs:	Array mit Proc-Records fr jede Prozedur.
*)
  Prof=RECORD
    succ,pred:ProfData;
    name:Arts.ModName;
    max:CARDINAL;
    procs: ProcArr;
  END;

CONST
  rawProfSize=SIZE(Prof)-SIZE(ProcArr);
  ntscClk = 715.909; (*timer frequencies in Hz*)
  palClk = 709.379; (* /1000.0 ergibt Millisekunden! *)

VAR (*$ LongAlign:=TRUE *)
  pList:List;
  myInt:Interrupt;
  oldInt:InterruptPtr;
  cbBase:CiaResourcePtr;
  time:TimeRec; (* zhlt rckwrts! *)
  hasInt,
  running:BOOLEAN;
  dummy:CiaIcrFlagSet;
  clkFreq: REAL;
  self: ExecD.TaskPtr;
  (*$ IF NOT CompGens *)
  callTime,
  enterTime:REAL;
  (*$ ENDIF *)

(*
  Hilfsprozeduren:
  GetTime:	Kopiert Zeit vom Timer in die timer Variable
  ShowTime:	Druckt Zeit aus.
  Diff:		Berechnet Differenz zweier Zeiten.
  AddTail:	Fgt Element an Ende der Liste an.
  NewList:	Initialisiert leere Liste.
*)

PROCEDURE GetTime;
BEGIN (* Timer STEHT!! *)
  time.lowlob:=ciab.talo;
  time.lowhib:=ciab.tahi;
END GetTime;

(*$ IF Show *)
PROCEDURE ShowTime;
BEGIN
(*$ RangeChk:=FALSE *)
  FormatNr(' Time=%ld  ',time.val);
(*$ POP RangeChk *)
END ShowTime;
(*$ ENDIF *)


(*$ EntryExitCode:=FALSE *)
PROCEDURE Diff(start{R.D0},end{R.D7}:LONGCARD):LONGCARD;
BEGIN (* start ist >= end, weil er rckwrts zhlt! *)
  ASSEMBLE(
	SUB.L	D7,D0  (* Bei berlauf auch richtig! *)
	RTS
  END);
END Diff;

(*$ EntryExitCode:=FALSE *)
PROCEDURE AddTail(VAR list{R.A0}:List; node{R.A1}:ProfData);
BEGIN
  ASSEMBLE(
	ADDQ.L	#4,A0
	MOVE.L	4(A0),D0
	MOVE.L	A1,4(A0)
	MOVE.L	A0,(A1)
	MOVE.L	D0,4(A1)
	MOVE.L	D0,A0
	MOVE.L	A1,(A0)
	RTS
  END);
END AddTail;

(*$ EntryExitCode:=FALSE *)
PROCEDURE NewList(VAR list{R.A0}:List);
BEGIN
  ASSEMBLE(
	MOVE.L	A0,(A0)
	ADDQ.L	#4,(A0)
	CLR.L	4(A0)
	MOVE.L	A0,8(A0)
	RTS
  END);
END NewList;

(*
 * Die exportierten Prozeduren Allocate, Enter,Exit,Call und Return. Ihre
 * Funktion ist im Definition Module erklrt.
 *)

PROCEDURE Allocate(VAR prof:ProfData; nOfBlocks:CARDINAL; name:ADDRESS);
CONST parSize=SIZE (ADDRESS)+SIZE(CARDINAL)+SIZE(ADDRESS);
      (*wenn schon, dann sauber!!! SHML*)
      (* wenn schon sauber, dann GANZ sauber!/bp
       * ProfData ist VAR!! Also hier SIZE(ADDRESS)!!!
       * SIZE(BOOLEAN) wre auch falsch, da Stack immer gerade!
       *)
VAR
  d:POINTER TO Arts.ModName;
  (* lowest mu letzte deklarierte Var sein! *)
  i,lowest:INTEGER;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
  	BCLR	#ordStart,ciab.cra (*stop timing!*)
	LINK	A5,#lowest
	MOVEM.L D0-D7/A0-A3/A6,-(A7)
  END);

(*
 * Ein Block wird alloziert, der neben der Modulinfo geng Platz hat fr
 * alle Prozedurinformationen. Dieser Block wird an das Ende der Modulliste
 * gehngt.
 *)

  Heap.Allocate(prof,(nOfBlocks+1)*SIZE(Proc)+rawProfSize);
  Arts.Assert(prof#NIL,ADR('Profiler: cannot Allocate'));
  prof^.max:=nOfBlocks;
  d:=name;
  prof^.name:=d^;
  WITH prof^ DO
    procs[0].name[0] := "<";
    Concat(procs[0].name,prof^.name);
    Concat(procs[0].name,">");
    FOR i := 1 TO nOfBlocks DO procs[i].name := "<unknown>"; END;
  END;
  AddTail(pList,prof);

  (*$ IF Show *)
    FormatS('Allocate: %s ',d^);
    FormatNr('Blocks: %ld\n',LONGINT(nOfBlocks));
  (*$ ENDIF *)

  ASSEMBLE(
	MOVEM.L (A7)+,D0-D7/A0-A3/A6
	UNLK	A5
  (*$ IF m68010 *)
(*$ IF CompGens *)
	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	LEA	parSize(A7),A7
(*$ IF CompGens *)
	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTS
  (*$ ENDIF *)
  END);
END Allocate;


PROCEDURE Enter(prof:ProfData; id:CARDINAL; pc:CARDINAL);
CONST parSize=SIZE(ProfData)+SIZE(CARDINAL)*2;
(* KEINE LocVars!!! *)
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
  	BCLR	#ordStart,ciab.cra (* stop timing *)
	LINK	A5,#0
	MOVEM.L D0-D7/A0-A3/A6,-(A7)
  END);

  Arts.Assert(prof#NIL,ADR(msgNil));
  Arts.Assert(id<=prof^.max,ADR(msgMax));

  GetTime;
  WITH prof^.procs[id] DO
    INC(called);
    ownStartTime:=time.val;
    totalStartTime:=time.val;
  END;

  (*$ IF Show *)
    FormatS('Enter %s ',prof^.name);
    ShowTime;
    FormatNr('id=%ld ',id);
    FormatNr('pc=%ld\n',pc);
  (*$ ENDIF *)

  ASSEMBLE(
	MOVEM.L (A7)+,D0-D7/A0-A3/A6
	UNLK	A5
  (*$ IF m68010 *)
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (* start timing *)
(*$ ENDIF *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (* start timing *)
(*$ ENDIF *)
	RTS
  (*$ ENDIF *)
  END);
END Enter;


PROCEDURE Exit(prof:ProfData; id:CARDINAL; pc:CARDINAL);
CONST parSize=SIZE (ProfData)+SIZE (CARDINAL)*2;
(* KEINE LocVars!!! *)
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
  	BCLR	#ordStart,ciab.cra (*stop timing!*)
	LINK	A5,#0
	MOVEM.L D0-D7/A0-A3/A6,-(A7)
  END);

  IF prof#NIL THEN
    Arts.Assert(id<=prof^.max,ADR(msgMax));

    GetTime;
    WITH prof^.procs[id] DO
      INC(ownTime.lc,Diff(ownStartTime,time.val));
      INC(totalTime.lc,Diff(totalStartTime,time.val));
    END;

    (*$ IF Show *)
      FormatS('Exit %s ',prof^.name);
      ShowTime;
      FormatNr('id=%ld ' ,id);
      FormatNr('pc=%ld\n',pc);
    (*$ ENDIF *)
  END;

  ASSEMBLE(
	MOVEM.L (A7)+,D0-D7/A0-A3/A6
	UNLK	A5
  (*$ IF m68010 *)
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTS
  (*$ ENDIF *)
  END);
END Exit;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Call(prof:ProfData; id:CARDINAL);
CONST parSize=SIZE (ProfData)+SIZE (CARDINAL);
(* KEINE LocVars!!! *)
BEGIN
  ASSEMBLE(
  	BCLR	#ordStart,ciab.cra (*stop timing!*)
	LINK	A5,#0
	MOVEM.L D0-D7/A0-A3/A6,-(A7)
  END);

  Arts.Assert(prof#NIL,ADR(msgNil));
  Arts.Assert(id<=prof^.max,ADR(msgMax));

  GetTime;
  WITH prof^.procs[id] DO
    INC(ownTime.lc,Diff(ownStartTime,time.val));
    INC(calls);
  END;

  (*$ IF Show *)
    FormatS('Call %s ',prof^.name);
    ShowTime;
    FormatNr('id=%ld\n',id);
  (*$ ENDIF *)

  ASSEMBLE(
	MOVEM.L (A7)+,D0-D7/A0-A3/A6
	UNLK	A5
  (*$ IF m68010 *)
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTS
  (*$ ENDIF *)
  END);
END Call;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Return(prof:ProfData; id:CARDINAL);
CONST parSize=SIZE (ProfData)+SIZE (CARDINAL);
(* KEINE LocVars!!! *)
BEGIN
  ASSEMBLE(
  	BCLR	#ordStart,ciab.cra (*stop timing!*)
	LINK	A5,#0
	MOVEM.L D0-D7/A0-A3/A6,-(A7)
  END);

  Arts.Assert(prof#NIL,ADR(msgNil));
  Arts.Assert(id<=prof^.max,ADR(msgMax));

  GetTime;
  WITH prof^.procs[id] DO
    ownStartTime:=time.val;
  END;

  (*$ IF Show *)
    FormatS('Return %s ',prof^.name);
    ShowTime;
    FormatNr('id=%ld\n',id);
  (*$ ENDIF *)

  ASSEMBLE(
	MOVEM.L (A7)+,D0-D7/A0-A3/A6
	UNLK	A5
  (*$ IF m68010 *)
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
(*$ IF CompGens *)
  	BSET	#ordStart,ciab.cra (*start timing!*)
(*$ ENDIF *)
	RTS
  (*$ ENDIF *)
  END);
END Return;

(* ############################################################ *)
(* ############################################################ *)
(*
 * Da Claudio gerne "sauber" programmiert, ich aber gerne in Assembler,
 * habe ich die lokalen Prozeduren wieder global gemacht (deshalb liefen
 * die Assembler-Parts auch nicht!), das ganze aber in ein Modul
 * verpackt. 26.1.91/bp
 *)
MODULE Ref;
IMPORT	SeqKey,OpenSeqIn,CloseSeq,SeqInB,SeqInCount,Copy,
	BYTE,CAST,ADR,ADDRESS,ASSEMBLE,
	ProfData,M2File,R;
EXPORT	GetNames;

VAR
  inFile:SeqKey;


PROCEDURE GetB():BYTE;
(*$ EntryExitCode:=FALSE*)
BEGIN
   ASSEMBLE(
	MOVE.L	inFile,A0
	JSR	SeqInB(PC)
	RTS
   END);
END GetB;

PROCEDURE InB(VAR b{R.A2}:BYTE);
(*$ EntryExitCode:=FALSE*)
BEGIN
  ASSEMBLE(
	BSR.S	GetB
	MOVE.B	D0,(A2)
	RTS
  END)
END InB;

PROCEDURE InCount(adr:ADDRESS; cnt:INTEGER);
BEGIN
  SeqInCount(inFile,adr,CAST(CARDINAL,cnt));
END InCount;

PROCEDURE InNumber0(VAR x:ARRAY OF BYTE; b:BYTE); (* nur f. PCpos *)
BEGIN
  ASSEMBLE(
	MOVE.B	b(A5),D0 (*; byte *)
	MOVEA.L	x(A5),A1 (*; adr *)
	ADDA.L	x+4(A5),A1 (*; high *)

	BCLR	#7,D0
	BNE.S	b10od11
(*; 00 oder 01 *)
	BCLR	#6,D0
	BNE.S	b01
(*; 00 *)
	BTST	#5,D0
	SNE	D4
	BEQ.S	b00a
	ORI.B	#$C0,D0
b00a:	MOVE.B	D0,(A1)
	BRA.S	fill

b01:	BTST	#5,D0
	SNE	D4
	BEQ.S	b01a
	ORI.B	#$C0,D0
b01a:	SUBQ.L	#1,x+4(A5)
	BMI.S	InError
	MOVE.B	D0,-1(A1)
	MOVE.L	A1,D5
	BSR	GetB
	MOVEA.L	D5,A1
	MOVE.B	D0,(A1)
	BRA.S	fill

b10od11:
	BCLR	#6,D0
	BNE.S	b11
(*; 10 *)
	BTST	#5,D0
	SNE	D4
	BEQ.S	b10a
	ORI.B	#$C0,D0
b10a:
	SUBQ.L	#2,x+4(A5)
	BMI.S	InError
	MOVE.B	D0,-2(A1)
	PEA	-1(A1)
	MOVEQ	#2,D0
	MOVE.W	D0,-(A7)
	BSR	InCount
	BRA.S	fill

(*; D0.B=anzahl zu lesende *)
b11:	MOVEQ	#0,D1
	MOVE.B	D0,D1
	MOVE.L	D1,D0
	SUBQ.L	#1,D1
	SUB.L	D1,x+4(A5)
	BMI.S	InError
	SUBA.L	D1,A1
	MOVE.L	A1,D5
	MOVE.L	A1,-(A7)
	MOVE.W	D0,-(A7)
	BSR	InCount
	MOVEA.L	D5,A1
	BTST	#7,(A1)
	SNE	D4

(*; D4=fill [0]... mit D4 (Vorzeichen) *)
fill:	MOVE.L	x+4(A5),D1
	BEQ.S	InNuOk
	MOVEA.L	x(A5),A1
	SUBQ.L	#1,D1
filllp:	MOVE.B	D4,(A1)+
	DBRA	D1,filllp

InError: (*; macht gar nichts! Besser als Speicher zerstren! *)
InNuOk:
  END);
END InNumber0;

(*$ EntryExitCode:=FALSE*)
PROCEDURE InNumber(VAR x:ARRAY OF BYTE);
BEGIN
  ASSEMBLE(
	BSR     GetB
	MOVEA.L	(A7)+,A0
	MOVE.B  D0,-(A7)
	MOVE.L	A0,-(A7)
	BRA     InNumber0
  END);
END InNumber;

(*$ EntryExitCode:=FALSE*)
PROCEDURE InBool(VAR b{R.A2}:BOOLEAN); (* bleibt so, 0=FALSE *)
BEGIN
  ASSEMBLE(
	BSR	GetB
	NEG.B	D0
	MOVE.B	D0,(A2)
	RTS
  END);
END InBool;

(*$ OverflowChk:=FALSE RangeChk:=FALSE *)
PROCEDURE InId(VAR s:ARRAY OF CHAR);
(* 22.1.91/bp Wir kennen nun auch LANGE Strings!! *)
VAR
  L,ic:INTEGER;
  ch:CHAR;
BEGIN
  InNumber(L);
  DEC(L);
  ic:=L;
  IF L>HIGH(s) THEN L:=HIGH(s); END;
  IF ic>0 THEN
    InCount(ADR(s),ic);
  END;
  s[L]:=0C;
END InId;
(*$ POP OverflowChk POP RangeChk *)

PROCEDURE GetNames(VAR p:ProfData);
CONST
  bufSize=10000;
  reffile=10;
  CTL=0; anchor=0; ModTag=1; ProcTag=2; RefTag=3; linkage=4;
  STR=1; enum=0; range=1; pointer=2; set=3; procTyp=4; funcTyp=5;
  array=6; dynarr=7; record=10; opaque=11; bpointer=12;
  CMP=2; parref=0; par=1; field=2;
  OBJ=3; varref=0; var=1; const=2; string=3; type=4; proc=5; func=6;
  module=7; svc=10; svcfunc=11;
TYPE
 (*
  * VORSICHT: Diese beiden Deklarationen mssen mit dem Compiler bereinstimmen.
  *)
  VarModes=(norm,absvar,regvar,farvar,extvar,smallextvar);
  ModModes=(none,hasimp,library,noimp);
VAR
  blk:CHAR;
  boolValue:BOOLEAN;
  block:CARDINAL;
  fname,id:ARRAY [0..255] OF CHAR;
  longwordValue:LONGINT;
  procNum:LONGCARD;
  quadwordValue:LONGREAL;
BEGIN
  M2File.GetFileName (fname, p^.name);
  IF OpenSeqIn(inFile,fname,bufSize) THEN
    InCount(ADR(longwordValue),4); (* Filetyp *)
    (* 22.1.91/bp Wir kenn nun auch verschiedene ref-Typen! *)
    IF (longwordValue>=reffile)&(longwordValue<=reffile+9) THEN
      LOOP
        InB(blk); block:=CARDINAL(blk);
	CASE block DIV 16 OF
	| OBJ:
	   DEC(block,16*OBJ);
	   IF block>svcfunc THEN EXIT END;
	   CASE block OF
	   | varref,var:
	      InNumber(longwordValue); (* Typ *)
	      InNumber(longwordValue); (* Level *)
	      InNumber(longwordValue); (* Address *)
	      InNumber(longwordValue); (* Mode *)
	      (* 30.7.90/bp neue Extern-VarModes *)
	      (* 22.1.91/bp Auch Obergrenze abfragen! Es kommen neue VarModes! *)
	      IF (longwordValue>=ORD(extvar))&(longwordValue<=ORD(smallextvar)) THEN
        	InId(id);
	      END;
	   | const:
	      InNumber(longwordValue); (* Typ *)
	      InNumber(longwordValue); (* Module *)
	      InNumber(quadwordValue); (* ConstVal *)
	   | string:
	      InNumber(longwordValue); (* Typ *)
	      InId(id); (* String *)
	   | type:
	      InNumber(longwordValue); (* Typ *)
	      InNumber(longwordValue); (* Module *)
	   | proc,func:
	      IF block=func THEN InNumber(longwordValue); (* Typ *) END;
	      InNumber(procNum); (* Number *)
	      InNumber(longwordValue); (* Level *)
	      InNumber(longwordValue); (* Adress *)
	      InNumber(longwordValue); (* Size *)
	      InNumber(longwordValue); (* Regs *)
	   | svc,svcfunc,module: (* Claudio hatte module vergessen! *)
	      IF block=svcfunc THEN InNumber(longwordValue); (* Typ *) END;
	      InNumber(longwordValue); (* Number *)
	   END;
	   InId(id);
(*
 * Funktionen und Prozeduren werden eingetragen.
 *)
 	   IF (block=proc) OR (block=func) THEN
	     IF procNum<=p^.max THEN Copy(p^.procs[procNum].name,id); END;
	   END;
	   InBool(boolValue);
	| CMP:
	   DEC(block,16*CMP);
	   IF block>field THEN EXIT END;
	   InNumber(longwordValue); (* Typ *)
	   InNumber(longwordValue); (* Offset/ParMode *)
	   InId(id);
	| STR:
	   DEC(block,16*STR);
	   IF block>bpointer THEN EXIT END;
	   InNumber(longwordValue); (* Size *)
	   CASE block OF
	     | bpointer,pointer,record,opaque,procTyp:
	     | enum,set,funcTyp,dynarr:
	        (* Elementzahl/Basistyp/Resultattyp/Elementtyp *)
	        InNumber(longwordValue);
	     | array:
	        InNumber(longwordValue); (* Elementtyp *)
	        InNumber(longwordValue); (* Indextyp *)
	     | range:
	        InNumber(longwordValue); (* Basistyp *)
	        InNumber(longwordValue); (* Lower Bound *)
	        InNumber(longwordValue); (* Upper Bound *)
	        InBool(boolValue); (* Sign *)
	     END;
	| CTL:
	   DEC(block,16*CTL);
	   IF block>linkage THEN EXIT END;
	   CASE block OF
	   | anchor:
	      InCount(ADR(quadwordValue),6); (* Key *)
	      InId(id); (* Name *)
	      InNumber(longwordValue); (* Mode *)
	      IF longwordValue=ORD(library) THEN InId(id); END;
	   | linkage:
	      InNumber(longwordValue); (* Basistyp *)
	      InNumber(longwordValue); (* Pointertyp *)
	   | ModTag,ProcTag:
	      InNumber(longwordValue); (* dummy ?/Prozedurnummer *)
	   | RefTag:
	      InNumber(longwordValue); (* Address *)
	      InNumber(longwordValue); (* Procedure Number *)
	      EXIT
	   END
	ELSE (*line block*)
	  InNumber0(longwordValue,blk); InNumber(longwordValue);
	END;
      END; (* LOOP *)
    END; (* IF reffile *)
    CloseSeq(inFile);
  END; (* IF OpenSeqIn *)
END GetNames;

END Ref; (* lokales Modul *)
(* ############################################################ *)
(* ############################################################ *)

PROCEDURE Auswertung;

TYPE
  IndexEntry=RECORD
    mod:ProfData;
    pnum:INTEGER;
  END;

VAR
  file:SeqKey;
  index:POINTER TO ARRAY [0..9999] OF IndexEntry;
  indexFirst,indexNext:INTEGER;
  procCnt:INTEGER;

  PROCEDURE Insert(ie:IndexEntry);
  VAR
    i:INTEGER;
    refTime:REAL;
  BEGIN
    i:=indexNext; refTime:=ie.mod^.procs[ie.pnum].ownTime.re;
    LOOP
      IF i<=indexFirst THEN EXIT; END;
      WITH index^[i-1] DO
        IF mod^.procs[pnum].ownTime.re>=refTime THEN EXIT END;
      END;
      index^[i]:=index^[i-1];
      DEC(i);
    END;
    index^[i]:=ie;
    INC(indexNext);
  END Insert;

CONST
  gesPrg="\nGesamtes Programm\n~~~~~~~~~~~~~~~~~";
  head="\nAnteil|    Prozedur selbst:  |    Prozedur gesamt:  |  Anzahl  | Prozedur\n  %   |   Zeit   |Zeit/Aufruf|   Zeit   |Zeit/Aufruf|  Aufrufe |";
  mod=" (Modul)";
  nexttbl="\n\n";
  table="\n------+----------+-----------+----------+-----------+----------+---------";
  underline="\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";

  PROCEDURE PrintHead(name:ARRAY OF CHAR);
  VAR
    len:INTEGER;
    line:ARRAY [0..199] OF CHAR;
  BEGIN
    len:=Length(name);
    IF len=0 THEN
      SeqOutCount(file,ADR(gesPrg),SIZE(gesPrg));
    ELSE
      line:="\nModul ";
      Concat(line,name);
      SeqOutCount(file,ADR(line),len+7);
      SeqOutCount(file,ADR(underline),len+7);
    END;
    SeqOutCount(file,ADR(head),SIZE(head));
    IF len=0 THEN SeqOutCount(file,ADR(mod),SIZE(mod)); END;
    SeqOutCount(file,ADR(table),SIZE(table));
  END PrintHead;

  PROCEDURE PrintTail;
  BEGIN
    SeqOutCount(file,ADR(table),SIZE(table));
    SeqOutCount(file,ADR(nexttbl),SIZE(nexttbl));
  END PrintTail;

  PROCEDURE Print(ie:IndexEntry; total:REAL; withMod:BOOLEAN);
  VAR
    err:BOOLEAN;
    perc,own,tot:REAL;
    line,str:ARRAY [0..199] OF CHAR;
  BEGIN
    line:="\n";
    WITH ie.mod^.procs[ie.pnum] DO
      perc:=ownTime.re/total*100.0;

      own:=ownTime.re/clkFreq;
      tot:=totalTime.re/clkFreq;
(* 8,1 zu 8,4 9,2 zu 9,5 *)
      RealToStr(perc,str,5,1,FALSE,err); Concat(line,str); Concat(line," | ");
      RealToStr(own,str,8,1,FALSE,err); Concat(line,str); Concat(line," | ");
      IF called>0 THEN RealToStr(own/REAL(called),str,9,2,FALSE,err);
      ELSE str:="- - - - -";
      END;
      Concat(line,str); Concat(line," | ");
      RealToStr(tot,str,8,1,FALSE,err); Concat(line,str); Concat(line," | ");
      IF called>0 THEN RealToStr(tot/REAL(called),str,9,2,FALSE,err);
      ELSE str:="- - - - -";
      END;
      Concat(line,str); Concat(line," | ");
      RealToStr(REAL(called),str,8,0,FALSE,err); (* TODO *)
      Concat(line,str); Concat(line," | ");
      Concat(line,name);
      IF withMod THEN
        Concat(line," (");
        Concat(line,ie.mod^.name);
        Concat(line,")");
      END;
      (* Concat(line,ie.mod^.name); Concat(line,"."); *)
      SeqOutCount(file,ADR(line),Length(line));
    END;
  END Print;

VAR
  (*$IF Test*)
  fcnt:CARDINAL;
  (*$ENDIF*)
  fname:ARRAY [0..99] OF CHAR;
  ges:REAL;
  i:CARDINAL;
  ie:IndexEntry;
  last:INTEGER;
  moduleTime:REAL;
  p:ProfData;
  perc,totalperc,profTime,eeTime,crTime:REAL;
  pName:POINTER TO ARRAY [0..255] OF CHAR;
BEGIN
 (*
  * Aus dem Programmnamen wird der Dateiname fr die Ausgabedatei gebildet,
  * und die Ausgabedatei geffnet.
  *)
  pName:=Arts.programName;
  Copy(fname,pName^);
  Concat(fname,".prf");
(*$IF Test *)
  fcnt:=0;
  REPEAT
    INC(fcnt);
    IF fcnt>=100 THEN RETURN; END;
    fname[1]:=CHAR((fcnt DIV 10)+48);
    fname[2]:=CHAR((fcnt MOD 10)+48);
  UNTIL OpenSeqOut(file,fname,10000);
(*$ELSE*)
  IF NOT OpenSeqOut(file,fname,10000) THEN RETURN END;
(*$ENDIF*)

 (*
  * Die Modulliste wird durchwandert.
  * Dabei wird die Gesamtzeit (ges) ermittelt,
  * als Summe aller Totalzeiten des Initialisierungsteils.
  * Es wird auch die totale Zahl aller Prozeduren
  * (procCnt) ermittelt.
  *)
  p:=pList.head;
  ges:=0.0;
  procCnt:=0;
  WHILE p^.succ#NIL DO
    INC(procCnt,p^.max+1);
    p:=p^.succ;
  END;
  IF procCnt=0 THEN RETURN END; (* fr simplen Import, sonst crash! *)
 (*
  * Es wird eine index Liste alloziert. Dieses dient dazu die Prozeduren
  * nach Zeit zu sortieren.
  *)
  Heap.Allocate(index,procCnt*SIZE(IndexEntry));
  IF index#NIL THEN (* hier kein Arts.Assert, bitte! *)
    p:=pList.head;
    indexFirst:=0; indexNext:=0;
    ReadPathTable(pathFileName);
    WHILE p^.succ#NIL DO
      GetNames (p);  (*Get procedure names of module p^.name*)
      ie.mod:=p; moduleTime:=0.0;
      FOR i:=0 TO p^.max DO
        ie.pnum:=i;
        WITH p^.procs[i] DO
          (*$ IF CompGens *)
          ownTime.re:=REAL(ownTime.lc);
          totalTime.re:=REAL(totalTime.lc);
          (*$ ELSE *)
          eeTime:=enterTime*REAL(called);
          crTime:=callTime*REAL(calls);
	  profTime:=eeTime+crTime;
	 (*
	  * Fr total zhlt: called*Exit + calls*Call +calls*Return
	  * Fr own zhlt called*Exit + calls*Call
	  *)
	  (* Return,Enter zhlt nicht zu own! Nur Call,Exit *)
	  ownTime.re:=REAL(ownTime.lc)-profTime;
	(*IF (i=0)&(ownTime.re<0.0) THEN ownTime.re:=0.0 END;*)
	  (* Enter zhlt nicht zu total Nur Call,Return, Exit *)
	  totalTime.re:=REAL(totalTime.lc)-profTime-crTime;
	(*IF (i=0)&(totalTime.re<0.0) THEN totalTime.re:=0.0 END;*)
	  (*$ ENDIF *)
	  ges:=ges+ownTime.re;
          Insert(ie);
          moduleTime:=moduleTime+ownTime.re;
        END;
      END;
      PrintHead(ie.mod^.name);
      FOR i:=indexFirst TO indexNext-1 DO
        Print(index^[i],moduleTime,FALSE);
      END;
      PrintTail;
      indexFirst:=indexNext;
      p:=p^.succ;
    END;

    PrintHead("");
    last:=indexNext-1; indexFirst:=0; indexNext:=1;
    FOR i:=1 TO last DO Insert(index^[i]); END;
    FOR i:=0 TO last DO Print(index^[i],ges,TRUE); END;
    PrintTail;
    Heap.Deallocate(index);
    M2File.ForgetPathTable;
  END;
  CloseSeq(file);
  IF Arts.wbStarted THEN
    MakeIcon(fname,"m2:icons/txt");
  END;
END Auswertung;

(* IcrVector: Decrementiert time.high *)
PROCEDURE TimeServ(VAR th{R.A1}:CARDINAL);
BEGIN
  (*$ OverflowChk:=FALSE *)
  DEC(th);
  (*$ POP OverflowChk *)
END TimeServ;

(*$ EntryExitCode:=FALSE *)
PROCEDURE TaskSwitch;
BEGIN
  ASSEMBLE(
	BCLR	#ordStart,ciab.cra
	SNE	running
	RTS
  END);
END TaskSwitch;

(*$ EntryExitCode:=FALSE *)
PROCEDURE TaskLaunch; (* Auch dies beinflut die Genauigkeit!! *)
BEGIN
  (*Falls Timer vor dem Switch eingeschaltet war, wird er wieder eingeschaltet*)
  ASSEMBLE(
	TST.B	running
	BEQ.S	notRun
	BSET	#ordStart,ciab.cra
    notRun:
  	RTS
  END);
END TaskLaunch;

(* Mist! Ergibt zu viel Zeit! *)

(*$ EntryExitCode:=FALSE *)
PROCEDURE DummyEnter(p:ProfData;id:CARDINAL;pc:CARDINAL);
CONST parSize=8;
BEGIN
  ASSEMBLE(
  (*$ IF m68010 *)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
	RTS
  (*$ ENDIF *)
  END);
END DummyEnter;

(*$ EntryExitCode:=FALSE *)
PROCEDURE DummyCall(p:ProfData;id:CARDINAL);
CONST parSize=6;
BEGIN
  ASSEMBLE(
(*  	BCLR	#ordStart,ciab.cra (* stop timing *)*)
  (*$ IF m68010 *)
(*  	BSET	#ordStart,ciab.cra (* start timing *)*)
	RTD	#parSize
  (*$ ELSE *)
	MOVE.L	(A7),parSize(A7)
	ADDQ.L	#parSize,A7
(*  	BSET	#ordStart,ciab.cra (* start timing *)*)
	RTS
  (*$ ENDIF *)
  END);
END DummyCall;


PROCEDURE Dummy;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RTS
  END);
END Dummy;

(*
 * Dies kann nur ein ungefhrer Test sein, weil der Cache
 * nicht bercksichtigt werden kann. Bei eigentlich sehr kurzen
 * Prozeduren fllt der Profiler jedoch zu sehr ins Gewicht!
 *)
(*$ IF NOT CompGens *)
PROCEDURE TimeTest;
VAR p:ProfData; i:INTEGER; dummy:INTEGER; startTime:LONGCARD;
BEGIN
  EXCL(ciab.cra,craStart); (* stop timing *)
  ExecL.Forbid;
  GetTime;
  startTime:=time.val;

(*
  ASSEMBLE(
	MOVE.W	#1000,D0
	BSET	#ordStart,ciab.cra
   lp:	MOVE.L	p(A5),-(A7)
	MOVE.W	#100,-(A7)
	BSR	Dummy
	ADDQ.L	#6,A7
	DBRA	D0,lp
	BCLR	#ordStart,ciab.cra
  END);
*)
  INCL(ciab.cra,craStart); (* start timing *)
  FOR i:=1 TO 1000 DO (* Return zhlt zu fremder Proc!! *)
    DummyCall(p,100);
  END;
  EXCL(ciab.cra,craStart); (* stop timing *)


  GetTime;
  ExecL.Permit;
  callTime:=REAL(Diff(startTime,time.val))/1400.0;

  ExecL.Forbid;
  GetTime;
  startTime:=time.val;

(*
  ASSEMBLE(
	MOVE.W	#1000,D0
	BSET	#ordStart,ciab.cra
   lp:	MOVE.L	p(A5),-(A7)
	MOVE.W	#100,-(A7)
	MOVE.W	#105,-(A7)
	BSR	Dummy
	ADDQ.L	#8,A7
	DBRA	D0,lp
	BCLR	#ordStart,ciab.cra
  END);
*)
  INCL(ciab.cra,craStart); (* start timing *)
  FOR i:=1 TO 1000 DO
    DummyEnter(p,100,105);
  END;
  EXCL(ciab.cra,craStart); (* stop timing *)

  GetTime;
  ExecL.Permit;
  enterTime:=REAL(Diff(startTime,time.val))/1400.0;
END TimeTest;
(*$ ENDIF *)

BEGIN

  NewList(pList);

 (*
  * Clock Frequenz bestimmen.
  *)
  IF GraphicsD.pal IN GraphicsL.graphicsBase^.displayFlags THEN
    clkFreq := palClk;
  ELSE
    clkFreq := ntscClk;
  END;

(*
  Doch wieder Bernd's Lsung, denn:
  1. Die einzige Mglichkeit einen Timer zu reservieren besteht darin,
     den Timer Interrupt zu reservieren.
  2. Obwohl minim umstndlicher hat die Interrupt Lsung den Vorteil
     nur einen der beiden Timer zu benutzen. In einem Multitasking-Environment
     sollte man anderen Programmen mglichst wenig Resourcen wegnehmen.

  Noch eine Bemerkung zu Punkt 2. Laut RKM sollte ein Programm zuerst
  versuchen Timer B zu allozieren, wenn dies nicht gelingt, dann sollte
  Timer A versucht werden. Der Profiler kann dies leider nicht tun, da
  der Compiler die Starts und Stops fr den Timer fix einprogrammiert.
  Die Wahl Timer A zu verwenden ist nicht mal so schlecht, denn falls
  vor dem Profiler ein Program aufgestartet wurde, dass nach RKM Schema
  Timer alloziert, dann hat dieses Programm Timer B belegt, und Timer A
  ist noch frei.
*)

 (*
  * Set up interrupt node.
  *)
  myInt.node.type:=interrupt;
  myInt.node.name:=ADR('Profiler');
  myInt.code:=ADR(TimeServ);
  myInt.data:=ADR(time.high);

 (*
  * Open Resource, Interrupt einhngen, Timer initialisieren anhalten und
  * zurcksetzen, timer Variable zurcksetzen, Switch und Launch Prozeduren
  * einsetzen und aktivieren, Timer starten.
  *)
  cbBase:=OpenResource(ADR(ciabName));
  Arts.Assert(cbBase#NIL,ADR('Profiler: no ciab.resource'));

  ExecL.Disable;
  oldInt:=AddICRVector(cbBase,ta,ADR(myInt));
  Arts.Assert(oldInt=NIL,ADR('Profiler: Ciab Timer A not free'));
  hasInt:=TRUE;
  EXCL (ciab.cra, craRunmode);
  EXCL (ciab.cra, craInmode);
  EXCL(ciab.cra,craStart);
  dummy:=AbleICR(cbBase,CiaIcrFlagSet{ta,setclr});
  ciab.talo:=0FFH;
  ciab.tahi:=0FFH;
  time.high:=0FFFFH;

  self := ExecL.FindTask (NIL);
  WITH self^ DO
    launch := TaskLaunch; switch := TaskSwitch;
    INCL(flags,ExecD.switch);   (*never forget these two!!!!!!!*)
    INCL(flags,ExecD.launch);
  END;

  INCL (ciab.cra, craStart); (*start timing!*)
  ExecL.Enable;

CLOSE
 (*
  * Switch und Launch Prozeduren deaktivieren und entfernen,
  * Interrupt entfernen
  *)

  ExecL.Disable;

  WITH self^ DO
    EXCL(flags,ExecD.switch);   (*never forget these two!!!!!!!*)
    EXCL(flags,ExecD.launch);
    launch := NIL; switch := NIL;
  END;

  IF hasInt THEN
    (*$ IF NOT CompGens *)
    TimeTest;
    (*$ ENDIF *)
    EXCL(ciab.cra,craStart);
    dummy:=AbleICR(cbBase,CiaIcrFlagSet{ta});
    RemICRVector(cbBase,ta,ADR(myInt));
    hasInt:=FALSE;
    ExecL.Enable;
    Auswertung;
  ELSE
    ExecL.Enable;
  END;
  CloseM2File; (* auf jeden Fall! *)

END Profiler.mod
