IMPLEMENTATION MODULE MkFile;
(*
 * 25.9.90/bp Auf M2File: GetFileName sagt Trennstelle dir/name
 * 10.6.90/bp Neue FileTypen ob1,ob2... fr 68010...
 *	      Kein UnLock bei Dirwechsel mehr!
 * 20.2.90/bp Deutsch/englische Version mit $g..
 * 25.5.89/ms DetectCtrlC zur Verhinderung des Unterbruchs inmitten
 *            eines GetFileName Aufrufs.
 * 15.2.89/ms Verwendung von Str anstelle von FileNames.MakeFileName
 *)

(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE
    NilChk:=FALSE StackChk:=FALSE RangeChk:=FALSE OverflowChk:=FALSE *)

(*$ DEFINE English:=FALSE *)


FROM SYSTEM IMPORT ADDRESS, BYTE, ADR, SETREG, ASSEMBLE;

FROM Arts IMPORT
 Assert, thisTask;

FROM ASCII IMPORT
 nul, lf;

FROM DosD IMPORT
 oldFile, newFile, sharedLock, FileHandlePtr, FileInfoBlockPtr, FileLockPtr, Process;
FROM DosL IMPORT
 Close, CurrentDir, Examine, Lock, Open, ParentDir, Read, UnLock;

FROM Heap IMPORT
 Allocate, Deallocate;

FROM String IMPORT
 Concat, Copy, Length;

FROM MkBase IMPORT
 external;

CONST
 maxPathLen=128;
 maxFileName=maxPathLen;
 Empty="";
 systemPath="M2:Path";

(*$ IF English *)
 memOverFlow = "Not enough memory";
 pathOverFlow = "Path Entry Too Long";

(*$ ELSE *)
 memOverFlow = "Zuwenig Speicher";
 pathOverFlow = "Pfadname zu lang";

(*$ ENDIF *)


TYPE
 Path=ARRAY [0..maxPathLen-1] OF CHAR;
 PathPtr = POINTER TO Path;
 PathEntryPtr=POINTER TO PathEntry;
 PathEntry=RECORD
  next: PathEntryPtr;
  pLock: FileLockPtr; (* path Lock *)
  oLock: FileLockPtr; (* altes currDir oder NIL *)
  dLock: ARRAY [MIN(FileType)..MAX(FileType)] OF FileLockPtr;
  (* a lock for each subdir *)
  path: Path;
 END;
 ShString=ARRAY [0..5] OF CHAR;
 ShStringPtr=POINTER TO ShString;

VAR
 dir,ext: ARRAY [MIN(FileType)..MAX(FileType)] OF ShStringPtr;
(*$ LongAlign:=TRUE *)
(* sollten schon auf Langworte kommen, sind ja alle Lang! *)
 userPath,
 defaultPath: PathEntryPtr;
 originalDirectory, newDir: FileLockPtr;


PROCEDURE Exists(fname: ADDRESS): BOOLEAN;
  VAR
    lock: FileLockPtr;
  BEGIN
    lock:=Lock(fname, sharedLock);
    IF lock=NIL THEN RETURN FALSE END;
    UnLock(lock);
    RETURN TRUE
  END Exists;


PROCEDURE InitPathLocks(path: PathEntryPtr);
  VAR
    t: FileType;
    dl: FileLockPtr;
  BEGIN
    WITH path^ DO
      IF pLock=NIL THEN
        pLock:=Lock(ADR(path), sharedLock);
        IF pLock#NIL THEN
          dl:=CurrentDir(pLock);
          FOR t:=MIN(FileType) TO MAX(FileType) DO
            dLock[t]:=Lock(dir[t], sharedLock);
          END;
          dl:=CurrentDir(dl);
        END
      END
    END
  END InitPathLocks;


(*$ CopyDyn:=FALSE *)
PROCEDURE GetFileName(VAR name: ARRAY OF CHAR; VAR len,trenn: INTEGER;
                      type: FileType; module: ARRAY OF CHAR; new: BOOLEAN);
  VAR
    curPath: PathEntryPtr;
    lock: FileLockPtr;
    sdir: BOOLEAN;
    fname: ARRAY [0..maxFileName] OF CHAR;
  BEGIN
    trenn:=-1;
    curPath:=userPath;
    lock:=Lock(dir[type],sharedLock);
    IF lock=NIL THEN fname:=Empty
    ELSE
      UnLock(lock);
      Copy(fname,dir[type]^)
    END;
    Concat(fname,module);
    Concat(fname,ext[type]^);
    len:=Length(fname);
    (* 17.11.91/bp external sagt, dass in allen Proj gesucht wird *)
    IF Exists(ADR(fname)) OR new THEN
    ELSIF external THEN
      Copy(fname,module);
      Concat(fname,ext[type]^);
      len:=Length(fname);
      LOOP
        IF curPath=NIL THEN len:=0; fname[0]:=0C; EXIT END;
        InitPathLocks(curPath);
        WITH curPath^ DO
          IF pLock#NIL THEN
            sdir:=dLock[type] # NIL;
            IF sdir THEN
              lock:=CurrentDir(dLock[type])
            ELSE
              lock:=CurrentDir(pLock)
            END;
            IF Exists(ADR(fname)) THEN
              Copy(fname,path);
              trenn:=Length(fname)-1;
              IF sdir THEN Concat(fname,dir[type]^) END;
              Concat(fname,module);
              Concat(fname,ext[type]^);
              len:=Length(fname);
              lock:=CurrentDir(lock);
              EXIT
            END;
            lock:=CurrentDir(lock);
          END
        END; (* WITH *)
        curPath:=curPath^.next;
      END (* LOOP *)
    ELSE (* nicht da und nicht external *)
      len:=0; fname[0]:=0C;
    END;
    Copy(name,fname);
  END GetFileName;


PROCEDURE GetInputFile(VAR name: ARRAY OF CHAR; VAR len: INTEGER;
                       type: FileType; givenName: ARRAY OF CHAR);
  VAR
    hasPath, hasExtension: BOOLEAN;
    i: INTEGER;
    extension: ShString;
    ch: CHAR;
  BEGIN
    i:=0; hasPath:=FALSE;
 (* Besser wre:
  * i:=LastPos(...);
  * hasExtension:=Occurs(name,i,ext[type]^,FALSE)=Length(name)-Length(ext[type]^);
  *)
    LOOP
      IF i>HIGH(givenName) THEN EXIT END;
      ch:=givenName[i];
      IF ch=nul THEN EXIT
      ELSIF (ch=":") OR (ch="/") THEN hasPath:=TRUE
      END;
      INC(i)
    END;
    hasExtension:=(i>4)
     & (CAP(givenName[i-4])=CAP(ext[type]^[0]))
     & (CAP(givenName[i-3])=CAP(ext[type]^[1]))
     & (CAP(givenName[i-2])=CAP(ext[type]^[2]))
     & ((CAP(givenName[i-1])=CAP(ext[type]^[3])) OR (type=objFile));
    IF hasExtension THEN
      extension:=Empty
    ELSE
      extension:=ext[type]^
    END;
    IF ~hasPath & Exists(dir[type]) THEN
      Copy(name,dir[type]^);
    ELSE
      name[0]:=nul
    END;
    Concat(name,givenName);
    Concat(name,extension);
    len:=Length(name);
  END GetInputFile;


PROCEDURE ForgetPathTable;
  VAR
    path: PathEntryPtr;
    t: FileType;
  BEGIN
    WHILE (userPath#NIL) & (userPath#defaultPath) DO
      path:=userPath;
      userPath:=userPath^.next;
      WITH path^ DO
        IF pLock#NIL THEN UnLock(pLock) END;
        FOR t:=MIN(FileType) TO MAX(FileType) DO
          IF dLock[t]#NIL THEN UnLock(dLock[t]) END;
        END
      END;
      Deallocate(path);
    END;
    userPath:=defaultPath;
    (* Wieder in StartDir gehen! *)
    IF originalDirectory#NIL THEN
      SETREG(0,CurrentDir(originalDirectory));
      originalDirectory:=NIL;
    END;
    IF newDir#NIL THEN UnLock(newDir); newDir:=NIL END;
  END ForgetPathTable;


(* falls wir aus einer SubDir gestartet wurden, wechseln wir ins ParentDir *)
PROCEDURE SetProjectDir;
 VAR
   dirInfo: FileInfoBlockPtr;
   ft: FileType;
   eq: BOOLEAN;
   i:INTEGER;
 BEGIN
   ASSEMBLE(
	MOVE.L	thisTask(A4),A0
	MOVE.L	Process.currentDir(A0),originalDirectory(A4)
   END);
   Allocate(dirInfo,SIZE(dirInfo^));
   Assert(dirInfo#NIL,ADR(memOverFlow));
   eq:=FALSE;
   IF Examine(originalDirectory,dirInfo) THEN
     ft:=MIN(FileType);
     REPEAT
       eq:=TRUE;
       FOR i:=0 TO 2 DO
         eq:=eq & (CAP(dir[ft]^[i])=CAP(dirInfo^.fileName[i]));
       END;
       (*$ RangeChk:=FALSE *)
       INC(ft);
       (*$ POP RangeChk *)
     UNTIL eq OR (ft>MAX(FileType));
   END;
   IF eq THEN
     newDir:=ParentDir(originalDirectory); (* neues Lock, merken! *)
     SETREG(0,CurrentDir(newDir));
   ELSE
     newDir:=NIL;
   END;
   Deallocate(dirInfo);
END SetProjectDir;


PROCEDURE ReadPathTable(name: ARRAY OF CHAR);
VAR
 ch: CHAR;
 f: FileHandlePtr;
 eof: BOOLEAN;
 i: INTEGER;
 entry: Path;
 lastEntry: PathEntryPtr;
 zero: INTEGER;

 PROCEDURE AddEntry;
 TYPE CharPtr = POINTER TO CHAR;
 VAR
   path: PathEntryPtr;
   cp1,cp2:CharPtr;
 BEGIN
   Allocate(path,SIZE(PathEntry)-SIZE(Path)+i+1);
   Assert(path#NIL,ADR(memOverFlow));
   cp1:=ADR(path^.path); cp2:=ADR(entry);
   WHILE cp2^#nul DO
     cp1^:=cp2^;
     INC(cp1); INC(cp2);
   END;
   cp1^:=nul;
   (* Copy(path^.path,entry); Copy kopiert den GANZEN String!!!! *)
   path^.next:=NIL;
   lastEntry^.next:=path;
   lastEntry:=path
 END AddEntry;

(*$ CopyDyn:=FALSE *)
BEGIN
  ForgetPathTable; (* alten lschen und in alte Dir wechseln, UnLocken *)
  SetProjectDir; (* ins Project heruntergehen, falls in SubDir *)
  lastEntry:=ADR(userPath);
  f:=Open(ADR(name),oldFile);
  IF f#NIL THEN
    eof:=Read(f,ADR(ch),1)#1; i:=0;
    WHILE ~eof DO
      IF (ch=lf) & (i#0) THEN
        ch:=entry[i-1];
        IF (ch#":") & (ch#"/") THEN
          entry[i]:="/"; INC(i)
        END;
        entry[i]:=nul;
        AddEntry;
        i:=0
      ELSIF i<maxPathLen THEN
        entry[i]:=ch; INC(i)
      END;
      eof:=Read(f,ADR(ch),1)#1
    END;
    Close(f)
  END;
  lastEntry^.next:=defaultPath;
(*
 * debug
 *
 * lastEntry:=userPath;
 *  WHILE lastEntry#NIL DO
 *   WriteString(lastEntry^.path); WriteLn;
 *   lastEntry:=lastEntry^.next
 *  END
 *)
END ReadPathTable;


BEGIN (* M2File *)
  dir[symFile]:=ADR("sym/");dir[refFile]:=ADR("ref/");dir[objFile]:=ADR(obName);
  dir[ob1File]:=ADR(obName);dir[ob2File]:=ADR(obName);dir[ob3File]:=ADR(obName);
  dir[ob4File]:=ADR(obName);dir[ob8File]:=ADR(obName);
  dir[modFile]:=ADR(txName);dir[defFile]:=ADR(txName);dir[binFile]:=ADR("bin/");
  ext[symFile]:=ADR(".sym");ext[refFile]:=ADR(".ref");ext[objFile]:=ADR(".obj");
  ext[ob1File]:=ADR(".ob1");ext[ob2File]:=ADR(".ob2");ext[ob3File]:=ADR(".ob3");
  ext[ob4File]:=ADR(".ob4");ext[ob8File]:=ADR(".ob8");
  ext[modFile]:=ADR(".mod");ext[defFile]:=ADR(".def");ext[binFile]:=ADR(Empty);
(* IMMER mit 0 initialisiert!
 * userPath:=NIL; defaultPath:=NIL; newDir:=NIL; originalDirectory:=NIL;
 *)
  ReadPathTable(systemPath);
  defaultPath:=userPath;
  ForgetPathTable; (* auf jeden fall wieder in StartDir gehen!! *)
CLOSE
  ForgetPathTable;
  defaultPath:=NIL;
  ForgetPathTable;
END MkFile.mod
