IMPLEMENTATION MODULE MkDpd;
(*$ LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE *)
(* 23.2.89/ms
 *
 * Die Einlese- bzw. Schreibroutinen beschrnken sich auf die ntige
 * Informationen und erzeugen dadurch mglichst kleine .dpd Dateien.
 *)

FROM SYSTEM IMPORT ADDRESS, ADR;

FROM Arts IMPORT
  ModName;

FROM FileSystem	IMPORT
  File, Response, Close, Lookup, ReadByteBlock, WriteByteBlock;

FROM String IMPORT
  Copy, Compare, Concat;

FROM Terminal IMPORT
  FormatS;

FROM M2Amiga IMPORT
  MakeIcon;

FROM MkBase IMPORT
  ModPtr, ImportPtr, FileName, quiet, mainMod, modList, isLinkable,
  AddMod, AddImport, CleanList;


CONST
  dpdExt=".dpd";
  bufSize=2048;
  dpdFileId=44504433H;
  emptyMod='@#+JR*!%&^';


PROCEDURE MakeFileName(VAR fName, modName: ARRAY OF CHAR);
  BEGIN
    Copy(fName, modName);
    Concat(fName, dpdExt);
  END MakeFileName;


PROCEDURE OutDpd(icon: BOOLEAN);
  VAR
    f: File;
    fName: FileName;
    li: LONGINT;
    i: INTEGER;
    n: ModName;
    imp: ImportPtr;
    m1, m2: ModPtr;
  BEGIN
    MakeFileName(fName, mainMod^.name);
    Lookup(f, fName, bufSize, TRUE);
    IF f.res=done THEN
      IF ~quiet THEN FormatS(" + %s\n", fName) END;
      li:=dpdFileId; WriteByteBlock(f, li);
      WriteByteBlock(f, isLinkable);

      m1:=modList; m2:=NIL; WHILE m1#NIL DO m2:=m1; m1:=m1^.next END;
      WHILE m2#NIL DO
        WriteByteBlock(f, m2^.name); WriteByteBlock(f, m2^.type);
        m2:=m2^.prev
      END;
      n:=emptyMod; WriteByteBlock(f, n);

      m1:=modList;
      WHILE m1#NIL DO
        imp:=m1^.importList;
        WHILE imp#NIL DO
          i:=imp^.importedMod^.num; IF imp^.importedByDef THEN i:=-i END;
          WriteByteBlock(f, i);
          imp:=imp^.next
        END;
        i:=0; WriteByteBlock(f, i);
        m1:=m1^.next
      END;

      IF icon & (f.res=done) THEN MakeIcon(fName, "dpd") END;
      Close(f)
    END
  END OutDpd;


PROCEDURE InDpd(VAR modName: ModName): BOOLEAN;
  VAR
    f: File;
    fName: FileName;
    li: LONGINT;
    i: INTEGER;
    n: ModName;
    m1, m2: ModPtr;
    ok: BOOLEAN;
  BEGIN
    CleanList;
    MakeFileName(fName, modName);
    Lookup(f, fName, bufSize, FALSE);
    IF f.res=done THEN
      IF ~quiet THEN FormatS(" - %s\n", fName) END;
      ReadByteBlock(f, li);
      ok:=(f.res=done) & (li=dpdFileId);
      IF ok THEN
        ReadByteBlock(f, isLinkable);

        LOOP
          ReadByteBlock(f, n);
          IF Compare(n, emptyMod)=0 THEN EXIT END;
          m1:=AddMod(n); ReadByteBlock(f, m1^.type)
        END;
        m1:=modList;
        WHILE m1#NIL DO
          LOOP
            ReadByteBlock(f, i);
            IF i=0 THEN EXIT END;
            m2:=modList; WHILE (m2#NIL) & (m2^.num#ABS(i)) DO m2:=m2^.next END;
            IF m2=NIL THEN ok:=FALSE
            ELSE AddImport(m1, m2, i<0)
            END
          END;
          m1:=m1^.next
        END;
        ok:=ok & (f.res=done)
      END;
      Close(f)
    END;
    RETURN ok
  END InDpd;


END MkDpd.mod
