IMPLEMENTATION MODULE MkBase;
(*$
  LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE
  Volatile:=FALSE
  DEFINE English:=FALSE
  DEFINE Debug:=FALSE
*)


FROM SYSTEM IMPORT ADR, ASSEMBLE;

FROM Arts IMPORT
  maxModName, ModName, Assert;

FROM ASCII IMPORT
  nul;

FROM DosD IMPORT
  sharedLock, Date, FileInfoBlockPtr, FileLockPtr;
FROM DosL IMPORT
  Examine, Lock, UnLock;

FROM Heap IMPORT
  Allocate, Deallocate;

FROM String IMPORT
  Compare;

FROM Terminal IMPORT
  FormatS, WriteString;


CONST
(*$ IF English *)
  noMem = "m2make: Insufficient Memory!";

(*$ ELSE *)
  noMem = "m2make: Speichermangel";

(*$ ENDIF *)


PROCEDURE AddMod(n: ModName): ModPtr;
  VAR
    m: ModPtr;
    i: INTEGER;
  BEGIN
    Allocate(m, SIZE(ModRec)); Assert(m#NIL, ADR(noMem));
    WITH m^ DO
      prev:=NIL; next:=modList;
      (* name:=n; but fill the rest with 0C *)
      i:=0;
      WHILE (i<SIZE(ModName)) & (n[i]#0C) DO name[i]:=n[i]; INC(i) END;
      WHILE i<SIZE(ModName) DO name[i]:=0C; INC(i) END;
      type:=noSource;
      IF modList=NIL THEN num:=1; mainMod:=m
      ELSE num:=modList^.num+1; modList^.prev:=m
      END;
      (* importList:=NIL; srcRead:=FALSE *)
    END;
    modList:=m;
    RETURN m
  END AddMod;


PROCEDURE FindMod(name: ModName): ModPtr;
  VAR
    m: ModPtr;
  BEGIN
    m:=modList;
    WHILE m#NIL DO
      IF Compare(m^.name, name)=0 THEN RETURN m END;
      m:=m^.next
    END;
    RETURN AddMod(name)
  END FindMod;


PROCEDURE AddImport(m, imp: ModPtr; mIsDef: BOOLEAN);
  VAR
    i: ImportPtr;
  BEGIN
    Allocate(i, SIZE(ImportRec)); Assert(i#NIL, ADR(noMem));
    WITH i^ DO
      next:=m^.importList; m^.importList:=i;
      importedMod:=imp; importedByDef:=mIsDef
    END
  END AddImport;


PROCEDURE DependsOn(a: ModPtr; bName: ModName; aIsDef: BOOLEAN; VAR err: BOOLEAN);
(*
  Module 'a' depends on module 'b', this means: 'a' imports 'b'.
  If 'a' is an implementation or program module (aIsDef=FALSE), then we just
  insert 'b' in the 'importList' of 'a'.
  If 'a' is a definition module (aIsDef=TRUE) we check for illegal imports
  (directly or indirectly cyclic!!).

  We do this by maintaining an order on 'modList': if 'a' imports 'b',
  'b' must precede 'a' in the list. For convenience the modules in the
  list are numbered (big numbers in the beginning, small numbers at the end).
  If we have to rearrange the list (procedure 'backwards') this order has to
  be maintained.
*)

  PROCEDURE backwards(x: ModPtr): BOOLEAN;
    VAR
      n: ModPtr;
      i: ImportPtr;
    BEGIN
      IF x=NIL THEN RETURN FALSE END; (* beginning of the list *)
      n:=x^.next;
      IF n=NIL THEN RETURN FALSE END; (* end of the list *)

      i:=n^.importList;
      LOOP
        IF i=NIL THEN EXIT END;
        IF i^.importedMod=x THEN
          IF i^.importedByDef THEN RETURN FALSE END;
          EXIT
        END;
        i:=i^.next
      END;

      (* flip 'x' and 'n' *)
      n^.prev:=x^.prev;
      IF x^.prev#NIL THEN x^.prev^.next:=n ELSE modList:=n END;
      x^.prev:=n;
      x^.next:=n^.next;
      IF n^.next#NIL THEN n^.next^.prev:=x END;
      n^.next:=x;

      DEC(x^.num); INC(n^.num);
      RETURN TRUE
    END backwards;

  TYPE
    StackPtr = POINTER TO StackRec;
    StackRec = RECORD
      mod: ModPtr;
      prev: StackPtr
    END;

  VAR
    st, stPrev: StackPtr;
    b, t: ModPtr;
    i: ImportPtr;
  BEGIN
(*$ IF Debug *)
    WriteString('<<Depends..');
(*$ ENDIF *)
    IF Compare(bName, 'SYSTEM')=0 THEN RETURN END;
    b:=FindMod(bName);
    err:=FALSE;
    IF aIsDef THEN          (* sort the 'modList' *)
(*
      WHILE (a^.num>b^.num) & backwards(a)       DO END;
      WHILE (a^.num>b^.num) & backwards(b^.prev) DO END;
      IF a^.num>b^.num THEN
        FormatS('DEF von %s und ', bName);
        FormatS('%s importieren sich gegenseitig', a^.name);
        err:=TRUE
      END;
*)
      Allocate(st, SIZE(StackRec)); st^.mod:=NIL; st^.prev:=NIL;
      t:=a;
      LOOP
        IF t^.num<b^.num THEN
          t:=st^.mod; stPrev:=st^.prev; Deallocate(st); st:=stPrev;
          IF t=NIL THEN EXIT END
        END;
        IF ~backwards(t) THEN
          stPrev:=st; Allocate(st, SIZE(StackRec)); st^.prev:=stPrev; st^.mod:=t;
          t:=t^.next;
          IF t=b THEN
            FormatS('DEF von %s und ', bName);
            FormatS('%s importieren sich gegenseitig', a^.name);
            err:=TRUE;
            WHILE st#NIL DO stPrev:=st^.prev; Deallocate(st); st:=stPrev END;
            EXIT
          END
        END
      END
    END;

    i:=a^.importList;
    WHILE (i#NIL) & (i^.importedMod#b) DO i:=i^.next END;
    IF i=NIL THEN AddImport(a, b, aIsDef)
    ELSIF aIsDef THEN i^.importedByDef:=TRUE
    END;
(*$ IF Debug *)
    WriteString('..end>>')
(*$ ENDIF *)
  END DependsOn;


PROCEDURE GetDate(VAR fn: ARRAY OF CHAR; VAR date: Date): BOOLEAN;
  VAR
    lock: FileLockPtr;
    fileInfo: FileInfoBlockPtr;
    result: BOOLEAN;
  BEGIN
    result:=FALSE;
    WITH date DO
      days:=0; minute:=0; tick:=0
    END;
    IF fn[0]#0C THEN
      Allocate(fileInfo, SIZE(fileInfo^));
      Assert(fileInfo#NIL, ADR(noMem));
      lock:=Lock(ADR(fn), sharedLock);
      IF lock#NIL THEN
        IF Examine(lock, fileInfo) THEN
          date:=fileInfo^.date;
          result:=TRUE
        END;
        UnLock(lock);
      END;
      Deallocate(fileInfo);
    END;
    RETURN result
  END GetDate;


PROCEDURE CleanList;
  VAR
    m, nxtM: ModPtr;
    nxtI: ImportPtr;
  BEGIN
    m:=modList;
    WHILE m#NIL DO
      WITH m^ DO
        WHILE importList#NIL DO
          nxtI:=importList^.next; Deallocate(importList); importList:=nxtI
        END;
        nxtM:=next; Deallocate(m); m:=nxtM
      END
    END;
    modList:=NIL; mainMod:=NIL
  END CleanList;

BEGIN
  modList:=NIL
END MkBase.mod
