IMPLEMENTATION MODULE M2OM;
(* 16.8.90/bp Optionen-Modul *)
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
*)
(*$ DEFINE ShowStack:=FALSE *)
(*$ DEFINE English:=FALSE *)

(* Problem:
 * Bei Angabe von CmdLin
 * Ich mache nun:
 * +name (erzeugt evtl.) und setzt auf +
 * -name (erzeugt evtl.) und setzt auf -
 * Dabei wird der Speicher aber erst bei Programmende freigegeben!
 *
 * Noch'n Problem:
 * POP macht DIV 2, d.h. er schiebt mit 1 nach, mte aber mit
 * dem default nachschieben! Aber bei 32 Leveln macht das nichts!
 *
 * Einfacher wre ein IFDEF gewesen!!! Und ganz ohne Expressions!
 *)
FROM SYSTEM	IMPORT	ADR,ADDRESS,CAST,ASSEMBLE;
FROM M2DM	IMPORT	Ident, ALLOCATE, AllocLev0,Diff;
FROM Heap	IMPORT	Allocate,Deallocate;
FROM Arts	IMPORT	BreakPoint,thisTask,wbStarted;
FROM ExecL	IMPORT	AddTail, Remove, CopyMem;
FROM ExecSupport IMPORT NewList;
FROM Terminal	IMPORT	Write,WriteString,WriteLn,Format,waitCloseGadget,FormatNr;
(*$ IF ShowStack *)
IMPORT StackSize;
(*$ ENDIF *)

CONST
  OpStatusMsg='+C +E +F +H +J +L +N +R +S +V +X +Y +Z  +D +I +P +W CPU:0\n';
  cpuPos=56;
  debugPos=40;
  iconPos=43;
  profilePos=46;
  warningsPos=49;

TYPE
  OptTypes=(standard,userText,userCmdText,userCmd);
  (*
   * userText: nur im Text DEFINEd
   * userCmdText: in CmdLin und Text defined
   * userCmd; nur von CmdLin, heit Undefined!!!
   * Die letzten beiden switchen hin und her!
   *)
  StrPtr=POINTER TO ARRAY[0..31] OF CHAR; (* Nur fr Debugger! *)
  OptRecPtr = POINTER TO OptRec;
  OptRec=RECORD
    succ,pred:OptRecPtr;
    name:Ident;
    stack:LONGINT;
    default:LONGINT;
    frozen:BOOLEAN; (* aktueller Status *)
    oneShot:BOOLEAN; (* nur:=FALSE *)
    option:Options;
    typ:OptTypes;
  END;
  OptList=RECORD head,tail,tailPred:OptRecPtr END;

VAR
 OptRecs:OptList;
 CompRecs:ARRAY CompOpts OF OptRecPtr;
 opMsg:ARRAY[0..59] OF CHAR;



PROCEDURE FindOpt(id{9}:Ident):OptRecPtr;
VAR op{13B}:OptRecPtr;
BEGIN
  op:=OptRecs.head;
  WHILE (op^.succ#NIL)&(Diff(op^.name,id)#0) DO op:=op^.succ END;
  IF op^.succ#NIL THEN RETURN op ELSE RETURN NIL END;
END FindOpt;

PROCEDURE ShowIdVal(id:Ident;val:BOOLEAN);
VAR s:ARRAY[0..79] OF CHAR; l:LONGINT;
BEGIN
  IF verbose THEN
    IF val THEN s[0]:='+' ELSE s[0]:='-' END;
    l:=id^.len;
    IF l<80 THEN
      CopyMem(ADR(id^.buf),ADR(s[1]),l);
      s[l+1]:=0C;
      WriteString(s);
    END;
  END;
END ShowIdVal;

(* fr Option-Parser: *)

(*$ ReturnChk:=FALSE *)
PROCEDURE KeepHeapId(id{8}:Ident): Ident;
VAR
 idn: Ident;
BEGIN
 Allocate(idn,id^.len+2);
 ASSEMBLE(
	(*LEA	idBuffer(A4),A0*)
	(* 20.12.90/bp *)
	MOVE.W	(A0),D1 (* mind. 0 *)
	MOVE.L	idn(A5),D0 (* return *)
	MOVE.L	D0,A1
	ADDQ.W	#1,D1
    lp:	MOVE.B	(A0)+,(A1)+
    	DBRA	D1,lp
 END);
(* CopyMem(ADR(idBuffer),id,l); *)
(* RETURN id *)
END KeepHeapId;
(*$ POP ReturnChk *)

PROCEDURE HoldNewOption(id{8}:Ident; val{7}:BOOLEAN):BOOLEAN;
(* Kommandozeile!
 * Wenn val=TRUE, dann setzen und/oder neu anlegen
 * Wenn val=FALSE, dann lschen und/oder neu anlegen
 * Wenn NIL dann anlegen op:=val
 * #NIL&userOpt: wert setzen
 * #NIL: error: standardopt
 *)
VAR op:OptRecPtr;
BEGIN
(*BreakPoint(ADR('vor holdnew'));*)
  op:=FindOpt(id);
  IF op=NIL THEN
    Allocate(op,SIZE(op^));
    op^.typ:=userCmd;
    op^.name:=KeepHeapId(id);
    IF val THEN
      op^.stack:=-1;
      op^.default:=-1;
    ELSE
      op^.stack:=0;
      op^.default:=0;
    END;
   (*
    op^.oneShot:=FALSE;
    op^.frozen:=FALSE;
    *)
    op^.option:=userOpt;
    AddTail(ADR(OptRecs),op);
    RETURN TRUE;
  ELSIF op^.typ#standard THEN (* KANN DANN nur userCmd sein! *)
    WITH op^ DO
      IF val THEN
        stack:=-1;
        default:=-1;
      ELSE
        stack:=0;
        default:=0;
      END;
      RETURN TRUE;
    END;
  ELSE
    RETURN FALSE (* Standard-Option! *)
  END;
END HoldNewOption;

PROCEDURE SetVal(id{8}:Ident; new{6},val{7}:BOOLEAN):OptionError;
(*
 * Wenn new, dannn neu mit val anlegen oder wenn bereits von cmdLine
 * angegeben, dann alten Wert lassen. sonst
 * Pushe Stack der Option id und setze deren Wert auf val.
 *)
VAR op:OptRecPtr; ch:CARDINAL;
BEGIN
  op:=FindOpt(id);
  IF new THEN
    WriteString(' !! DEFINE: '); ShowIdVal(id,val);
    IF op=NIL THEN (* DEFINE.. ohne CommandLine! *)
      AllocLev0(op,SIZE(op^));
      (* op^.typ:=FALSE *)
      op^.name:=id;
      IF val THEN
        op^.stack:=-1;
        op^.default:=-1;
      ELSE
        op^.stack:=0;
        op^.default:=0;
      END;
      (*op^.oneShot:=FALSE;*)
      op^.typ:=userText;
      (*op^.frozen:=FALSE;*)
      op^.option:=userOpt;
      AddTail(ADR(OptRecs),op);
      WriteLn;
      RETURN optOk;
    ELSIF op^.typ=userCmd THEN (* Kommandozeile hat Vorrang!*)
      op^.typ:=userCmdText;	  (* Wert so lassen! *)
      IF op^.default=0 THEN ch:=ORD('-') ELSE ch:=ORD('+') END;
      (*$ IF English *)
      Format(' (Value ignored, stays "%c"!)\n',ADR(ch));
      (*$ ELSE *)
      Format(' (Wert ignoriert, bleibt "%c"!)\n',ADR(ch));
      (*$ ENDIF *)
      RETURN optOk;
    ELSE (*  Doppeldef! *)
      WriteLn;
      RETURN optDefined;
    END;
  ELSE (* nicht new, normale Zuweisung *)
    IF (op#NIL)&(op^.typ#userCmd) THEN

      WITH op^ DO
        IF frozen THEN RETURN optFrozen
        ELSIF	oneShot (* val mu#default und Option mu=default sein *)
		&(
          	     (default<0)&( val OR ~ODD(stack))
          	   OR(default=0)&(~val OR  ODD(stack))
          	 )
          	& NOT ((option=genDebug) & (default=0) & ~val) (* GenDebug darf nur AUS pro Proc *)
          	THEN
          RETURN optSingleShot (* nur:= 1mal FALSE *)
        ELSE
          (*$ OverflowChk:=FALSE *)
          stack:=stack*2;
          IF val THEN INC(stack) END;
          (*$ POP OverflowChk *)
          Option[option]:=val;
          RETURN optOk;
        END;
      END;
    ELSE
      RETURN optUndefined
    END;
  END; (* new *)
END SetVal;

PROCEDURE GetVal(id{8}:Ident; VAR val{10}:BOOLEAN):BOOLEAN;
VAR op{13B}:OptRecPtr;
BEGIN
  op:=FindOpt(id);
  IF (op#NIL)&(op^.typ#userCmd) THEN
    val:=ODD(op^.stack);RETURN TRUE
  ELSE
    val:=FALSE; RETURN FALSE
  END;
END GetVal;

PROCEDURE Pop(id{8}:Ident):OptionError;
VAR op{13B}:OptRecPtr;
BEGIN
  op:=FindOpt(id);
  IF (op#NIL)&(op^.typ#userCmd) THEN
    IF op^.frozen THEN RETURN optFrozen
    ELSIF op^.oneShot THEN RETURN optSingleShot
    ELSE
      (*$ OverflowChk:=FALSE *)
      op^.stack:=op^.stack DIV 2;
      (*$ POP OverflowChk *)
      IF op^.option#userOpt THEN Option[op^.option]:=ODD(op^.stack) END;
      RETURN optOk;
    END;
  ELSE
    RETURN optUndefined
  END;
END Pop;

(* fr Compiler: *)

PROCEDURE HoldOption(o{6}:CompOpts; v{7}:BOOLEAN);
BEGIN
  WITH CompRecs[o]^ DO
    IF v THEN
        stack:=-1;
        default:=-1;
    ELSE
        stack:=0;
        default:=0;
    END;
    Option[o]:=v;
  END;
END HoldOption;

PROCEDURE PushOption(o{6}:CompOpts; v{7}:BOOLEAN);
BEGIN
  WITH CompRecs[o]^ DO
    (*$ OverflowChk:=FALSE *)
    stack:=stack*2;
    IF v THEN INC(stack) END;
    (*$ POP OverflowChk *)
    Option[o]:=v;
  END;
END PushOption;

PROCEDURE PopOption(o{6}: CompOpts);
BEGIN
  WITH CompRecs[o]^ DO
    (*$ OverflowChk:=FALSE *)
    stack:=stack DIV 2;
    (*$ POP OverflowChk *)
    Option[o]:=ODD(stack);
  END;
END PopOption;

PROCEDURE SetFreezeOptions(set{5}: OptionsSet; val{7}:BOOLEAN);
VAR o:CompOpts;
BEGIN
  FOR o:=MIN(CompOpts) TO MAX(CompOpts) DO
    IF o IN set THEN
      CompRecs[o]^.frozen:=val;
    END;
  END;
END SetFreezeOptions;

PROCEDURE FreezeOptions(set{6}: OptionsSet);
BEGIN
  SetFreezeOptions(set,TRUE);
END FreezeOptions;

PROCEDURE UnFreezeOptions(set{6}: OptionsSet);
BEGIN
  SetFreezeOptions(set,FALSE);
END UnFreezeOptions;

PROCEDURE SetCPU(ch{3}:CHAR); (* nur '0'..'4','8'!! *)
VAR o{7}:CompOpts;
    cpu{2}:OptionsSet;
BEGIN
  cpuCh:=ch; (* merken fr ShowOpts *)
 (* Dies ist immer noch sehr lax, aber fr den Compiler ausreichend! *)
  CASE ch OF
  | '0': cpu:=OptionsSet{}; (* nichts *)
  | '1': cpu:=OptionsSet{m68010};
  | '2': cpu:=OptionsSet{m68010,m68020};
  | '3': cpu:=OptionsSet{m68010,m68020,m68030};
  | '4': cpu:=OptionsSet{m68010,m68020,m68040,m68881}; (* bis auf 30er alles *)
  | '8': cpu:=OptionsSet{m68010,m68020,m68030,m68881};
  END;
  FOR o:=m68010 TO m68881 DO
    HoldOption(o,o IN cpu);
  END;
END SetCPU;

PROCEDURE ShowOpts;
VAR ch:CHAR; o:Options; i,l:INTEGER; op:OptRecPtr; str:Ident;

  PROCEDURE putPM(pos{7}:INTEGER; b:BOOLEAN);
  VAR ch{0}:CHAR;
  BEGIN
    IF b THEN ch:='+' ELSE ch:='-' END;
    opMsg[pos]:=ch;
  END putPM;

BEGIN
  WriteString(' Status: ');
  i:=0; (* String mu passen! *)
  FOR ch:='A' TO 'Z' DO
    o:=optArr[ch];
    IF o#userOpt THEN
      putPM(i,Option[o]);
      INC(i,3);
    END;
  END;
  putPM(debugPos,debug);
  putPM(iconPos,iconOn);
  putPM(profilePos,profile);
  putPM(warningsPos,warnings);
  opMsg[cpuPos]:=cpuCh;
  WriteString(opMsg);
  (*$ IF English *)
  WriteString(' User Options:');
  (*$ ELSE *)
  WriteString(' Benutzer-Optionen:');
  (*$ ENDIF *)
  op:=CompRecs[MAX(CompOpts)]^.succ;
  IF op^.succ#NIL THEN
    REPEAT
      Write(' ');
      WITH op^ DO
	ShowIdVal(name,default#0);
      END;
      op:=op^.succ;
    UNTIL op^.succ=NIL;
  ELSE
    (*$ IF English *)
    WriteString(' none');
    (*$ ELSE *)
    WriteString(' keine');
    (*$ ENDIF *)
  END;
  WriteLn;
END ShowOpts;

PROCEDURE InitM2OM;
(* alle auf default setzen, ~typ:lschen! *)
VAR o:OptRecPtr;
BEGIN
(*BreakPoint(ADR('vor clean om'));*)
  o:=OptRecs.head;
  WHILE o^.succ#NIL DO
    WITH o^ DO
      stack:=default; (* Default kann nur von Commline verndert werden! *)
      frozen:=FALSE;
      Option[option]:=ODD(stack); (* macht nichts! *)
      IF typ=userText THEN
        Remove(o);
      ELSIF typ=userCmdText THEN
        typ:=userCmd (* wieder undefined *)
      END;
      o:=succ;
    END;
  END;
(*BreakPoint(ADR('nach clean om'));*)
END InitM2OM;

PROCEDURE PutVal(id{12B}:Ident; op{2B}:CompOpts);
VAR o:OptRecPtr;
BEGIN
  ALLOCATE(o,SIZE(o^));
  WITH o^ DO
    name:=id;
    IF op IN firstDefault THEN
      stack:=-1; default:=-1;
    ELSE stack:=0; default:=0;
    END;
    (*frozen:=FALSE;*)
    oneShot:=op IN oneShots;
    option:=op;
    typ:=standard;
  END;
  AddTail(ADR(OptRecs),o);
  CompRecs[op]:=o;
  Option[op]:=op IN firstDefault;
END PutVal;

BEGIN
  NewList(ADR(OptRecs));
  PutVal(ADR('\o\x08STACKCHK'),stkchk);	(* s *)
  PutVal(ADR('\o\x06NILCHK'),nilchk);	(* n *)
  PutVal(ADR('\o\x08RANGECHK'),rngchk);	(* r *)
  PutVal(ADR('\o\x0bOVERFLOWCHK'),ovflchk);(* v *)
  PutVal(ADR('\o\x07CASECHK'),casechk);	(* c *)
  PutVal(ADR('\o\x09RETURNCHK'),retchk);	(* f *)
  PutVal(ADR('\o\x09LONGALIGN'),longWordAlign); (* l *)
  PutVal(ADR('\o\x08VOLATILE'),volatile);	(* h *)
  PutVal(ADR('\o\x0aSTACKPARMS'),safeParmPass); (* z *)
  PutVal(ADR('\o\x08CSTRINGS'),cStrings);
  PutVal(ADR('\o\x05JOKER'),joker);	 (* j *)
  PutVal(ADR('\o\x08GENDEBUG'),genDebug);	 (* x *)
  PutVal(ADR('\o\x0dENTRYEXITCODE'),entcode);
  PutVal(ADR('\o\x0aENTRYCLEAR'),entryClear);   (* e *)
  PutVal(ADR('\o\x07COPYDYN'),copyDyn);
  PutVal(ADR('\o\x0aPARDEALLOC'),pardealloc);
  PutVal(ADR('\o\x06LOADA4'),loadA4);
  PutVal(ADR('\o\x06SAVEA4'),saveA4);
  PutVal(ADR('\o\x0bSAVEALLREGS'),saveAllRegs);
  PutVal(ADR('\o\x0eIMPLEMENTATION'),withimp);
  PutVal(ADR('\o\x07NAMECHK'),namechk);
  PutVal(ADR('\o\x09LARGEVARS'),largeVars);
  PutVal(ADR('\o\x07CHIPBSS'),chipBss);
  PutVal(ADR('\o\x08CHIPCODE'),chipCode);
  PutVal(ADR('\o\x08CHIPDATA'),chipData);

  PutVal(ADR('\o\x06M68010'),m68010); (* 0..8 *)
  PutVal(ADR('\o\x06M68020'),m68020);
  PutVal(ADR('\o\x06M68030'),m68030);
  PutVal(ADR('\o\x06M68040'),m68040);
  PutVal(ADR('\o\x06M68881'),m68881);
  SetCPU('0'); (* !! *)
  optArr['A']:=userOpt;
  optArr['B']:=userOpt;
  optArr['C']:=casechk;
  optArr['D']:=userOpt;
  optArr['E']:=entryClear;
  optArr['F']:=retchk;
  optArr['G']:=userOpt;
  optArr['H']:=volatile;
  optArr['I']:=userOpt;
  optArr['J']:=joker;
  optArr['K']:=userOpt;
  optArr['L']:=longWordAlign;
  optArr['M']:=userOpt;
  optArr['N']:=nilchk;
  optArr['O']:=userOpt;
  optArr['P']:=userOpt;
  optArr['Q']:=userOpt;
  optArr['R']:=rngchk;
  optArr['S']:=stkchk;
  optArr['T']:=userOpt;
  optArr['U']:=userOpt;
  optArr['V']:=ovflchk;
  optArr['W']:=userOpt;
  optArr['X']:=genDebug;
  optArr['Y']:=largeVars;
  optArr['Z']:=safeParmPass;
  opMsg:=OpStatusMsg;
  debug:=TRUE; optiCode:=FALSE; (* ~debug! *)
  verbose:=TRUE;
  iconOn:=wbStarted;
  profile:=FALSE;
  warnings:=TRUE;

END M2OM.mod
