IMPLEMENTATION MODULE M2HM;
(* 28.2.90/bp
 *	Optimierung ADD2: addql,subql fr ,Ax
 *	Optimierung, lokale Speedys (mark put16 etc in Assembler und Reg-PAras
 * 3.3.90/bp
 *	Optimierung SHI2 wieder zurck, bremste bei 68020!
 *	neu ADD2: Lea.. statt ADDA.L
 *	In Cmp2 fr imm+quick ein LoadD eingefgt
 *)
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
*)
(*$ DEFINE CompGens:=TRUE *)

FROM SYSTEM IMPORT
 BITSET,SHORTSET,CAST,LONGSET,SHIFT,WORD,ASSEMBLE,ADR,ADDRESS;
FROM Assembler IMPORT
 d0,d1,d2,d3,d4,d5,d6,d7,a0,a1,a2,a3,a4,a5,a6,a7,nbit,zbit,vbit,cbit
 ,ddir,adir,aidr,ainc,adec,aoff,aidx,absW,absL,prel,imm
 ,ls3,ls4,ls5,ls6,ls7,ls8,ls9,ls10,ls11,ls12
 ,addB,addaL,addiB,addqB,addqW,addmL,addqL,andB,andiB,andiW,asliB,asriB,asriL
 ,bcc,bcs,beq,bge,bhi,bls,bne,bpl,bra,bseti,bsr,btst,btsti
 ,chkW,clrB,clrW,clrL,cmpB,cmpL,cmpaL,cmpiB,cmpiW,dbra,divsW,divuW,eorB,eoriB
 ,extL
 ,jmp,jsr,lea,linkW,lsliB,lsriB,moveB,moveW,moveL,moveaL,moveqL,movemmL,movemL
 ,mulsW,muluW,negB,negW,negL,notB,orB,oriB,pea,roliB,roriB,rts
 ,subB,subaL,subiB,subqB,subqW,submL,subqL,swapW,trap,trapv,tstB,tstW,unlk,nop,
 rtd;
FROM M2DM IMPORT
 ObjPtr,ObjClass,StrPtr,StrForm,ConstValue,PDesc,Object,Structure,
 tp,maxSCard,minSInt,maxSInt,minInt,maxInt,maxCard,maxLCard,pc,
 maxLInt,byte,word,long,WidType,RegType,Register,RegisterSet,Ident,
 Condition,GlobVarType,VarModes,mainmod,ExportTypes;
FROM M2SM IMPORT Symbol,MarkForm,MarkId,Mark;
FROM M2OM IMPORT Options,Option,CompOpts,optiCode,profile,PushOption,PopOption;
FROM M2TM IMPORT FindInScope;
FROM M2LM IMPORT
 ip,FixLink,MergedLinks,FixShort,FixShortWith,FixupWith,fixup,PCRef,
 Delete, BCondBranch, SubBranch, ExtCall,GetA4,DRel,AbsData,Define,PutWord,
 PutLong,AllocString,ConstRel,AktHunk;
FROM M2RM IMPORT InRef,WriteRefPoint;
FROM M2XM IMPORT
 curLev,Rbusy,Rlock,Rpool,UsedRegs,Item,ItemMode,ItSet,GetReg,
 ReleaseReg,SetbusyReg,Release,Islocked,SetconMd,SetlocMd,SetregMd,
 SetstkMd,SignedT,Gea,Ext,Move,LoadCC,LoadD,Isz,SetcocMd,Jf,
 InvertCC,LoadX,LoadAdr,MoveAdr,LoadP,StackTop,NeedD0,ConstSize,
 UnsignedT,SwapD0,FreeD0,
 LoadA6, AllRegsDestroyed, RegDestroyed, RegsDestroyed, AmigaDestroyed,
 PointersDestroyed,GetConstReg,MoveConstToReg,MoveConstWordToDReg,
 SaveRegs, RestoreRegs,IsByte,IsWord;
FROM Arts IMPORT BreakPoint;
FROM ExecL	IMPORT	CopyMem;

CONST
 sb=a4; mp=a5; lb=a6; sp=a7; fp0=0; fp1=1;
 trapCC = 0101000011111100L; (* f.68020 *)
 chkL=0100000100000000L;
 FWord = 0F200H; (* Standard 1. Wort bei 68881 *)
 fmovemMR=1101000000000000L; (* FMOVE.D ea,FPx *)
 fmovemRM=1110000000000000L; (* FMOVE.D FPx,ea *)

TYPE
 ArtsIx=(modnr,stkChk,halt,mulu32,divu32,muls32,divs32,oplib,closlib);
 ProfIx=(pmodnr,pAllocate,pEnter,pExit,pCall,pReturn);
 DebIx=(dmodnr,dPrBeg,dMdBeg,dP,dPrEnd,dMdEnd);

VAR
 artsMod: ARRAY [modnr..closlib] OF Ident;
 profMod: ARRAY [pmodnr..pReturn] OF Ident;
 debMod:  ARRAY DebIx OF Ident;

 mask:ARRAY [0..32] OF LONGINT;
 hightyp:StrPtr;
 profModName:LONGINT;
 stackAmount,parAmount: LONGINT;
 locVarSize: LONGINT;
 artsmodnr,profmodnr,debmodnr,actRef:INTEGER;
 data,memory,control,alterable:BITSET;
 ShiCode:ARRAY [Asl..Ror] OF CARDINAL;
 trapLoc: ARRAY [13..15] OF INTEGER; (* 28.4.90/bp 13=NilCheck! *)
 stackFixup,saveregsFixup,fsaveFixup,linkFixup,globFixup: INTEGER;
 linkSize:INTEGER; (* codegre des LINK-Befehls 4 oder 10 *)
 stackRegs: INTEGER;
 dynCopied,secondMain:BOOLEAN; (* wichtig fr UnLink-Register-Restore! *)
 inhibitProf:BOOLEAN; (* 18.11.90/bp wird zu TRUE, wenn LoadA4 oder SaveA4! *)
    (* 13.10.91/bp gilt auch fuer gendebug *)

 (*$ IF CompGens *)
 lastHunk:CARDINAL;
 (*$ ENDIF *)

PROCEDURE Assert(ok:BOOLEAN; code:INTEGER);
BEGIN
  IF ~ok THEN Mark(6800+code) END;
END Assert;

PROCEDURE Assertea(ea:INTEGER; allowed:BITSET; code:INTEGER);
VAR
 md:INTEGER;
BEGIN
 md:=ea DIV 8;
 IF ~(md IN allowed) OR (md=7) & ~(((ea MOD 8)+8) IN allowed) THEN
  Mark(6900+code);
 END;
END Assertea;

PROCEDURE Iea(fea:INTEGER):INTEGER;
(* invert the 'mode/reg' effective address to 'reg/mode' representation. *)
BEGIN
  RETURN (fea MOD 8)*8+(fea DIV 8)
END Iea;

PROCEDURE Trap(nr: INTEGER; cc: Condition);
(* 26.5.89/ms
 *	Diese neue Prozedur bernimmt die Erzeugung der TRAP #14/#15
 *	Instruktionen. Diese werden sobald als mglich mit Rckwrts-
 *	Sprngen implementiert. Dies spart einerseits ein paar wenige
 *	Byte Code und andererseits wird die Ausfhrungszeit verkrzt.
 *	Da diese Optimierung den Abbruchpunkt eines Programmes ver-
 *	ndert, muss sie von der Option 'optiCode' abhngig gemacht werden.
 *	Aus dem Prozessor-Handbuch musste ich entnehmen, dass bei
 *	langen Sprngen der Sprung schneller abgearbeitet wird als
 *	das gewhnliche Weitergehen. Ein Vorteil besteht NUR bei kurzen
 *	Sprngen.
 *)
VAR
 distance,op: INTEGER;
BEGIN
 (* 18.6.90/bp *)
 IF Option[m68020] THEN
   PutWord(trapCC+CARDINAL(cc)*ls8);
 ELSE
   distance:=ip-trapLoc[nr]+2;
   IF optiCode & (trapLoc[nr]#0) & (distance<=128) THEN
     BCondBranch(cc,trapLoc[nr]);
   ELSE
     (* mssen wir uns nicht merken! *)
     op:=bra+ORD(InvertCC(cc))*ls8+2;
     PutWord(op);
     trapLoc[nr]:=ip;
     PutWord(trap+nr)
   END
 END;
END Trap;

PROCEDURE GetArts;
VAR
 pno:INTEGER;
 adr:LONGINT;
 arts,obj:ObjPtr;
 i:ArtsIx;
BEGIN
 InRef(artsMod[modnr],arts,adr,pno); (* adr,pno used as dummy *)
 IF arts#NIL THEN
  arts:=arts^.right;
  artsmodnr:=arts^.compmod;
  arts:=arts^.root;
  FOR i:=stkChk TO closlib DO
   obj:=FindInScope(artsMod[i],arts);
   IF obj#NIL THEN
    WITH obj^ DO
     IF class#Proc THEN
      Mark(6001); MarkId(arts^.name);
     END (*IF class*);
    END (*WITH obj^*);
   ELSE
    Mark(6002); MarkId(artsMod[i]);
   END (*IF obj#NIL*);
  END (*FOR i*);
 ELSE
  Mark(6024);
 END (*IF arts#NIL*);
END GetArts;

PROCEDURE GetProfiler;
VAR
 pno:INTEGER;
 adr:LONGINT;
 prof,obj:ObjPtr;
 i:ProfIx;
 c:ConstValue;
BEGIN
 InRef(profMod[pmodnr],prof,adr,pno); (* adr,pno used as dummy *)
 IF prof#NIL THEN
  c.modNr:=0;
  c.inMem:=TRUE;
  AllocString(mainmod^.name,c,TRUE);
  profModName:=c.buffOffset;
  prof:=prof^.right;
  profmodnr:=prof^.compmod;
  prof:=prof^.root;
  FOR i:=pAllocate TO pReturn DO
   obj:=FindInScope(profMod[i],prof);
   IF obj#NIL THEN
    WITH obj^ DO
     IF class#Proc THEN
      Mark(6001); MarkId(prof^.name);
     END (*IF class*);
    END (*WITH obj^*);
   ELSE
    Mark(6002); MarkId(profMod[i]);
   END (*IF obj#NIL*);
  END (*FOR i*);
 ELSE
  Mark(6034);
 END (*IF prof#NIL*);
END GetProfiler;

PROCEDURE GetDebug;
VAR
 pno:INTEGER;
 adr:LONGINT;
 deb,obj:ObjPtr;
 i:DebIx;
 c:ConstValue;
BEGIN
 InRef(debMod[dmodnr],deb,adr,pno); (* adr,pno used as dummy *)
 IF deb#NIL THEN
  c.modNr:=0;
  c.inMem:=TRUE;
  AllocString(mainmod^.name,c,TRUE); (* mehr, mit path! nee: Currentdir reicht! *)
  profModName:=c.buffOffset;
  deb:=deb^.right;
  debmodnr:=deb^.compmod;
  deb:=deb^.root;
  FOR i:=dPrBeg TO MAX(DebIx) DO
   obj:=FindInScope(debMod[i],deb);
   IF obj#NIL THEN
    WITH obj^ DO
     IF class#Proc THEN
      Mark(6001); MarkId(deb^.name);
     END (*IF class*);
    END (*WITH obj^*);
   ELSE
    Mark(6002); MarkId(debMod[i]);
   END (*IF obj#NIL*);
  END (*FOR i*);
 ELSE
  Mark(6035);
 END (*IF deb#NIL*);
END GetDebug;

PROCEDURE ExternalCall(mno:INTEGER; id:Ident; expo:ExportTypes);
(* call of the external procedure id in module #mno. *)
BEGIN
 INCL(UsedRegs,sb+8); (* !!! *)
 ExtCall(mno,id,expo);
 AmigaDestroyed; PointersDestroyed(FALSE); (* nur globVars *)
END ExternalCall;

PROCEDURE OvflTrap(signed:BOOLEAN);
(* overflow-check thru TRAPV or needTrap *)
VAR
 distance: INTEGER;
BEGIN
 IF Option[ovflchk] THEN
  IF signed THEN
   PutWord(trapv);
  ELSE
   Trap(15, CS);
  END;
 END;
END OvflTrap;

PROCEDURE OvflCheck(R:Register; signed:BOOLEAN);
VAR
 Dn:Register;
BEGIN
 IF Option[ovflchk] THEN
  IF signed THEN
   GetReg(Dn,Dreg); (* scratch reg. *)
   PutWord(moveW+Dn*ls9+R); (* copy wordpart *)
   PutWord(extL+Dn);
   PutWord(cmpL+R*ls9+Dn); (* CMP.L Dn,R *)
   RegDestroyed(Dn);
   Trap(15, NE);
   ReleaseReg(Dn)
  ELSE
   PutWord(swapW+R);
   PutWord(tstW+R);
   Trap(15, NE);
   PutWord(swapW+R)
  END
 END
END OvflCheck;

PROCEDURE SetupSL(plev:INTEGER);
(* push Static Link onto stack. *)
CONST
 offSL=8; (* offset of Static Link relative to MP *)
VAR
 N,An:Register;
 n:INTEGER;
BEGIN
 IF plev#0 THEN
  IF plev=curLev THEN     (* level difference=0 *)
   PutWord(pea+aidr+mp);(* PEA (MP) *)
  ELSIF plev+1=curLev THEN(* level difference=1 *)
   PutWord(moveL+sp*ls9+adec*ls3+aoff+mp); (* MOVE.L offSL(MP),-(SP) *)
   PutWord(offSL);
  ELSE                    (* level difference>=2 *)
   GetReg(N,Areg); An:=N MOD 8;
   PutWord(moveaL+An*ls9+aoff+mp); (* MOVEA.L offSL(MP),An *)
   PutWord(offSL);
   n:=curLev-plev;
   WHILE n>2 DO
    DEC(n);
    PutWord(moveaL+An*ls9+aoff+An); (* MOVEA.L offSL(An),An *)
    PutWord(offSL);
   END;
   PutWord(moveL+sp*ls9+adec*ls3+aoff+An); (* MOVE.L offSL(An),-(SP) *)
   PutWord(offSL);
   ReleaseReg(N);
   RegDestroyed(N);
  END;
  INCL(UsedRegs,mp+8);
 END (*plev#0*);
END SetupSL;

PROCEDURE InitM2HM;
VAR
 k:INTEGER;
 exp:LONGINT;
BEGIN
 (*$ IF CompGens *)
 lastProfOff:=-1;
 lastHunk:=10000;
 (*$ ENDIF *)
 curLev:=0;
 inhibitProf:=FALSE;
 ShiCode[Asl]:=asliB; ShiCode[Asr]:=asriB;
 ShiCode[Lsl]:=lsliB; ShiCode[Lsr]:=lsriB;
 ShiCode[Rol]:=roliB; ShiCode[Ror]:=roriB;
 exp:=0; mask[0]:=0; mask[32]:=-1;
 FOR k:=1 TO 31 DO INC(exp,exp+1); mask[k]:=exp END;
 hightyp:=tp.numtyp[long,TRUE];
 (* elements 0..7 correspond to the 'mode' field allowed for <ea>,*)
 (* elements 8..12 to the 'register' field allowed for mode=7. *)
 data:={0,2..7,8..12};
 memory:={2..7,8..12};
 control:={2,5..7,8..11};
 alterable:={0..7,8..9};
 artsMod[modnr]:=  ADR("\o\x04Arts");
 artsMod[stkChk]:= ADR("\o\x06StkChk");
 artsMod[halt]:=   ADR("\o\x0bSystemError");
 artsMod[mulu32]:= ADR("\o\x06Mulu32");
 artsMod[divu32]:= ADR("\o\x06Divu32");
 artsMod[muls32]:= ADR("\o\x06Muls32");
 artsMod[divs32]:= ADR("\o\x06Divs32");
 artsMod[oplib]:=  ADR("\o\x07OpenLib");
 artsMod[closlib]:=ADR("\o\x08CloseLib");

 profMod[pmodnr]:=   ADR("\o\x08Profiler");
 profMod[pAllocate]:=ADR("\o\x08Allocate");
 profMod[pEnter]:=   ADR("\o\x05Enter");
 profMod[pExit]:=    ADR("\o\x04Exit");
 profMod[pCall]:=    ADR("\o\x04Call");
 profMod[pReturn]:=  ADR("\o\x06Return");

 debMod[dmodnr]:=    ADR("\o\x02MD");
 debMod[dPrBeg]:=    ADR("\o\x05PrBeg");
 debMod[dPrEnd]:=    ADR("\o\x05PrEnd");
 debMod[dP]:=        ADR("\o\x01P");
 debMod[dMdBeg]:=    ADR("\o\x05MdBeg");
 debMod[dMdEnd]:=    ADR("\o\x05MdEnd");

 InitTraps;
 secondMain:=FALSE;
 actRef:=0;
END InitM2HM;

PROCEDURE CheckClimit(VAR x:Item; limit:LONGINT);
(* check item associated with x to be in the range [0..limit]. *)
VAR
 sz:WidType;
 distance: INTEGER;
BEGIN
 IF ~Option[rngchk] THEN RETURN END;
 IF (limit<0) THEN Mark(6021) END; (* invalid limit *)
 LoadD(x,FALSE); (* assert x to be loaded into a D-register *)
 Isz(x,sz);
 IF sz<=word THEN (* use CHK-instruction *)
  IF x.wid=byte THEN LoadX(x,word,FALSE); END; (* 18.11.90/bp *)
  PutWord(chkW+x.R*ls9+imm);
  PutWord(INTEGER(limit))
 ELSE (* use CMP-instruction *)
  (* 18.6.90/bp auch CHK.L *)
  IF Option[m68020] THEN
    PutWord(chkL+x.R*ls9+imm);
    PutLong(limit);
  ELSE
    PutWord(cmpiB+long*ls6+x.R);
    PutLong(limit);
    Trap(14, HI);
  END;
 END;
END CheckClimit;

PROCEDURE CallDebug(sysp:DebIx; nr:INTEGER);
(*
 * dPrBeg: (mod:ADDRESS;pno:INTEGER)
 * dMdBeg: (mod:ADDRESS;mno:INTEGER)
 * dP:     (ref:INTEGER)
 * dPrEnd: ()
 * dMdEnd: ()
 *)
BEGIN
  IF Option[genDebug]&Option[entcode] THEN
    IF sysp<=dP THEN
      IF sysp<dP THEN
        PutWord(pea+prel); ConstRel(0,profModName);
      END;
      IF nr=0 THEN
        PutWord(clrW+adec+sp);
      ELSE
        PutWord(moveW+sp*ls9+adec*ls3+imm); PutWord(nr);
      END;
    END;
    ExtCall(debmodnr,debMod[sysp],exported);
  END;
END CallDebug;

PROCEDURE ProcStart(pno:INTEGER);
BEGIN
  CallDebug(dPrBeg,pno);
END ProcStart;

PROCEDURE ModStart(mno:INTEGER);
BEGIN
  CallDebug(dMdBeg,mno);
END ModStart;

PROCEDURE ProcEnd;
BEGIN
  CallDebug(dPrEnd,0);
END ProcEnd;

PROCEDURE ModEnd;
BEGIN
  CallDebug(dMdEnd,0);
END ModEnd;

PROCEDURE RefPoint;
BEGIN
  CallDebug(dP,actRef);
  WriteRefPoint;
  INC(actRef);
END RefPoint;

(* NICHT FR Allocate aufrufen! *)
PROCEDURE CallProf(sysp{7}:ProfIx);
VAR id{6}:INTEGER;
BEGIN
 IF profile & ~inhibitProf THEN
  (*$ IF CompGens *)
     IF (lastProfOff=ip)&(lastHunk=AktHunk) THEN
       Delete(ip-8,8)
     ELSE
       (* Excl ciab.cra,craStart ANDI.B #$00FE,$BFDE00 *)
       PutWord(0239H); PutWord(00FEH); PutLong(0BFDE00H);
     END;
  (*$ ENDIF *)

   (* Parameter: profData,id [,pc] *)
   IF GlobVarType=normVar THEN
     PutWord(moveL+sp*ls9+adec*ls3+aoff+sb); DRel(0,profDataOffset);
   ELSE
     PutWord(moveL+sp*ls9+adec*ls3+absL); AbsData(0,profDataOffset);
   END;
   IF profActAncestor^.class=Proc THEN
     id:=profActAncestor^.pd^.num;
   ELSE
     id:=profActAncestor^.compmod;
   END;
  (*$ IF CompGens *)
   IF id#0 THEN (* KEINE Optimierung, sonst Timing falsch! *)
     PutWord(moveW+sp*ls9+adec*ls3+imm); PutWord(id);
   ELSE
     PutWord(clrW+adec+sp);
   END;
  (*$ ELSE *)
   PutWord(moveW+sp*ls9+adec*ls3+imm);
  (*$ ENDIF *)

   IF (sysp=pEnter) OR (sysp=pExit) THEN
     PutWord(moveW+sp*ls9+adec*ls3+imm); PutWord(ip);
   END;
   ExtCall(profmodnr,profMod[sysp],exported);

  (*$ IF CompGens *)
   (* Incl ciab.cra,craStart ORI.B #$0001,$BFDE00 *)
   PutWord(0039H); PutWord(0001H); PutLong(0BFDE00H);
   lastProfOff:=ip;
   lastHunk:=AktHunk; (* wegen Optimierung BEIDES merken! *)
  (*$ ENDIF *)
  END;
END CallProf;


PROCEDURE CallSystem(sysp{7}:ArtsIx);
BEGIN
 INCL(UsedRegs,sb+8); (* !!! *)
 IF profile THEN (* schneller Compile *)
   IF sysp#stkChk THEN CallProf(pCall) END;
   ExtCall(artsmodnr,artsMod[sysp],exported);
   IF sysp#stkChk THEN CallProf(pReturn) END;
 ELSE
   ExtCall(artsmodnr,artsMod[sysp],exported);
 END;
 AmigaDestroyed;
END CallSystem;

PROCEDURE GenStkChk(s: LONGINT);
(*
 * 25.5.89/ms
 *	GenStkChk legt nur noch die maximal verwendete Anzahl Byte
 *	ab. Dadurch kann der erzeugte Code massgebend verkleinert
 *	werden!
 *)
BEGIN
 IF s<stackAmount THEN stackAmount:=s END
END GenStkChk;

PROCEDURE GenStackCheck(size:LONGINT);
(*
 * 12.8.89/ms
 *	Edgar hat mir mitgeteilt, dass Prozeduren mit Parametern im
 *	d0 keine Freude an dieser Implementation haben. -> d0 wird,
 *	falls belegt, vorbergehend auf dem Stack zwischengelagert.
 * 25.5.89/ms
 *	Dies ist eine neue Prozedur welche StackCheck optimiert.
 *	Die alte Prozedur wurde aus Kompatibilitt beibehalten.
 *	Hier wird ein System-Call erzeugt, der Parameter wird am
 *	Ende des Blocks nachgefhrt.
 *)
BEGIN
  IF Option[stkchk] THEN
   stackRegs:=0;
   IF d0 IN Rbusy THEN
    PutWord(moveL+sp*ls9+adec*ls3);
    INC(stackRegs);
   END;
   PutWord(moveL+d0*ls9+imm);
   stackFixup:=ip;
   PutWord(0); PutWord(0);
   CallSystem(stkChk);
   IF d0 IN Rbusy THEN
    PutWord(moveL+sp+ainc);
   END;
   AmigaDestroyed;
   stackAmount:=0;
   parAmount:=size;
  END
END GenStackCheck;

PROCEDURE GenHalt(haltindex:INTEGER);
BEGIN
 haltindex:=haltindex MOD 256;
 PutWord(moveqL+d0*ls9+haltindex);
 CallSystem(halt);
END GenHalt;

(* Alle Arithmetischen und logischen doppelt gefaltet *)
PROCEDURE Int32Ari(inst:ArtsIx; VAR x,y:Item);
(* Interface to the 32-Bit arithmetic in System. *)
(* x (inst) y -> (D0.L,D1.L) *)
VAR
 d0Set:BOOLEAN;
 z:Item;
BEGIN
 IF (inst=mulu32) OR (inst=muls32) THEN SwapD0(x,y) END;
 d0Set:=((x.mode#DregMd) OR (x.R#d0)) & ((y.mode#DregMd) OR (y.R#d0));
 IF d0Set THEN NeedD0(x) END;
 SetregMd(z,d1,resultTyp); y.typ:=resultTyp; Move(y,z); Release(y); y:=z;
 IF (x.mode#DregMd) OR (x.R#d0) THEN
  IF ~d0Set THEN NeedD0(x) END;
  SetregMd(z,d0,resultTyp); x.typ:=resultTyp;
  Move(x,z); Release(x); x:=z
 END;
 CallSystem(inst);
 AmigaDestroyed;
 (* result in register-pair (D0.L,D1.L). x.wid:=long; *)
END Int32Ari;

PROCEDURE Op1(op:CARDINAL; VAR x:Item);
(* generate instructions with 1 operand represented by an eff. address in *)
(* bits [0..5] and its variable size in bits [6..7] of the instruction *)
(* word. Used for CLR,TST,NEG,COM (=NOT),INC1,DEC1. Not used for JSR,*)
(* JMP,PEA,Scc because these instructions have a fixed size. *)
(* 18.8.91/bp NICHT fuer CLR benutzt! *)
(* Note:x can be a memory location or on TOS. *)
VAR
 ea:CARDINAL;
 sz:WidType;
BEGIN
 Isz(x,sz);
 Gea(x,ea,op#tstB); (* bei TST NICHT destroyed! *)
 (* 18.8.91/bp Gea setzt bei Dreg/Areg NICHT als UsedReg! *)
 WITH x DO
  IF mode=stkMd THEN            (* change (SP)+ to (SP). *)
            (* for TST the operand is popped from stack! *)
   IF op#tstB THEN ea:=aidr+sp; END;
  END;
  IF (op#subqB+ls9)&(op#addqB+ls9) THEN
    Assertea(ea,data*alterable,0);
  ELSE (* addq, subq gehen auch bei aregs! *)
    Assertea(ea,alterable,12);
  END;
  PutWord(op+sz*ls6+ea); Ext(x);
  IF mode=DregMd THEN wid:=sz END;
  (* 18.8.91/bp Muss als Used markiert werden!!! *)
  IF (op#tstB) & ((mode=DregMd) OR (mode=AregMd)) THEN RegDestroyed(x.R) END;
 END
END Op1;

PROCEDURE Power2(VAR x:Item; VAR exp2:CARDINAL):BOOLEAN;
(* Note:negative numbers must NOT return as power of 2. *)
VAR
 pw2:BOOLEAN;
 v:LONGCARD;
BEGIN
 exp2:=0; pw2:=FALSE;
 IF x.mode=vconMd THEN
  v:=CAST(LONGCARD,x.val.conLI);
  pw2:=(x.val.conSign=0) & (v#0);
  WHILE (v>1) & pw2 DO
   pw2:=~ODD(v);
   v:=SHIFT(v,-1); (* v:=v DIV 2; *)
   INC(exp2); (* side effect of Power2 *)
  END;
 END;
 RETURN pw2 (* 0<=exp2<=31 *)
END Power2;

PROCEDURE MulPw2(VAR x:Item; exp:CARDINAL);
(* x * (power of 2) relevant is the width,not the size! *)
VAR
 op:CARDINAL;
 Dn:Register; new:BOOLEAN;
BEGIN
 Assert((x.mode=DregMd) & (exp<=31),1);
 IF exp#0 THEN
  IF exp=1 THEN
    PutWord(addB+x.wid*ls6+x.R*ls9+x.R);
  ELSE
    op:=asliB+x.wid*ls6+x.R;
    IF (1<=exp) & (exp<=8) THEN (* immediate shift *)
      PutWord(op+(exp MOD 8)*ls9);
    ELSE (* register by register shift *)
      GetConstReg(exp,Dn,new);
      PutWord(op+Dn*ls9+ls5);
      IF new THEN ReleaseReg(Dn) END;
    END;
  END;
  RegDestroyed(x.R);
  (* do not change x.wid *)
 END (*exp#0*);
END MulPw2;

PROCEDURE MUL2(VAR x,y:Item; ovfl:BOOLEAN);
(* x * y -> x *)
VAR
 op,ea,pw2:CARDINAL;
 op1:ArtsIx;
 szx,szy:WidType;
 QReg:Register;
 new:BOOLEAN;
 signar,loady:BOOLEAN;
BEGIN
 Isz(x,szx); Isz(y,szy);
 IF y.mode=vconMd THEN y.size:=SHIFT(1,szx); szy:=szx;
 ELSIF x.mode=vconMd THEN x.size:=SHIFT(1,szy); szx:=szy;
 END;
 signar:=~(UnsignedT(x) & UnsignedT(y));
 loady:=y.mode IN ItSet{AregMd,stkMd};
 IF szx<long THEN (* szy<long expected 16 * 16 bits *)
 (* die nchste Zeile weiter unten!
  IF (szy=byte) OR loady THEN LoadX(y,word,FALSE) END;
 *)
  IF Power2(y,pw2) THEN
    IF signar OR ~ovfl OR (pw2<=1) THEN (* 18.11.90/bp *)
      LoadD(x,TRUE); (* neu: bei byte kein ext! 16.10.90/bp *)
      MulPw2(x,pw2);
      IF ovfl & (pw2#0) THEN OvflTrap(signar) END;
    ELSE (* unsigned *4,8... *)
      PushOption(rngchk,TRUE);
      (*$ OverflowChk:=FALSE RangeChk:=FALSE *)
      IF szx=byte THEN
        LoadX(x,word,FALSE); (* mu word fr check, aber byte fr MulPw2! *)
        CheckClimit(x,SHIFT(CARDINAL(0FFH),-pw2));
        x.wid:=byte;
      ELSE
        CheckClimit(x,SHIFT(CARDINAL(0FFFFH),-pw2)); (* imp: LoadX(x,word,FALSE) *)
      END;
      (*$ POP OverflowChk POP RangeChk *)
      PopOption(rngchk);
      MulPw2(x,pw2);
      RegDestroyed(x.R);
    END;
  ELSE
   LoadX(x,word,TRUE);                  (* assert DregMd for destination *)
   IF (szy=byte) OR loady THEN LoadX(y,word,FALSE) END;
   IF signar THEN op:=mulsW ELSE op:=muluW END;
   Gea(y,ea,FALSE); Assertea(ea,data,1);
   PutWord(op+x.R*ls9+ea); Ext(y);
   x.wid:=long;
   IF ovfl THEN OvflCheck(x.R,signar) END;
  END;
 ELSE                                              (* 32 * 32 bits *)
 (* Die nchste Zeile weiter unten:
  IF (szy<long) OR loady THEN LoadX(y,long,TRUE) END;
 *)
  LoadX(x,long,TRUE);                  (* assert DregMd for destination *)
  IF Power2(y,pw2) THEN
    IF signar OR ~ovfl OR (pw2<=1) THEN (* 18.11.90/bp *)
      MulPw2(x,pw2);
      IF ovfl & (pw2#0) THEN OvflTrap(signar) END;
    ELSE
      PushOption(rngchk,TRUE);
      (*$ OverflowChk:=FALSE RangeChk:=FALSE *)
      CheckClimit(x,SHIFT(LONGCARD(0FFFFFFFFH),-pw2));
      (*$ POP OverflowChk POP RangeChk *)
      PopOption(rngchk);
      MulPw2(x,pw2);
    END;
  ELSE
   IF (szy<long) OR loady THEN LoadX(y,long,TRUE) END;
   resultTyp:=tp.numtyp[long,signar];
   (* 18.6.90/bp fr 68020.. gehen wir direkt! *)
   IF Option[m68020] THEN (* mindestens *)
     IF (y.mode=vconMd)&(IsByte(y.val.conLI)) THEN
       GetConstReg(y.val.conLI,QReg,new);
       SetregMd(y,QReg,y.typ);
     ELSE
       new:=TRUE;
     END;
     Gea(y,ea,FALSE); Assertea(ea,data,13);
     PutWord(0100110000000000L+ea); (* muls/mulu 32*32->32 *)
     IF signar THEN op:=ls11 ELSE op:=0 END;
     PutWord(op+x.R*ls12+x.R);
     Ext(y);
     x.wid:=long;
     IF ~new THEN y.mode:=vconMd END; (* damit kein Release erzwungen! *)
     (*RegDestroyed(x.R); durch LoadX schon passiert! *)
   ELSE
     IF signar THEN op1:=muls32 ELSE op1:=mulu32 END;
     Int32Ari(op1,x,y);
   END;
   IF ovfl THEN OvflTrap(TRUE); (* use always only TRAPV *) END;
   (* 64-bit result is in D0.L/D1.L: 18.6.90/bp NICHT mehr bei 68020..*)
   (* x.R remains reserved,x.wid remains long. *)
  END;
 END;
 Release(y);
END MUL2;

PROCEDURE SHI2(inst:CARDINAL; VAR x,y:Item);
(* shift left/right x by y. *)
VAR
 op,cv:CARDINAL;
 szx:WidType;
 lv:LONGINT;
 imm:BOOLEAN;
BEGIN
 IF (x.mode=stkMd) & (y.mode=stkMd) THEN LoadD(y,FALSE) END;
 LoadD(x,TRUE);
 Isz(x,szx);
 op:=inst+szx*ls6+x.R; (* register to be shifted *)
 imm:=FALSE;
 IF y.mode=vconMd THEN
  lv:=y.val.conLI;
  (* 01.03.90/bp >=1 --> >0 *)
  IF (lv>0) & (lv<=8) THEN imm:=TRUE END;
 END;
 IF imm THEN (* immediate shift:value 0 excluded *)
  cv:=CARDINAL(lv) MOD 8;
  PutWord(op+cv*ls9);
 ELSE (* register by register shift *)
  LoadD(y,FALSE); (* load shift count *)
  INC(op,y.R*ls9+ls5); (* indicates register shift *)
  (* shift is modulo 64:no chechs are made for *)
  (* positive or negative values of shift count. *)
  PutWord(op);
 END;
 x.wid:=szx; (* resulting width of D-Register *)
 Release(y);
END SHI2;

PROCEDURE Log2(inst:CARDINAL; VAR x,y:Item);
(* the logical operators AND,OR,EOR. x (log2) y -> x *)
(* Note:x can be a memory location or on top of stack. *)
CONST FullByte=LONGSET{0..7};
      FullWord=LONGSET{0..15};
      FullLong=LONGSET{0..31};
VAR
 op,eax,eay:CARDINAL;
 szx,szy:WidType;
 DoIt,empty,full:BOOLEAN;
 help:LONGSET;
BEGIN
 Isz(x,szx); Isz(y,szy);
 IF y.mode=vconMd THEN y.size:=SHIFT(1,szx); szy:=szx;
 ELSIF x.mode=vconMd THEN x.size:=SHIFT(1,szy); szx:=szy;
 END;
 Gea(x,eax,TRUE);
 IF x.mode=stkMd THEN eax:=aidr+sp; (* gives (SP) *) END;
 IF (y.mode=vconMd) & (x.mode#AregMd) THEN
  (* ANDI/ORI/EORI *)
  DoIt:=TRUE;
  IF szx=byte THEN
    help:=FullByte;
  ELSIF szx=word THEN
    help:=FullWord;
  ELSE
    help:=FullLong;
  END;
  empty:=y.val.conSet*help=LONGSET{};
  full:=y.val.conSet*help=help;
  IF inst=andB THEN
    (* 9.3.90/bp andi #00000.. -> CLR.X ea *)
    IF empty THEN
      op:=clrB; (* ginge nun noch bei DregMd: moveq statt clr.l *)
      y.mode:=stkMd; (* irgendwas, was keinen Code erzeugt! *)
    ELSIF full THEN (* andi #fff.. -> nix tun *)
      DoIt:=FALSE
    ELSE
      op:=andiB;
    END;
  ELSIF inst=orB THEN
    IF empty THEN
      DoIt:=FALSE;
    ELSE
      op:=oriB;
    END;
  ELSE
    IF empty THEN
      DoIt:=FALSE
    ELSIF full THEN
      op:=notB;
      y.mode:=stkMd; (* aviod code and ReleaseReg-trouble! *)
    ELSE
      op:=eoriB;
    END;
  END;
  IF DoIt THEN
    Assertea(eax,data*alterable,2);
    PutWord(op+szx*ls6+eax);
    Ext(y); (* source extension first *)
    Ext(x); (* destination extension *)
  END;
 ELSE
  IF (x.mode=stkMd) & (y.mode=stkMd) THEN LoadD(y,FALSE) END;
  IF x.mode=AregMd THEN LoadD(x,TRUE); Gea(x,eax,FALSE) END; (* da DregMd!/bp*)
  op:=inst+szx*ls6;
  Gea(y,eay,FALSE);
  IF (x.mode=DregMd) & (inst#eorB) THEN (* destination is D-Register:*)
   Assertea(eay,data,3);
   PutWord(op+x.R*ls9+eay); Ext(y)
  ELSE
   (* destination is memory location or inst=EOR. *)
   (* assert source operand in D-Register. *)
   LoadD(y,FALSE);
   IF inst#eorB THEN INC(op,ls8); Assertea(eax,alterable*memory,4); END;
   PutWord(op+y.R*ls9+eax); Ext(x)
  END;
 END;
 IF x.mode=DregMd THEN
   x.wid:=szx;
   RegDestroyed(x.R)
 END;
 Release(y);
END Log2;

PROCEDURE DivPw2(VAR x:Item; exp:INTEGER; modulus:BOOLEAN);
VAR
 m:LONGINT;
 y:Item;
BEGIN
 Assert(exp<=31,2);
 IF exp=0 THEN (* DIV/MOD 1 *)
  IF modulus THEN Release(x); SetconMd(x,0,x.typ); END;
  (* else no change if x DIV 1 *)
 ELSE
  LoadD(x,TRUE);
  IF ~modulus THEN (* DIV *)
   SetconMd(y,exp,tp.uinttyp);
   IF SignedT(x) THEN SHI2(asriB,x,y)
   ELSE SHI2(lsriB,x,y)
   END;
  ELSE (* MOD *)
   m:=mask[exp]; (* 2**exp-1 *)
   SetconMd(y,m,x.typ);
   Log2(andB,x,y);
  END;
 END;
 (* x.wid is set by SHI2 and Log2 *)
 Release(y);
END DivPw2;

PROCEDURE DIV2(VAR x,y:Item; modulus:BOOLEAN);
(* x DIV/MOD y -> x *)
VAR
 op,ea:CARDINAL;
 op1:ArtsIx;
 szx,szy:WidType;
 signar,loady,new:BOOLEAN;
 Dn,QReg:Register;
BEGIN
 Isz(x,szx); Isz(y,szy);
 IF y.mode=vconMd THEN y.size:=SHIFT(1,szx); szy:=szx;
 ELSIF x.mode=vconMd THEN x.size:=SHIFT(1,szy); szx:=szy;
 END;
 signar:=resultTyp^.sign;
 loady:=y.mode IN ItSet{AregMd,stkMd};
 IF szx<long THEN (* szy<long expected     32 DIV/MOD 16 bits *)
  IF (szy=byte) OR loady THEN LoadX(y,word,FALSE) END;
  LoadX(x,long,TRUE);
  IF signar THEN op:=divsW ELSE op:=divuW END;
  Gea(y,ea,FALSE); Assertea(ea,data,5);
  PutWord(op+x.R*ls9+ea); Ext(y); (* source *)
                (* quotient in bits [0..15],remainder in bits [16..31] *)
  IF modulus THEN PutWord(swapW+x.R) END;
  x.wid:=word; (* resulting width *)
 ELSE                              (* 32 DIV/MOD 32 bits *)
  IF (szy<long) OR loady THEN LoadX(y,long,TRUE) END;
  (* 18.6.90/bp Use the Power of your machine! *)
  IF Option[m68020] THEN
    LoadX(x,long,TRUE);
    IF (y.mode=vconMd)&(IsByte(y.val.conLI)) THEN
      GetConstReg(y.val.conLI,QReg,new);
      SetregMd(y,QReg,y.typ);
    ELSE
      new:=TRUE
    END;
    Gea(y,ea,TRUE); Assertea(ea,data,11);
    PutWord(0100110001000000L+ea);
    IF signar THEN op:=ls11 ELSE op:=0 END;
    IF modulus THEN
      GetReg(Dn,Dreg); (* Neues Reg fuer Remainder *)
      RegDestroyed(Dn);
      PutWord(op+x.R*ls12+Dn);
      ReleaseReg(x.R);   (* Quotient interessiert uns nicht, *)
      RegDestroyed(x.R);
      x.R:=Dn;
    ELSE
      (* Quotient nach x, vergiss den Rest *)
      PutWord(op+x.R*ls12+x.R);
    END;
    Ext(y);
    IF ~new THEN y.mode:=vconMd END; (* damit kein Release erzwungen! *)
  ELSE (* popelige 68000 oder 68010! *)
    IF signar THEN op1:=divs32 ELSE op1:=divu32 END;
    Int32Ari(op1,x,y);
    (* quotient in register D1.L,remainder in D0.L:*)
    (* x.R remains reserved,x.wid remains long. *)
    IF ~modulus THEN PutWord(moveL+d0*ls9+d1) END;
  END;
 END;
 Release(y);
END DIV2;

PROCEDURE ADD2(inst:CARDINAL; VAR x,y:Item);
(* x +/- y -> x *)
(* Note:x can be a memory location or on top of stack. *)
VAR
 op,eax,eay:CARDINAL;
 szx,szy:WidType;
 cadd:BOOLEAN;
 lv:LONGINT; new:BOOLEAN; (* 3.3.90/bp *)
 QReg: Register;
BEGIN
 Isz(x,szx); Isz(y,szy);
 cadd:=y.mode=vconMd;
 IF x.mode=vconMd THEN x.size:=SHIFT(1,szy); LoadD(x,TRUE); szx:=szy;
 ELSIF cadd THEN y.size:=SHIFT(1,szx); szy:=szx; lv:=y.val.conLI; (* 3.3.90/bp *)
 END;
 Gea(x,eax,TRUE);
 IF x.mode=stkMd THEN eax:=aidr+sp (* gives (SP) *) END;
 IF cadd & (x.mode#AregMd) THEN
  (* 28.2.90/bp >=1 --> >0 *)
  IF (lv>0) & (lv<=8) THEN
   IF inst=addB THEN op:=addqB ELSE op:=subqB END;
   Assertea(eax,alterable,6);
   eay:=CARDINAL(lv) MOD 8;
   PutWord(op+eay*ls9+szx*ls6+eax); Ext(x);
  ELSIF (lv#0) THEN
   Assertea(eax,data*alterable,7);
   (* 3.3.90/bp womglich longwert erst in Register mit moveq *)
   IF (szx=long) & IsByte(lv) THEN
     GetConstReg(lv,QReg,new);
     IF x.mode=DregMd THEN (* 4.3.90/bp ergibt sonst ADDX.L !!! *)
       PutWord(inst+long*ls6+x.R*ls9+QReg);
     ELSE
       IF inst=addB THEN op:=addmL ELSE op:=submL END;
       PutWord(op+QReg*ls9+eax); Ext(x);
     END;
     IF new THEN ReleaseReg(QReg) END;
   ELSE
     IF inst=addB THEN op:=addiB ELSE op:=subiB END;
     PutWord(op+szx*ls6+eax);
     Ext(y); (* extend source constant first *)
     Ext(x); (* extend destination *)
   END;
  END;
 ELSE
  op:=inst;
  IF (x.mode=stkMd) & (y.mode=stkMd) THEN LoadD(y,FALSE) END;
  Gea(y,eay,FALSE);
  IF x.mode=DregMd THEN            (* destination is D-Register:*)
   INC(op,(CARDINAL(x.R) MOD 8)*ls9);
   IF (y.mode=AregMd) & (szy=byte) THEN Mark(6013) END;
   PutWord(op+szy*ls6+eay); Ext(y)
  ELSIF x.mode=AregMd THEN         (* destination is A-Register:*)
   (* 3.3.90/bp Wert in lv merken, bereits weiter oben geschehen. *)
   (* allow long operation only. *)
   IF szx<long THEN Mark(6014) END;
   (* 28.2.90/bp Optimierung addq,subq! *)
   IF cadd & (lv>0) & (lv<=8) THEN
     IF inst=addB THEN op:=addqL ELSE op:=subqL END;
     eay:=CARDINAL(lv) MOD 8;
     PutWord(op+eay*ls9+adir+(CARDINAL(x.R) MOD 8));
   (* 3.3.90/bp Integer-Bereich --> LEA.L ii(Ax),Ax *)
   (* Fr minInt ausgenommen, da evtl. bei subB Negation ntig *)
   ELSIF cadd & IsWord(lv) THEN
     IF inst=subB THEN
     (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
     lv:=-lv
     (*$ POP RangeChk POP OverflowChk *)
     END;
     eay:=x.R MOD 8;
     PutWord(lea+eay*ls9+aoff+eay); PutWord(INTEGER(lv));
   ELSE
     INC(op,(CARDINAL(x.R) MOD 8)*ls9);
     PutWord(op+7*ls6+eay); Ext(y); (* sz=7, generiert ADDA.L *)
   END;
  ELSE                             (* destination is memory location:*)
   (* assert source op. in D-Register. *)
   LoadD(y,FALSE);
   Assertea(eax,alterable*memory,8);
   INC(op,y.R*ls9+ls8);
   PutWord(op+szx*ls6+eax); Ext(x)
  END
 END;
 IF (x.mode=DregMd) OR (x.mode=AregMd) THEN
   IF x.mode=DregMd THEN x.wid:=szx END;
   RegDestroyed(x.R); (* bei +-0 auch??/bp *)
 END;
 Release(y)
END ADD2;

PROCEDURE Normalize(VAR x:Item; i:LONGINT);
(* normalize x with the low-bound i *)
VAR
 op:CARDINAL;
 y:Item;
BEGIN
 IF i#0 THEN
  Assert(x.mode=DregMd,6);
  (* Note:overflow-checks must be OFF for compiler! *)
  IF i>0 THEN op:=subB ELSE op:=addB; i:=ABS(i) END;
  SetconMd(y,i,x.typ);
  ADD2(op,x,y);
 END;
END Normalize;

PROCEDURE Cmp2(VAR x,y:Item; c:Condition);
VAR
 eax,eay:CARDINAL;
 szx,szy:WidType;
BEGIN
 IF constOp THEN
  WITH x.val DO (* teste umgekehrte Relation!! *)
   CASE c OF
   | NE: conLI:=ORD((conSign=y.val.conSign) & (conLI=y.val.conLI))
   | EQ: conLI:=ORD((conSign#y.val.conSign) OR (conLI#y.val.conLI))
   | LE: conLI:=ORD((conSign>y.val.conSign) OR
                (conSign=y.val.conSign) & (LONGCARD(conLI)>LONGCARD(y.val.conLI)))
   | LT: conLI:=ORD((conSign>y.val.conSign) OR
                (conSign=y.val.conSign) & (LONGCARD(conLI)>=LONGCARD(y.val.conLI)))
   | GE: conLI:=ORD((conSign<y.val.conSign) OR
                (conSign=y.val.conSign) & (LONGCARD(conLI)<LONGCARD(y.val.conLI)))
   | GT: conLI:=ORD((conSign<y.val.conSign) OR
                (conSign=y.val.conSign) & (LONGCARD(conLI)<=LONGCARD(y.val.conLI)))
   ELSE
    Mark(6006); conLI:=0;
   END;
   conSign:=0; x.typ:=tp.booltyp
  END
 ELSE
  IF x.mode=cocMd THEN LoadCC(x);
  ELSIF y.mode=cocMd THEN LoadCC(y);
  END;

  Isz(x,szx); Isz(y,szy);
  (* 3.3.90/bp Wenn imm und quick geht, dann soll es sein! *)
  IF (y.mode=vconMd) & (y.val.conLI#0) & ((x.mode=AregMd) OR (x.mode=DregMd))
      & (szx=long) & IsByte(y.val.conLI) THEN
    LoadD(y,FALSE);
  END;
  IF y.mode=vconMd THEN y.size:=SHIFT(1,szx); szy:=szx;
  ELSIF x.mode=vconMd THEN x.size:=SHIFT(1,szy); szx:=szy;
  END;
  Gea(x,eax,FALSE);
  IF (y.mode=vconMd) & (x.mode#AregMd) THEN
   (* source is constant:*)
   IF y.val.conLI=0 THEN
    Op1(tstB,x)  (* x would be popped if stkMd *)
   ELSE
    Assertea(eax,data*alterable,9);
    PutWord(cmpiB+szx*ls6+eax); (* x would be popped if stkMd *)
    Ext(y); (* immediate source *)
    Ext(x); (* extend destination *)
   END;
  ELSIF x.mode=AregMd THEN   (* destination is A-Register:*)
   (* allow long operation only. *)
   IF szx<long THEN Mark(6015) END;
   IF (y.mode=vconMd)&(y.val.conLI=0) THEN
     GetReg(y.R,Dreg);
     y.mode:=DregMd; (* nur fr Release *)
     PutWord(moveL+y.R*ls9+x.R); (* setzt autom. cond-codes! *)
     RegDestroyed(y.R);
   ELSE
     Gea(y,eay,FALSE);
     PutWord(cmpaL+(CARDINAL(x.R) MOD 8)*ls9+eay); Ext(y);
   END;
  ELSE
   IF (x.mode=stkMd) & (y.mode=stkMd) THEN LoadD(y,FALSE) END;
   (* destination must be D-Register:*)
   LoadD(x,FALSE);
   Gea(y,eay,FALSE);
   IF y.mode=AregMd THEN
    (* allow word/long only for source in A-Reg. *)
    IF szy=byte THEN Mark(6016) END;
   END;
   IF (y.mode=DregMd) & (y.R=x.R) THEN Mark(6031) END;
   PutWord(cmpB+(CARDINAL(x.R) MOD 8)*ls9+szx*ls6+eay); Ext(y)
            (* y would be popped if stkMd *)
  END;
  SetcocMd(x,c); (* result is in the condition code register! *)
 END;
 Release(y);
END Cmp2;

PROCEDURE In2(VAR x,y:Item);
(* perform bit-manipulations:BTST. *)
(* y is the destination bit pattern,x is the bit number. *)
VAR
 Dn:Register;
BEGIN
(* Debug.Item("In2 X", x); Debug.Item("In2 Y", y);*)
 IF constOp THEN
  x.val.conLI:=LONGINT(x.val.conLI IN y.val.conSet); x.val.conSign:=0;
 ELSE
  LoadD(y,FALSE); (* load bit pattern *)
  IF x.mode=vconMd THEN
   PutWord(btsti+ddir+y.R);
   PutWord(INTEGER(x.val.conLI));
  ELSE
   LoadD(x,FALSE); (* load bit number *)
   PutWord(btst+x.R*ls9+ddir+y.R);
  END;
  SetcocMd(x,EQ); (* result is in the condition code register! *)
 END;
 x.typ:=tp.booltyp;
 Release(y);
END In2;

PROCEDURE Neg1(VAR x:Item);
BEGIN
 IF x.mode=vconMd THEN
  WITH x.val DO
   IF (conSign=0) & (CAST(LONGCARD,conLI)>80000000H) THEN Mark(6017)
   ELSIF conLI#0 THEN
    (*$ OverflowChk:=FALSE *) conLI:=-conLI; conSign:=-1-conSign (*$ POP OverflowChk *)
   END
  END
 ELSE
  LoadD(x,TRUE); Op1(negB,x);
  OvflTrap(SignedT(x))
 END
END Neg1;

PROCEDURE Abs1(VAR x:Item);
VAR
 l: INTEGER;
BEGIN
 IF x.mode=vconMd THEN
  IF x.val.conSign=-1 THEN x.val.conLI:=ABS(x.val.conLI); x.val.conSign:=0 END;
 ELSE
  LoadD(x,FALSE); Op1(tstB,x);
  l:=ip; PutWord(bge);
  Neg1(x);
  FixShort(l)
 END
END Abs1;

PROCEDURE Cap1(VAR x:Item);
BEGIN
 IF x.mode=vconMd THEN
  x.val.conLI:=ORD(CAP(CHR(x.val.conLI)));
 ELSE
  LoadD(x,TRUE);
  PutWord(cmpiB+x.R); PutWord(97);
  PutWord(bcs+10);
  PutWord(cmpiB+x.R); PutWord(122);
  PutWord(bhi+4);
  PutWord(andiB+x.R); PutWord(95);
 END;
END Cap1;

PROCEDURE Tst1(VAR x:Item; c:Condition);
BEGIN
(*    muss vconMd nicht behandeln
 IF x.mode=vconMd THEN
  WITH x.val DO
   CASE c OF
   | EQ: I:=ORD((I=0) & (sign=0))
   | NE: I:=ORD((I#0) OR (sign#0))
   | GT: I:=ORD((sign>0) OR (sign=0) & (I#0))
   | GE: I:=ORD(sign>=0)
   | LT: I:=ORD(sign<0)
   | LE: I:=ORD((sign<0) OR (sign=0) & (I=0))
   ELSE
    Mark(6007); I:=0
   END;
   sign:=0
  END
 ELSE
*)
 IF x.mode=AregMd THEN
   LoadD(x,FALSE)
 ELSE
   Op1(tstB,x); (* todo: DIES kan entfallen, wenn von AregMd!! *)
 END;
 SetcocMd(x,c); (* macht auch Relaese! *)
END Tst1;

PROCEDURE Com1(VAR x:Item);
BEGIN
 IF x.mode=vconMd THEN x.val.conLI:=-1-x.val.conLI
 ELSE
  LoadD(x,TRUE);
  Op1(notB,x);
 END;
END Com1;

PROCEDURE Inc1(VAR x:Item);
BEGIN
 Op1(addqB+1*ls9,x);
 IF x.mode#AregMd THEN OvflTrap(SignedT(x)) END;
END Inc1;

PROCEDURE Dec1(VAR x:Item);
BEGIN
 Op1(subqB+1*ls9,x);
 IF x.mode#AregMd THEN OvflTrap(SignedT(x)) END;
END Dec1;

PROCEDURE And1(VAR x:Item);
BEGIN
 WITH x DO
  IF mode#vconMd THEN
   IF mode#cocMd THEN
    Tst1(x,EQ);
   END;
   Jf(CC,Fjmp); FixLink(Tjmp);
  END;
 END (*WITH*);
END And1;

PROCEDURE Or1(VAR x:Item);
BEGIN
 WITH x DO
  IF mode#vconMd THEN
   IF mode#cocMd THEN
    Tst1(x,NE); Jf(CC,Tjmp);
   ELSE
    Jf(InvertCC(CC),Tjmp);
   END;
   FixLink(Fjmp);
  END;
 END (*WITH*);
END Or1;

PROCEDURE Not1(VAR x:Item);
VAR
 t:INTEGER;
BEGIN
 WITH x DO
  IF mode=vconMd THEN val.conLI:=1-val.conLI
  ELSIF mode=cocMd THEN
   CC:=InvertCC(CC);
   t:=Tjmp; Tjmp:=Fjmp; Fjmp:=t;
  ELSE
   Tst1(x,NE);
  END;
 END (*WITH*);
END Not1;

PROCEDURE And2(VAR x,y:Item);
 BEGIN
  IF constOp THEN x.val.conLI:=x.val.conLI*y.val.conLI
  ELSE
   IF x.mode=vconMd THEN
   (* 22.10.89/ms I=1 -> I#0 *)
    IF x.val.conLI#0 THEN
     IF y.mode<=DregMd THEN Tst1(y,EQ)
     ELSIF y.mode#cocMd THEN Mark(6025)
     END
    ELSE
     SetcocMd(y,T)
    END;
    SetcocMd(x,EQ)
   ELSIF y.mode#cocMd THEN
    IF y.mode=vconMd THEN
    (* 22.10.89/ms I=1 -> I#0 *)
     IF y.val.conLI#0 THEN SetcocMd(y,F) ELSE SetcocMd(y,T) END;
    ELSIF y.mode<=DregMd THEN Tst1(y,EQ)
    ELSE Mark(6026); SetcocMd(y,EQ)
    END
   END;
   IF y.Fjmp#0 THEN x.Fjmp:=MergedLinks(x.Fjmp,y.Fjmp) END;
   x.CC:=y.CC; x.Tjmp:=y.Tjmp
  END
END And2;

PROCEDURE Or2(VAR x,y:Item);
BEGIN
 IF constOp THEN INC(x.val.conLI,y.val.conLI); IF x.val.conLI>1 THEN x.val.conLI:=1 END
 ELSE
  IF x.mode=vconMd THEN
   IF x.val.conLI=0 THEN
    IF y.mode<=DregMd THEN Tst1(y,EQ)
    ELSIF y.mode#cocMd THEN Mark(6028)
    END
   ELSE
    SetcocMd(y,F)
   END;
   SetcocMd(x,EQ)
  ELSIF y.mode#cocMd THEN
   IF y.mode=vconMd THEN
   (* 22.10.89/ms I=1 -> I#0 *)
    IF y.val.conLI#0 THEN SetcocMd(y,F) ELSE SetcocMd(y,T) END
   ELSIF y.mode<=DregMd THEN Tst1(y,EQ)
   ELSE Mark(6029); SetcocMd(y,EQ)
   END
  END;
  IF y.Tjmp#0 THEN x.Tjmp:=MergedLinks(x.Tjmp,y.Tjmp) END;
  x.CC:=y.CC; x.Fjmp:=y.Fjmp
 END
END Or2;

PROCEDURE Add2(VAR x,y:Item);
VAR
 op:CARDINAL;
BEGIN
 IF constOp THEN
  WITH x.val DO
   IF CAST(LONGCARD,conLI)>CAST(LONGCARD,maxLCard)-CAST(LONGCARD,y.val.conLI) THEN
    INC(conSign)
   END;
   INC(conLI,y.val.conLI); INC(conSign,y.val.conSign)
  END
 (* Checks ob gltige Zahl, nicht >4Mrd oder <-2Mrd *)
 ELSE
  op:=addB;
  IF (y.mode=vconMd) & (y.val.conSign<0) THEN
  (*$ OverflowChk:=FALSE *)
   y.val.conLI:=-y.val.conLI; op:=subB;
  (*$ POP OverflowChk *)
  END;
  ADD2(op,x,y);
  x.typ:=resultTyp;
  (* 9.3.90/bp Warum noch bei +-0 prfen, ADD2 hat nichts getan! *)
  IF (x.mode#AregMd)&~((y.mode=vconMd)&(y.val.conLI=0)) THEN OvflTrap(SignedT(x)) END
 END
END Add2;

PROCEDURE Sub2(VAR x,y:Item);
VAR
 op:CARDINAL;
BEGIN
 IF constOp THEN
  (* Zwischenresultat der Negation von y DARF ungltige Zahl sein !! *)
  WITH y.val DO IF conLI#0 THEN conLI:=-conLI; conSign:=-1-conSign END END; Add2(x,y)
 ELSE
  op:=subB;
  IF (y.mode=vconMd) & (y.val.conLI<0) THEN
  (*$ OverflowChk:=FALSE *)
   y.val.conLI:=-y.val.conLI; op:=addB;
  (*$ POP OverflowChk *)
  END;
  ADD2(op,x,y);
  x.typ:=resultTyp;
  (* 9.3.90/bp bei -0 kein Check!! *)
  IF (x.mode#AregMd)&~((y.mode=vconMd)&(y.val.conLI=0)) THEN OvflTrap(SignedT(x)) END
 END
END Sub2;

PROCEDURE IAnd2(VAR x,y:Item);
BEGIN
 IF constOp THEN x.val.conSet:=x.val.conSet*y.val.conSet; x.val.conSign:=0;
 ELSE Log2(andB,x,y);
 END;
END IAnd2;

PROCEDURE IOr2(VAR x,y:Item);
BEGIN
 IF constOp THEN x.val.conSet:=x.val.conSet+y.val.conSet; x.val.conSign:=0;
 ELSE Log2(orB,x,y);
 END;
END IOr2;

PROCEDURE IEor2(VAR x,y:Item);
BEGIN
 IF constOp THEN x.val.conSet:=x.val.conSet/y.val.conSet; x.val.conSign:=0;
 ELSE
   LoadD(x,TRUE); Log2(eorB,x,y)
 END
END IEor2;

PROCEDURE Quo2(VAR x,y:Item);
VAR
 pw2:CARDINAL;
BEGIN
 IF (y.mode=vconMd) & (y.val.conLI=0) THEN
  Mark(6018);
 ELSIF constOp THEN
  WITH x.val DO
   conLI:=ABS(conLI) DIV ABS(y.val.conLI);
   IF (conSign#y.val.conSign) & (conLI#0) THEN conLI:=-conLI; conSign:=-1; ELSE conSign:=0; END;
  END;
 ELSIF ~resultTyp^.sign & Power2(y,pw2) THEN
  DivPw2(x,pw2,FALSE);
 ELSE
  DIV2(x,y,FALSE);
 END;
 x.typ:=resultTyp;
END Quo2;

PROCEDURE Rem2(VAR x,y:Item);
VAR
 pw2:CARDINAL;
BEGIN
 IF (y.mode=vconMd) & (y.val.conLI=0) THEN
  Mark(6019);
 ELSIF constOp THEN
  WITH x.val DO
   conLI:=ABS(conLI) MOD ABS(y.val.conLI);
   IF (conSign<0) & (conLI#0) THEN conLI:=-conLI; conSign:=-1; ELSE conSign:=0; END;
  END;
 ELSIF ~resultTyp^.sign & Power2(y,pw2) THEN
  DivPw2(x,pw2,TRUE)
 ELSE
  DIV2(x,y,TRUE)
 END;
 x.typ:=resultTyp;
END Rem2;

PROCEDURE Div2(VAR x,y:Item);
VAR
 yorig,
 z: Item;
 exp:CARDINAL;
 L0, L1, L2: INTEGER;
 Dn: Register;
 szy:WidType;
BEGIN
 yorig:=y; (* merken, da Sub2 Item verndert!! *)
 WITH x.val DO
  IF constOp THEN
   IF conSign#y.val.conSign THEN
    Sub2(x,y);
    IF conSign<0 THEN INC(conLI) ELSE DEC(conLI) END;
   END
  ELSIF Power2(y,exp) THEN
   DivPw2(x,exp,FALSE); RETURN;
  ELSIF resultTyp^.sign THEN
   LoadD(x,TRUE); GetReg(Dn,Dreg); SetregMd(z,Dn,resultTyp); Move(x,z);
   (* 29.11.90/bp *)
   IF (y.mode=vconMd) THEN (* Laden lohnt sich auf jeden Fall!/bp *)
     Isz(x,szy);
     LoadX(y,szy,FALSE);
     y.typ:=resultTyp (* Sonst nachher rger! *)
   END;
   IEor2(z,y); Release(z);
   L0:=ip;
   PutWord(bpl);
    Sub2(x,y); (* Da y nicht mehr vconMd: kein Problem!/bp *)
    L1:=ip;
    PutWord(bpl);
     Inc1(x);
    L2:=ip;
    PutWord(bra);
    FixShort(L1);
     Dec1(x);
    (*END*)
   (*END*)
   FixShort(L0);
   FixShort(L2);
  END;
 END;
 Quo2(x,yorig);
END Div2;

PROCEDURE Mod2(VAR x,y:Item);
VAR
 z,ysave: Item;
 L0,L1: INTEGER;
 exp:CARDINAL;
 Dn:Register;
BEGIN
 IF ~constOp & Power2(y,exp) THEN
  DivPw2(x,exp,TRUE)
 ELSE (* 18.8.91/bp War uebler Fehler! ysave-Reg war released!
       * Zudem etwas optimiert durch die beiden LoadD
       *)
  IF resultTyp^.sign (* IMMER!& (resultTyp^.size=4)*) THEN
   LoadD(y,FALSE); (* ??? wird nicht zerstoert?? *)
   (* Register merken, da Rem2 released, wir aber noch brauchen! *)
   (*
   GetReg(Dn,Dreg); SetregMd(ysave,Dn,resultTyp); Move(y,ysave);
   *)
   ysave:=y;
   LoadD(x,TRUE);
   Rem2(x,y);
   SetbusyReg(ysave.R);
  ELSE
   Rem2(x,y);
   (* ysave:=y; wird bei unsigned nicht benutzt! *)
  END;
  WITH x.val DO
   IF constOp THEN
    IF (conLI#0) & (conSign#y.val.conSign) THEN Add2(x,y) END;
   ELSIF resultTyp^.sign THEN
    GetReg(Dn,Dreg); SetregMd(z,Dn,resultTyp); Move(x,z);
    L0:=ip;
    PutWord(beq);
     IEor2(z,ysave); Release(z);
     L1:=ip; PutWord(bpl);
     Add2(x,ysave);
     FixShort(L1);
    (*END*)
    FixShort(L0);
   END
  END
 (*
  IF resultTyp^.sign & (resultTyp^.size=4) THEN
   GetReg(Dn,Dreg); SetregMd(ysave,Dn,resultTyp); Move(y,ysave);
   Rem2(x,y);
  ELSE
   Rem2(x,y);
   ysave:=y;
  END;
  WITH x.val DO
   IF constOp THEN
    IF (conLI#0) & (conSign#y.val.conSign) THEN Add2(x,y) END;
   ELSIF resultTyp^.sign THEN
    GetReg(Dn,Dreg); SetregMd(z,Dn,resultTyp); Move(x,z);
    L0:=ip;
    PutWord(beq);
     IEor2(z,ysave); Release(z);
     L1:=ip; PutWord(bpl);
     Add2(x,ysave);
     FixShort(L1);
    (*END*)
    FixShort(L0);
   END
  END
 *)
 END
END Mod2;

PROCEDURE Mul2(VAR x,y:Item);
BEGIN
 IF (y.mode=vconMd) & (y.val.conLI=0) THEN
  Release(x); SetconMd(x,0,x.typ); x.val.conSign:=0;
 ELSIF constOp THEN
  x.val.conLI:=x.val.conLI*y.val.conLI;
 ELSIF (y.mode#vconMd) OR (y.val.conLI#1) THEN
  MUL2(x,y,TRUE)
 END;
 x.typ:=resultTyp;
END Mul2;

PROCEDURE Shi2(VAR x,y:Item; shiftop:ShiType);
BEGIN
 SHI2(ShiCode[shiftop],x,y);
END Shi2;

PROCEDURE Ash2(VAR x,y:Item; shiftop:ShiType);
(* now only used by M2EM:GenStParam -> Shift *)
(* Arithmetic/Logical/Rotate Shift x by y. *)
(* y is the shift count of type INTEGER or INTEGER. *)
(* if y>=0 then shift LEFT. if y<0 then shift RIGHT. *)
VAR
 op,rm,regi:CARDINAL;
 ct:INTEGER;
 sz:WidType;
BEGIN
 Assert(x.mode=DregMd,4);
 Assert((shiftop=Asl) OR (shiftop=Lsl) OR (shiftop=Rol),5);
 regi:=x.R MOD 8;
 RegDestroyed(regi); (* IMMER Dreg!! *)
 Isz(x,sz);
 op:=ShiCode[shiftop]+sz*ls6+regi; (* initially LEFT shift *)
 IF y.mode=vconMd THEN
  ct:=y.val.conLI;
  (* 3.3.90/bp bei Shift(16): SWAP *)
  IF (ABS(ct)=16) & (sz=2) THEN (* long *)
    IF shiftop=Rol THEN
      PutWord(swapW+regi); (* links/rechts egal! *)
    ELSIF ct>=0 THEN (* asl,lsl egal, immer 0 von rechts *)
      PutWord(swapW+regi);
      PutWord((clrW+ddir)+regi);
    ELSIF shiftop=Lsl THEN (* also Lsr #16,dn *)
      PutWord(clrW+regi);
      PutWord(swapW+regi);
    ELSE (* bleibt nur noch Asr #16,Dn, keine Optimierung mglich *)
      INC(regi,asriL);
      PutWord(regi); (* 2mal asr #8,dn *)
      PutWord(regi);
    END;
  ELSE
    (* immediate shift count:bit 5 remains 0! *)
    IF ct<0 THEN
      DEC(op,ls8); (* RIGHT shift *)
      (* Note:overflow-checks must be OFF for compiler! *)
      ct:=ABS(ct);
    END;
    ct:=ct MOD 32; (* shift count modulo 32 *)
    rm:=ct MOD 8; ct:=ct DIV 8;
    IF rm#0 THEN PutWord(op+rm*ls9) END;
    WHILE ct>0 DO PutWord(op); DEC(ct) END;
  END;
 ELSE
  (* variable shift count of type INTEGER/CARDINAL:*)
  (* INTEGER/CARDINAL count treated the same way.  *)
  (* Note:Hardware takes shift count modulo 64 !   *)
  LoadX(y,word,TRUE);          (* load shift count *)
  INC(op,y.R*ls9+ls5);         (* register shift   *)
  PutWord(tstW+y.R);             (* test shift count *)
  PutWord(bpl+6);                (* if count>=0      *)
  PutWord(negW+y.R);             (* abs. value count *)
  PutWord(op-ls8);               (* RIGHT shift      *)
  PutWord(bra+2);                (* skip next instr. *)
  PutWord(op);                   (* LEFT shift       *)
 END;
 x.wid:=sz; (* resulting width of D-Register *)
 Release(y);
END Ash2;

PROCEDURE ConIndex(VAR x:Item; inc:LONGINT);
(* called for constant index and field-offset. *)
(* if NOT indir:adr-field is incremented *)
(* if indir:off-field is incremented. *)
VAR
 i:LONGINT;
BEGIN
 WITH x DO
  IF mode<vconMd THEN  (* reference to indir,adr,off allowed. *)
   IF indir THEN INC(off,inc) ELSE INC(adr,inc) END;
  ELSIF mode=memconMd THEN
   INC(conOffset,inc);
  ELSE (* all other modes *)
   Mark(6020);
  END;
 END
END ConIndex;

PROCEDURE CheckHigh(VAR x,high:Item);
(* check item associated with x to be in the range [0..(high)]. *)
(* Note:CHK treats operand and upper-bound as signed 2's complement *)
(*       integers! *)
VAR
 ea:CARDINAL;
 sz,hsz:WidType;
 distance: INTEGER;
BEGIN
 IF ~Option[rngchk] THEN RETURN END;
 LoadD(x,FALSE); (* assert x to be loaded into a D-register *)
 Isz(high,hsz); Isz(x,sz);
 IF sz=word THEN (* use CHK-instruction *)
  IF hsz#word THEN LoadD(high,FALSE) END;
  Gea(high,ea,FALSE);
  Assertea(ea,data,10);
  PutWord(chkW+x.R*ls9+ea); Ext(high);
 ELSE (* use CMP-instruction *)
  IF hsz#sz THEN LoadX(high,sz,FALSE) END;
  Gea(high,ea,FALSE);
  (* 18.6.90/bp auch CHK.L ausnutzen *)
  IF Option[m68020] THEN
    PutWord(chkL+x.R*ls9+ea); Ext(high);
  ELSE
    PutWord(cmpB+x.R*ls9+sz*ls6+ea); Ext(high);
    Trap(14, HI);
  END;
 END;
 Release(high);
END CheckHigh;

PROCEDURE VarIndex(VAR x,y:Item; elsize:LONGINT);
(* generate x with a variable index y and elementsize elsize. *)
(* Note:Indices/Offsets always signed integers on MC68000! *)
VAR
 elsz:Item;
BEGIN
 (* Note:the minimal width of an index must be word! *)
 (* ----- VarIndex works also fine for long inidices. *)
 Assert(y.mode=DregMd,7);
 (*
  * 26.3.89/ms
  *	Calling SetregMd before NeedD0 and Release to assure correct release.
  * 25.2.89/ms
  *	d0 cannot be used as index register.
  *)
 IF (elsize#1) & (x.typ^.size>maxInt) THEN
  (* 20.2.89/ms Extend only if the type size is bigger than 1 *)
  LoadX(y,long,TRUE); y.typ:=tp.numtyp[long,FALSE];
 END;
 SetconMd(elsz,elsize,y.typ);
 MUL2(y,elsz,FALSE); (* inhibit overflow-checks *)
 (* 18.8.90/bp ERST JETZT FreeD0, MUL2 kann es noch in D0 gesetzt haben! *)
 IF y.R=d0 THEN
  FreeD0;
 END;
 Assert(y.wid>=word,8);
 LoadAdr(x);
 WITH x DO
  (* transform 'AregMd' to 'RidxMd' *)
  mode:=RidxMd; indir:=FALSE;
  adr:=0; off:=0;
  RX:=y.R; wid:=y.wid;
 END;
END VarIndex;

PROCEDURE GetHigh(VAR x:Item);
(* get high-index of dynamic array parameter:*)
(* Caution:x.typ IS changed ! *)
BEGIN
 WITH x DO
  IF mode<vconMd THEN
   (* reference to indir,adr,off allowed. *)
   indir:=FALSE; off:=0;
   INC(adr,4); typ:=hightyp;
   wid:=2;
  ELSE Mark(6023)
  END;
 END (*WITH*);
END GetHigh;

PROCEDURE PreProcess(VAR op:Symbol; VAR x,y:Item);
VAR
 z:Item;
BEGIN
 constOp:=(x.mode=vconMd) & (y.mode=vconMd);
 IF (op=plus) OR (op=times) THEN
  IF (x.mode#DregMd)
     & ((y.mode=DregMd) & (y.R IN Rpool)
        OR (x.mode=vconMd) & (y.mode<=stkMd)) THEN
   z:=x; x:=y; y:=z;
  END;
 ELSIF (eql<=op) & (op<=geq) THEN
  IF x.mode=vconMd THEN
   IF (y.mode=DregMd) & (y.R=d0) THEN Release(y); NeedD0(x) END;
   z:=x; x:=y; y:=z;
   IF op=lss THEN op:=gtr;
   ELSIF op=leq THEN op:=geq;
   ELSIF op=gtr THEN op:=lss;
   ELSIF op=geq THEN op:=leq;
   END
  END
 END
END PreProcess;

PROCEDURE DynArray(VAR x,y:Item);
(* generate descriptor for dynamic array parameters:*)
(* Caution:guarantee HIGH to be in the range 0<=HIGH<=maxLInt. *)
CONST
 ByteSize=1;
VAR
 high,onstack,e:Item;
 s:StrPtr;
 i,elsize:LONGINT;
 dynbyte:BOOLEAN;
BEGIN
 Assert((x.mode=stkMd) & (x.typ^.form=Array) & x.typ^.dyn,9);
 dynbyte:=(x.typ^.ElemTyp=tp.bytetyp);
 IF (y.typ^.form=Array) THEN
  elsize:=y.typ^.ElemTyp^.size;
  IF y.typ^.dyn THEN (* copy existing descriptor *)
   high:=y; GetHigh(high);
   IF dynbyte & (elsize#ByteSize) THEN
    LoadD(high,TRUE);
    Inc1(high); (* enable overflow-check *)
    SetconMd(e,elsize,high.typ);
    MUL2(high,e,TRUE);
    Op1(subqB+1*ls9,high); (* disable overflow-check *)
    IF Option[ovflchk] THEN CheckClimit(high,maxLInt-1) END;
   END;
  ELSE (* generate new descriptor *)
   IF ~dynbyte THEN
    s:=y.typ^.IndexTyp; i:=0;
    WITH s^ DO
     IF form=Range THEN
      IF (max>=min) & ((min>=0) OR (max<=(maxLInt+min))) THEN
       i:=max-min
      ELSE
       Mark(6010); (* range distance too big *)
      END;
     END (*Range*);
    END (*WITH*);
   ELSE
    i:=y.typ^.size; IF i>0 THEN DEC(i) END;
   END;
   SetconMd(high,i,hightyp);
  END;
 ELSIF (y.typ^.form=String) THEN
  (* 29.11.90/bp Wir lassen HIGH doch korrekt. CopyDynArray macht
   * CLR.W -(A7), wom it dies auch bei  Variablen greift!
   *)
   (* 5.9.90/bp Immer die 0 mitnehmen! *)
  i:=y.val.conSize; IF i>0 THEN DEC(i) END;
  SetconMd(high,i,hightyp);
 ELSE
  Assert(dynbyte,10);
  i:=y.typ^.size; IF i>0 THEN DEC(i) END;
  SetconMd(high,i,hightyp);
  IF y.mode>=memconMd THEN Mark(6009) END;
 END;
 SetstkMd(onstack,hightyp);
 Move(high,onstack);
 MoveAdr(y,onstack);
 Release(high);
 Release(y);
END DynArray;

PROCEDURE CopyDynArray(a,s:INTEGER);
(* descriptor at a(MP),element-size is s:copy (high+1)*s Bytes from *)
(* [a(MP)] on top of stack and update descriptor address. *)
VAR
 Dn,An,Am:Register;
 op,src,dst:INTEGER;
 st1,st2,x,e:Item;
BEGIN
 IF ~Option[entcode] OR ~Option[copyDyn] THEN RETURN END;
 dynCopied:=TRUE; (* flag fr unlink! *)
 Assert(s>0,11);
 SetlocMd(x,a+4,hightyp);
 LoadD(x,TRUE); Dn:=x.R;
 (* Caution:value of HIGH must be in positive INTEGER range,*)
 (* -------  even if HIGH is hold in a longword (LONGINT) !   *)
 (*          this is essential for the code generation below. *)
 IF s=1 THEN (* geht etwas schneller! *)
   (* 29.11.90/bp Damit Strings garantiert mit 0 enden: *)
   PutWord(clrW+adec+sp);
   PutWord(addqL+2*ls9+Dn);
   PutWord(andiW+Dn); PutWord(0FFFEH);
 ELSE (* s>1 *)
   PutWord(addqL+1*ls9+Dn); (*Inc1(x);*) (* (high+1)=nr. of elements *)
   (* (high+1) * s=nr. of bytes to copy *)
   SetconMd(e,s,x.typ);
   MUL2(x,e,TRUE);
  (*
   * 13.3.89/ms
   * Das Register muss hier nochmals berprft und allenfalls kopiert werden.
   *)
   IF x.R#Dn THEN
     IF x.R=d0 THEN FreeD0 END;
     Dn:=x.R;
   END;
   IF ODD(s) THEN
     (* Note:Dn will never overflow at the INC below ! *)
     PutWord(btsti+ddir+Dn);  (* total nr. of bytes   *)
     PutWord(0);              (* must be even         *)
     PutWord(beq+2);          (* skip if already even *)
     PutWord(addqL+1*ls9+Dn); (* if odd then+1        *)
   END;
 END;
 GetReg(An,Areg); GetReg(Am,Areg);
 src:=An MOD 8; dst:=Am MOD 8;
 (* 30.8.90/bp Der StkChk muss VOR suba.L dn,a7 passieren! *)
 IF Option[stkchk] THEN
  IF d0 IN Rbusy THEN PutWord(moveL+sp*ls9+adec*ls3) END;
  PutWord(moveL+d0*ls9+Dn); (* move.l dn,d0 !!! *)
  PutWord(negL+d0);
  CallSystem(stkChk);
  IF d0 IN Rbusy THEN PutWord(moveL+sp+ainc) END;
 END;
 PutWord(subaL+sp*ls9+Dn);                (* SUBA.L Dn.W,SP *)
 PutWord(moveaL+src*ls9+aoff+mp);         (* MOVEA.L a(MP),An *)
 PutWord(a);
 PutWord(moveL+Iea(aoff+mp)*ls6+adir+sp); (* MOVE.L SP,a(MP) *)
 PutWord(a);
 PutWord(moveaL+dst*ls9+adir+sp);         (* MOVEA.L SP,Am *)
 INC(src,ainc); INC(dst,ainc);
 PutWord(subqL+1*ls9+Dn);                 (* loop count in Dn *)
 PutWord(moveB+Iea(dst)*ls6+src);         (* L:MOVE.B (An)+,(Am)+ *)
 PutWord(dbra+Dn);                        (* DBRA Dn,L *)
 PutWord(177774B);
 Release(x);
 ReleaseReg(An);
 ReleaseReg(Am);
 RegsDestroyed(RegisterSet{d0,Dn,An,Am});
END CopyDynArray;

PROCEDURE EnterCase(VAR x:Item; base:INTEGER; lo,hi:LONGINT);
(* JR adjust this to work for long -> enter case-statement processor *)
VAR
 m,n,z,t:Item;
 B,An:Register;
 xt:StrPtr;
 op: Symbol;
BEGIN
 WITH z DO   (* transform z to 'prgMd' *)
  typ:=tp.numtyp[word,TRUE]; mode:=prgMd; where:=base;
  adrtoload:=FALSE; nilToCheck:=FALSE;
 END (*WITH z*);
 xt:=x.typ;              (* hold original type of x *)
 LoadX(x,word,TRUE); x.typ:=tp.numtyp[word,TRUE];  (*! always word ??? *)
 LoadAdr(z);             (* z.mode:=RindMd; *)
 An:=z.R MOD 8;
 SetconMd(m,lo,x.typ); ADD2(subB,x,m);
 t:=x;
 SetconMd(n,hi-lo,x.typ); constOp:=FALSE; Cmp2(x,n,LT);
 x:=t;                   (* Preserve x from becoming cocMd *)
 PutWord(bls+2);
 PutWord(moveqL+x.R*ls9+377B); (* MOVEQ #-1,R *)
 SetconMd(m,1,tp.numtyp[word,TRUE]);   (*! always word ??? *)
 SHI2(asliB,x,m);
 PutWord(moveW+x.R*ls9+aidx+An);
 IF x.wid=word THEN PutWord(x.R*ls12) ELSE PutWord(x.R*ls12+ls11) END;
 PutWord(jsr+aidx+An);
 PutWord(x.R*ls12);
 Release(z);
 Release(x);
 x.typ:=xt; (* restore original type of x *)
 AllRegsDestroyed;
END EnterCase;

PROCEDURE ExitCase;
(* leave case-statement *)
BEGIN
  PutWord(rts);
  AllRegsDestroyed;
END ExitCase;

PROCEDURE Link(lev:INTEGER; size:LONGINT; link:BOOLEAN);
(* generate entry-code for procedure at level lev *)
VAR dn,an:Register; swapped,pushed:BOOLEAN; wcnt,lcntM1,i:INTEGER;
BEGIN
 AllRegsDestroyed;
 stackFixup:=-1;
 dynCopied:=FALSE;
 locVarSize:=size;
 saveregsFixup:=-1;
 fsaveFixup:=-1;
 UsedRegs:=RegisterSet{};
 linkFixup:=-1;
 globFixup:=-1;
 IF Option[entcode] THEN
   inhibitProf:=Option[loadA4] OR Option[saveA4];
   IF link THEN CallProf(pEnter) END;
   GenStackCheck(size); (* 26.3.90/bp UN-Wichtig, ob A6 destroyed! *)
   (* global and local procedure *)
   IF link THEN
     linkFixup:=ip;
     IF -32768<=size THEN
       IF (size=0) OR ~Option[entryClear] THEN (* Don't clear the stack! *)
       (* evtl. movea.l a5,-(a7) moveal a7,a5 clr.x -(a7) ...
	* regsave kommt erst danach!!! also KEIN GetReg!!!
	*)
         PutWord(linkW+mp); (* LINK MP,#local-data-size *)
         PutWord(INTEGER(size));
       ELSE
         wcnt:=(-size) DIV 2; (* Anzahl Worte *)
         PutWord(moveL+sp*ls9+adec*ls3+adir+mp); (* MOVE.L A5,-(A7) *)
         PutWord(moveaL+mp*ls9+adir+sp);	 (* MOVEA.L A7,A5 *)
         IF wcnt>9 THEN
	   swapped:=FALSE; pushed:=FALSE; dn:=d0;
	   IF ~(d0 IN Rlock) THEN (* dn:=d0 *)
           ELSIF ~(d1 IN Rlock) THEN dn:=d1
	   ELSIF ~((a0+adir) IN Rlock) THEN an:=a0; swapped:=TRUE;
	   ELSIF ~((a1+adir) IN Rlock) THEN an:=a1; swapped:=TRUE;
	   ELSE
	     pushed:=TRUE; (* kein Reg frei, also push d0 *)
	   END;
	   IF swapped THEN PutWord(moveaL+an*ls9); (* MOVEA.L D0,an *)
	   ELSIF pushed THEN PutWord(moveL+sp*ls9+adec*ls3+d0); DEC(wcnt,2)
	   END;
	   lcntM1:=wcnt DIV 2 -1;
	   IF IsByte(lcntM1) THEN
	     MoveConstToReg(lcntM1,dn);
	   ELSE
	     MoveConstWordToDReg(lcntM1,dn);
	   END;
	   PutWord(clrL+adec+sp);
	   PutWord(dbra+dn);
	   PutWord(177774B);
	   RegDestroyed(dn);
	   IF swapped THEN PutWord(moveL+d0*ls9+adir+an)
	   ELSIF pushed THEN
	     PutWord(moveL+d0*ls9+aoff+mp); PutWord(-4);
	     PutWord(clrL+aoff+mp); PutWord(-4);
	   END;
	 ELSE
	   FOR i:=1 TO wcnt DIV 2 DO
	     PutWord(clrL+adec+sp);
	   END;
	 END;
	 IF ODD(wcnt) THEN
	   PutWord(clrW+adec+sp);
	 END;
       END; (* cnt#0 & Optin[ *)
     ELSE (* hier kein Clear, wer soviel Stack braucht, ist dumm *)
       PutWord(moveL+sp*ls9+ls8+adir+mp);
       PutWord(moveaL+mp*ls9+adir+sp);
       PutWord(addaL+sp*ls9+imm); PutLong(size);
     END;
     linkSize:=ip-linkFixup;
   END;
   (* 16.10.91/bp regsave nur noch bei global! *)
   (* 5.11.91/bp Doch wieder auch lokale, sonst Aerger mit lockedregs! *)
 (*
   IF lev<=0 THEN
  *)
     saveregsFixup:=ip;
     PutWord(movemmL+adec+sp); PutWord(0011111100110010L); (* d2-d7/a2/a3/a6 *)
     IF Option[m68881] THEN
       fsaveFixup:=ip;
       PutWord(FWord+adec+sp);
       PutWord(fmovemRM+11111100L);
     END;
 (*
   END;
  *)
   IF Option[loadA4] THEN   (* global procedure *)
     globFixup:=ip;
     PutWord(lea+sb*ls9+absL); (* MOVEA.L -d(PC),SB *)
     GetA4; (* put32 0, _LinkerDB markieren! *)
   END;
 END; (* if entcode *)
END Link;

PROCEDURE CheckSet(s:BITSET; VAR rev:BITSET; VAR r:Register):INTEGER;
(*$ RangeChk:=FALSE OverflowChk:=FALSE *)
(* true, wenn nur 1 reg drin, dann rev=CARDINAL(reg) *)
(* niemals ein leeres Set bergeben! *)
VAR i,cnt:INTEGER;
BEGIN
  cnt:=0; rev:=BITSET{};
  FOR i:=0 TO 15 DO
    IF i IN s THEN r:=i; INCL(rev,15-i); INC(cnt) END;
  END;
  RETURN cnt;
END CheckSet;
(*$ POP RangeChk POP OverflowChk *)

PROCEDURE RevShort(a{0}:BITSET; VAR b{8}:BITSET; VAR c{9}:INTEGER);
BEGIN
  ASSEMBLE(
	MOVEQ	#7,D1
	MOVEQ	#0,D2
  slp:	ROXR.B	#1,D0 (* set invertieren *)
	ROXL.B	#1,D2
	DBRA	D1,slp
	MOVE.W	D2,(A0)

	MOVEQ	#7,D1
	MOVEQ	#0,D0
  clp:	ROXR.B	#1,D2 (* bits zhlen *)
	BCC.S	noC
	ADDQ.W	#1,D0
  noC:	DBRA	D1,clp
	MOVE.W	D0,(A1)
  END);
END RevShort;

PROCEDURE FixMovem(VAR wo,wof:INTEGER; size:LONGINT; VAR wasDyn:BOOLEAN);
  (* fixen des movem *)
VAR
 singreg:Register;
 count,fcount:INTEGER;
 reg:CARDINAL;
 used,fused: RECORD
   CASE :INTEGER OF
   | 0: rs:RegisterSet;
   | 1: i1,i2:INTEGER;
   | 2: s1,s2:BITSET;
   | 3: f0,fs,f2,f3:SHORTSET;
   | 4: u1,u2:CARDINAL;
   END;
 END;
BEGIN
  used.rs:=UsedRegs
   -RegisterSet{d0,d1,a0+8,a1+8,sb+8,mp+8,sp+8,fp0+16,fp1+16,pc};
     (* wer wei? *)
   (* dies mu IMMER, kann ja lokale oder fremde aufrufen !! *)
  IF (sb+8 IN UsedRegs)&(Option[loadA4] OR Option[saveA4]) THEN
    INCL(used.rs,sb+8)
  END;
  (* 13.10.91/bp *)
  IF Option[saveAllRegs] THEN
    used.rs:=used.rs+RegisterSet{d0,d1,a0+8,a1+8};
  END; (* Was ist mit fregs? TODO! *)
  IF optiCode & (globFixup>=0) & ~(sb+8 IN UsedRegs) THEN
    EXCL(used.rs,sb+8);
    Delete(globFixup,6);
  END;
  IF used.rs=RegisterSet{} THEN
    IF wo>=0 THEN (* nur fmovem alleine gibt es nicht! *)
      IF wof>=0 THEN Delete(wo,8) (* wof mu wo+4 sein!!! *)
      ELSE Delete(wo,4) END
    END;
  ELSE (* fregs oder normregs oder beide *)
    fused:=used;
    count:=CheckSet(used.s2,used.s1,singreg);
    IF wof>=0 THEN
      RevShort(fused.s1,fused.s2,fcount);
      IF fcount>0 THEN
        FixShortWith(wof+3,CAST(CHAR,fused.fs));
      ELSE
        Delete(wof,4);
      END;
    ELSE
      fcount:=0;
    END;
    IF count=0 THEN
      Delete(wo,4);
    ELSIF count=1 THEN (* 1 reg *)
      reg:=CARDINAL(singreg) MOD 8 *ls9+singreg DIV 8 * ls6;
      FixupWith(wo,moveL+sp*ls9+adec*ls3+singreg);
      Delete(wo+2,2);
    ELSE (* >1 *)
      FixupWith(wo+2,used.i1);
    END;
    (* So, die movem und fmovem am Anfang sind gepatcht *)
    IF wasDyn THEN
      DEC(size,fcount*12+count*4); (* extended lreal braucht 12 Bytes! *)
      IF size>=minInt THEN
        IF fcount>0 THEN
          PutWord(FWord+aoff+mp);
          PutWord(fmovemMR+fused.u2);
          PutWord(INTEGER(size));
          INC(size,fcount*12); (* !!! *)
        END;
        IF count=1 THEN
          PutWord(moveL+aoff+mp+reg); (* move.l size-4(a5),singreg *)
          PutWord(INTEGER(size));
	ELSIF count>1 THEN
	  PutWord(movemL+aoff+mp); PutWord(used.i2); PutWord(INTEGER(size));
	END;
      ELSE (* size<minInt *)
	PutWord(moveaL+a0*ls6+adir+mp); (* movea.l a5,a0 *)
	PutWord(addaL+a0*ls9+imm); PutLong(size); (* suba.l #-----..,a0 *)
	IF fcount>0 THEN
	  PutWord(FWord+ainc+a0); (* hier ainc!!! damit a0 erhht wird! *)
          PutWord(fmovemMR+fused.u2);
	END;
	IF count=1 THEN
	  PutWord(moveL+aidr+a0+reg); (* move.l (a0),singreg *)
	ELSIF count>1 THEN
	  PutWord(movemL+aidr+a0); PutWord(used.i2); (* movem.l (a0),list *)
	END;
      END;
    ELSE (* kein CopyDyn, also stimmt sp *)
      IF fcount>0 THEN
        PutWord(FWord+ainc+sp);
        PutWord(fmovemMR+fused.u2);
      END;
      IF count=1 THEN
        PutWord(moveL+ainc+sp+CARDINAL(singreg) MOD 8 *ls9+singreg DIV 8*ls6);
      ELSIF count>1 THEN
        PutWord(movemL+ainc+sp); PutWord(used.i2);
      END;
    END;
  END; (* kein leerset *)
  wo:=-1; wof:=-1; wasDyn:=FALSE;
END FixMovem;

PROCEDURE Unlink(parSize:LONGINT; lev:INTEGER; link:BOOLEAN);
(* generate exit-code for procedure at level lev *)
(* 24.11.90/bp Hack: CallProf(pExit) ; FixLink(-level) *)
VAR
 i,len: INTEGER;
 help: RECORD
   CASE :INTEGER OF
   | 0: li: LONGINT;
   | 1: i1,i2:INTEGER;
   | 2: u0,u1,u2,u3:SHORTCARD;
   END
 END;
BEGIN
 IF Option[entcode] THEN
  IF stackFixup>=0 THEN
   INC(stackAmount,parAmount); (* beides zusammen! -a+-b*)
   IF stackAmount#0 THEN
     help.li:=stackAmount;
     IF IsByte(stackAmount) THEN
       (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
       FixupWith(stackFixup-2,moveqL+help.u3);
       (*$ POP RangeChk POP OverflowChk *)
       Delete(stackFixup,4);
     ELSE
       FixupWith(stackFixup, help.i1);
       FixupWith(stackFixup+2, help.i2);
     END;
   ELSE
   (*
    * 13.11.89/ms
    *  Der StackCheck Code wird berschrieben, falls ein Test auf 0
    *  geschieht.
    *)
    DEC(stackFixup,2+stackRegs*2);
    Delete(stackFixup,4*stackRegs+10); (* alles weg *)
    len:=4+2*stackRegs;
    FixupWith(stackFixup,bra+2*len);
   END;
  END; (* fixup#0 *)

  (* 24.11.90/bp ProfExit mu leider VOR RETURN!!! *)
  IF ~link & (lev<=0) THEN (* bler Trick: lev ist -returnL! *)
    IF ~secondMain THEN
      CallProf(pExit);
      secondMain:=TRUE
    END;
    FixLink(-lev);
  END;

  (* 16.10.91/bp reg-rettung nur noch bei global! *)
  (* 5.11.91/bp Doch wieder! *)
(*
  IF lev<=0 THEN
 *)
    FixMovem(saveregsFixup,fsaveFixup,locVarSize,dynCopied);
(*
  END;
 *)
  (* UNLK MP *)
  IF link THEN
    IF optiCode&~(mp+8 IN UsedRegs) THEN
      IF linkFixup>=0 THEN Delete(linkFixup,linkSize) END;
    ELSE
      PutWord(unlk+mp)
    END;
  END;
  IF (lev>0) THEN
    (* local procedure:include SL *)
    (* in the parameter size. *)
    INC(parSize,4);
  END;
  IF (parSize>0) AND Option[pardealloc] THEN
    IF Option[m68010] & (parSize<maxInt) THEN (* bei = maxInt: Overflow bei INC! *)
      IF ODD(parSize) THEN INC(parSize) END; (* kommt das vor??/bp *)
      IF link THEN CallProf(pExit) END;
      PutWord(rtd); PutWord(INTEGER(parSize));
    (* 13.10.91/bp *)
    ELSIF Option[saveAllRegs] THEN
      IF parSize<maxInt THEN
        PutWord(moveL+a7*ls9+aoff*ls3+aidr+a7);PutWord(INTEGER(parSize)); (* MOVE.L (A7),parSize(A7) *)
      ELSE (* zuviel, was dann? Kommt niemals vor! *)
        Mark(6033);
      END;
      StackTop(parSize);
      IF link THEN CallProf(pExit) END;
      PutWord(rts);
    ELSE
      PutWord(moveaL+a0*ls9+ainc+sp); (* MOVEA.L (SP)+,A0 *)
      StackTop(parSize); (* LEA #parSize(SP),SP *)
      IF link THEN CallProf(pExit) END;
      PutWord(jmp+aidr+a0);
    END;
  ELSE
   IF link THEN (* proc *)
     CallProf(pExit);
   END;
   PutWord(rts);
  END;
 END; (* entcode *)
 stackFixup:=-1;linkFixup:=-1;saveregsFixup:=-1;fsaveFixup:=-1;globFixup:=-1;
 AllRegsDestroyed;
 inhibitProf:=FALSE;
END Unlink;

PROCEDURE CallInt(proc:ObjPtr);
(* call of local procedure. pd^.implemented=TRUE! *)
BEGIN
  INCL(UsedRegs,sb+8); (* !!! *)
  CallProf(pCall);
  SubBranch(proc);
  CallProf(pReturn);
  AmigaDestroyed;
  IF proc^.pd^.lev>0 THEN
    PointersDestroyed(TRUE); (* alles! *)
    (* 16.10.91/bp lokale retten keine Regs! *)
    (* 5.11.91/bp Doch! *)
  (*
    AllRegsDestroyed;
   *)
  ELSE
    PointersDestroyed(FALSE)
  END;
END CallInt;

PROCEDURE CallExt(proc:ObjPtr);
(* call of external procedure *)
BEGIN
   CallProf(pCall);
   (* 04.07.92/bp *)
   IF proc^.pd^.external THEN
     ExternalCall(0,CAST(Ident,proc^.pd^.adr),noHead);
   ELSIF (proc^.pmod=0)&~proc^.pd^.exp THEN
     ExternalCall(0,CAST(Ident,LONGINT(proc^.pd^.num)),private)
   ELSE
     ExternalCall(proc^.pmod,proc^.name,exported)
   END;
   CallProf(pReturn);
END CallExt;

PROCEDURE CallCod(proc:ObjPtr);
(* call of code procedure *)
BEGIN
 INCL(UsedRegs,sb+8); (* !!! *)
 WITH proc^ DO
  IF (* cmod>0 *) (cd#NIL)& ~(a6+8 IN cd^.regs) THEN
    LoadA6(cmod);
  END;
  CallProf(pCall);
  PutWord(jsr+aoff+a6); (* JSR cnum(A6) *)
  PutWord(cnum);
  CallProf(pReturn);
  AmigaDestroyed; (* PointersDestroyed(FALSE,FALSE,FALSE); nichts zerstrt! *)
 END (*WITH*);
END CallCod;

PROCEDURE CallInd(VAR x:Item);
(* call of procedure variable *)
VAR
 ea:CARDINAL;
BEGIN
 INCL(UsedRegs,sb+8); (* !!! *)
 LoadP(x); x.mode:=RindMd; (* transform 'AregMd' to 'RindMd' *)
 Gea(x,ea,FALSE);
 CallProf(pCall);
 PutWord(jsr+ea); Ext(x);
 Release(x);
 CallProf(pReturn);
 AmigaDestroyed; PointersDestroyed(TRUE); (* kann alles sein! *)
END CallInd;

PROCEDURE InitTraps;
BEGIN
  trapLoc[13]:=0; trapLoc[14]:=0; trapLoc[15]:=0;
END InitTraps;

PROCEDURE EnterLocMod;
BEGIN
  UsedRegs:=RegisterSet{};
END EnterLocMod;

PROCEDURE EnterModule(VAR l:INTEGER);
(* l=0 -> mod is program; l=-1 -> mod is implementation *)
BEGIN
 Link(0,0,FALSE);
 IF (l#0) THEN
   l:=0;
   IF Option[entcode] THEN
     IF GlobVarType=normVar THEN
       PutWord(addqW+1*ls9+aoff+sb); DRel(0,0); (* ADDQ.W #1,0(SB) *)
       PutWord(cmpiW+aoff+sb); PutWord(1); DRel(0,0); (* CMPI.W #1,0(SB) *)
       Jf(NE,l);
       INCL(UsedRegs,sb+8);
     ELSE
       PutWord(addqW+1*ls9+absL); AbsData(0,0);
       PutWord(cmpiW+absL); PutWord(1); AbsData(0,0); (* CMPI.W #1,var0 *)
       Jf(NE,l);
     END;
   END;
 ELSE
   l:=0;
 END;
END EnterModule;

PROCEDURE EnterExitModule(VAR l:INTEGER);
(* l=0 -> mod is program; l=-1 -> mod is implementation *)
BEGIN
  Link(0,0,FALSE);
  IF (l#0) THEN
    l:=0;
    IF Option[entcode] THEN
      IF GlobVarType=normVar THEN
        PutWord(subqW+1*ls9+aoff+sb); DRel(0,0); (* SUBQ.W #1,0(SB) *)
        Jf(NE,l);
        INCL(UsedRegs,sb+8);
      ELSE
        PutWord(subqW+1*ls9+absL); AbsData(0,0);
        Jf(NE,l);
      END;
    END;
  ELSE
    l:=0;
  END;
  (* 25.11.90/bp Auch Close mu in Profiler! *)
  IF Option[entcode] THEN CallProf(pEnter) END;
END EnterExitModule;


PROCEDURE CloseModule(m:INTEGER);
BEGIN
  IF Option[entcode] THEN
    ExternalCall(m,NIL,closemod);
  END;
END CloseModule;

PROCEDURE ExitInit(l:INTEGER);
BEGIN
  IF Option[entcode] & (l#0) THEN
    IF GlobVarType=normVar THEN
      PutWord(moveW+sb*ls9+aoff*ls3+imm); PutWord(1); DRel(0,0);(*MOVE.W #1,0(SB)*)
    ELSE
      PutWord(moveW+001111L*ls6+imm); PutWord(1); AbsData(0,0);
    END;
  END;
END ExitInit;

PROCEDURE ExitProfExit;
BEGIN
  IF Option[entcode] THEN
    CallProf(pExit)
  END
END ExitProfExit;

PROCEDURE InitModule(m:INTEGER);
BEGIN
  IF Option[entcode] THEN
    ExternalCall(m,NIL,openmod);
  END;
END InitModule;

PROCEDURE GenLibraryCode(proc:ObjPtr);
VAR
  l,l2,version:INTEGER;
  c:ConstValue;
BEGIN
  c.modNr:=0; (* einzig ntige Initialisierung! *)
  AllocString(proc^.key^.id,c,TRUE);
 (* optiCode ist SICHER aus (von m2c), also kommt Optimizer) *)
  PutWord(addqW+1*ls9+aoff+sb); DRel(0,0); (* ADDQ.W #1,0(SB) *)
  PutWord(cmpiW+aoff+sb); PutWord(1); DRel(0,0); (* CMPI.W #1,0(SB) *)
  Jf(NE,l);
  version:=proc^.key^.ver;
  MoveConstToReg(ABS(version),d0);
  PutWord(lea+a1*ls9+prel);
  ConstRel(0,c.buffOffset); (* lea libname(pc),a1 *)
  IF version>0 THEN
    CallSystem(oplib);
  ELSE
    PutWord(moveL+sp*ls9+adec*ls3+adir+a6);
    PutWord(moveaL+a6*ls9+absW); PutWord(4);
    PutWord(jsr+aoff+a6); PutWord(-552); (* OpenLibrary *)
    PutWord(moveaL+a6*ls9+sp+ainc);
  END;
  PutWord(moveL+aoff*ls3+sb*ls9); DRel(0,4); (* movel d0,4(a4) *)
  IF version<0 THEN Jf(EQ,l2) END;
  PutWord(moveaL+a0*ls9+d0);
  PutWord(moveW+aoff*ls3+sb*ls9+aoff+a0); PutWord(20); DRel(0,2);
  fixup(l);
  IF version<0 THEN fixup(l2) END;
  PutWord(rts);
  Define(closemod,NIL); (* hier ist close *)
  PutWord(subqW+1*ls9+aoff+sb); DRel(0,0); (* ADDQ.W #1,0(SB) *)
  Jf(NE,l);
  PutWord(moveaL+a1*ls9+aoff+sb); DRel(0,4); (* movea.l 4(a4),a1 *)
  CallSystem(closlib);
  fixup(l);
  PutWord(rts);
END GenLibraryCode;

PROCEDURE GenProfMain(mno:INTEGER);
BEGIN
  IF profile THEN (* VAR prof:ProfData;nOfBlocks:CARDINAL; modName:ADDRESS) *)
    (* Parameter: profData,id [,pc] *)
    IF GlobVarType=normVar THEN
      PutWord(pea+aoff+sb); DRel(0,profDataOffset);
    ELSE
      PutWord(pea+absL); AbsData(0,profDataOffset);
    END;
    PutWord(moveW+sp*ls9+adec*ls3+imm); PutWord(mno);
    PutWord(pea+prel); ConstRel(0,profModName);
    (* Aufruf *)
    ExtCall(profmodnr,profMod[pAllocate],exported);
    CallProf(pEnter);
  END;
END GenProfMain;


BEGIN
 stackFixup:=-1; linkFixup:=-1; saveregsFixup:=-1; fsaveFixup:=-1;
 InitTraps;
END M2HM.
