IMPLEMENTATION MODULE M2DecSrc;
(* 17.11.90/bp *)
(* 05.09.92/bp angepasst an externe Procs *)

(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

FROM SYSTEM	IMPORT	ASSEMBLE,ADR,ADDRESS,CAST,BYTE,WORD,BITSET;
FROM Arts	IMPORT	ModType;
FROM Terminal	IMPORT	WriteString,Format,FormatNr,WriteLn,Write,FormatS;
FROM SeqIO	IMPORT	SeqKey,OpenSeqIn,CloseSeq,SeqOk,SeqInB,SeqInW,SeqInL;
FROM M2File	IMPORT	FileType,GetInputFile;
FROM ASCII	IMPORT	ht,eol;
FROM Call	IMPORT	Return;
FROM String	IMPORT	LastPos;
IMPORT R;

CONST
  illRef = "\n!!Referenzdatei \"%s\" hat falschen Typ!!\n\n";
  noRefFile = "\n!! Referenzdatei \"%s\" nicht gefunden !!\n\n";
  trashRef = "Referenzdatei fehlerhaft!";
  srcNotFound="\n!! Quelltext \"%s\" nicht gefunden !!\n\n";
  srcBuffSize=512;
  refBuffSize=1024;
  highcol="\[3%cm";
  normal="\[0m";

VAR
  src,
  ref:SeqKey;
  srcPos:LONGINT;
  srcOk,refOk:BOOLEAN;


PROCEDURE Err(s1,s2:ARRAY OF CHAR); (*$ CopyDyn:=FALSE *)
BEGIN
  FormatS(s1,s2); WriteLn;
 (* BreakPoint(ADR('error'));*)
  loadErr:=TRUE;
(*BreakPoint(ADR('xit Err to Terminate'));*)
  Return; (* from Call! *)
END Err;

PROCEDURE InB(VAR b:BYTE);
BEGIN
  b:=SeqInB(ref);
  refOk:=SeqOk(ref);
END InB;

PROCEDURE InWord(VAR i:INTEGER);
BEGIN
  i:=SeqInW(ref);
  refOk:=SeqOk(ref);
END InWord;

PROCEDURE InLong(VAR l:LONGINT);
BEGIN
  l:=SeqInL(ref);
  refOk:=SeqOk(ref);
END InLong;

PROCEDURE InNumber2(ch:CHAR; VAR x:ARRAY OF BYTE);
VAR
  c,i,k,l:SHORTINT;
  fill:BOOLEAN;
BEGIN
  c:=SHORTCARD(ch) MOD 64;
  l:=HIGH(x);
  fill:=c>31;
  IF fill THEN DEC(c,64); END;
  CASE CAST(SHORTCARD,ch) DIV 64 OF
  | 0: x[l]:=c; DEC(l,1);
  | 1: x[l-1]:=c; InB(x[l]); DEC(l,2);
  | 2: x[l-2]:=c; InB(x[l-1]); InB(x[l]); DEC(l,3);
  | 3:
    k:=l-c+1;
    FOR i:=k TO l DO InB(x[i]); END;
    l:=k-1; (* = DEC(l,c); *)
    fill:=CAST(SHORTINT,x[k])<0;
  END;
  FOR i:=0 TO l DO x[i]:=CAST(SHORTINT,fill); END;
END InNumber2;

PROCEDURE InNumber(VAR x:ARRAY OF BYTE);
VAR
  ch:CHAR;
BEGIN
  InB(ch); InNumber2(ch,x);
END InNumber;

PROCEDURE InId;
VAR
  i,l:INTEGER;
  ch:CHAR;
BEGIN
  InNumber(l); FOR i:=1 TO l-1 DO InB(ch); END;
END InId;

CONST
  reffile=10; (* 11, 12 13, 14 ,18 *)
  extvar=4; (* !!!!! *)
  CTL=0; anchor=0; ModTag=1; ProcTag=2; RefTag=3; linkage=4;
  STR=1; enum=0; range=1; pointer=2; set=3; procTyp=4; funcTyp=5;
  array=6; dynarr=7; record=10; opaque=11; bpointer=12;
  CMP=2; parref=0; par=1; field=2;
  OBJ=3; varref=0; var=1; const=2; string=3; type=4; proc=5; func=6;
  module=7; svc=10; svcfunc=11;

PROCEDURE CheckRef(VAR filename: ARRAY OF CHAR;ft:FileType):BOOLEAN;
VAR
  i: INTEGER;
  dummyL: LONGINT;
BEGIN
  IF OpenSeqIn(ref,filename,refBuffSize) THEN
    InLong(dummyL);
    (*$ RangeChk:=FALSE *)
    IF ft=ob8File THEN INC(ft,3) END;
    IF dummyL#(reffile-ORD(objFile)+ORD(ft)) THEN
      FormatS(illRef,filename);
      RETURN FALSE
    END;
    (*$ POP RangeChk *)
  ELSE
    FormatS(noRefFile,filename); (* Hier kein Abbruch! *)
    RETURN FALSE
  END;
  RETURN TRUE
END CheckRef;

PROCEDURE PCAssert(cond:BOOLEAN):BOOLEAN;
BEGIN
  IF ~cond THEN
    Err(trashRef,empty); RETURN TRUE;
  END;
  RETURN FALSE;
END PCAssert;

PROCEDURE GetPC(VAR srcPos,pc:LONGINT);
VAR
  blk:CHAR;
  block:CARDINAL;
  d:LONGINT;
  lr:LONGREAL;
  c:INTEGER;
BEGIN
  LOOP
    InB(blk);
    IF ~refOk THEN srcPos:=MAX(LONGINT); pc:=MAX(LONGINT); RETURN; END;
    block:=ORD(blk);
    CASE block DIV 16 OF
    | OBJ:
      DEC(block,16*OBJ);
      IF PCAssert(block<=svcfunc) THEN RETURN END;
      CASE block OF
      | var,varref: InNumber(d); InNumber(d); InNumber(d); InNumber(d);
        IF (d>=extvar)&(d<=extvar+1) THEN InId END; (* externe Var *)
      | const: InNumber(d); InNumber(d); InNumber(lr);
      | string: InNumber(d); InId;
      | type,svcfunc: InNumber(d); InNumber(d);
      | proc,func:
        IF block=func THEN InNumber(d); END;
        InNumber(d); (* pnr *)
        InNumber(d); (* pd^.lev *)
        (* 05.09.92/bp externe Procs haben lev=-1 *)
        IF d<0 THEN
          InId;
        ELSE
          InNumber(d); (* pd^.adr *)
        END;
        InNumber(d); (* pd^.size *)
        InNumber(d); (* pd^.regs *)
      | svc,module: InNumber(d);
      END;
      InId; InNumber(d);
    | CMP:
      DEC(block,16*CMP);
      IF PCAssert(block<=field) THEN RETURN END;
      InNumber(d); InNumber(d); InId;
    | STR:
      DEC(block,16*STR);
      IF PCAssert(block<=bpointer) THEN RETURN END;
      InNumber(d);
      CASE block OF
      | enum: InNumber(d);
      | range: InNumber(d); InNumber(d); InNumber(d); InNumber(d);
      | bpointer,pointer,procTyp,record,opaque:
      | set,funcTyp,dynarr: InNumber(d);
      | array: InNumber(d); InNumber(d);
      END
    | CTL:
      DEC(block,16*CTL);
      IF PCAssert(block<=linkage) THEN RETURN END;
      CASE block OF
      | linkage: InNumber(d); InNumber(d);
      | ModTag,ProcTag: InNumber(d);
      | anchor:
        InWord(c); InWord(c); InWord(c);
        InId; InNumber(d); IF d=LONGINT(lib) THEN InId; END;
      | RefTag: InNumber(d); InNumber(d);
      END;
    ELSE (*line block*)
      InNumber2(blk,pc); InNumber(srcPos); EXIT;
    END
  END; (* LOOP *)
(* FormatNr("\nSrcPos=%ld ",srcPos); FormatNr("pc=$%04lx\n\n",pc);*)
END GetPC;




PROCEDURE OpenSrc(name:ARRAY OF CHAR; ft:FileType):BOOLEAN;
VAR
  fName:ARRAY[0..127] OF CHAR;
  len:INTEGER;
BEGIN
  CloseSrc;
  len:=LastPos(name,127,".");
  IF len>0 THEN name[len]:=0C END; (* lsche Extension! *)
  GetInputFile(fName,modFile,name);
  IF OpenSeqIn(src,fName,srcBuffSize) THEN
    GetInputFile(fName,refFile,name);
    IF CheckRef(fName,ft) THEN
      srcOk:=TRUE;
      refOk:=TRUE;
      RETURN TRUE;
    END;
  ELSE
    FormatS(srcNotFound,fName);
  END;
  CloseSrc;
  RETURN FALSE
END OpenSrc;

PROCEDURE CloseSrc;
BEGIN
  CloseSeq(ref);
  CloseSeq(src);
  refOk:=FALSE;
  srcOk:=FALSE;
  srcPos:=0;
END CloseSrc;

VAR
  lastLinePos:INTEGER;

PROCEDURE GotoX;
VAR i{R.D7}:INTEGER;
BEGIN
  FOR i:=1 TO lastLinePos DO Write(" ") END;
END GotoX;

(* Zeige Src bis nchsten RefPoint, gib pc davon zurck *)
PROCEDURE ShowSrc(txtCol:SrcColor):LONGINT;
VAR
  nxtSrcPos,nxtPC:LONGINT;
  srcCol:CARDINAL;
  ch{R.D7}:CHAR;
BEGIN
  nxtPC:=MAX(LONGINT);
  IF srcOk THEN
    GetPC(nxtSrcPos,nxtPC);
    IF loadErr THEN RETURN MAX(LONGINT) END;
    GotoX;
    IF txtCol#0 THEN
      srcCol:=ORD(txtCol)+30H;
      Format(highcol,ADR(srcCol));
    END;
    LOOP
      IF srcPos>=nxtSrcPos THEN EXIT; END;
      ch:=SeqInB(src);
      IF ~SeqOk(src) THEN
        srcOk:=FALSE;
        EXIT;
      END;
      Write(ch);
      IF ch=ht THEN
        ASSEMBLE(
	  MOVE.W  lastLinePos(A4),D0
	  ADDQ.W  #8,D0
	  ANDI.W  #$FFF8,D0
	  MOVE.W  D0,lastLinePos(A4)
	END);
      ELSIF ch=eol THEN
        lastLinePos:=0;
      ELSE
        INC(lastLinePos);
      END;
      INC(srcPos);
    END;
    IF txtCol#0 THEN
      WriteString(normal);
    END;
    WriteLn;
    IF lastLinePos#0 THEN WriteLn END;
  END;
  RETURN nxtPC;
END ShowSrc;


BEGIN
  (* loadErr:=FALSE; *)
CLOSE
  CloseSrc;
END M2DecSrc.
